/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.databinding.IUpdatableTree;
import org.eclipse.jface.databinding.WritableUpdatable;
import org.eclipse.jface.internal.databinding.swt.AsyncRunnable;
import org.eclipse.jface.internal.databinding.swt.SyncRunnable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class TreeViewerUpdatableTree
extends WritableUpdatable
implements IUpdatableTree {
    protected TreeViewer viewer;
    private Map nodes;
    private Object rootKey;
    private Object viewerInput;
    private boolean updatingViewer;
    private boolean updatingVirtual;
    private List viewerRefreshList;
    Class[] classTypes;
    static /* synthetic */ Class class$0;

    public TreeViewerUpdatableTree(TreeViewer viewer) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this(viewer, classArray);
    }

    public TreeViewerUpdatableTree(TreeViewer viewer, Class[] classTypes) {
        this.nodes = new HashMap();
        this.rootKey = this;
        this.viewerInput = null;
        this.updatingViewer = false;
        this.updatingVirtual = false;
        this.viewerRefreshList = new ArrayList();
        this.viewer = viewer;
        this.classTypes = classTypes;
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                TreeViewerUpdatableTree.this.viewerInput = newInput;
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return TreeViewerUpdatableTree.this.getElements(inputElement);
            }

            public boolean hasChildren(Object element) {
                return TreeViewerUpdatableTree.this.hasChildren(element);
            }

            public Object getParent(Object element) {
                TreeNode node = TreeViewerUpdatableTree.this.getTreeNode(element);
                if (node != null) {
                    return node.getParent();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return TreeViewerUpdatableTree.this.getElements(parentElement);
            }
        });
        this.viewer.setInput((Object)this);
    }

    protected TreeNode getTreeNode(Object element) {
        if (element == null || element == this.rootKey || element == this.viewerInput) {
            TreeNode result = (TreeNode)this.nodes.get(this.rootKey);
            if (result == null) {
                result = new TreeNode(null);
                this.nodes.put(this.rootKey, result);
            }
            return result;
        }
        return (TreeNode)this.nodes.get(element);
    }

    private int primAddChildElement(List list, Object element, int index) {
        int position;
        if (index < 0 || index > list.size()) {
            position = list.size();
            list.add(element);
        } else {
            list.add(index, element);
            position = index;
        }
        return position;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateViewer(Runnable runable) {
        if (this.updatingViewer) {
            this.viewerRefreshList.add(runable);
            return;
        }
        this.updatingViewer = true;
        try {
            runable.run();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.updatingViewer = false;
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.updatingViewer = false;
        }
        block3: while (!this.viewerRefreshList.isEmpty()) {
            Runnable[] work = this.viewerRefreshList.toArray(new Runnable[this.viewerRefreshList.size()]);
            this.viewerRefreshList.clear();
            int i = 0;
            while (true) {
                if (i >= work.length) continue block3;
                this.updateViewer(work[i]);
                ++i;
            }
            break;
        }
        return;
    }

    public int addElement(final Object parentElement, final int index, final Object value) {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                return new Integer(TreeViewerUpdatableTree.this.addElement(parentElement, index, value, true));
            }
        };
        return (Integer)runnable.run();
    }

    protected int addElement(final Object parentElement, int index, final Object value, final boolean fire) {
        TreeNode parentNode = this.getTreeNode(parentElement);
        if (parentNode == null) {
            return -1;
        }
        if (!this.hasChildren(parentElement) && parentNode.getChildren() == null) {
            parentNode.setChildren(new ArrayList());
        }
        List list = parentNode.getChildren();
        int addedIndex = -1;
        if (!list.contains(value)) {
            addedIndex = this.primAddChildElement(list, value, index);
            TreeNode valueNode = new TreeNode(parentElement);
            this.nodes.put(value, valueNode);
            final int fireIndex = addedIndex;
            this.updateViewer(new Runnable(){

                public void run() {
                    TreeViewerUpdatableTree.this.viewer.add(parentElement == null ? TreeViewerUpdatableTree.this.viewerInput : parentElement, value);
                    if (fire) {
                        TreeViewerUpdatableTree.this.fireChangeEvent(2, null, value, parentElement, fireIndex);
                    }
                }
            });
        }
        return addedIndex;
    }

    public void removeElement(final Object parentElement, final int index) {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                TreeViewerUpdatableTree.this.removeElement(parentElement, index, true);
                return null;
            }
        };
        runnable.run();
    }

    protected void removeElement(final Object parentElement, final int index, final boolean fire) {
        if (this.hasChildren(parentElement)) {
            TreeNode parentNode = this.getTreeNode(parentElement);
            List children = parentNode.getChildren();
            if (children != null) {
                final Object element = children.remove(index);
                this.updateViewer(new Runnable(){

                    public void run() {
                        TreeViewerUpdatableTree.this.viewer.remove(element);
                        if (fire) {
                            TreeViewerUpdatableTree.this.fireChangeEvent(4, element, null, parentElement, index);
                        }
                    }
                });
            }
            if (children.size() == 0) {
                parentNode.setChildren(null);
            }
        }
    }

    public void setElement(final Object parentElement, final int index, final Object value) {
        AsyncRunnable runnable = new AsyncRunnable(){

            public void run() {
                if (TreeViewerUpdatableTree.this.hasChildren(parentElement)) {
                    TreeNode parentNode = TreeViewerUpdatableTree.this.getTreeNode(parentElement);
                    List children = parentNode.getChildren();
                    Object oldValue = children.get(index);
                    if (oldValue.equals(value)) {
                        TreeViewerUpdatableTree.this.updateViewer(new Runnable(this, value){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ Object val$value;
                            {
                                this.this$1 = var1_1;
                                this.val$value = object;
                            }

                            public void run() {
                                6.access$0(this.this$1).viewer.update(this.val$value, null);
                            }
                        });
                    } else {
                        TreeViewerUpdatableTree.this.removeElement(parentElement, index, false);
                        TreeViewerUpdatableTree.this.addElement(parentElement, index, value, false);
                    }
                    TreeViewerUpdatableTree.this.fireChangeEvent(1, oldValue, value, parentElement, index);
                }
            }

            static /* synthetic */ TreeViewerUpdatableTree access$0(6 var0) {
                return var0.TreeViewerUpdatableTree.this;
            }
        };
        runnable.runOn(this.viewer.getTree().getDisplay());
    }

    public void setElements(final Object parentElement, final Object[] values) {
        SyncRunnable runnable = new SyncRunnable(){

            public Object run() {
                TreeViewerUpdatableTree.this.hasChildren(parentElement);
                TreeNode parentNode = TreeViewerUpdatableTree.this.getTreeNode(parentElement);
                if (parentNode == null) {
                    return null;
                }
                List children = parentNode.getChildren();
                if (children != null) {
                    while (children.size() > 0) {
                        TreeViewerUpdatableTree.this.removeElement(parentElement, 0, true);
                    }
                }
                parentNode.setRequestedChildren(true);
                if (values != null) {
                    int i = 0;
                    while (i < values.length) {
                        TreeViewerUpdatableTree.this.addElement(parentElement, i, values[i], true);
                        ++i;
                    }
                }
                return null;
            }
        };
        runnable.runOn(this.viewer.getTree().getDisplay());
    }

    public Object getElement(Object parentElement, int index) {
        List children;
        TreeNode parentNode;
        Object element = null;
        if (this.hasChildren(parentElement) && (parentNode = this.getTreeNode(parentElement)) != null && (children = parentNode.getChildren()) != null && index >= 0 && index < children.size()) {
            element = children.get(index);
        }
        return element;
    }

    public Object[] getElements(Object parentElement) {
        if (this.hasChildren(parentElement)) {
            TreeNode parentNode = this.getTreeNode(parentElement);
            List children = parentNode == null ? null : parentNode.getChildren();
            return children == null ? Collections.EMPTY_LIST.toArray() : children.toArray();
        }
        return Collections.EMPTY_LIST.toArray();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        TreeNode node = this.getTreeNode(element);
        if (node == null) {
            return false;
        }
        boolean have = node.getChildren() != null && node.getChildren().size() > 0;
        if (have) return have;
        if (this.updatingVirtual) return have;
        if (node.isRequestedChildren()) return have;
        this.updatingVirtual = true;
        try {
            this.fireChangeEvent(32, null, null, element, -1);
            node.setRequestedChildren(true);
            have = node.getChildren() != null && node.getChildren().size() > 0;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.updatingVirtual = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.updatingVirtual = false;
            return have;
        }
    }

    public Object getParent(Object element) {
        TreeNode elementNode = (TreeNode)this.nodes.get(element);
        return elementNode.getParent();
    }

    public Class[] getTypes() {
        return this.classTypes;
    }

    private class TreeNode {
        Object parent;
        List children;
        boolean requestedChildren = false;

        TreeNode(Object parent, List children) {
            this.parent = parent;
            this.children = children;
        }

        TreeNode(Object parent) {
            this(parent, null);
        }

        public List getChildren() {
            return this.children;
        }

        public Object getParent() {
            return this.parent;
        }

        public void setChildren(List children) {
            this.children = children;
            this.requestedChildren = false;
        }

        public boolean isRequestedChildren() {
            return this.requestedChildren;
        }

        public void setRequestedChildren(boolean requestedChildren) {
            this.requestedChildren = requestedChildren;
        }
    }
}

