/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.model.ModelMessages;
import org.eclipse.ltk.internal.ui.refactoring.model.RefactoringDescriptorSynchronizationProxy;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.ui.PlatformUI;

public final class RejectRefactoringsAction
extends Action {
    private final ISynchronizationContext fContext;
    private RefactoringDescriptorProxy[] fProxies = null;
    static /* synthetic */ Class class$0;

    private static ResourceMapping getResourceMapping(Object element) {
        if (element instanceof IAdaptable) {
            Object adapted;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapted = adaptable.getAdapter((Class)clazz)) instanceof ResourceMapping) {
                return (ResourceMapping)adapted;
            }
        }
        return null;
    }

    private static ResourceTraversal[] getResourceTraversals(Object element) {
        ResourceMapping mapping = RejectRefactoringsAction.getResourceMapping(element);
        if (mapping != null) {
            try {
                return mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
        return new ResourceTraversal[0];
    }

    public RejectRefactoringsAction(ISynchronizationContext context) {
        Assert.isNotNull((Object)context);
        this.fContext = context;
        this.setText(ModelMessages.RejectRefactoringsAction_title);
        this.setToolTipText(ModelMessages.RejectRefactoringsAction_tool_tip);
        this.setDescription(ModelMessages.RejectRefactoringsAction_description);
    }

    private IDiff[] getDiffs(Object element) {
        return this.fContext.getDiffTree().getDiffs(RejectRefactoringsAction.getResourceTraversals(element));
    }

    public boolean isEnabled() {
        if (this.fProxies != null && this.fProxies.length > 0 && this.fContext instanceof IMergeContext) {
            int index = 0;
            while (index < this.fProxies.length) {
                RefactoringDescriptorSynchronizationProxy proxy;
                if (this.fProxies[index] instanceof RefactoringDescriptorSynchronizationProxy && (proxy = (RefactoringDescriptorSynchronizationProxy)this.fProxies[index]).getDirection() == 512) {
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public void run() {
        if (this.fProxies != null && this.fProxies.length > 0 && this.fContext instanceof IMergeContext) {
            final IMergeContext context = (IMergeContext)this.fContext;
            final HashSet<IDiff> set = new HashSet<IDiff>();
            int index = 0;
            while (index < this.fProxies.length) {
                IDiff[] diffs = this.getDiffs(this.fProxies[index]);
                if (diffs != null && diffs.length > 0) {
                    set.addAll(Arrays.asList(diffs));
                }
                ++index;
            }
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            context.merge(set.toArray(new IDiff[set.size()]), false, monitor);
                        }
                        catch (CoreException exception) {
                            throw new InvocationTargetException(exception);
                        }
                    }
                });
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setRefactoringDescriptors(RefactoringDescriptorProxy[] proxies) {
        Assert.isNotNull((Object)proxies);
        this.fProxies = proxies;
    }
}

