/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryControl;
import org.eclipse.ltk.internal.ui.refactoring.util.PixelConverter;
import org.eclipse.ltk.internal.ui.refactoring.util.SWTUtil;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ManageRefactoringHistoryControl
extends RefactoringHistoryControl {
    private Button fDeleteAllButton = null;
    private Button fDeleteButton = null;
    private Button fEditButton = null;

    public ManageRefactoringHistoryControl(Composite parent, RefactoringHistoryControlConfiguration configuration) {
        super(parent, configuration);
    }

    protected void createButtonBar(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        composite.setLayoutData((Object)data);
        this.fDeleteButton = new Button(composite, 0);
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.setText(RefactoringUIMessages.ManageRefactoringHistorycontrol_delete_label);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.widthHint = SWTUtil.getButtonWidthHint(this.fDeleteButton);
        this.fDeleteButton.setLayoutData((Object)data);
        this.fDeleteAllButton = new Button(composite, 0);
        this.fDeleteAllButton.setEnabled(false);
        this.fDeleteAllButton.setText(RefactoringUIMessages.ManageRefactoringHistorycontrol_delete_all_label);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.widthHint = SWTUtil.getButtonWidthHint(this.fDeleteAllButton);
        this.fDeleteAllButton.setLayoutData((Object)data);
        this.fEditButton = new Button(composite, 0);
        this.fEditButton.setEnabled(false);
        this.fEditButton.setText(RefactoringUIMessages.ManageRefactoringHistoryControl_edit_label);
        data = new GridData();
        data.verticalIndent = new PixelConverter((Control)parent).convertVerticalDLUsToPixels(7);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.widthHint = SWTUtil.getButtonWidthHint(this.fEditButton);
        this.fEditButton.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)parent);
    }

    public void createControl() {
        super.createControl();
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.heightHint = new PixelConverter((Control)this).convertHeightInCharsToPixels(24);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.setLayoutData(data);
    }

    protected TreeViewer createHistoryViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        if (this.fControlConfiguration.isCheckableViewer()) {
            return new RefactoringHistoryControl.RefactoringHistoryTreeViewer(this, parent, 770);
        }
        return new TreeViewer(parent, 770);
    }

    public Button getDeleteAllButton() {
        return this.fDeleteAllButton;
    }

    public Button getDeleteButton() {
        return this.fDeleteButton;
    }

    public Button getEditButton() {
        return this.fEditButton;
    }

    protected void handleCheckStateChanged() {
        super.handleCheckStateChanged();
        this.fDeleteButton.setEnabled(this.getCheckedDescriptors().length > 0);
    }

    protected void handleSelectionChanged(IStructuredSelection selection) {
        super.handleSelectionChanged(selection);
        this.fEditButton.setEnabled(this.getSelectedDescriptors().length == 1);
    }

    public void setInput(RefactoringHistory history) {
        super.setInput(history);
        this.fDeleteAllButton.setEnabled(history != null && !history.isEmpty());
        this.fDeleteButton.setEnabled(false);
        this.fEditButton.setEnabled(false);
    }
}

