/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryControl;
import org.eclipse.ltk.internal.ui.refactoring.util.SWTUtil;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectRefactoringHistoryControl
extends RefactoringHistoryControl {
    protected static final RefactoringDescriptorProxy[] EMPTY_DESCRIPTORS = new RefactoringDescriptorProxy[0];
    private Button fDeselectAllButton = null;
    private Button fSelectAllButton = null;

    public SelectRefactoringHistoryControl(Composite parent, RefactoringHistoryControlConfiguration configuration) {
        super(parent, configuration);
    }

    protected void createButtonBar(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        composite.setLayoutData((Object)data);
        this.fSelectAllButton = new Button(composite, 0);
        this.fSelectAllButton.setEnabled(false);
        this.fSelectAllButton.setText(RefactoringUIMessages.SelectRefactoringHistoryControl_select_all_label);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.widthHint = SWTUtil.getButtonWidthHint(this.fSelectAllButton);
        this.fSelectAllButton.setLayoutData((Object)data);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                SelectRefactoringHistoryControl.this.handleSelectAll();
            }
        });
        this.fDeselectAllButton = new Button(composite, 0);
        this.fDeselectAllButton.setEnabled(false);
        this.fDeselectAllButton.setText(RefactoringUIMessages.SelectRefactoringHistoryControl_deselect_all_label);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.widthHint = SWTUtil.getButtonWidthHint(this.fDeselectAllButton);
        this.fDeselectAllButton.setLayoutData((Object)data);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                SelectRefactoringHistoryControl.this.handleDeselectAll();
            }
        });
        Dialog.applyDialogFont((Control)parent);
    }

    protected TreeViewer createHistoryViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        if (this.fControlConfiguration.isCheckableViewer()) {
            return new RefactoringHistoryControl.RefactoringHistoryTreeViewer(parent, 770);
        }
        return new TreeViewer(parent, 770);
    }

    public Button getDeselectAllButton() {
        return this.fDeselectAllButton;
    }

    public Button getSelectAllButton() {
        return this.fSelectAllButton;
    }

    protected void handleCheckStateChanged() {
        super.handleCheckStateChanged();
        RefactoringHistory history = this.getInput();
        if (history != null) {
            int total;
            int checked = this.getCheckedDescriptors().length;
            this.fSelectAllButton.setEnabled(checked < (total = history.getDescriptors().length));
            this.fDeselectAllButton.setEnabled(checked > 0);
        }
    }

    protected void handleDeselectAll() {
        this.setCheckedDescriptors(EMPTY_DESCRIPTORS);
    }

    protected void handleSelectAll() {
        RefactoringHistory history = this.getInput();
        if (history != null) {
            this.setCheckedDescriptors(history.getDescriptors());
        }
    }

    public void setInput(RefactoringHistory history) {
        super.setInput(history);
        this.fDeselectAllButton.setEnabled(false);
        this.fSelectAllButton.setEnabled(history != null && !history.isEmpty());
    }
}

