/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.compare.IStreamMerger;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.team.core.mapping.IStorageMerger;

public final class RefactoringHistoryMerger
implements IStreamMerger,
IStorageMerger {
    public boolean canMergeWithoutAncestor() {
        return true;
    }

    public IStatus merge(OutputStream output, String outputEncoding, InputStream ancestor, String ancestorEncoding, InputStream target, String targetEncoding, InputStream source, String sourceEncoding, IProgressMonitor monitor) {
        try {
            this.performMerge(output, target, source);
        }
        catch (CoreException exception) {
            return new Status(4, RefactoringUIPlugin.getPluginId(), 1, RefactoringUIMessages.RefactoringHistoryMerger_error_auto_merge, (Throwable)exception);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus merge(OutputStream output, String encoding, IStorage ancestor, IStorage target, IStorage other, IProgressMonitor monitor) throws CoreException {
        InputStream sourceStream;
        block17: {
            InputStream targetStream = null;
            sourceStream = null;
            try {
                try {
                    targetStream = target.getContents();
                    sourceStream = target.getContents();
                    this.performMerge(output, targetStream, sourceStream);
                }
                catch (CoreException exception) {
                    Status status = new Status(4, RefactoringUIPlugin.getPluginId(), 1, RefactoringUIMessages.RefactoringHistoryMerger_error_auto_merge, (Throwable)exception);
                    Object var10_11 = null;
                    if (targetStream != null) {
                        try {
                            targetStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (sourceStream == null) return status;
                    try {
                        sourceStream.close();
                        return status;
                    }
                    catch (IOException iOException) {}
                    return status;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (targetStream != null) {
                    try {}
                    catch (IOException iOException) {}
                    targetStream.close();
                }
                if (sourceStream == null) throw throwable;
                try {}
                catch (IOException iOException) {}
                sourceStream.close();
                throw throwable;
                throw throwable;
            }
            {
                Object var10_13 = null;
                if (targetStream == null) break block17;
            }
            try {}
            catch (IOException iOException) {}
            targetStream.close();
        }
        if (sourceStream == null) return Status.OK_STATUS;
        try {}
        catch (IOException iOException) {
            return Status.OK_STATUS;
        }
        sourceStream.close();
        return Status.OK_STATUS;
    }

    private void performMerge(OutputStream output, InputStream target, InputStream source) throws CoreException {
        RefactoringDescriptor[] sourceDescriptors = RefactoringHistoryManager.readRefactoringDescriptors((InputStream)source, (long)0L, (long)Long.MAX_VALUE);
        RefactoringDescriptor[] targetDescriptors = RefactoringHistoryManager.readRefactoringDescriptors((InputStream)target, (long)0L, (long)Long.MAX_VALUE);
        HashSet<RefactoringDescriptor> set = new HashSet<RefactoringDescriptor>();
        int index = 0;
        while (index < sourceDescriptors.length) {
            set.add(sourceDescriptors[index]);
            ++index;
        }
        index = 0;
        while (index < targetDescriptors.length) {
            set.add(targetDescriptors[index]);
            ++index;
        }
        RefactoringDescriptor[] outputDescriptors = new RefactoringDescriptor[set.size()];
        set.toArray(outputDescriptors);
        Arrays.sort(outputDescriptors, new Comparator(){

            public final int compare(Object first, Object second) {
                RefactoringDescriptor predecessor = (RefactoringDescriptor)first;
                RefactoringDescriptor successor = (RefactoringDescriptor)second;
                return (int)(successor.getTimeStamp() - predecessor.getTimeStamp());
            }
        });
        RefactoringHistoryManager.writeRefactoringDescriptors((OutputStream)output, (RefactoringDescriptor[])outputDescriptors, (boolean)true);
    }
}

