/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.history;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.IInitializableRefactoringComponent;
import org.eclipse.ltk.core.refactoring.IRefactoringInstanceCreator;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformRefactoringHistoryOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.IErrorWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringHistoryPreviewPage;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusEntryFilter;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.UIPerformChangeOperation;
import org.eclipse.ltk.internal.ui.refactoring.WorkbenchRunnableAdapter;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryErrorPage;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryOverviewPage;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class RefactoringHistoryWizard
extends Wizard {
    private static final String PREFERENCE_DO_NOT_SHOW_APPLY_ERROR = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.show.apply.refactoring";
    private static final String PREFERENCE_DO_NOT_SHOW_SKIP = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.show.skip.refactoring";
    private static final String PREFERENCE_DO_NOT_WARN_FINISH = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.warn.finish.wizard";
    public static final int STATUS_CODE_INTERRUPTED = 10003;
    private boolean fAboutToPerformFired = false;
    private RefactoringHistoryControlConfiguration fControlConfiguration;
    private int fCurrentRefactoring = 0;
    private RefactoringDescriptorProxy[] fDescriptorProxies = null;
    private final RefactoringHistoryErrorPage fErrorPage;
    private boolean fInAddPages = false;
    private final String fOverviewDescription;
    private RefactoringHistoryOverviewPage fOverviewPage;
    private final String fOverviewTitle;
    private RefactoringPreviewChangeFilter fPreviewChangeFilter = new RefactoringPreviewChangeFilter(){

        public final boolean select(Change change) {
            return RefactoringHistoryWizard.this.selectPreviewChange(change);
        }
    };
    private final RefactoringHistoryPreviewPage fPreviewPage;
    private RefactoringHistory fRefactoringHistory;
    private RefactoringStatusEntryFilter fStatusEntryFilter = new RefactoringStatusEntryFilter(){

        public final boolean select(RefactoringStatusEntry entry) {
            return RefactoringHistoryWizard.this.selectStatusEntry(entry);
        }
    };

    public RefactoringHistoryWizard(String caption, String title, String description) {
        Assert.isNotNull((Object)caption);
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)description);
        this.fOverviewTitle = title;
        this.fOverviewDescription = description;
        this.fErrorPage = new RefactoringHistoryErrorPage();
        this.fErrorPage.setFilter(this.fStatusEntryFilter);
        this.fPreviewPage = new RefactoringHistoryPreviewPage();
        this.fPreviewPage.setFilter(this.fPreviewChangeFilter);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(caption);
        this.setDefaultPageImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_REFACTOR);
    }

    protected RefactoringStatus aboutToPerformHistory(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        return new RefactoringStatus();
    }

    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)descriptor);
        RefactoringStatus status = new RefactoringStatus();
        if (refactoring instanceof IInitializableRefactoringComponent) {
            IInitializableRefactoringComponent component = (IInitializableRefactoringComponent)refactoring;
            RefactoringArguments arguments = RefactoringCore.getRefactoringInstanceCreator().createArguments(descriptor);
            if (arguments != null) {
                status.merge(component.initialize(arguments));
            } else {
                status.addFatalError(Messages.format(RefactoringUIMessages.PerformRefactoringHistoryOperation_init_error, new String[]{descriptor.getDescription()}));
            }
        } else {
            status.addFatalError(Messages.format(RefactoringUIMessages.PerformRefactoringHistoryOperation_init_error, new String[]{descriptor.getDescription()}));
        }
        return status;
    }

    public final void addPage(IWizardPage page) {
        Assert.isTrue((boolean)this.fInAddPages);
        super.addPage(page);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addPages() {
        try {
            this.fInAddPages = true;
            this.addUserDefinedPages();
            Assert.isNotNull((Object)this.fRefactoringHistory);
            Assert.isNotNull((Object)this.fControlConfiguration);
            this.fOverviewPage = new RefactoringHistoryOverviewPage(this.fRefactoringHistory, this.fOverviewTitle, this.fOverviewDescription, this.fControlConfiguration);
            this.addPage((IWizardPage)this.fOverviewPage);
            this.addPage(this.fErrorPage);
            this.addPage(this.fPreviewPage);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fInAddPages = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fInAddPages = false;
            return;
        }
    }

    protected void addUserDefinedPages() {
        Assert.isTrue((boolean)this.fInAddPages);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.fErrorPage) {
            RefactoringStatus status = this.fErrorPage.getStatus();
            return status == null || !status.hasFatalError();
        }
        return true;
    }

    private RefactoringStatus checkConditions(Refactoring refactoring, IProgressMonitor monitor, int style) throws OperationCanceledException {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            CheckConditionsOperation operation = new CheckConditionsOperation(refactoring, style);
            operation.run(monitor);
            status.merge(operation.getStatus());
        }
        catch (CoreException exception) {
            RefactoringUIPlugin.log(exception);
            status.addFatalError(RefactoringUIMessages.RefactoringWizard_internal_error_1);
        }
        return status;
    }

    private Change createChange(Refactoring refactoring, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)monitor);
        CreateChangeOperation operation = new CreateChangeOperation(refactoring);
        operation.run(monitor);
        return operation.getChange();
    }

    public void dispose() {
        Platform.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                RefactoringUIPlugin.log(exception);
            }

            public final void run() throws Exception {
                RefactoringStatusEntry entry;
                if (RefactoringHistoryWizard.this.fAboutToPerformFired && (entry = RefactoringHistoryWizard.this.historyPerformed((IProgressMonitor)new NullProgressMonitor()).getEntryWithHighestSeverity()) != null) {
                    RefactoringUIPlugin.log((IStatus)new Status(4, entry.getPluginId(), entry.getCode(), entry.getMessage(), null));
                }
            }
        });
        super.dispose();
    }

    private RefactoringStatus fireAboutToPerformHistory(final IProgressMonitor monitor) {
        final RefactoringStatus status = new RefactoringStatus();
        Platform.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                RefactoringUIPlugin.log(exception);
                status.addFatalError(RefactoringUIMessages.RefactoringWizard_unexpected_exception_1);
            }

            public final void run() throws Exception {
                status.merge(RefactoringHistoryWizard.this.aboutToPerformHistory(monitor));
            }
        });
        return status;
    }

    private RefactoringDescriptorProxy getCurrentDescriptor() {
        RefactoringDescriptorProxy[] proxies = this.getRefactoringDescriptors();
        if (this.fCurrentRefactoring >= 0 && this.fCurrentRefactoring < proxies.length) {
            return proxies[this.fCurrentRefactoring];
        }
        return null;
    }

    private Refactoring getCurrentRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        IRefactoringInstanceCreator factory = RefactoringCore.getRefactoringInstanceCreator();
        Refactoring refactoring = factory.createRefactoring(descriptor);
        if (refactoring != null) {
            status.merge(this.aboutToPerformRefactoring(refactoring, descriptor, monitor));
            if (!status.hasFatalError()) {
                return refactoring;
            }
        } else {
            status.addFatalError(NLS.bind((String)RefactoringUIMessages.RefactoringHistoryWizard_error_instantiate_refactoring, (Object)descriptor.getDescription()));
        }
        return null;
    }

    public final IErrorWizardPage getErrorPage() {
        return this.fErrorPage;
    }

    /*
     * Unable to fully structure code
     */
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fOverviewPage) {
            this.fCurrentRefactoring = 0;
            return this.getRefactoringPage();
        }
        if (page == this.fPreviewPage) {
            ++this.fCurrentRefactoring;
            return this.getRefactoringPage();
        }
        if (page == this.fErrorPage) {
            status = this.fErrorPage.getStatus();
            wizard = this.getContainer();
            if (status.hasFatalError()) {
                store = RefactoringUIPlugin.getDefault().getPreferenceStore();
                message = null;
                key = null;
                if (!RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title.equals(this.fErrorPage.getTitle())) {
                    message = NLS.bind((String)RefactoringUIMessages.RefactoringHistoryWizard_fatal_error_message, (Object)this.fErrorPage.getTitle());
                    key = RefactoringHistoryWizard.PREFERENCE_DO_NOT_SHOW_SKIP;
                } else {
                    message = RefactoringUIMessages.RefactoringHistoryWizard_error_applying_changes;
                    key = RefactoringHistoryWizard.PREFERENCE_DO_NOT_SHOW_APPLY_ERROR;
                }
                if (!store.getBoolean(key)) {
                    dialog = MessageDialogWithToggle.openWarning((Shell)this.getShell(), (String)wizard.getShell().getText(), (String)message, (String)RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, (boolean)false, null, null);
                    store.setValue(key, dialog.getToggleState());
                }
                ++this.fCurrentRefactoring;
                return this.getRefactoringPage();
            }
            refactoring = this.fErrorPage.getRefactoring();
            if (refactoring != null) {
                runnable = new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Assert.isNotNull((Object)monitor);
                        try {
                            try {
                                RefactoringHistoryWizard.this.fPreviewPage.setRefactoring(refactoring);
                                Change change = RefactoringHistoryWizard.this.createChange(refactoring, monitor);
                                RefactoringHistoryWizard.this.getShell().getDisplay().syncExec(new Runnable(this, change){
                                    final /* synthetic */ 5 this$1;
                                    private final /* synthetic */ Change val$change;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$change = change;
                                    }

                                    public final void run() {
                                        RefactoringHistoryWizard.access$1(5.access$0(this.this$1)).setChange(this.val$change);
                                    }
                                });
                            }
                            catch (CoreException exception) {
                                throw new InvocationTargetException(exception);
                            }
                            catch (OperationCanceledException exception) {
                                throw new InterruptedException(exception.getLocalizedMessage());
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_6 = null;
                            monitor.done();
                            throw throwable;
                        }
                        {
                            Object var3_7 = null;
                        }
                        monitor.done();
                    }

                    static /* synthetic */ RefactoringHistoryWizard access$0(5 var0) {
                        return var0.RefactoringHistoryWizard.this;
                    }
                };
                try {
                    wizard.run(true, false, runnable);
                }
                catch (InvocationTargetException exception) {
                    throwable = exception.getTargetException();
                    if (throwable == null) ** GOTO lbl41
                    RefactoringUIPlugin.log(exception);
                    this.fErrorPage.setStatus(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringWizard_unexpected_exception_1));
                    return this.fErrorPage;
                }
                catch (InterruptedException v0) {
                    return this.fErrorPage;
                }
            } else {
                this.fPreviewPage.setRefactoring(null);
                this.fPreviewPage.setChange(null);
            }
lbl41:
            // 3 sources

            descriptor = this.getCurrentDescriptor();
            if (descriptor != null) {
                this.fPreviewPage.setTitle(descriptor, this.fCurrentRefactoring, this.fDescriptorProxies.length);
            } else {
                this.fPreviewPage.setTitle(RefactoringUIMessages.PreviewWizardPage_changes);
            }
            this.fPreviewPage.setStatus(status);
            this.fPreviewPage.setNextPageDisabled(this.isLastRefactoring());
            return this.fPreviewPage;
        }
        return super.getNextPage(page);
    }

    public final IPreviewWizardPage getPreviewPage() {
        return this.fPreviewPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.fErrorPage || page == this.fPreviewPage) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    private RefactoringDescriptorProxy[] getRefactoringDescriptors() {
        if (this.fDescriptorProxies == null) {
            RefactoringDescriptorProxy[] proxies = this.fRefactoringHistory.getDescriptors();
            RefactoringDescriptorProxy[] result = new RefactoringDescriptorProxy[proxies.length];
            System.arraycopy(proxies, 0, result, 0, proxies.length);
            Arrays.sort(result, new Comparator(){

                public final int compare(Object first, Object second) {
                    RefactoringDescriptorProxy predecessor = (RefactoringDescriptorProxy)first;
                    RefactoringDescriptorProxy successor = (RefactoringDescriptorProxy)second;
                    return (int)(predecessor.getTimeStamp() - successor.getTimeStamp());
                }
            });
            this.fDescriptorProxies = result;
        }
        return this.fDescriptorProxies;
    }

    private IWizardPage getRefactoringPage() {
        final IWizardPage[] result = new IWizardPage[1];
        final RefactoringStatus status = new RefactoringStatus();
        IWizardContainer wizard = this.getContainer();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Assert.isNotNull((Object)monitor);
                try {
                    block18: {
                        try {
                            RefactoringDescriptorProxy proxy;
                            boolean last;
                            block20: {
                                monitor.beginTask(RefactoringUIMessages.RefactoringHistoryWizard_preparing_refactoring, 220);
                                result[0] = null;
                                if (!RefactoringHistoryWizard.this.fAboutToPerformFired) {
                                    try {
                                        status.merge(RefactoringHistoryWizard.this.fireAboutToPerformHistory((IProgressMonitor)new SubProgressMonitor(monitor, 50, 2)));
                                        Object var2_5 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var2_4 = null;
                                        RefactoringHistoryWizard.this.fAboutToPerformFired = true;
                                        throw throwable;
                                    }
                                    RefactoringHistoryWizard.this.fAboutToPerformFired = true;
                                }
                                last = RefactoringHistoryWizard.this.isLastRefactoring();
                                proxy = RefactoringHistoryWizard.this.getCurrentDescriptor();
                                RefactoringHistoryWizard.this.preparePreviewPage(status, proxy, last);
                                RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last || status.hasFatalError());
                                RefactoringHistoryWizard.this.fErrorPage.setRefactoring(null);
                                if (!status.isOK()) {
                                    result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                    break block18;
                                }
                                if (proxy == null) break block20;
                                IRefactoringHistoryService service = RefactoringCore.getRefactoringHistoryService();
                                try {
                                    block19: {
                                        block21: {
                                            block22: {
                                                service.connect();
                                                RefactoringDescriptor descriptor = proxy.requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                                                if (descriptor == null || descriptor.isUnknown()) break block21;
                                                Refactoring refactoring = RefactoringHistoryWizard.this.getCurrentRefactoring(descriptor, status, (IProgressMonitor)new SubProgressMonitor(monitor, 60, 2));
                                                if (refactoring == null || !status.isOK()) break block22;
                                                RefactoringHistoryWizard.this.fPreviewPage.setRefactoring(refactoring);
                                                RefactoringHistoryWizard.this.fErrorPage.setRefactoring(refactoring);
                                                status.merge(RefactoringHistoryWizard.this.checkConditions(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2), 2));
                                                if (!status.isOK()) {
                                                    RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                                    result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                                    break block19;
                                                } else {
                                                    status.merge(RefactoringHistoryWizard.this.checkConditions(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 65, 2), 4));
                                                    if (!status.isOK()) {
                                                        RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                                        result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                                        break block19;
                                                    } else {
                                                        Change change = RefactoringHistoryWizard.this.createChange(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 5, 2));
                                                        RefactoringHistoryWizard.this.getShell().getDisplay().syncExec(new Runnable(this, change){
                                                            final /* synthetic */ 8 this$1;
                                                            private final /* synthetic */ Change val$change;
                                                            {
                                                                this.this$1 = var1_1;
                                                                this.val$change = change;
                                                            }

                                                            public final void run() {
                                                                RefactoringHistoryWizard.access$1(8.access$0(this.this$1)).setChange(this.val$change);
                                                            }
                                                        });
                                                        result[0] = RefactoringHistoryWizard.this.fPreviewPage;
                                                    }
                                                }
                                                break block19;
                                            }
                                            RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                            result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                            break block19;
                                        }
                                        status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringHistoryWizard_error_resolving_refactoring));
                                        RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                                        result[0] = RefactoringHistoryWizard.this.fErrorPage;
                                    }
                                    Object var8_15 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var8_14 = null;
                                    service.disconnect();
                                    throw throwable;
                                }
                                service.disconnect();
                                break block18;
                            }
                            RefactoringHistoryWizard.this.prepareErrorPage(status, proxy, status.hasFatalError(), last);
                            result[0] = RefactoringHistoryWizard.this.fErrorPage;
                        }
                        catch (CoreException exception) {
                            throw new InvocationTargetException(exception);
                        }
                        catch (OperationCanceledException exception) {
                            throw new InterruptedException(exception.getLocalizedMessage());
                        }
                    }
                    Object var10_18 = null;
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }

            static /* synthetic */ RefactoringHistoryWizard access$0(8 var0) {
                return var0.RefactoringHistoryWizard.this;
            }
        };
        try {
            wizard.run(true, false, runnable);
        }
        catch (InvocationTargetException exception) {
            RefactoringUIPlugin.log(exception);
            Throwable throwable = exception.getTargetException();
            if (throwable != null) {
                this.fErrorPage.setNextPageDisabled(this.isLastRefactoring());
                this.fErrorPage.setStatus(RefactoringStatus.createFatalErrorStatus((String)RefactoringUIMessages.RefactoringWizard_unexpected_exception_1));
                result[0] = this.fErrorPage;
            }
        }
        catch (InterruptedException interruptedException) {
            result[0] = null;
        }
        return result[0];
    }

    protected RefactoringStatus historyPerformed(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        return new RefactoringStatus();
    }

    private boolean isLastRefactoring() {
        return this.fCurrentRefactoring >= this.getRefactoringDescriptors().length - 1;
    }

    private boolean isSecondLastRefactoring() {
        return this.fCurrentRefactoring >= this.getRefactoringDescriptors().length - 2;
    }

    public boolean performFinish() {
        IWizardContainer wizard = this.getContainer();
        final RefactoringStatus status = new RefactoringStatus();
        RefactoringDescriptorProxy[] proxies = this.getRefactoringDescriptors();
        ArrayList<RefactoringDescriptorProxy> list = new ArrayList<RefactoringDescriptorProxy>(proxies.length);
        int index = this.fCurrentRefactoring;
        while (index < proxies.length) {
            list.add(proxies[index]);
            ++index;
        }
        RefactoringDescriptorProxy[] descriptors = new RefactoringDescriptorProxy[list.size()];
        list.toArray(descriptors);
        boolean last = this.isLastRefactoring();
        if (wizard.getCurrentPage() == this.fPreviewPage && last) {
            Refactoring refactoring = this.fPreviewPage.getRefactoring();
            Change change = this.fPreviewPage.getChange();
            if (refactoring != null && change != null) {
                status.merge(this.performPreviewChange(change, refactoring));
                if (!status.isOK()) {
                    RefactoringStatusEntry entry = status.getEntryWithHighestSeverity();
                    if (entry.getSeverity() == 1 && entry.getCode() == 10003) {
                        return false;
                    }
                    this.fErrorPage.setStatus(status);
                    this.fErrorPage.setNextPageDisabled(true);
                    this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title);
                    this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error);
                    wizard.showPage((IWizardPage)this.fErrorPage);
                    return false;
                }
            }
        } else {
            IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
            if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_FINISH) && proxies.length > 0) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openWarning((Shell)this.getShell(), (String)wizard.getShell().getText(), (String)Messages.format(RefactoringUIMessages.RefactoringHistoryWizard_warning_finish, this.getLabelAsText(IDialogConstants.FINISH_LABEL)), (String)RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, (boolean)false, null, null);
                store.setValue(PREFERENCE_DO_NOT_WARN_FINISH, dialog.getToggleState());
            }
            PerformRefactoringHistoryOperation operation = new PerformRefactoringHistoryOperation((RefactoringHistory)new RefactoringHistoryImplementation(descriptors)){

                protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
                    RefactoringStatus[] result = new RefactoringStatus[]{new RefactoringStatus()};
                    Platform.run((ISafeRunnable)new ISafeRunnable(this, result, refactoring, descriptor, monitor){
                        final /* synthetic */ 10 this$1;
                        private final /* synthetic */ RefactoringStatus[] val$result;
                        private final /* synthetic */ Refactoring val$refactoring;
                        private final /* synthetic */ RefactoringDescriptor val$descriptor;
                        private final /* synthetic */ IProgressMonitor val$monitor;
                        {
                            this.this$1 = var1_1;
                            this.val$result = refactoringStatusArray;
                            this.val$refactoring = refactoring;
                            this.val$descriptor = refactoringDescriptor;
                            this.val$monitor = iProgressMonitor;
                        }

                        public void handleException(Throwable exception) {
                            RefactoringUIPlugin.log(exception);
                        }

                        public final void run() throws Exception {
                            this.val$result[0] = 10.access$0(this.this$1).aboutToPerformRefactoring(this.val$refactoring, this.val$descriptor, this.val$monitor);
                        }
                    });
                    return result[0];
                }

                protected void refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
                    Platform.run((ISafeRunnable)new ISafeRunnable(this, refactoring, monitor){
                        final /* synthetic */ 10 this$1;
                        private final /* synthetic */ Refactoring val$refactoring;
                        private final /* synthetic */ IProgressMonitor val$monitor;
                        {
                            this.this$1 = var1_1;
                            this.val$refactoring = refactoring;
                            this.val$monitor = iProgressMonitor;
                        }

                        public void handleException(Throwable exception) {
                            RefactoringUIPlugin.log(exception);
                        }

                        public final void run() throws Exception {
                            10.access$0(this.this$1).refactoringPerformed(this.val$refactoring, this.val$monitor);
                        }
                    });
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        monitor.beginTask(RefactoringUIMessages.RefactoringHistoryWizard_preparing_refactorings, 100);
                        if (!RefactoringHistoryWizard.this.fAboutToPerformFired) {
                            try {
                                status.merge(RefactoringHistoryWizard.this.fireAboutToPerformHistory((IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)));
                            }
                            catch (Throwable throwable) {
                                Object var2_3 = null;
                                RefactoringHistoryWizard.this.fAboutToPerformFired = true;
                                throw throwable;
                            }
                            {
                                Object var2_4 = null;
                            }
                            RefactoringHistoryWizard.this.fAboutToPerformFired = true;
                        }
                        if (!status.isOK()) {
                            throw new CoreException((IStatus)new Status(status.getSeverity(), RefactoringUIPlugin.getPluginId(), 0, null, null));
                        }
                        super.run((IProgressMonitor)new SubProgressMonitor(monitor, 80, 2));
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var4_7 = null;
                    }
                    monitor.done();
                }

                static /* synthetic */ RefactoringHistoryWizard access$0(10 var0) {
                    return var0.RefactoringHistoryWizard.this;
                }
            };
            try {
                wizard.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)operation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            }
            catch (InvocationTargetException exception) {
                RefactoringUIPlugin.log(exception);
                Throwable throwable = exception.getTargetException();
                if (throwable != null) {
                    String message = throwable.getLocalizedMessage();
                    if (message != null && !"".equals(message)) {
                        status.merge(RefactoringStatus.createFatalErrorStatus((String)message));
                    }
                    this.fErrorPage.setStatus(status);
                    this.fErrorPage.setNextPageDisabled(status.hasFatalError());
                    this.fErrorPage.setTitle(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error_title);
                    this.fErrorPage.setDescription(RefactoringUIMessages.RefactoringHistoryPreviewPage_apply_error);
                    wizard.showPage((IWizardPage)this.fErrorPage);
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    protected String getLabelAsText(String label) {
        Assert.isNotNull((Object)label);
        StringBuffer buffer = new StringBuffer(label.length());
        int index = 0;
        while (index < label.length()) {
            char character = label.charAt(index);
            if (character != '&') {
                buffer.append(character);
            }
            ++index;
        }
        return buffer.toString();
    }

    public final RefactoringStatus performPreviewChange(Change change, final Refactoring refactoring) {
        Assert.isNotNull((Object)change);
        Assert.isNotNull((Object)refactoring);
        UIPerformChangeOperation operation = new UIPerformChangeOperation(this.getShell().getDisplay(), change, this.getContainer()){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(RefactoringUIMessages.RefactoringHistoryWizard_preparing_changes, 12);
                    super.run((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                    RefactoringHistoryWizard.this.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 2, 2));
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                monitor.done();
            }
        };
        RefactoringStatus status = this.performPreviewChange(operation, refactoring);
        if (status.isOK()) {
            status.merge(operation.getValidationStatus());
        }
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus performPreviewChange(PerformChangeOperation operation, Refactoring refactoring) {
        Assert.isNotNull((Object)operation);
        Assert.isNotNull((Object)refactoring);
        operation.setUndoManager(RefactoringCore.getUndoManager(), refactoring.getName());
        IWizardContainer wizard = this.getContainer();
        Shell shell = wizard.getShell();
        try {
            try {
                wizard.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)operation, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot()));
            }
            catch (InvocationTargetException exception) {
                Throwable throwable = exception.getTargetException();
                if (operation.changeExecutionFailed()) {
                    Change change = operation.getChange();
                    ChangeExceptionHandler handler = new ChangeExceptionHandler(shell, refactoring);
                    if (throwable instanceof RuntimeException) {
                        handler.handle(change, (RuntimeException)throwable);
                    } else if (throwable instanceof CoreException) {
                        handler.handle(change, (CoreException)throwable);
                    }
                }
                ExceptionHandler.handle(exception, shell, RefactoringUIMessages.RefactoringWizard_refactoring, RefactoringUIMessages.RefactoringWizard_unexpected_exception_1);
            }
            catch (InterruptedException exception) {
                RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)new Status(1, RefactoringUIPlugin.getPluginId(), 10003, exception.getLocalizedMessage(), (Throwable)exception));
                Object var9_11 = null;
                this.fPreviewPage.setNextPageDisabled(this.isSecondLastRefactoring());
                this.getContainer().updateButtons();
                return refactoringStatus;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.fPreviewPage.setNextPageDisabled(this.isSecondLastRefactoring());
            this.getContainer().updateButtons();
            throw throwable;
        }
        {
            Object var9_13 = null;
            this.fPreviewPage.setNextPageDisabled(this.isSecondLastRefactoring());
        }
        this.getContainer().updateButtons();
        return new RefactoringStatus();
    }

    private void prepareErrorPage(final RefactoringStatus status, final RefactoringDescriptorProxy descriptor, final boolean fatal, final boolean disabled) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public final void run() {
                RefactoringHistoryWizard.this.fErrorPage.setTitle(descriptor, RefactoringHistoryWizard.this.fCurrentRefactoring, RefactoringHistoryWizard.this.fDescriptorProxies.length);
                RefactoringHistoryWizard.this.fErrorPage.setNextPageDisabled(disabled && fatal);
                RefactoringHistoryWizard.this.fErrorPage.setPageComplete(!fatal);
                RefactoringHistoryWizard.this.fErrorPage.setStatus(null);
                RefactoringHistoryWizard.this.fErrorPage.setStatus(status);
            }
        });
    }

    private void preparePreviewPage(final RefactoringStatus status, final RefactoringDescriptorProxy descriptor, final boolean disabled) {
        this.getShell().getDisplay().syncExec(new Runnable(){

            public final void run() {
                RefactoringHistoryWizard.this.fPreviewPage.setTitle(descriptor, RefactoringHistoryWizard.this.fCurrentRefactoring, RefactoringHistoryWizard.this.fDescriptorProxies.length);
                RefactoringHistoryWizard.this.fPreviewPage.setNextPageDisabled(disabled);
                RefactoringHistoryWizard.this.fPreviewPage.setPageComplete(!disabled);
                RefactoringHistoryWizard.this.fPreviewPage.setStatus(status);
            }
        });
    }

    protected RefactoringStatus refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)monitor);
        return new RefactoringStatus();
    }

    protected boolean selectPreviewChange(Change change) {
        return true;
    }

    protected boolean selectStatusEntry(RefactoringStatusEntry entry) {
        return true;
    }

    public final void setConfiguration(RefactoringHistoryControlConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
    }

    public final void setInput(RefactoringHistory history) {
        Assert.isNotNull((Object)history);
        this.fRefactoringHistory = history;
    }
}

