/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;

public final class UScript {
    private static final String copyrightNotice = "Copyright \u00a92001 IBM Corp.  All rights reserved.";
    public static final int INVALID_CODE = -1;
    public static final int COMMON = 0;
    public static final int INHERITED = 1;
    public static final int ARABIC = 2;
    public static final int ARMENIAN = 3;
    public static final int BENGALI = 4;
    public static final int BOPOMOFO = 5;
    public static final int CHEROKEE = 6;
    public static final int COPTIC = 7;
    public static final int CYRILLIC = 8;
    public static final int DESERET = 9;
    public static final int DEVANAGARI = 10;
    public static final int ETHIOPIC = 11;
    public static final int GEORGIAN = 12;
    public static final int GOTHIC = 13;
    public static final int GREEK = 14;
    public static final int GUJARATI = 15;
    public static final int GURMUKHI = 16;
    public static final int HAN = 17;
    public static final int HANGUL = 18;
    public static final int HEBREW = 19;
    public static final int HIRAGANA = 20;
    public static final int KANNADA = 21;
    public static final int KATAKANA = 22;
    public static final int KHMER = 23;
    public static final int LAO = 24;
    public static final int LATIN = 25;
    public static final int MALAYALAM = 26;
    public static final int MONGOLIAN = 27;
    public static final int MYANMAR = 28;
    public static final int OGHAM = 29;
    public static final int OLD_ITALIC = 30;
    public static final int ORIYA = 31;
    public static final int RUNIC = 32;
    public static final int SINHALA = 33;
    public static final int SYRIAC = 34;
    public static final int TAMIL = 35;
    public static final int TELUGU = 36;
    public static final int THAANA = 37;
    public static final int THAI = 38;
    public static final int TIBETAN = 39;
    public static final int CANADIAN_ABORIGINAL = 40;
    public static final int UCAS = 40;
    public static final int YI = 41;
    public static final int TAGALOG = 42;
    public static final int HANUNOO = 43;
    public static final int BUHID = 44;
    public static final int TAGBANWA = 45;
    public static final int BRAILLE = 46;
    public static final int CYPRIOT = 47;
    public static final int LIMBU = 48;
    public static final int LINEAR_B = 49;
    public static final int OSMANYA = 50;
    public static final int SHAVIAN = 51;
    public static final int TAI_LE = 52;
    public static final int UGARITIC = 53;
    public static final int KATAKANA_OR_HIRAGANA = 54;
    public static final int BUGINESE = 55;
    public static final int GLAGOLITIC = 56;
    public static final int KHAROSHTHI = 57;
    public static final int SYLOTI_NAGRI = 58;
    public static final int NEW_TAI_LUE = 59;
    public static final int TIFINAGH = 60;
    public static final int OLD_PERSIAN = 61;
    public static final int CODE_LIMIT = 62;
    private static final int SCRIPT_MASK = 127;
    private static final UCharacterProperty prop = UCharacterProperty.getInstance();

    private static int[] findCodeFromLocale(ULocale locale) {
        ICUResourceBundle rb;
        try {
            rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt35b", locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
        if (rb.getLoadingStatus() == 3 && !locale.equals(ULocale.getDefault())) {
            return null;
        }
        ICUResourceBundle sub = rb.get("LocaleScript");
        int[] result = new int[sub.getSize()];
        int w = 0;
        for (int i = 0; i < result.length; ++i) {
            int code = UCharacter.getPropertyValueEnum(4106, sub.getString(i));
            result[w++] = code;
        }
        if (w < result.length) {
            throw new InternalError("bad locale data, listed " + result.length + " scripts but found only " + w);
        }
        return result;
    }

    public static final int[] getCode(Locale locale) {
        return UScript.findCodeFromLocale(ULocale.forLocale(locale));
    }

    public static final int[] getCode(ULocale locale) {
        return UScript.findCodeFromLocale(locale);
    }

    public static final int[] getCode(String nameOrAbbrOrLocale) {
        try {
            return new int[]{UCharacter.getPropertyValueEnum(4106, nameOrAbbrOrLocale)};
        }
        catch (IllegalArgumentException e) {
            return UScript.findCodeFromLocale(new ULocale(nameOrAbbrOrLocale));
        }
    }

    public static final int getCodeFromName(String nameOrAbbr) {
        try {
            return UCharacter.getPropertyValueEnum(4106, nameOrAbbr);
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }

    public static final int getScript(int codepoint) {
        if (codepoint >= 0 & codepoint <= 0x10FFFF) {
            return prop.getAdditional(codepoint, 0) & 0x7F;
        }
        throw new IllegalArgumentException(Integer.toString(codepoint));
    }

    public static final String getName(int scriptCode) {
        return UCharacter.getPropertyValueName(4106, scriptCode, 1);
    }

    public static final String getShortName(int scriptCode) {
        return UCharacter.getPropertyValueName(4106, scriptCode, 0);
    }

    private UScript() {
    }
}

