/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEditGroup;

public abstract class AbstractFix
implements IFix {
    private final String fName;
    private final ICompilationUnit fCompilationUnit;
    private final IFixRewriteOperation[] fFixRewrites;
    private final CompilationUnit fUnit;

    protected AbstractFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        this.fName = name;
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fFixRewrites = fixRewriteOperations;
        this.fUnit = compilationUnit;
    }

    public String getDescription() {
        return this.fName;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public TextChange createChange() throws CoreException {
        if (this.fFixRewrites == null || this.fFixRewrites.length == 0) {
            return null;
        }
        CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(this.getCompilationUnit(), this.fUnit);
        ArrayList groups = new ArrayList();
        int i = 0;
        while (i < this.fFixRewrites.length) {
            this.fFixRewrites[i].rewriteAST(cuRewrite, groups);
            ++i;
        }
        CompilationUnitChange result = cuRewrite.createChange();
        if (result == null) {
            return null;
        }
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            TextEditGroup group = (TextEditGroup)iter.next();
            result.addTextEditGroup(group);
        }
        return result;
    }

    public static abstract class AbstractFixRewriteOperation
    implements IFixRewriteOperation {
        protected Type importType(ITypeBinding toImport, ASTNode accessor, ImportRewrite imports, CompilationUnit compilationUnit) {
            ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(compilationUnit, accessor.getStartPosition(), imports);
            return imports.addImport(toImport, compilationUnit.getAST(), (ImportRewrite.ImportRewriteContext)importContext);
        }
    }
}

