/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.jdt.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IInitializableRefactoringComponent;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.GenericRefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;

public class RenameResourceProcessor
extends RenameProcessor
implements IInitializableRefactoringComponent,
ICommentProvider,
INameUpdating {
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_NAME = "name";
    private IResource fResource;
    private String fNewElementName;
    private String fComment;
    private RenameModifications fRenameModifications;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameResourceProcessor";
    static /* synthetic */ Class class$0;

    public RenameResourceProcessor(IResource resource) {
        this.fResource = resource;
        if (resource != null) {
            this.setNewElementName(resource.getName());
        }
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull(newName);
        this.fNewElementName = newName;
    }

    public String getNewElementName() {
        return this.fNewElementName;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws JavaModelException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fResource);
    }

    public String getProcessorName() {
        String message = Messages.format(RefactoringCoreMessages.RenameResourceProcessor_name, new String[]{this.getCurrentElementName(), this.getNewElementName()});
        return message;
    }

    public Object[] getElements() {
        return new Object[]{this.fResource};
    }

    public String getCurrentElementName() {
        return this.fResource.getName();
    }

    public String[] getAffectedProjectNatures() throws CoreException {
        return ResourceProcessors.computeAffectedNatures(this.fResource);
    }

    public Object getNewElement() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.createNewPath(this.getNewElementName()));
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fRenameModifications.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return RefactoringStatus.create((IStatus)Resources.checkInSync(this.fResource));
    }

    public RefactoringStatus checkNewElementName(String newName) throws JavaModelException {
        Assert.isNotNull(newName, "new name");
        IContainer c = this.fResource.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_Internal_Error);
        }
        if (c.findMember(newName) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_alread_exists);
        }
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_invalidName);
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, this.fResource.getType()));
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(newName), this.fResource.getType())));
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            this.fRenameModifications = new RenameModifications();
            this.fRenameModifications.rename(this.fResource, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker((Class)clazz);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.fRenameModifications.buildDelta(deltaFactory);
            refactoringStatus = new RefactoringStatus();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private String createNewPath(String newName) {
        return this.fResource.getFullPath().removeLastSegments(1).append(newName).toString();
    }

    public Change createChange(IProgressMonitor pm) throws JavaModelException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask("", 1);
        try {
            dynamicValidationStateChange = new DynamicValidationStateChange(new RenameResourceChange(this.fResource, this.getNewElementName(), this.getComment()));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String name;
        if (arguments instanceof GenericRefactoringArguments) {
            GenericRefactoringArguments generic = (GenericRefactoringArguments)arguments;
            String path = generic.getAttribute(ATTRIBUTE_PATH);
            if (path != null) {
                this.fResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (this.fResource == null || !this.fResource.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)"org.eclipse.jdt.ui.rename.resource"));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_PATH));
            }
            name = generic.getAttribute(ATTRIBUTE_NAME);
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_NAME));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setNewElementName(name);
        return new RefactoringStatus();
    }

    public boolean canEnableComment() {
        return true;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }
}

