/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ISourceConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.GenericRefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public final class ExtractInterfaceProcessor
extends SuperTypeRefactoringProcessor {
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.extractInterfaceProcessor";
    public static final String ID_EXTRACT_INTERFACE = "org.eclipse.jdt.ui.extract.interface";
    private static final String ATTRIBUTE_COMMENTS = "comments";
    private static final String ATTRIBUTE_ABSTRACT = "abstract";
    private static final String ATTRIBUTE_PUBLIC = "public";
    private static final String ATTRIBUTE_REPLACE = "replace";
    private boolean fAbstract = true;
    private TextChangeManager fChangeManager = null;
    private boolean fComments = true;
    private IMember[] fMembers = null;
    private boolean fPublic = true;
    private boolean fReplace = false;
    private CodeGenerationSettings fSettings;
    private final Set fStaticBindings = new HashSet();
    private IType fSubType;
    private String fSuperName;
    private String fSuperSource = null;
    private final Set fTypeBindings = new HashSet();

    protected static boolean isExtractableMember(IMember member) throws JavaModelException {
        Assert.isNotNull(member);
        switch (member.getElementType()) {
            case 9: {
                return JdtFlags.isPublic(member) && !JdtFlags.isStatic(member) && !((IMethod)member).isConstructor();
            }
            case 8: {
                return JdtFlags.isPublic(member) && JdtFlags.isStatic(member) && JdtFlags.isFinal(member) && !JdtFlags.isEnum(member);
            }
        }
        return false;
    }

    public ExtractInterfaceProcessor(IType type, CodeGenerationSettings settings) {
        this.fSubType = type;
        this.fSettings = settings;
        if (this.fSubType != null) {
            this.fSuperName = this.fSubType.getElementName();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status;
        block6: {
            RefactoringStatus refactoringStatus;
            Assert.isNotNull(monitor);
            Assert.isNotNull(context);
            status = new RefactoringStatus();
            this.fChangeManager = new TextChangeManager();
            try {
                RefactoringStatus validation;
                monitor.beginTask("", 4);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_checking);
                status.merge(Checks.checkIfCuBroken((IMember)this.fSubType));
                if (status.hasError()) break block6;
                if (this.fSubType.isBinary() || this.fSubType.isReadOnly() || !this.fSubType.exists()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_no_binary, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fSubType)));
                    break block6;
                }
                if (this.fSubType.isAnonymous()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_no_anonymous, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fSubType)));
                    break block6;
                }
                if (this.fSubType.isAnnotation()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_no_annotation, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fSubType)));
                    break block6;
                }
                status.merge(this.checkSuperType());
                if (status.hasFatalError()) break block6;
                monitor.worked(1);
                if (status.hasFatalError()) break block6;
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                if (status.hasFatalError() || (validation = Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getRefactoring().getValidationContext())).isOK()) break block6;
                refactoringStatus = validation;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return refactoringStatus;
        }
        Object var5_8 = null;
        monitor.done();
        return status;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull(monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_checking);
            status.merge(Checks.checkIfCuBroken((IMember)this.fSubType));
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
        return status;
    }

    protected final RefactoringStatus checkSuperType() throws JavaModelException {
        IPackageFragment fragment = this.fSubType.getPackageFragment();
        IType type = Checks.findTypeInPackage(fragment, this.fSuperName);
        if (type != null && type.exists()) {
            if (fragment.isDefaultPackage()) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_existing_default_type, new String[]{this.fSuperName}));
            }
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_existing_type, new String[]{this.fSuperName, fragment.getElementName()}));
        }
        return new RefactoringStatus();
    }

    public final RefactoringStatus checkTypeName(String name) {
        Assert.isNotNull(name);
        try {
            RefactoringStatus result = Checks.checkTypeName(name);
            if (result.hasFatalError()) {
                return result;
            }
            String unitName = JavaModelUtil.getRenamedCUName(this.fSubType.getCompilationUnit(), name);
            result.merge(Checks.checkCompilationUnitName(unitName));
            if (result.hasFatalError()) {
                return result;
            }
            IPackageFragment fragment = this.fSubType.getPackageFragment();
            if (fragment.getCompilationUnit(unitName).exists()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_existing_compilation_unit, new String[]{unitName, fragment.getElementName()}));
                return result;
            }
            result.merge(this.checkSuperType());
            return result;
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error);
        }
    }

    public final Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        DynamicValidationStateChange dynamicValidationStateChange;
        Assert.isNotNull(monitor);
        try {
            monitor.beginTask("", 6);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            DynamicValidationStateChange change = new DynamicValidationStateChange(RefactoringCoreMessages.ExtractInterfaceRefactoring_name, (Change[])this.fChangeManager.getAllChanges()){

                public final RefactoringDescriptor getRefactoringDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    arguments.put("input", ExtractInterfaceProcessor.this.fSubType.getHandleIdentifier());
                    arguments.put("name", ExtractInterfaceProcessor.this.fSuperName);
                    int index = 0;
                    while (index < ExtractInterfaceProcessor.this.fMembers.length) {
                        arguments.put("element" + (index + 1), ExtractInterfaceProcessor.this.fMembers[index].getHandleIdentifier());
                        ++index;
                    }
                    arguments.put(ExtractInterfaceProcessor.ATTRIBUTE_ABSTRACT, Boolean.valueOf(ExtractInterfaceProcessor.this.fAbstract).toString());
                    arguments.put(ExtractInterfaceProcessor.ATTRIBUTE_COMMENTS, Boolean.valueOf(ExtractInterfaceProcessor.this.fComments).toString());
                    arguments.put(ExtractInterfaceProcessor.ATTRIBUTE_PUBLIC, Boolean.valueOf(ExtractInterfaceProcessor.this.fPublic).toString());
                    arguments.put(ExtractInterfaceProcessor.ATTRIBUTE_REPLACE, Boolean.valueOf(ExtractInterfaceProcessor.this.fReplace).toString());
                    arguments.put("instanceof", Boolean.valueOf(ExtractInterfaceProcessor.this.fInstanceOf).toString());
                    String project = null;
                    IJavaProject javaProject = ExtractInterfaceProcessor.this.fSubType.getJavaProject();
                    if (javaProject != null) {
                        project = javaProject.getElementName();
                    }
                    return new RefactoringDescriptor(ExtractInterfaceProcessor.ID_EXTRACT_INTERFACE, project, Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_descriptor_description, new String[]{ExtractInterfaceProcessor.this.fSuperName, JavaElementLabels.getElementLabel((IJavaElement)ExtractInterfaceProcessor.this.fSubType, JavaElementLabels.ALL_FULLY_QUALIFIED)}), ExtractInterfaceProcessor.this.getComment(), arguments, 65542);
                }
            };
            IFile file = ResourceUtil.getFile(this.fSubType.getCompilationUnit());
            if (this.fSuperSource != null && this.fSuperSource.length() > 0) {
                change.add(new CreateTextFileChange(file.getFullPath().removeLastSegments(1).append(JavaModelUtil.getRenamedCUName(this.fSubType.getCompilationUnit(), this.fSuperName)), this.fSuperSource, file.getCharset(false), "java"));
            }
            dynamicValidationStateChange = change;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return dynamicValidationStateChange;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final TextChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException, CoreException {
        TextChangeManager textChangeManager;
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        try {
            TextChangeManager manager;
            block10: {
                monitor.beginTask("", 20);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                this.fSuperSource = null;
                manager = new TextChangeManager();
                CompilationUnitRewrite sourceRewrite = new CompilationUnitRewrite(this.fSubType.getCompilationUnit());
                AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.fSubType, sourceRewrite.getRoot());
                if (declaration != null) {
                    IMethod[] methods;
                    this.createTypeSignature(sourceRewrite, declaration, status, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    IField[] fields = this.getExtractedFields(this.fSubType.getCompilationUnit());
                    if (fields.length > 0) {
                        ASTNodeDeleteUtil.markAsDeleted((IJavaElement[])fields, sourceRewrite, null);
                    }
                    if (this.fSubType.isInterface() && (methods = this.getExtractedMethods(this.fSubType.getCompilationUnit())).length > 0) {
                        ASTNodeDeleteUtil.markAsDeleted((IJavaElement[])methods, sourceRewrite, null);
                    }
                    ICompilationUnit superUnit = null;
                    try {
                        superUnit = WorkingCopyUtil.getNewWorkingCopy(this.fSubType.getPackageFragment(), JavaModelUtil.getRenamedCUName(this.fSubType.getCompilationUnit(), this.fSuperName), this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        this.fSuperSource = this.createTypeSource(superUnit, sourceRewrite, declaration, status, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                        if (this.fSuperSource != null) {
                            superUnit.getBuffer().setContents(this.fSuperSource);
                            JavaModelUtil.reconcile(superUnit);
                        }
                        HashSet replacements = new HashSet();
                        if (this.fReplace) {
                            this.rewriteTypeOccurrences(manager, sourceRewrite, superUnit, replacements, status, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
                        }
                        this.createMethodComments(sourceRewrite, replacements);
                        manager.manage(this.fSubType.getCompilationUnit(), (TextChange)sourceRewrite.createChange());
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (superUnit == null) throw throwable;
                        superUnit.discardWorkingCopy();
                        throw throwable;
                    }
                    {
                        Object var9_11 = null;
                        if (superUnit == null) break block10;
                    }
                    superUnit.discardWorkingCopy();
                }
            }
            textChangeManager = manager;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return textChangeManager;
    }

    protected final SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel model) {
        return new ExtractInterfaceConstraintsSolver(model, this.fSuperName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createFieldDeclaration(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration, VariableDeclarationFragment fragment) throws CoreException {
        Assert.isNotNull(targetDeclaration);
        Assert.isNotNull(sourceRewrite);
        Assert.isNotNull(targetRewrite);
        Assert.isNotNull(fragment);
        FieldDeclaration field = (FieldDeclaration)fragment.getParent();
        ImportRewriteUtil.collectImports(this.fSubType.getJavaProject(), (ASTNode)field, this.fTypeBindings, this.fStaticBindings, false);
        ASTRewrite rewrite = ASTRewrite.create((AST)field.getAST());
        ITrackedNodePosition position = rewrite.track((ASTNode)field);
        ListRewrite rewriter = rewrite.getListRewrite((ASTNode)field, FieldDeclaration.FRAGMENTS_PROPERTY);
        VariableDeclarationFragment current = null;
        Iterator iterator = field.fragments().iterator();
        while (iterator.hasNext()) {
            current = (VariableDeclarationFragment)iterator.next();
            if (current.getName().getIdentifier().equals(fragment.getName().getIdentifier())) continue;
            rewriter.remove((ASTNode)current, null);
        }
        ICompilationUnit unit = sourceRewrite.getCu();
        ITextFileBuffer buffer = RefactoringFileBuffers.acquire(unit);
        try {
            Document document = new Document(buffer.getDocument().get());
            try {
                rewrite.rewriteAST((IDocument)document, unit.getJavaProject().getOptions(true)).apply((IDocument)document, 2);
                targetRewrite.getListRewrite((ASTNode)targetDeclaration, targetDeclaration.getBodyDeclarationsProperty()).insertFirst(targetRewrite.createStringPlaceholder(this.normalizeText(document.get(position.getStartPosition(), position.getLength())), 23), null);
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
            }
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            RefactoringFileBuffers.release(unit);
            throw throwable;
        }
        RefactoringFileBuffers.release(unit);
    }

    protected final void createMemberDeclarations(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration) throws CoreException {
        Assert.isNotNull(sourceRewrite);
        Assert.isNotNull(targetRewrite);
        Assert.isNotNull(targetDeclaration);
        Arrays.sort(this.fMembers, new Comparator(){

            public final int compare(Object first, Object second) {
                Assert.isNotNull(first);
                Assert.isNotNull(second);
                ISourceReference predecessor = (ISourceReference)first;
                ISourceReference successor = (ISourceReference)second;
                try {
                    return predecessor.getSourceRange().getOffset() - successor.getSourceRange().getOffset();
                }
                catch (JavaModelException javaModelException) {
                    return first.hashCode() - second.hashCode();
                }
            }
        });
        this.fTypeBindings.clear();
        this.fStaticBindings.clear();
        if (this.fMembers.length > 0) {
            IMember member = null;
            int index = this.fMembers.length - 1;
            while (index >= 0) {
                member = this.fMembers[index];
                if (member instanceof IField) {
                    this.createFieldDeclaration(sourceRewrite, targetRewrite, targetDeclaration, ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, sourceRewrite.getRoot()));
                } else if (member instanceof IMethod) {
                    this.createMethodDeclaration(sourceRewrite, targetRewrite, targetDeclaration, ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, sourceRewrite.getRoot()));
                }
                --index;
            }
        }
    }

    protected final void createMethodComment(ASTRewrite rewrite, MethodDeclaration declaration, Set replacements, boolean javadoc) throws CoreException {
        Assert.isNotNull(rewrite);
        Assert.isNotNull(declaration);
        Assert.isNotNull(replacements);
        IMethodBinding binding = declaration.resolveBinding();
        if (binding != null) {
            IVariableBinding variable = null;
            SingleVariableDeclaration argument = null;
            IPackageFragment fragment = this.fSubType.getPackageFragment();
            String string = fragment.isDefaultPackage() ? this.fSuperName : String.valueOf(fragment.getElementName()) + "." + this.fSuperName;
            ITypeBinding[] bindings = binding.getParameterTypes();
            String[] names = new String[bindings.length];
            int offset = 0;
            while (offset < names.length) {
                argument = (SingleVariableDeclaration)declaration.parameters().get(offset);
                variable = argument.resolveBinding();
                if (variable != null) {
                    names[offset] = replacements.contains(variable.getKey()) ? string : (binding.isVarargs() && bindings[offset].isArray() && offset == names.length - 1 ? Bindings.getFullyQualifiedName(bindings[offset].getElementType()) : Bindings.getFullyQualifiedName(bindings[offset]));
                }
                ++offset;
            }
            String comment = CodeGeneration.getMethodComment(this.fSubType.getCompilationUnit(), this.fSubType.getElementName(), declaration, false, binding.getName(), string, names, StubUtility.getLineDelimiterUsed(this.fSubType.getJavaProject()));
            if (comment != null) {
                if (declaration.getJavadoc() != null) {
                    rewrite.replace((ASTNode)declaration.getJavadoc(), rewrite.createStringPlaceholder(comment, 29), null);
                } else if (javadoc) {
                    rewrite.set((ASTNode)declaration, (StructuralPropertyDescriptor)MethodDeclaration.JAVADOC_PROPERTY, (Object)rewrite.createStringPlaceholder(comment, 29), null);
                }
            }
        }
    }

    protected final void createMethodComments(CompilationUnitRewrite sourceRewrite, Set replacements) throws CoreException {
        Assert.isNotNull(sourceRewrite);
        Assert.isNotNull(replacements);
        if (this.fComments && this.fMembers.length > 0) {
            IJavaProject project = this.fSubType.getJavaProject();
            boolean javadoc = project.getOption("org.eclipse.jdt.core.compiler.doc.comment.support", true).equals("enabled");
            IMember member = null;
            int index = 0;
            while (index < this.fMembers.length) {
                member = this.fMembers[index];
                if (member instanceof IMethod) {
                    this.createMethodComment(sourceRewrite.getASTRewrite(), ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, sourceRewrite.getRoot()), replacements, javadoc);
                }
                ++index;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void createMethodDeclaration(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration, MethodDeclaration declaration) throws CoreException {
        Assert.isNotNull(targetDeclaration);
        Assert.isNotNull(sourceRewrite);
        Assert.isNotNull(targetRewrite);
        Assert.isNotNull(declaration);
        ImportRewriteUtil.collectImports(this.fSubType.getJavaProject(), (ASTNode)declaration, this.fTypeBindings, this.fStaticBindings, true);
        ASTRewrite rewrite = ASTRewrite.create((AST)declaration.getAST());
        ITrackedNodePosition position = rewrite.track((ASTNode)declaration);
        if (declaration.getBody() != null) {
            rewrite.remove((ASTNode)declaration.getBody(), null);
        }
        ListRewrite modifiers = rewrite.getListRewrite((ASTNode)declaration, declaration.getModifiersProperty());
        boolean publicFound = false;
        boolean abstractFound = false;
        Modifier modifier = null;
        IExtendedModifier extended = null;
        Iterator iterator = declaration.modifiers().iterator();
        while (iterator.hasNext()) {
            extended = (IExtendedModifier)iterator.next();
            if (extended.isAnnotation()) continue;
            modifier = (Modifier)extended;
            if (this.fPublic && modifier.getKeyword().equals(Modifier.ModifierKeyword.PUBLIC_KEYWORD)) {
                publicFound = true;
                continue;
            }
            if (this.fAbstract && modifier.getKeyword().equals(Modifier.ModifierKeyword.ABSTRACT_KEYWORD)) {
                abstractFound = true;
                continue;
            }
            modifiers.remove((ASTNode)modifier, null);
        }
        ModifierRewrite rewriter = ModifierRewrite.create(rewrite, (ASTNode)declaration);
        if (this.fPublic && !publicFound) {
            rewriter.setVisibility(1, null);
        }
        if (this.fAbstract && !abstractFound) {
            rewriter.setModifiers(1024, 0, null);
        }
        ICompilationUnit unit = sourceRewrite.getCu();
        ITextFileBuffer buffer = RefactoringFileBuffers.acquire(unit);
        try {
            Document document = new Document(buffer.getDocument().get());
            try {
                rewrite.rewriteAST((IDocument)document, unit.getJavaProject().getOptions(true)).apply((IDocument)document, 2);
                targetRewrite.getListRewrite((ASTNode)targetDeclaration, targetDeclaration.getBodyDeclarationsProperty()).insertFirst(targetRewrite.createStringPlaceholder(this.normalizeText(document.get(position.getStartPosition(), position.getLength())), 31), null);
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
            }
            Object var17_20 = null;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            RefactoringFileBuffers.release(unit);
            throw throwable;
        }
        RefactoringFileBuffers.release(unit);
    }

    protected final void createTypeDeclaration(CompilationUnitRewrite sourceRewrite, AbstractTypeDeclaration sourceDeclaration, StringBuffer buffer, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(sourceRewrite);
        Assert.isNotNull(sourceDeclaration);
        Assert.isNotNull(buffer);
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        monitor.beginTask("", 1);
        monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
        String delimiter = StubUtility.getLineDelimiterUsed(this.fSubType.getJavaProject());
        if (JdtFlags.isPublic((IMember)this.fSubType)) {
            buffer.append(ATTRIBUTE_PUBLIC);
            buffer.append(" ");
        }
        buffer.append("interface ");
        buffer.append(this.fSuperName);
        buffer.append(" {");
        buffer.append(delimiter);
        buffer.append(delimiter);
        buffer.append('}');
        Document document = new Document(buffer.toString());
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(document.get().toCharArray());
        CompilationUnit unit = (CompilationUnit)parser.createAST((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ASTRewrite targetRewrite = ASTRewrite.create((AST)unit.getAST());
        AbstractTypeDeclaration targetDeclaration = (AbstractTypeDeclaration)unit.types().get(0);
        this.createTypeParameters(targetRewrite, sourceDeclaration, targetDeclaration);
        this.createMemberDeclarations(sourceRewrite, targetRewrite, targetDeclaration);
        TextEdit edit = targetRewrite.rewriteAST((IDocument)document, this.fSubType.getJavaProject().getOptions(true));
        try {
            edit.apply((IDocument)document, 2);
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        buffer.setLength(0);
        buffer.append(document.get());
    }

    protected final String createTypeImports(ICompilationUnit unit, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(unit);
        ImportRewrite rewrite = StubUtility.createImportRewrite(unit, true);
        ITypeBinding type = null;
        Iterator iterator = this.fTypeBindings.iterator();
        while (iterator.hasNext()) {
            type = (ITypeBinding)iterator.next();
            if (type.isTypeVariable()) {
                ITypeBinding[] bounds = type.getTypeBounds();
                int index = 0;
                while (index < bounds.length) {
                    rewrite.addImport(bounds[index]);
                    ++index;
                }
            }
            rewrite.addImport(type);
        }
        IBinding binding = null;
        Iterator iterator2 = this.fStaticBindings.iterator();
        while (iterator2.hasNext()) {
            binding = (IBinding)iterator2.next();
            rewrite.addStaticImport(binding);
        }
        Document document = new Document();
        try {
            rewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1)).apply((IDocument)document);
        }
        catch (MalformedTreeException exception) {
            JavaPlugin.log(exception);
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        catch (CoreException exception) {
            JavaPlugin.log(exception);
        }
        this.fTypeBindings.clear();
        this.fStaticBindings.clear();
        return document.get();
    }

    protected final void createTypeParameters(ASTRewrite targetRewrite, AbstractTypeDeclaration sourceDeclaration, AbstractTypeDeclaration targetDeclaration) {
        Assert.isNotNull(targetRewrite);
        Assert.isNotNull(sourceDeclaration);
        Assert.isNotNull(targetDeclaration);
        if (sourceDeclaration instanceof TypeDeclaration) {
            TypeParameter parameter = null;
            ListRewrite rewrite = targetRewrite.getListRewrite((ASTNode)targetDeclaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            Iterator iterator = ((TypeDeclaration)sourceDeclaration).typeParameters().iterator();
            while (iterator.hasNext()) {
                parameter = (TypeParameter)iterator.next();
                rewrite.insertLast(ASTNode.copySubtree((AST)targetRewrite.getAST(), (ASTNode)parameter), null);
                ImportRewriteUtil.collectImports(this.fSubType.getJavaProject(), (ASTNode)sourceDeclaration, this.fTypeBindings, this.fStaticBindings, false);
            }
        }
    }

    protected final void createTypeSignature(CompilationUnitRewrite rewrite, AbstractTypeDeclaration declaration, RefactoringStatus status, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull(rewrite);
        Assert.isNotNull(declaration);
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        AST ast = declaration.getAST();
        ITypeParameter[] parameters = this.fSubType.getTypeParameters();
        SimpleType type = ast.newSimpleType((Name)ast.newSimpleName(this.fSuperName));
        if (parameters.length > 0) {
            ParameterizedType parameterized = ast.newParameterizedType((Type)type);
            int index = 0;
            while (index < parameters.length) {
                parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getElementName())));
                ++index;
            }
            type = parameterized;
        }
        ASTRewrite rewriter = rewrite.getASTRewrite();
        if (declaration instanceof TypeDeclaration) {
            rewriter.getListRewrite((ASTNode)declaration, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY).insertLast((ASTNode)type, null);
        } else if (declaration instanceof EnumDeclaration) {
            rewriter.getListRewrite((ASTNode)declaration, EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY).insertLast((ASTNode)type, null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final String createTypeSource(ICompilationUnit copy, CompilationUnitRewrite sourceRewrite, AbstractTypeDeclaration declaration, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(copy);
        Assert.isNotNull(sourceRewrite);
        Assert.isNotNull(declaration);
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        String source = null;
        try {
            monitor.beginTask("", 2);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            String delimiter = StubUtility.getLineDelimiterUsed(this.fSubType.getJavaProject());
            String typeComment = null;
            String fileComment = null;
            if (this.fSettings.createComments) {
                ITypeParameter[] parameters = this.fSubType.getTypeParameters();
                String[] names = new String[parameters.length];
                int index = 0;
                while (true) {
                    if (index >= parameters.length) {
                        typeComment = CodeGeneration.getTypeComment(copy, this.fSubType.getTypeQualifiedName('.'), names, delimiter);
                        fileComment = CodeGeneration.getFileComment(copy, delimiter);
                        break;
                    }
                    names[index] = parameters[index].getElementName();
                    ++index;
                }
            }
            StringBuffer buffer = new StringBuffer(64);
            this.createTypeDeclaration(sourceRewrite, declaration, buffer, status, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            String imports = this.createTypeImports(copy, monitor);
            source = this.createTypeTemplate(copy, imports, fileComment, typeComment, buffer.toString());
            if (source == null) {
                if (!this.fSubType.getPackageFragment().isDefaultPackage()) {
                    if (imports.length() > 0) {
                        buffer.insert(0, imports);
                    }
                    buffer.insert(0, "package " + this.fSubType.getPackageFragment().getElementName() + ";");
                }
                source = buffer.toString();
            }
            Document document = new Document(source);
            TextEdit edit = CodeFormatterUtil.format2(8, source, 0, delimiter, copy.getJavaProject().getOptions(true));
            if (edit != null) {
                try {
                    edit.apply((IDocument)document, 2);
                }
                catch (MalformedTreeException exception) {
                    JavaPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                }
                catch (BadLocationException exception) {
                    JavaPlugin.log(exception);
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                }
                source = document.get();
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var15_19 = null;
        }
        monitor.done();
        return source;
    }

    protected final String createTypeTemplate(ICompilationUnit unit, String imports, String fileComment, String comment, String content) throws CoreException {
        Assert.isNotNull(unit);
        Assert.isNotNull(imports);
        Assert.isNotNull(content);
        IPackageFragment fragment = (IPackageFragment)unit.getParent();
        StringBuffer buffer = new StringBuffer();
        String delimiter = StubUtility.getLineDelimiterUsed(this.fSubType.getJavaProject());
        if (!fragment.isDefaultPackage()) {
            buffer.append("package " + fragment.getElementName() + ";");
            buffer.append(delimiter);
            buffer.append(delimiter);
        }
        if (imports.length() > 0) {
            buffer.append(imports);
        }
        return StubUtility.getCompilationUnitContent(unit, buffer.toString(), fileComment, comment, content, delimiter);
    }

    public final boolean getAbstract() {
        return this.fAbstract;
    }

    public final Object[] getElements() {
        return new Object[]{this.fSubType};
    }

    public final IMember[] getExtractableMembers() throws JavaModelException {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        IJavaElement[] children = this.fSubType.getChildren();
        int index = 0;
        while (index < children.length) {
            if (children[index] instanceof IMember && ExtractInterfaceProcessor.isExtractableMember((IMember)children[index])) {
                list.add(children[index]);
            }
            ++index;
        }
        IMember[] members = new IMember[list.size()];
        list.toArray(members);
        return members;
    }

    protected final IField[] getExtractedFields(ICompilationUnit unit) {
        Assert.isNotNull(unit);
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        int index = 0;
        while (index < this.fMembers.length) {
            IJavaElement element;
            if (this.fMembers[index] instanceof IField && (element = JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)this.fMembers[index])) instanceof IField) {
                list.add(element);
            }
            ++index;
        }
        IField[] fields = new IField[list.size()];
        list.toArray(fields);
        return fields;
    }

    protected final IMethod[] getExtractedMethods(ICompilationUnit unit) {
        Assert.isNotNull(unit);
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        int index = 0;
        while (index < this.fMembers.length) {
            IJavaElement element;
            if (this.fMembers[index] instanceof IMethod && (element = JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)this.fMembers[index])) instanceof IMethod) {
                list.add(element);
            }
            ++index;
        }
        IMethod[] methods = new IMethod[list.size()];
        list.toArray(methods);
        return methods;
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_name, new String[]{this.fSubType.getElementName()});
    }

    public final boolean getPublic() {
        return this.fPublic;
    }

    public final IType getType() {
        return this.fSubType;
    }

    public final String getTypeName() {
        return this.fSuperName;
    }

    public final boolean isApplicable() throws CoreException {
        return Checks.isAvailable((IJavaElement)this.fSubType) && !this.fSubType.isBinary() && !this.fSubType.isReadOnly() && !this.fSubType.isAnnotation() && !this.fSubType.isAnonymous();
    }

    public final boolean isComments() {
        return this.fComments;
    }

    public final boolean isReplace() {
        return this.fReplace;
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    protected final String normalizeText(String code) throws JavaModelException {
        Assert.isNotNull(code);
        String[] lines = Strings.convertIntoLines(code);
        IJavaProject project = this.fSubType.getJavaProject();
        Strings.trimIndentation(lines, project, false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed(project));
    }

    protected final void rewriteTypeOccurrences(TextChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, ICompilationUnit unit, CompilationUnit node, Set replacements) throws CoreException {
        CompilationUnitChange change;
        CompilationUnitRewrite currentRewrite = null;
        boolean isSubUnit = rewrite.getCu().equals(unit.getPrimary());
        currentRewrite = isSubUnit ? rewrite : new CompilationUnitRewrite(unit, node);
        Collection collection = (Collection)this.fTypeOccurrences.get(unit);
        if (collection != null && !collection.isEmpty()) {
            TType estimate = null;
            ISourceConstraintVariable variable = null;
            ITypeConstraintVariable constraint = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                variable = (ISourceConstraintVariable)iterator.next();
                if (!(variable instanceof ITypeConstraintVariable) || (estimate = (TType)(constraint = (ITypeConstraintVariable)variable).getData("te")) == null) continue;
                CompilationUnitRange range = constraint.getRange();
                if (isSubUnit) {
                    this.rewriteTypeOccurrence(range, estimate, requestor, currentRewrite, node, replacements, currentRewrite.createGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence));
                    continue;
                }
                ASTNode result = NodeFinder.perform((ASTNode)node, range.getSourceRange());
                if (result == null) continue;
                this.rewriteTypeOccurrence(estimate, currentRewrite, result, currentRewrite.createGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence));
            }
        }
        if (!isSubUnit && (change = currentRewrite.createChange()) != null) {
            manager.manage(unit, (TextChange)change);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void rewriteTypeOccurrences(final TextChangeManager manager, final CompilationUnitRewrite sourceRewrite, final ICompilationUnit superUnit, final Set replacements, final RefactoringStatus status, final IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull(manager);
        Assert.isNotNull(sourceRewrite);
        Assert.isNotNull(superUnit);
        Assert.isNotNull(replacements);
        Assert.isNotNull(status);
        Assert.isNotNull(monitor);
        try {
            monitor.beginTask("", 20);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            ICompilationUnit subUnit = null;
            try {
                subUnit = WorkingCopyUtil.getNewWorkingCopy(this.fSubType.getCompilationUnit(), this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                ITextFileBuffer buffer = RefactoringFileBuffers.acquire(this.fSubType.getCompilationUnit());
                ASTRewrite rewrite = sourceRewrite.getASTRewrite();
                try {
                    Document document = new Document(buffer.getDocument().get());
                    try {
                        rewrite.rewriteAST((IDocument)document, this.fSubType.getJavaProject().getOptions(true)).apply((IDocument)document, 2);
                    }
                    catch (MalformedTreeException exception) {
                        JavaPlugin.log(exception);
                    }
                    catch (BadLocationException exception) {
                        JavaPlugin.log(exception);
                    }
                    subUnit.getBuffer().setContents(document.get());
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    RefactoringFileBuffers.release(this.fSubType.getCompilationUnit());
                    throw throwable;
                }
                {
                    Object var12_16 = null;
                }
                RefactoringFileBuffers.release(this.fSubType.getCompilationUnit());
                JavaModelUtil.reconcile(subUnit);
                IJavaProject project = subUnit.getJavaProject();
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setWorkingCopyOwner(this.fOwner);
                parser.setResolveBindings(true);
                parser.setProject(project);
                parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
                parser.createASTs(new ICompilationUnit[]{subUnit}, new String[0], new ASTRequestor(){

                    public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                        block7: {
                            try {
                                TextEdit edit;
                                ITypeBinding subBinding;
                                IType subType = (IType)JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)ExtractInterfaceProcessor.this.fSubType);
                                AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(subType, node);
                                if (subDeclaration == null || (subBinding = subDeclaration.resolveBinding()) == null) break block7;
                                String name = null;
                                ITypeBinding superBinding = null;
                                ITypeBinding[] superBindings = subBinding.getInterfaces();
                                int index = 0;
                                while (index < superBindings.length) {
                                    name = superBindings[index].getName();
                                    if (name.startsWith(ExtractInterfaceProcessor.this.fSuperName) && superBindings[index].getTypeArguments().length == subBinding.getTypeParameters().length) {
                                        superBinding = superBindings[index];
                                    }
                                    ++index;
                                }
                                if (superBinding == null) break block7;
                                ExtractInterfaceProcessor.this.solveSuperTypeConstraints(unit, node, subType, subBinding, superBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 14), status);
                                if (status.hasFatalError()) break block7;
                                ExtractInterfaceProcessor.this.rewriteTypeOccurrences(manager, this, sourceRewrite, unit, node, replacements, status, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
                                if (!manager.containsChangesIn(superUnit) || (edit = manager.get(superUnit).getEdit()) == null) break block7;
                                Document document = new Document(superUnit.getBuffer().getContents());
                                try {
                                    edit.apply((IDocument)document, 2);
                                }
                                catch (MalformedTreeException exception) {
                                    JavaPlugin.log(exception);
                                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                                }
                                catch (BadLocationException exception) {
                                    JavaPlugin.log(exception);
                                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                                }
                                ExtractInterfaceProcessor.this.fSuperSource = document.get();
                                manager.remove(superUnit);
                            }
                            catch (JavaModelException exception) {
                                JavaPlugin.log(exception);
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                            }
                        }
                    }

                    public final void acceptBinding(String key, IBinding binding) {
                    }
                }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (subUnit == null) throw throwable;
                subUnit.discardWorkingCopy();
                throw throwable;
            }
            {
                Object var14_19 = null;
                if (subUnit != null) {
                    subUnit.discardWorkingCopy();
                }
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var16_22 = null;
        }
        monitor.done();
    }

    public final void setAbstract(boolean declare) {
        this.fAbstract = declare;
    }

    public final void setComments(boolean comments) {
        this.fComments = comments;
    }

    public final void setExtractedMembers(IMember[] members) throws JavaModelException {
        this.fMembers = members;
    }

    public final void setPublic(boolean declare) {
        this.fPublic = declare;
    }

    public final void setReplace(boolean replace) {
        this.fReplace = replace;
    }

    public final void setTypeName(String name) {
        Assert.isNotNull(name);
        this.fSuperName = name;
    }

    public final RefactoringStatus initialize(RefactoringArguments arguments) {
        if (arguments instanceof GenericRefactoringArguments) {
            IJavaElement element;
            GenericRefactoringArguments generic = (GenericRefactoringArguments)arguments;
            String handle = generic.getAttribute("input");
            if (handle != null) {
                element = JavaCore.create((String)handle);
                if (element == null || !element.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_EXTRACT_INTERFACE));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
            }
            this.fSubType = (IType)element;
            String name = generic.getAttribute("name");
            if (name != null) {
                this.fSuperName = name;
                RefactoringStatus status = this.checkTypeName(name);
                if (status.hasError()) {
                    return status;
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"name"));
            }
            String deferred = generic.getAttribute(ATTRIBUTE_ABSTRACT);
            if (deferred == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_ABSTRACT));
            }
            this.fAbstract = Boolean.valueOf(deferred);
            String comment = generic.getAttribute(ATTRIBUTE_COMMENTS);
            if (comment == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_COMMENTS));
            }
            this.fComments = Boolean.valueOf(comment);
            String instance = generic.getAttribute("instanceof");
            if (instance == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"instanceof"));
            }
            this.fInstanceOf = Boolean.valueOf(instance);
            String visibility = generic.getAttribute(ATTRIBUTE_PUBLIC);
            if (visibility == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_PUBLIC));
            }
            this.fPublic = Boolean.valueOf(visibility);
            String replace = generic.getAttribute(ATTRIBUTE_REPLACE);
            if (replace == null) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)ATTRIBUTE_REPLACE));
            }
            this.fReplace = Boolean.valueOf(replace);
            int count = 1;
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            String attribute = "element" + count;
            RefactoringStatus status = new RefactoringStatus();
            while ((handle = generic.getAttribute(attribute)) != null) {
                IJavaElement element2 = JavaCore.create((String)handle);
                if (element2 == null || !element2.exists()) {
                    status.merge(RefactoringStatus.createWarningStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_EXTRACT_INTERFACE)));
                } else {
                    elements.add(element2);
                }
                attribute = "element" + ++count;
            }
            this.fMembers = elements.toArray(new IMember[elements.size()]);
            if (elements.isEmpty()) {
                return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringCoreMessages.InitializableRefactoring_input_not_exists, (Object)ID_EXTRACT_INTERFACE));
            }
            this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fSubType.getJavaProject());
            if (!status.isOK()) {
                return status;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }
}

