/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.CorextMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoHistory;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class OpenTypeHistory
extends TypeInfoHistory {
    private boolean fNeedsConsistencyCheck = true;
    private final IElementChangedListener fDeltaListener = new TypeHistoryDeltaListener();
    private UpdateJob fUpdateJob;
    private static final String FILENAME = "OpenTypeHistory.xml";
    private static OpenTypeHistory fgInstance;

    public static synchronized OpenTypeHistory getInstance() {
        if (fgInstance == null) {
            fgInstance = new OpenTypeHistory();
        }
        return fgInstance;
    }

    public static void shutdown() {
        if (fgInstance == null) {
            return;
        }
        fgInstance.doShutdown();
    }

    private OpenTypeHistory() {
        super(FILENAME);
        JavaCore.addElementChangedListener((IElementChangedListener)this.fDeltaListener);
    }

    public synchronized void markAsInconsistent() {
        this.fNeedsConsistencyCheck = true;
        if (this.fUpdateJob != null) {
            this.fUpdateJob.cancel();
        }
        this.fUpdateJob = new UpdateJob(this.fUpdateJob);
        this.fUpdateJob.setPriority(20);
        this.fUpdateJob.schedule();
    }

    public synchronized boolean needConsistencyCheck() {
        return this.fNeedsConsistencyCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        OpenTypeHistory openTypeHistory = this;
        synchronized (openTypeHistory) {
            if (!this.fNeedsConsistencyCheck) {
                return;
            }
        }
        if (this.hasUpdateJob()) {
            try {
                Platform.getJobManager().join((Object)UpdateJob.FAMILY, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        openTypeHistory = this;
        synchronized (openTypeHistory) {
            if (!this.fNeedsConsistencyCheck) {
                return;
            }
            this.internalCheckConsistency(monitor);
        }
    }

    protected Object getKey(Object object) {
        return object;
    }

    private synchronized void internalCheckConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        ArrayList keys = new ArrayList(this.getKeys());
        monitor.beginTask(CorextMessages.TypeInfoHistory_consistency_check, keys.size());
        monitor.setTaskName(CorextMessages.TypeInfoHistory_consistency_check);
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            TypeInfo type = (TypeInfo)iter.next();
            try {
                IType jType = type.resolveType(scope);
                if (jType == null || !jType.exists()) {
                    this.remove(type);
                } else {
                    type.setModifiers(jType.getFlags());
                }
            }
            catch (JavaModelException javaModelException) {
                this.remove(type);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
        }
        monitor.done();
        this.fNeedsConsistencyCheck = false;
    }

    private synchronized void clearUpdateJob(UpdateJob toClear) {
        if (this.fUpdateJob == toClear) {
            this.fUpdateJob = null;
        }
    }

    private synchronized boolean hasUpdateJob() {
        return this.fUpdateJob != null;
    }

    private void doShutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fDeltaListener);
    }

    private static class TypeHistoryDeltaListener
    implements IElementChangedListener {
        TypeHistoryDeltaListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.processDelta(event.getDelta())) {
                OpenTypeHistory.getInstance().markAsInconsistent();
            }
        }

        private boolean processDelta(IJavaElementDelta delta) {
            IJavaElement elem = delta.getElement();
            boolean isChanged = delta.getKind() == 4;
            boolean isRemoved = delta.getKind() == 2;
            switch (elem.getElementType()) {
                case 2: {
                    if (isRemoved || isChanged && (delta.getFlags() & 0x400) != 0) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 3: {
                    if (isRemoved || isChanged && ((delta.getFlags() & 0x8000) != 0 || (delta.getFlags() & 0x80) != 0)) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 7: {
                    if (isChanged && (delta.getFlags() & 2) != 0) {
                        return true;
                    }
                }
                case 1: 
                case 4: 
                case 6: {
                    if (isRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (!JavaModelUtil.isPrimary((ICompilationUnit)elem)) {
                        return false;
                    }
                    if (isRemoved || isChanged && this.isUnknownStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isUnknownStructuralChange(int flags) {
            if ((flags & 1) == 0) {
                return false;
            }
            return (flags & 0x4000) == 0;
        }

        private boolean processChildrenDelta(IJavaElementDelta delta) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class UpdateJob
    extends Job {
        public static final String FAMILY;
        private UpdateJob fLastJob;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.util.OpenTypeHistory$UpdateJob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            FAMILY = clazz.getName();
        }

        public UpdateJob(UpdateJob lastJob) {
            super(CorextMessages.TypeInfoHistory_consistency_check);
            this.fLastJob = lastJob;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            try {
                if (this.fLastJob != null) {
                    boolean joined = false;
                    while (true) {
                        if (joined) {
                            this.fLastJob = null;
                            break;
                        }
                        try {
                            this.fLastJob.join();
                            joined = true;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                history.internalCheckConsistency(monitor);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                history.clearUpdateJob(this);
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            history.clearUpdateJob(this);
            return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }

        public boolean belongsTo(Object family) {
            return FAMILY.equals(family);
        }
    }
}

