/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;

class PackagesViewLabelProvider
extends AppearanceAwareLabelProvider {
    static final int HIERARCHICAL_VIEW_STATE = 0;
    static final int FLAT_VIEW_STATE = 1;
    private int fViewState;
    private ImageDescriptorRegistry fRegistry;
    private TreeHierarchyLayoutProblemsDecorator fDecorator;

    PackagesViewLabelProvider(int state) {
        this(state, 36421324767273L, 3);
    }

    PackagesViewLabelProvider(int state, long textFlags, int imageFlags) {
        super(textFlags, imageFlags);
        Assert.isTrue((boolean)this.isValidState(state));
        this.fViewState = state;
        this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        this.fDecorator = new TreeHierarchyLayoutProblemsDecorator(this.isFlatView());
        this.addLabelDecorator(this.fDecorator);
    }

    private boolean isValidState(int state) {
        return state == 1 || state == 0;
    }

    public Image getImage(Object element) {
        if (element instanceof LogicalPackage) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            return this.getLogicalPackageImage(cp);
        }
        return super.getImage(element);
    }

    private Image getLogicalPackageImage(LogicalPackage cp) {
        IPackageFragment[] fragments = cp.getFragments();
        int i = 0;
        while (i < fragments.length) {
            IPackageFragment fragment = fragments[i];
            if (!this.isEmpty(fragment)) {
                return this.decorateCompoundElement(JavaPluginImages.DESC_OBJS_LOGICAL_PACKAGE, cp);
            }
            ++i;
        }
        return this.decorateCompoundElement(JavaPluginImages.DESC_OBJS_EMPTY_LOGICAL_PACKAGE, cp);
    }

    private Image decorateCompoundElement(ImageDescriptor imageDescriptor, LogicalPackage cp) {
        Image image = this.fRegistry.get(imageDescriptor);
        return this.decorateImage(image, (Object)cp);
    }

    private boolean isEmpty(IPackageFragment fragment) {
        try {
            return fragment.getCompilationUnits().length == 0 && fragment.getClassFiles().length == 0;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public String getText(Object element) {
        if (element instanceof IPackageFragment) {
            return this.getText((IPackageFragment)element);
        }
        if (element instanceof LogicalPackage) {
            return this.getText((LogicalPackage)((Object)element));
        }
        return super.getText(element);
    }

    private String getText(IPackageFragment fragment) {
        if (this.isFlatView()) {
            return this.getFlatText(fragment);
        }
        return this.getHierarchicalText(fragment);
    }

    private String getText(LogicalPackage logicalPackage) {
        IPackageFragment[] fragments = logicalPackage.getFragments();
        return this.getText(fragments[0]);
    }

    private String getFlatText(IPackageFragment fragment) {
        return super.getText(fragment);
    }

    private boolean isFlatView() {
        return this.fViewState == 1;
    }

    private String getHierarchicalText(IPackageFragment fragment) {
        if (fragment.isDefaultPackage()) {
            return super.getText(fragment);
        }
        IResource res = fragment.getResource();
        if (res != null && res.getType() != 1) {
            return this.decorateText(res.getName(), fragment);
        }
        return this.decorateText(this.calculateName(fragment), fragment);
    }

    private String calculateName(IPackageFragment fragment) {
        String name = fragment.getElementName();
        if (name.indexOf(".") != -1) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        return name;
    }
}

