/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.CodeStyleCleanUp;
import org.eclipse.jdt.internal.ui.fix.ControlStatementsCleanUp;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.Java50CleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.fix.PotentialProgrammingProblemsCleanUp;
import org.eclipse.jdt.internal.ui.fix.StringCleanUp;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class CleanUpRefactoringWizard
extends RefactoringWizard {
    private static final String CLEAN_UP_WIZARD_SETTINGS_SECTION_ID = "CleanUpWizard";
    private final boolean fShowCUPage;
    private final boolean fShowCleanUpPage;

    public CleanUpRefactoringWizard(CleanUpRefactoring refactoring, int flags, boolean showCUPage, boolean showCleanUpPage) {
        super((Refactoring)refactoring, flags);
        this.fShowCUPage = showCUPage;
        this.fShowCleanUpPage = showCleanUpPage;
        this.setDefaultPageTitle(MultiFixMessages.CleanUpRefactoringWizard_PageTitle);
        this.setWindowTitle(MultiFixMessages.CleanUpRefactoringWizard_WindowTitle);
    }

    protected void addUserInputPages() {
        if (this.fShowCUPage) {
            SelectCUPage selectCUPage = new SelectCUPage(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_name);
            if (this.fShowCleanUpPage) {
                selectCUPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_message);
            } else {
                ICleanUp[] cleanUps = ((CleanUpRefactoring)this.getRefactoring()).getCleanUps();
                if (cleanUps.length == 1) {
                    ICleanUp cleanUp = cleanUps[0];
                    String[] descriptions = cleanUp.getDescriptions();
                    if (descriptions.length == 1) {
                        selectCUPage.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_preSingleSelect_message, descriptions[0]));
                    } else {
                        selectCUPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_preSelect_message);
                    }
                } else {
                    selectCUPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCompilationUnitsPage_preSelect_message);
                }
            }
            this.addPage((IWizardPage)selectCUPage);
        }
        if (this.fShowCleanUpPage) {
            SelectCleanUpPage selectSolverPage = new SelectCleanUpPage(MultiFixMessages.CleanUpRefactoringWizard_SelectCleanUpsPage_name);
            if (this.fShowCUPage) {
                selectSolverPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCleanUpsPage_message);
            } else {
                ICompilationUnit[] compilationUnits = ((CleanUpRefactoring)this.getRefactoring()).getCompilationUnits();
                if (compilationUnits.length == 1) {
                    String label = JavaElementLabels.getElementLabel((IJavaElement)compilationUnits[0], JavaElementLabels.ALL_DEFAULT);
                    selectSolverPage.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_SelectCleanUpsPage_preSingleSelect_message, label));
                } else {
                    selectSolverPage.setMessage(MultiFixMessages.CleanUpRefactoringWizard_SelectCleanUpsPage_message);
                }
            }
            this.addPage((IWizardPage)selectSolverPage);
        }
    }

    private static IDialogSettings getCleanUpWizardSettings() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(CLEAN_UP_WIZARD_SETTINGS_SECTION_ID);
        if (section == null) {
            section = settings.addNewSection(CLEAN_UP_WIZARD_SETTINGS_SECTION_ID);
        }
        return section;
    }

    private class SelectCUPage
    extends UserInputWizardPage {
        private ContainerCheckedTreeViewer fTreeViewer;

        public SelectCUPage(String name) {
            super(name);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.createViewer(composite);
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
        }

        private TreeViewer createViewer(Composite parent) {
            this.fTreeViewer = new ContainerCheckedTreeViewer(parent, 2820);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(40);
            gd.heightHint = this.convertHeightInCharsToPixels(15);
            this.fTreeViewer.getTree().setLayoutData((Object)gd);
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider(256));
            this.fTreeViewer.setContentProvider((IContentProvider)new StandardJavaElementContentProvider());
            this.fTreeViewer.setSorter((ViewerSorter)new JavaElementSorter());
            this.fTreeViewer.addFilter(new ViewerFilter(this){
                final /* synthetic */ SelectCUPage this$1;
                {
                    this.this$1 = selectCUPage;
                }

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IJavaElement) {
                        IJavaElement jElement = (IJavaElement)element;
                        return !jElement.isReadOnly();
                    }
                    return false;
                }
            });
            IJavaModel create = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            this.fTreeViewer.setInput((Object)create);
            this.checkElements((CheckboxTreeViewer)this.fTreeViewer, (CleanUpRefactoring)this.getRefactoring());
            return this.fTreeViewer;
        }

        private void checkElements(CheckboxTreeViewer treeViewer, CleanUpRefactoring refactoring) {
            ICompilationUnit[] compilationUnits = refactoring.getCompilationUnits();
            int i = 0;
            while (i < compilationUnits.length) {
                ICompilationUnit compilationUnit = compilationUnits[i];
                treeViewer.expandToLevel((Object)compilationUnit, 0);
                treeViewer.setChecked((Object)compilationUnit, true);
                ++i;
            }
            if (compilationUnits.length > 0) {
                treeViewer.setSelection((ISelection)new StructuredSelection((Object[])this.smallestCommonParents((IJavaElement[])compilationUnits)), true);
            }
        }

        private IJavaElement[] smallestCommonParents(IJavaElement[] elements) {
            if (elements.length == 1) {
                return elements;
            }
            ArrayList<IJavaElement> parents = new ArrayList<IJavaElement>();
            boolean hasParents = false;
            IJavaElement parent = this.getParent(elements[0]);
            if (parent == null) {
                parent = elements[0];
            } else {
                hasParents = true;
            }
            parents.add(parent);
            int i = 1;
            while (i < elements.length) {
                parent = this.getParent(elements[i]);
                if (this.getParent(elements[i - 1]) != parent) {
                    if (parent == null) {
                        parent = elements[i];
                    } else {
                        hasParents = true;
                    }
                    if (!parents.contains(parent)) {
                        parents.add(parent);
                    }
                }
                ++i;
            }
            IJavaElement[] parentsArray = parents.toArray(new IJavaElement[parents.size()]);
            if (hasParents) {
                return this.smallestCommonParents(parentsArray);
            }
            return parentsArray;
        }

        private IJavaElement getParent(IJavaElement element) {
            if (element instanceof ICompilationUnit) {
                return element.getParent();
            }
            if (element instanceof IPackageFragment) {
                return element.getParent().getParent();
            }
            return element.getParent();
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private void initializeRefactoring() {
            CleanUpRefactoring refactoring = (CleanUpRefactoring)this.getRefactoring();
            refactoring.clearCompilationUnits();
            Object[] checkedElements = this.fTreeViewer.getCheckedElements();
            int i = 0;
            while (i < checkedElements.length) {
                if (checkedElements[i] instanceof ICompilationUnit) {
                    refactoring.addCompilationUnit((ICompilationUnit)checkedElements[i]);
                }
                ++i;
            }
            if (!refactoring.hasCleanUps()) {
                ICleanUp[] cleanUps = this.createAllCleanUps();
                int i2 = 0;
                while (i2 < cleanUps.length) {
                    refactoring.addCleanUp(cleanUps[i2]);
                    ++i2;
                }
            }
        }

        private ICleanUp[] createAllCleanUps() {
            IDialogSettings section = CleanUpRefactoringWizard.getCleanUpWizardSettings();
            ICleanUp[] result = new ICleanUp[]{new CodeStyleCleanUp(section), new ControlStatementsCleanUp(section), new UnusedCodeCleanUp(section), new Java50CleanUp(section), new StringCleanUp(section), new PotentialProgrammingProblemsCleanUp(section)};
            return result;
        }
    }

    private class SelectCleanUpPage
    extends UserInputWizardPage {
        private ICleanUp[] fCleanUps;

        public SelectCleanUpPage(String name) {
            super(name);
        }

        public void createControl(Composite parent) {
            ScrolledComposite scrolled = new ScrolledComposite(parent, 768);
            scrolled.setLayoutData((Object)new GridData(4, 4, true, true));
            scrolled.setLayout((Layout)new GridLayout(1, false));
            scrolled.setExpandHorizontal(true);
            scrolled.setExpandVertical(true);
            Composite composite = new Composite((Composite)scrolled, 0);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.createGroups(composite);
            scrolled.setContent((Control)composite);
            scrolled.setMinSize(composite.computeSize(-1, -1));
            this.setControl((Control)scrolled);
            Dialog.applyDialogFont((Control)scrolled);
        }

        private void createGroups(Composite parent) {
            CleanUpRefactoring refactoring = (CleanUpRefactoring)this.getRefactoring();
            IJavaProject[] projects = refactoring.getProjects();
            IJavaProject project = projects.length == 1 ? projects[0] : null;
            IDialogSettings section = CleanUpRefactoringWizard.getCleanUpWizardSettings();
            this.fCleanUps = new ICleanUp[6];
            Composite group = this.createGroup(parent, MultiFixMessages.CleanUpRefactoringWizard_CodeStyleSection_description);
            Label accesses = new Label(group, 0);
            accesses.setLayoutData((Object)new GridData(16384, 128, false, false));
            accesses.setText(MultiFixMessages.CleanUpRefactoringWizard_memberAccesses_sectionDescription);
            Composite composite = new Composite(group, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.fCleanUps[0] = new CodeStyleCleanUp(section);
            this.fCleanUps[0].createConfigurationControl(composite, project);
            Label statements = new Label(group, 0);
            statements.setLayoutData((Object)new GridData(16384, 128, false, false));
            statements.setText(MultiFixMessages.CleanUpRefactoringWizard_controlStatements_sectionDescription);
            composite = new Composite(group, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.fCleanUps[1] = new ControlStatementsCleanUp(section);
            this.fCleanUps[1].createConfigurationControl(composite, project);
            group = this.createGroup(parent, MultiFixMessages.CleanUpRefactoringWizard_UnusedCodeSection_description);
            Label remove = new Label(group, 0);
            remove.setLayoutData((Object)new GridData(16384, 128, false, false));
            remove.setText(MultiFixMessages.CleanUpRefactoringWizard_Remove_sectionTitle);
            composite = new Composite(group, 0);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            this.fCleanUps[2] = new UnusedCodeCleanUp(section);
            this.fCleanUps[2].createConfigurationControl(composite, project);
            this.fCleanUps[5] = new StringCleanUp(section);
            this.fCleanUps[5].createConfigurationControl(composite, project);
            group = this.createGroup(parent, MultiFixMessages.CleanUpRefactoringWizard_Annotations_sectionName);
            this.fCleanUps[3] = new Java50CleanUp(section);
            this.fCleanUps[3].createConfigurationControl(group, project);
            group = this.createGroup(parent, MultiFixMessages.CleanUpRefactoringWizard_PotentialProgrammingProblems_description);
            this.fCleanUps[4] = new PotentialProgrammingProblemsCleanUp(section);
            this.fCleanUps[4].createConfigurationControl(group, project);
        }

        private Composite createGroup(Composite parent, String description) {
            Group group = new Group(parent, 0);
            group.setLayoutData((Object)new GridData(4, 128, true, false));
            group.setLayout((Layout)new GridLayout(1, true));
            group.setText(description);
            return group;
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
            if (this.fCleanUps != null) {
                IDialogSettings settings = CleanUpRefactoringWizard.getCleanUpWizardSettings();
                int i = 0;
                while (i < this.fCleanUps.length) {
                    this.fCleanUps[i].saveSettings(settings);
                    ++i;
                }
            }
        }

        private void initializeRefactoring() {
            if (this.fCleanUps != null) {
                CleanUpRefactoring refactoring = (CleanUpRefactoring)this.getRefactoring();
                refactoring.clearCleanUps();
                int i = 0;
                while (i < this.fCleanUps.length) {
                    refactoring.addCleanUp(this.fCleanUps[i]);
                    ++i;
                }
            }
        }
    }
}

