/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.ControlStatementsFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ControlStatementsCleanUp
extends AbstractCleanUp {
    public static final int ADD_BLOCK_TO_CONTROL_STATEMENTS = 1;
    public static final int CONVERT_FOR_LOOP_TO_ENHANCED_FOR_LOOP = 2;
    public static final int REMOVE_UNNECESSARY_BLOCKS = 4;
    private static final int DEFAULT_FLAG = 0;
    private static final String SECTION_NAME = "CleanUp_ControlStatements";

    public ControlStatementsCleanUp(int flag) {
        super(flag);
    }

    public ControlStatementsCleanUp(IDialogSettings settings) {
        super(ControlStatementsCleanUp.getSection(settings, SECTION_NAME), 0);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return ControlStatementsFix.createCleanUp(compilationUnit, this.isFlag(1), this.isFlag(4), this.isFlag(2));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(ControlStatementsCleanUp.getSection(settings, SECTION_NAME));
    }

    public Control createConfigurationControl(Composite parent, IJavaProject project) {
        Button button = new Button(parent, 32);
        button.setText(MultiFixMessages.ControlStatementsCleanUp_useBlocks_checkBoxLabel);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.indent((Control)button);
        Composite sub = new Composite(parent, 0);
        sub.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sub.setLayout((Layout)layout);
        this.indent((Control)sub);
        int[] flags = new int[]{1, 4};
        int[] uiFlags = new int[]{0x40000000, 0x20000000};
        String[] labels = new String[]{MultiFixMessages.ControlStatementsCleanUp_always_checkBoxLabel, MultiFixMessages.ControlStatementsCleanUp_removeIfPossible_checkBoxLabel};
        this.createSubGroup(sub, button, 16, flags, labels, uiFlags, false);
        Button box1 = this.addCheckBox(parent, 2, MultiFixMessages.ControlStatementsCleanUp_convertLoops_checkBoxLabel);
        this.indent((Control)box1);
        if (project != null && !JavaModelUtil.is50OrHigher(project)) {
            box1.setEnabled(false);
        }
        return parent;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.CodeStyleMultiFix_ConvertSingleStatementInControlBodeyToBlock_description);
        }
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }
}

