/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.model;

import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.model.JavaModelContentProvider;
import org.eclipse.jdt.internal.ui.model.JavaModelProvider;
import org.eclipse.jdt.internal.ui.model.JavaProjectSettings;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.model.AbstractSynchronizationContentProvider;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.IResourceMappingScope;
import org.eclipse.team.core.mapping.ISynchronizationContext;

public final class JavaSynchronizationContentProvider
extends AbstractSynchronizationContentProvider {
    private ITreeContentProvider fContentProvider = null;
    private Object fModelRoot = null;
    static /* synthetic */ Class class$0;

    static IDiff[] getDiffs(ISynchronizationContext context, Object element) {
        return context.getDiffTree().getDiffs(JavaSynchronizationContentProvider.getResourceTraversals(element));
    }

    static ResourceMapping getResourceMapping(Object element) {
        if (element instanceof IJavaElement) {
            return JavaElementResourceMapping.create((IJavaElement)element);
        }
        if (element instanceof IAdaptable) {
            Object adapted;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.mapping.ResourceMapping");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapted = adaptable.getAdapter((Class)clazz)) instanceof ResourceMapping) {
                return (ResourceMapping)adapted;
            }
        }
        return null;
    }

    static ResourceTraversal[] getResourceTraversals(Object element) {
        ResourceMapping mapping = JavaSynchronizationContentProvider.getResourceMapping(element);
        if (mapping != null) {
            try {
                return mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exception) {
                JavaPlugin.log(exception);
            }
        }
        return new ResourceTraversal[0];
    }

    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parent, Object[] children) {
        Object[] elements = super.getChildrenInContext(context, parent, children);
        if (parent instanceof IPackageFragment) {
            return this.getPackageFragmentChildren(context, parent, elements);
        }
        if (parent instanceof IPackageFragmentRoot) {
            return this.getPackageFragmentRootChildren(context, parent, elements);
        }
        if (parent instanceof IJavaProject) {
            return this.getJavaProjectChildren(context, parent, elements);
        }
        if (parent instanceof JavaProjectSettings) {
            return this.getProjectSettingsChildren(context, parent, elements);
        }
        if (parent instanceof RefactoringHistory) {
            return ((RefactoringHistory)parent).getDescriptors();
        }
        return elements;
    }

    protected ITreeContentProvider getDelegateContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new JavaModelContentProvider();
        }
        return this.fContentProvider;
    }

    private Object[] getJavaProjectChildren(ISynchronizationContext context, Object parent, Object[] children) {
        LinkedList<Object> list = new LinkedList<Object>();
        int index = 0;
        while (index < children.length) {
            list.add(children[index]);
            ++index;
        }
        return list.toArray(new Object[list.size()]);
    }

    protected String getModelProviderId() {
        return "org.eclipse.jdt.ui.modelProvider";
    }

    protected Object getModelRoot() {
        if (this.fModelRoot == null) {
            this.fModelRoot = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        }
        return this.fModelRoot;
    }

    private Object[] getPackageFragmentChildren(ISynchronizationContext context, Object parent, Object[] children) {
        HashSet<Object> set = new HashSet<Object>();
        int index = 0;
        while (index < children.length) {
            set.add(children[index]);
            ++index;
        }
        IResource resource = ((IPackageFragment)parent).getResource();
        if (resource != null) {
            IResourceDiffTree tree = context.getDiffTree();
            IResource[] members = tree.members(resource);
            int index2 = 0;
            while (index2 < members.length) {
                int type;
                IDiff diff = tree.getDiff(members[index2]);
                if (diff != null && (type = members[index2].getType()) == 1 && this.isInScope((IResourceMappingScope)context.getScope(), parent, members[index2])) {
                    set.add(JavaCore.create((IResource)members[index2]));
                }
                ++index2;
            }
        }
        return set.toArray(new Object[set.size()]);
    }

    private Object[] getPackageFragmentRootChildren(ISynchronizationContext context, Object parent, Object[] children) {
        final HashSet<Object> set = new HashSet<Object>();
        int index = 0;
        while (index < children.length) {
            set.add(children[index]);
            ++index;
        }
        IResource resource = JavaModelProvider.getResource(parent);
        if (resource != null) {
            final IResourceDiffTree tree = context.getDiffTree();
            IResource[] members = tree.members(resource);
            int index2 = 0;
            while (index2 < members.length) {
                int type = members[index2].getType();
                boolean contained = this.isInScope((IResourceMappingScope)context.getScope(), parent, members[index2]);
                if (type == 1 && contained) {
                    set.add(JavaCore.create((IFile)((IFile)members[index2])));
                } else if (type == 2 && contained) {
                    set.add(JavaCore.create((IResource)members[index2]));
                }
                if (type == 2) {
                    IFolder folder = (IFolder)members[index2];
                    try {
                        tree.accept(folder.getFullPath(), new IDiffVisitor(){

                            public final boolean visit(IDiff diff) throws CoreException {
                                IResource current = tree.getResource(diff);
                                if (current != null) {
                                    int kind = current.getType();
                                    if (kind == 1) {
                                        set.add(JavaCore.create((IResource)current.getParent()));
                                    } else {
                                        set.add(JavaCore.create((IResource)current));
                                    }
                                }
                                return true;
                            }
                        }, 2);
                    }
                    catch (CoreException exception) {
                        JavaPlugin.log(exception);
                    }
                }
                ++index2;
            }
            return set.toArray(new Object[set.size()]);
        }
        return children;
    }

    private Object[] getProjectSettingsChildren(ISynchronizationContext context, Object parent, Object[] children) {
        HashSet<Object> set = new HashSet<Object>();
        int index = 0;
        while (index < children.length) {
            set.add(children[index]);
            ++index;
        }
        IResource resource = JavaModelProvider.getResource(parent);
        if (resource != null) {
            IResourceDiffTree tree = context.getDiffTree();
            IResource[] members = tree.members(resource);
            int index2 = 0;
            while (index2 < members.length) {
                int type;
                IDiff diff = tree.getDiff(members[index2]);
                if (diff != null && (type = members[index2].getType()) == 1 && this.isInScope((IResourceMappingScope)context.getScope(), parent, members[index2])) {
                    set.add(members[index2]);
                }
                ++index2;
            }
        }
        return set.toArray(new Object[set.size()]);
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        return JavaSynchronizationContentProvider.getResourceTraversals(object);
    }

    private boolean hasChildrenInScope(IResourceMappingScope scope, Object element, IResource resource) {
        IResource[] roots = scope.getRoots();
        IPath path = resource.getFullPath();
        if (element instanceof IPackageFragment) {
            int index = 0;
            while (index < roots.length) {
                if (path.equals((Object)roots[index].getFullPath().removeLastSegments(1))) {
                    return true;
                }
                ++index;
            }
            return false;
        }
        int index = 0;
        while (index < roots.length) {
            if (path.isPrefixOf(roots[index].getFullPath())) {
                return true;
            }
            ++index;
        }
        return false;
    }

    protected boolean isInScope(IResourceMappingScope scope, Object parent, Object element) {
        IResource resource = JavaModelProvider.getResource(element);
        if (resource == null) {
            return false;
        }
        if (scope.contains(resource)) {
            return true;
        }
        return this.hasChildrenInScope(scope, element, resource);
    }
}

