/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.IPropertiesFilePartitions;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlinkDetector;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyValueScanner;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.HTMLAnnotationHover;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.jdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.jdt.internal.ui.text.java.JavaStringDoubleClickSelector;
import org.eclipse.jdt.internal.ui.text.spelling.PropertiesSpellingReconcileStrategy;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertiesFileSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;
    private AbstractJavaScanner fPropertyKeyScanner;
    private AbstractJavaScanner fCommentScanner;
    private AbstractJavaScanner fPropertyValueScanner;
    private IColorManager fColorManager;

    public PropertiesFileSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(preferenceStore);
        this.fColorManager = colorManager;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    protected RuleBasedScanner getPropertyKeyScanner() {
        return this.fPropertyKeyScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fCommentScanner;
    }

    protected RuleBasedScanner getPropertyValueScanner() {
        return this.fPropertyValueScanner;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    private void initializeScanners() {
        this.fPropertyKeyScanner = new SingleTokenJavaScanner(this.getColorManager(), this.fPreferenceStore, "pf_coloring_key");
        this.fPropertyValueScanner = new PropertyValueScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = new SingleTokenJavaScanner(this.getColorManager(), this.fPreferenceStore, "pf_coloring_comment");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        JavaPresentationReconciler reconciler = new JavaPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getPropertyKeyScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__pf_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__pf_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getPropertyValueScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__pf_roperty_value");
        reconciler.setRepairer((IPresentationRepairer)dr, "__pf_roperty_value");
        return reconciler;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return new JavaStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        int length = IPropertiesFilePartitions.PARTITIONS.length;
        String[] contentTypes = new String[length + 1];
        contentTypes[0] = "__dftl_partition_content_type";
        int i = 0;
        while (i < length) {
            contentTypes[i + 1] = IPropertiesFilePartitions.PARTITIONS[i];
            ++i;
        }
        return contentTypes;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fPropertyKeyScanner.affectsBehavior(event) || this.fCommentScanner.affectsBehavior(event) || this.fPropertyValueScanner.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPropertyKeyScanner.affectsBehavior(event)) {
            this.fPropertyKeyScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fPropertyValueScanner.affectsBehavior(event)) {
            this.fPropertyValueScanner.adaptToPreferenceChange(event);
        }
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fTextEditor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 2];
        detectors[0] = new PropertyKeyHyperlinkDetector(this.fTextEditor);
        int i = 0;
        while (i < inheritedDetectorsLength) {
            detectors[i + 1] = inheritedDetectors[i];
            ++i;
        }
        return detectors;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.getEditor() != null && this.getEditor().isEditable() && this.fPreferenceStore != null) {
            PropertiesSpellingReconcileStrategy strategy = new PropertiesSpellingReconcileStrategy(this.getEditor());
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return PropertiesFileSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return PropertiesFileSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }
}

