/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.StringTokenizer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.ErasureMatchFilter;
import org.eclipse.jdt.internal.ui.search.ImportFilter;
import org.eclipse.jdt.internal.ui.search.InexactMatchFilter;
import org.eclipse.jdt.internal.ui.search.JavaElementMatch;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavadocFilter;
import org.eclipse.jdt.internal.ui.search.ReadFilter;
import org.eclipse.jdt.internal.ui.search.WriteFilter;

abstract class MatchFilter {
    private static final String SETTINGS_LAST_USED_FILTERS = "filters_last_used";
    private static final MatchFilter IMPORT_FILTER = new ImportFilter();
    private static final MatchFilter JAVADOC_FILTER = new JavadocFilter();
    private static final MatchFilter READ_FILTER = new ReadFilter();
    private static final MatchFilter WRITE_FILTER = new WriteFilter();
    private static final MatchFilter INEXACT_FILTER = new InexactMatchFilter();
    private static final MatchFilter ERASURE_FILTER = new ErasureMatchFilter();
    private static final MatchFilter[] ALL_FILTERS = new MatchFilter[]{IMPORT_FILTER, JAVADOC_FILTER, READ_FILTER, WRITE_FILTER, INEXACT_FILTER, ERASURE_FILTER};

    MatchFilter() {
    }

    public static MatchFilter[] getLastUsedFilters() {
        String string = JavaPlugin.getDefault().getDialogSettings().get(SETTINGS_LAST_USED_FILTERS);
        if (string != null && string.length() > 0) {
            return MatchFilter.decodeFiltersString(string);
        }
        return MatchFilter.getDefaultFilters();
    }

    public static void setLastUsedFilters(MatchFilter[] filters) {
        String encoded = MatchFilter.encodeFilters(filters);
        JavaPlugin.getDefault().getDialogSettings().put(SETTINGS_LAST_USED_FILTERS, encoded);
    }

    public static MatchFilter[] getDefaultFilters() {
        return new MatchFilter[]{IMPORT_FILTER};
    }

    private static String encodeFilters(MatchFilter[] enabledFilters) {
        StringBuffer buf = new StringBuffer();
        buf.append(enabledFilters.length);
        int i = 0;
        while (i < enabledFilters.length) {
            buf.append(';');
            buf.append(enabledFilters[i].getID());
            ++i;
        }
        return buf.toString();
    }

    private static MatchFilter[] decodeFiltersString(String encodedString) {
        StringTokenizer tokenizer = new StringTokenizer(encodedString, String.valueOf(';'));
        int count = Integer.valueOf(tokenizer.nextToken());
        MatchFilter[] res = new MatchFilter[count];
        int i = 0;
        while (i < count) {
            res[i] = MatchFilter.findMatchFilter(tokenizer.nextToken());
            ++i;
        }
        return res;
    }

    public abstract boolean isApplicable(JavaSearchQuery var1);

    public abstract boolean filters(JavaElementMatch var1);

    public abstract String getName();

    public abstract String getActionLabel();

    public abstract String getDescription();

    public abstract String getID();

    public static MatchFilter[] allFilters() {
        return ALL_FILTERS;
    }

    private static MatchFilter findMatchFilter(String id) {
        int i = 0;
        while (i < ALL_FILTERS.length) {
            if (ALL_FILTERS[i].getID().equals(id)) {
                return ALL_FILTERS[i];
            }
            ++i;
        }
        return IMPORT_FILTER;
    }
}

