/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.fix.ControlStatementsFix;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.ControlStatementsCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.AssignToVariableAssistProposal;
import org.eclipse.jdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.LinkedNamesAssistProposal;
import org.eclipse.jdt.internal.ui.text.correction.NewDefiningMethodProposal;
import org.eclipse.jdt.internal.ui.text.correction.SurroundWith;
import org.eclipse.jdt.internal.ui.text.correction.SurroundWithRunnableProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;

public class QuickAssistProcessor
implements IQuickAssistProcessor {
    public static final String CONVERT_FOR_LOOP_ID = "org.eclipse.jdt.ui.correction.convertForLoop.assist";
    public static final String ASSIGN_TO_LOCAL_ID = "org.eclipse.jdt.ui.correction.assignToLocal.assist";
    public static final String ASSIGN_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.assignToField.assist";
    public static final String ASSIGN_PARAM_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.assignParamToField.assist";
    public static final String ADD_BLOCK_ID = "org.eclipse.jdt.ui.correction.addBlock.assist";

    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            return QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, null) || QuickAssistProcessor.getRenameLocalProposals(context, coveringNode, null, false, null) || QuickAssistProcessor.getAssignToVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getUnWrapProposals(context, coveringNode, null) || QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, null) || QuickAssistProcessor.getJoinVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getAddFinallyProposals(context, coveringNode, null) || QuickAssistProcessor.getAddElseProposals(context, coveringNode, null) || QuickAssistProcessor.getSplitVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getAddBlockProposals(context, coveringNode, null) || QuickAssistProcessor.getArrayInitializerToArrayCreation(context, coveringNode, null) || QuickAssistProcessor.getCreateInSuperClassProposals(context, coveringNode, null) || QuickAssistProcessor.getInvertEqualsProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertForLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getExtractLocalProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertIterableLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getSurroundWithRunnableProposal(context, coveringNode, null) || this.getRemoveBlockProposals(context, coveringNode, null);
        }
        return false;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList resultingCollections = new ArrayList();
            boolean noErrorsAtLocation = this.noErrorsAtLocation(locations);
            QuickAssistProcessor.getRenameLocalProposals(context, coveringNode, locations, noErrorsAtLocation, resultingCollections);
            if (noErrorsAtLocation) {
                QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAssignToVariableProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getUnWrapProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getSplitVariableProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getJoinVariableProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddFinallyProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddElseProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddBlockProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getInvertEqualsProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getArrayInitializerToArrayCreation(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getCreateInSuperClassProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getExtractLocalProposal(context, coveringNode, resultingCollections);
                if (!QuickAssistProcessor.getConvertForLoopProposal(context, coveringNode, resultingCollections)) {
                    QuickAssistProcessor.getConvertIterableLoopProposal(context, coveringNode, resultingCollections);
                }
                QuickAssistProcessor.getSurroundWithRunnableProposal(context, coveringNode, resultingCollections);
                this.getRemoveBlockProposals(context, coveringNode, resultingCollections);
            }
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        return null;
    }

    private boolean noErrorsAtLocation(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                if (locations[i].isError()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean getExtractLocalProposal(IInvocationContext context, ASTNode covering, ArrayList proposals) throws CoreException {
        ASTNode node = context.getCoveredNode();
        if (!(node instanceof Expression)) {
            return false;
        }
        Expression expression = (Expression)node;
        ITypeBinding binding = expression.resolveTypeBinding();
        if (binding == null || Bindings.isVoidType(binding)) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        final ICompilationUnit cu = context.getCompilationUnit();
        final ExtractTempRefactoring refactoring = new ExtractTempRefactoring(cu, expression.getStartPosition(), expression.getLength());
        if (refactoring.checkActivationBasics(context.getASTRoot(), (IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
            CUCorrectionProposal proposal = new CUCorrectionProposal(label, cu, 5, image){

                protected TextChange createTextChange() throws CoreException {
                    refactoring.setTempName(refactoring.guessTempName());
                    if (!refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor()).hasFatalError()) {
                        return (TextChange)refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
                    }
                    Document document = new Document("");
                    document.setInitialLineDelimiter(StubUtility.getLineDelimiterUsed((IJavaElement)cu));
                    return new DocumentChange(this.getDisplayString(), (IDocument)document);
                }
            };
            proposals.add(proposal);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getJoinVariableProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ASTNode parent = node.getParent();
        VariableDeclarationFragment fragment = null;
        boolean onFirstAccess = false;
        if (node instanceof SimpleName && node.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
            onFirstAccess = true;
            SimpleName name = (SimpleName)node;
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return false;
            }
            ASTNode declaring = context.getASTRoot().findDeclaringNode(binding);
            if (!(declaring instanceof VariableDeclarationFragment)) return false;
            fragment = (VariableDeclarationFragment)declaring;
        } else {
            if (!(parent instanceof VariableDeclarationFragment)) return false;
            fragment = (VariableDeclarationFragment)parent;
        }
        IVariableBinding binding = fragment.resolveBinding();
        if (fragment.getInitializer() != null || binding == null || binding.isField()) {
            return false;
        }
        if (!(fragment.getParent() instanceof VariableDeclarationStatement)) {
            return false;
        }
        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
        SimpleName[] names = LinkedNodeFinder.findByBinding(statement.getParent(), (IBinding)binding);
        if (names.length <= 1 || names[0] != fragment.getName()) {
            return false;
        }
        SimpleName firstAccess = names[1];
        if (onFirstAccess ? firstAccess != node : firstAccess.getLocationInParent() != Assignment.LEFT_HAND_SIDE_PROPERTY) {
            return false;
        }
        Assignment assignment = (Assignment)firstAccess.getParent();
        if (assignment.getLocationInParent() != ExpressionStatement.EXPRESSION_PROPERTY) {
            return false;
        }
        ExpressionStatement assignParent = (ExpressionStatement)assignment.getParent();
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_joindeclaration_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)assignment.getRightHandSide());
        rewrite.set((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, (Object)placeholder, null);
        if (onFirstAccess) {
            rewrite.replace((ASTNode)assignParent, rewrite.createMoveTarget((ASTNode)statement), null);
        } else if (ASTNodes.isControlStatementBody(assignParent.getLocationInParent())) {
            Block block = ast.newBlock();
            rewrite.replace((ASTNode)assignParent, (ASTNode)block, null);
        } else {
            rewrite.remove((ASTNode)assignParent, null);
        }
        proposal.setEndPosition(rewrite.track((ASTNode)fragment.getName()));
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getSplitVariableProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ExpressionStatement newStatement;
        VariableDeclarationStatement statement;
        VariableDeclarationFragment fragment;
        if (node instanceof VariableDeclarationFragment) {
            fragment = (VariableDeclarationFragment)node;
        } else if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
            fragment = (VariableDeclarationFragment)node.getParent();
        } else {
            return false;
        }
        if (fragment.getInitializer() == null) {
            return false;
        }
        ASTNode fragParent = fragment.getParent();
        if (fragParent instanceof VariableDeclarationStatement) {
            statement = (VariableDeclarationStatement)fragParent;
        } else if (fragParent instanceof VariableDeclarationExpression) {
            statement = (Statement)fragParent.getParent();
        } else {
            return false;
        }
        ASTNode statementParent = statement.getParent();
        StructuralPropertyDescriptor property = statement.getLocationInParent();
        if (!property.isChildListProperty()) {
            return false;
        }
        List list = (List)statementParent.getStructuralProperty(property);
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_splitdeclaration_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        int insertIndex = list.indexOf(statement);
        Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)fragment.getInitializer());
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide(placeholder);
        assignment.setLeftHandSide((Expression)ast.newSimpleName(fragment.getName().getIdentifier()));
        if (statement instanceof VariableDeclarationStatement) {
            newStatement = ast.newExpressionStatement((Expression)assignment);
            ++insertIndex;
        } else {
            rewrite.replace(fragment.getParent(), (ASTNode)assignment, null);
            VariableDeclarationFragment newFrag = ast.newVariableDeclarationFragment();
            newFrag.setName(ast.newSimpleName(fragment.getName().getIdentifier()));
            newFrag.setExtraDimensions(fragment.getExtraDimensions());
            VariableDeclarationExpression oldVarDecl = (VariableDeclarationExpression)fragParent;
            VariableDeclarationStatement newVarDec = ast.newVariableDeclarationStatement(newFrag);
            newVarDec.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)oldVarDecl.getType()));
            newVarDec.modifiers().addAll(ASTNodeFactory.newModifiers(ast, oldVarDecl.getModifiers()));
            newStatement = newVarDec;
        }
        ListRewrite listRewriter = rewrite.getListRewrite(statementParent, (ChildListPropertyDescriptor)property);
        listRewriter.insertAt((ASTNode)newStatement, insertIndex, null);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getAssignToVariableProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof ExpressionStatement)) {
            return false;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        if (expression.getNodeType() == 7) {
            return false;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if ((typeBinding = Bindings.normalizeTypeBinding(typeBinding)) == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        AssignToVariableAssistProposal localProposal = new AssignToVariableAssistProposal(cu, 1, expressionStatement, typeBinding, 2);
        localProposal.setCommandId(ASSIGN_TO_LOCAL_ID);
        resultingCollections.add(localProposal);
        ASTNode type = ASTResolving.findParentType((ASTNode)expression);
        if (type != null) {
            AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(cu, 2, expressionStatement, typeBinding, 1);
            fieldProposal.setCommandId(ASSIGN_TO_FIELD_ID);
            resultingCollections.add(fieldProposal);
        }
        return false;
    }

    private static boolean getAssignParamToFieldProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode(node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)parent;
        IVariableBinding binding = paramDecl.resolveBinding();
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (binding == null || methodDecl.getBody() == null) {
            return false;
        }
        ITypeBinding typeBinding = binding.getType();
        if (typeBinding == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType(node);
        if (parentType != null) {
            CompilationUnit root = context.getASTRoot();
            IVariableBinding[] declaredFields = parentType.getDeclaredFields();
            boolean isStaticContext = ASTResolving.isInStaticContext(node);
            int i = 0;
            while (i < declaredFields.length) {
                VariableDeclarationFragment fragment;
                ASTNode fieldDeclFrag;
                IVariableBinding curr = declaredFields[i];
                if (isStaticContext == Modifier.isStatic((int)curr.getModifiers()) && typeBinding.isAssignmentCompatible(curr.getType()) && (fieldDeclFrag = root.findDeclaringNode((IBinding)curr)) instanceof VariableDeclarationFragment && (fragment = (VariableDeclarationFragment)fieldDeclFrag).getInitializer() == null) {
                    resultingCollections.add(new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, fragment, typeBinding, 1));
                }
                ++i;
            }
        }
        AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, null, typeBinding, 3);
        fieldProposal.setCommandId(ASSIGN_PARAM_TO_FIELD_ID);
        resultingCollections.add(fieldProposal);
        return true;
    }

    private static boolean getAddFinallyProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        TryStatement tryStatement = ASTResolving.findParentTryStatement(node);
        if (tryStatement == null || tryStatement.getFinally() != null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (tryStatement != statement && tryStatement.getBody() != statement) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = tryStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Block finallyBody = ast.newBlock();
        rewrite.set((ASTNode)tryStatement, (StructuralPropertyDescriptor)TryStatement.FINALLY_PROPERTY, (Object)finallyBody, null);
        String label = CorrectionMessages.QuickAssistProcessor_addfinallyblock_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getAddElseProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Block body = ast.newBlock();
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)body, null);
        String label = CorrectionMessages.QuickAssistProcessor_addelseblock_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getCatchClauseToThrowsProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor(node, 12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type = catchClause.getException().getType();
        if (!type.isSimpleType()) {
            return false;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause);
        if (!(bodyDeclaration instanceof MethodDeclaration) && !(bodyDeclaration instanceof Initializer)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = bodyDeclaration.getAST();
        if (bodyDeclaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
            ITypeBinding binding = type.resolveBinding();
            if (binding == null || QuickAssistProcessor.isNotYetThrown(binding, methodDeclaration.thrownExceptions())) {
                Name name = ((SimpleType)type).getName();
                Name newName = (Name)ASTNode.copySubtree((AST)ast, (ASTNode)name);
                ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
                listRewriter.insertLast((ASTNode)newName, null);
            }
            String label = CorrectionMessages.QuickAssistProcessor_catchclausetothrows_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 4, image);
            resultingCollections.add(proposal);
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
        String label = CorrectionMessages.QuickAssistProcessor_removecatchclause_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static void removeCatchBlock(ASTRewrite rewrite, CatchClause catchClause) {
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null) {
            rewrite.remove((ASTNode)catchClause, null);
        } else {
            Block block = tryStatement.getBody();
            List statements = block.statements();
            int nStatements = statements.size();
            if (nStatements == 1) {
                ASTNode first = (ASTNode)statements.get(0);
                rewrite.replace((ASTNode)tryStatement, rewrite.createCopyTarget(first), null);
            } else if (nStatements > 1) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)statements.get(0);
                ASTNode last = (ASTNode)statements.get(statements.size() - 1);
                ASTNode newStatement = listRewrite.createCopyTarget(first, last);
                if (ASTNodes.isControlStatementBody(tryStatement.getLocationInParent())) {
                    Block newBlock = rewrite.getAST().newBlock();
                    newBlock.statements().add(newStatement);
                    newStatement = newBlock;
                }
                rewrite.replace((ASTNode)tryStatement, newStatement, null);
            } else {
                rewrite.remove((ASTNode)tryStatement, null);
            }
        }
    }

    private static boolean isNotYetThrown(ITypeBinding binding, List thrownExcpetions) {
        int i = 0;
        while (i < thrownExcpetions.size()) {
            Name name = (Name)thrownExcpetions.get(i);
            ITypeBinding elem = (ITypeBinding)name.resolveBinding();
            if (elem != null && Bindings.isSuperType(elem, binding)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean getRenameLocalProposals(IInvocationContext context, ASTNode node, IProblemLocation[] locations, boolean noErrorsAtLocation, Collection resultingCollections) {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (binding != null && binding.getKind() == 1) {
            return false;
        }
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                switch (locations[i].getProblemId()) {
                    case 536871002: 
                    case 536871006: 
                    case 536871007: 
                    case 570425435: 
                    case 570425436: 
                    case 570425437: {
                        return false;
                    }
                }
                ++i;
            }
        }
        if (resultingCollections == null) {
            return true;
        }
        LinkedNamesAssistProposal proposal = new LinkedNamesAssistProposal(context.getCompilationUnit(), name);
        if (!noErrorsAtLocation) {
            proposal.setRelevance(1);
        }
        resultingCollections.add(proposal);
        return true;
    }

    public static ASTNode getCopyOfInner(ASTRewrite rewrite, ASTNode statement, boolean toControlStatementBody) {
        if (statement.getNodeType() == 8) {
            Block block = (Block)statement;
            List innerStatements = block.statements();
            int nStatements = innerStatements.size();
            if (nStatements == 1) {
                return rewrite.createCopyTarget((ASTNode)innerStatements.get(0));
            }
            if (nStatements > 1) {
                if (toControlStatementBody) {
                    return rewrite.createCopyTarget((ASTNode)block);
                }
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)innerStatements.get(0);
                ASTNode last = (ASTNode)innerStatements.get(nStatements - 1);
                return listRewrite.createCopyTarget(first, last);
            }
            return null;
        }
        return rewrite.createCopyTarget(statement);
    }

    private static boolean getUnWrapProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        MethodInvocation invocation;
        ASTNode outer = node;
        Block block = null;
        if (outer.getNodeType() == 8) {
            block = (Block)outer;
            outer = block.getParent();
        }
        Statement body = null;
        String label = null;
        if (outer instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)outer;
            Statement elseBlock = ifStatement.getElseStatement();
            if (elseBlock == null || elseBlock instanceof Block && ((Block)elseBlock).statements().isEmpty()) {
                body = ifStatement.getThenStatement();
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_ifstatement;
        } else if (outer instanceof WhileStatement) {
            body = ((WhileStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_whilestatement;
        } else if (outer instanceof ForStatement) {
            body = ((ForStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_forstatement;
        } else if (outer instanceof DoStatement) {
            body = ((DoStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_dostatement;
        } else if (outer instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)outer;
            if (tryStatement.catchClauses().isEmpty()) {
                body = tryStatement.getBody();
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_trystatement;
        } else if (outer instanceof AnonymousClassDeclaration) {
            List decls = ((AnonymousClassDeclaration)outer).bodyDeclarations();
            int i = 0;
            while (i < decls.size()) {
                ASTNode elem = (ASTNode)decls.get(i);
                if (elem instanceof MethodDeclaration) {
                    Block curr = ((MethodDeclaration)elem).getBody();
                    if (curr != null && !curr.statements().isEmpty()) {
                        if (body != null) {
                            return false;
                        }
                        body = curr;
                    }
                } else if (elem instanceof TypeDeclaration) {
                    return false;
                }
                ++i;
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_anonymous;
            if ((outer = ASTResolving.findParentStatement(outer)) == null) {
                return false;
            }
        } else if (outer instanceof Block) {
            body = block;
            outer = block;
            label = CorrectionMessages.QuickAssistProcessor_unwrap_block;
        } else if (!(outer instanceof ParenthesizedExpression) && outer instanceof MethodInvocation && (invocation = (MethodInvocation)outer).arguments().size() == 1) {
            int kind;
            body = (ASTNode)invocation.arguments().get(0);
            if (invocation.getParent().getNodeType() == 21 && (kind = body.getNodeType()) != 7 && kind != 38 && kind != 37 && kind != 32 && kind != 48) {
                body = null;
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_methodinvocation;
        }
        if (body == null) {
            return false;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)outer.getAST());
        ASTNode inner = QuickAssistProcessor.getCopyOfInner(rewrite, (ASTNode)body, ASTNodes.isControlStatementBody(outer.getLocationInParent()));
        if (inner == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        rewrite.replace(outer, inner, null);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean isControlStatementWithBlock(ASTNode node) {
        switch (node.getNodeType()) {
            case 19: 
            case 24: 
            case 25: 
            case 61: {
                return true;
            }
        }
        return false;
    }

    private boolean getRemoveBlockProposals(IInvocationContext context, ASTNode coveringNode, Collection resultingCollections) {
        IFix[] fixes = ControlStatementsFix.createRemoveBlockFix(context.getASTRoot(), coveringNode);
        if (fixes != null) {
            ControlStatementsCleanUp cleanUp = new ControlStatementsCleanUp(4);
            int i = 0;
            while (i < fixes.length) {
                IFix fix = fixes[i];
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 10, image, context);
                resultingCollections.add(proposal);
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean getAddBlockProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        Statement statement = ASTResolving.findParentStatement(node);
        if (statement == null) {
            return false;
        }
        if (!QuickAssistProcessor.isControlStatementWithBlock((ASTNode)statement)) {
            if (!QuickAssistProcessor.isControlStatementWithBlock(statement.getParent())) {
                return false;
            }
            int statementStart = statement.getStartPosition();
            int statementEnd = statementStart + statement.getLength();
            int offset = context.getSelectionOffset();
            int length = context.getSelectionLength();
            if (length == 0 ? offset != statementEnd : offset > statementStart || offset + length < statementEnd) {
                return false;
            }
            statement = (Statement)statement.getParent();
        }
        ChildPropertyDescriptor childProperty = null;
        Statement child = null;
        switch (statement.getNodeType()) {
            case 25: {
                Statement elseStatement;
                int selectionStart = context.getSelectionOffset();
                int selectionEnd = context.getSelectionOffset() + context.getSelectionLength();
                Statement then = ((IfStatement)statement).getThenStatement();
                if (selectionEnd <= then.getStartPosition() + then.getLength()) {
                    if (then instanceof Block) break;
                    childProperty = IfStatement.THEN_STATEMENT_PROPERTY;
                    child = then;
                    break;
                }
                if (selectionStart < then.getStartPosition() + then.getLength() || (elseStatement = ((IfStatement)statement).getElseStatement()) instanceof Block) break;
                childProperty = IfStatement.ELSE_STATEMENT_PROPERTY;
                child = elseStatement;
                break;
            }
            case 61: {
                Statement whileBody = ((WhileStatement)statement).getBody();
                if (whileBody instanceof Block) break;
                childProperty = WhileStatement.BODY_PROPERTY;
                child = whileBody;
                break;
            }
            case 24: {
                Statement forBody = ((ForStatement)statement).getBody();
                if (forBody instanceof Block) break;
                childProperty = ForStatement.BODY_PROPERTY;
                child = forBody;
                break;
            }
            case 19: {
                Statement doBody = ((DoStatement)statement).getBody();
                if (doBody instanceof Block) break;
                childProperty = DoStatement.BODY_PROPERTY;
                child = doBody;
            }
        }
        if (child == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ASTNode childPlaceholder = rewrite.createMoveTarget((ASTNode)child);
        Block replacingBody = ast.newBlock();
        replacingBody.statements().add(childPlaceholder);
        rewrite.set((ASTNode)statement, (StructuralPropertyDescriptor)childProperty, (Object)replacingBody, null);
        String label = childProperty == IfStatement.THEN_STATEMENT_PROPERTY ? CorrectionMessages.QuickAssistProcessor_replacethenwithblock_description : (childProperty == IfStatement.ELSE_STATEMENT_PROPERTY ? CorrectionMessages.QuickAssistProcessor_replaceelsewithblock_description : CorrectionMessages.QuickAssistProcessor_replacebodywithblock_description);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 10, image);
        proposal.setCommandId(ADD_BLOCK_ID);
        proposal.setEndPosition(rewrite.track((ASTNode)child));
        resultingCollections.add(proposal);
        if (statement.getNodeType() == 25) {
            IfStatement ifStatement;
            Statement elseStatment;
            rewrite = ASTRewrite.create((AST)ast);
            while (statement.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                statement = (Statement)statement.getParent();
            }
            boolean missingBlockFound = false;
            boolean foundElse = false;
            do {
                ifStatement = (IfStatement)statement;
                Statement thenStatment = ifStatement.getThenStatement();
                elseStatment = ifStatement.getElseStatement();
                if (!(thenStatment instanceof Block)) {
                    ASTNode childPlaceholder1 = rewrite.createMoveTarget((ASTNode)thenStatment);
                    Block replacingBody1 = ast.newBlock();
                    replacingBody1.statements().add(childPlaceholder1);
                    rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.THEN_STATEMENT_PROPERTY, (Object)replacingBody1, null);
                    if (thenStatment != child) {
                        missingBlockFound = true;
                    }
                }
                if (elseStatment != null) {
                    foundElse = true;
                }
                statement = elseStatment;
            } while (elseStatment instanceof IfStatement);
            if (elseStatment != null && !(elseStatment instanceof Block)) {
                ASTNode childPlaceholder2 = rewrite.createMoveTarget((ASTNode)elseStatment);
                Block replacingBody2 = ast.newBlock();
                replacingBody2.statements().add(childPlaceholder2);
                rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)replacingBody2, null);
                if (elseStatment != child) {
                    missingBlockFound = true;
                }
            }
            if (missingBlockFound && foundElse) {
                String label2 = CorrectionMessages.QuickAssistProcessor_replacethenelsewithblock_description;
                Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, context.getCompilationUnit(), rewrite, 10, image2);
                resultingCollections.add(proposal2);
            }
        }
        return true;
    }

    private static boolean getSurroundWithRunnableProposal(IInvocationContext context, ASTNode node, ArrayList resultingCollections) throws CoreException {
        Statement[] selectedStatements = SurroundWith.getSelectedStatements(context);
        if (selectedStatements == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        String label = CorrectionMessages.QuickAssistProcessor_surround_with_runnable;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        SurroundWithRunnableProposal proposal = new SurroundWithRunnableProposal(label, context, 10, image, selectedStatements);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInvertEqualsProposal(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        MethodInvocation replacement;
        ASTNode parent = node.getParent();
        if (!(parent instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation method = (MethodInvocation)parent;
        if (!"equals".equals(method.getName().getIdentifier())) {
            return false;
        }
        List arguments = method.arguments();
        if (arguments.size() != 1) {
            return false;
        }
        Expression right = (Expression)arguments.get(0);
        ITypeBinding binding = right.resolveTypeBinding();
        if (binding != null && !binding.isClass() && !binding.isInterface()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Expression left = method.getExpression();
        AST ast = method.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (left == null) {
            replacement = ast.newMethodInvocation();
            replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
            replacement.arguments().add(ast.newThisExpression());
            replacement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)right));
            rewrite.replace((ASTNode)method, (ASTNode)replacement, null);
        } else if (right instanceof ThisExpression) {
            replacement = ast.newMethodInvocation();
            replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
            replacement.arguments().add(rewrite.createCopyTarget((ASTNode)left));
            rewrite.replace((ASTNode)method, (ASTNode)replacement, null);
        } else {
            Expression leftExpression = left;
            while (leftExpression instanceof ParenthesizedExpression) {
                leftExpression = ((ParenthesizedExpression)left).getExpression();
            }
            rewrite.replace((ASTNode)right, rewrite.createCopyTarget((ASTNode)leftExpression), null);
            if (right instanceof CastExpression || right instanceof Assignment || right instanceof ConditionalExpression || right instanceof InfixExpression) {
                ParenthesizedExpression paren = ast.newParenthesizedExpression();
                paren.setExpression((Expression)rewrite.createCopyTarget((ASTNode)right));
                rewrite.replace((ASTNode)left, (ASTNode)paren, null);
            } else {
                rewrite.replace((ASTNode)left, rewrite.createCopyTarget((ASTNode)right), null);
            }
        }
        String label = CorrectionMessages.QuickAssistProcessor_invertequals_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getArrayInitializerToArrayCreation(IInvocationContext context, ASTNode node, Collection resultingCollections) throws CoreException {
        if (!(node instanceof ArrayInitializer)) {
            return false;
        }
        ArrayInitializer initializer = (ArrayInitializer)node;
        ASTNode parent = initializer.getParent();
        while (parent instanceof ArrayInitializer) {
            initializer = (ArrayInitializer)parent;
            parent = parent.getParent();
        }
        ITypeBinding typeBinding = initializer.resolveTypeBinding();
        if (!(parent instanceof VariableDeclaration) || typeBinding == null || !typeBinding.isArray()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_typetoarrayInitializer_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
        String typeName = imports.addImport(typeBinding);
        ArrayCreation creation = ast.newArrayCreation();
        creation.setInitializer((ArrayInitializer)rewrite.createMoveTarget((ASTNode)initializer));
        creation.setType((ArrayType)ASTNodeFactory.newType(ast, typeName));
        rewrite.replace((ASTNode)initializer, (ASTNode)creation, null);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getCreateInSuperClassProposals(IInvocationContext context, ASTNode node, ArrayList resultingCollections) throws CoreException {
        if (!(node instanceof SimpleName) || !(node.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration decl = (MethodDeclaration)node.getParent();
        if (decl.getName() != node || decl.resolveBinding() == null || Modifier.isPrivate((int)decl.getModifiers())) {
            return false;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        IMethodBinding binding = decl.resolveBinding();
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        ITypeBinding[] superTypes = Bindings.getAllSuperTypes(binding.getDeclaringClass());
        if (resultingCollections == null) {
            int i = 0;
            while (i < superTypes.length) {
                ITypeBinding curr = superTypes[i];
                if (curr.isFromSource() && Bindings.findOverriddenMethodInType(curr, binding) == null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        List params = decl.parameters();
        String[] paramNames = new String[paramTypes.length];
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)params.get(i);
            paramNames[i] = param.getName().getIdentifier();
            ++i;
        }
        i = 0;
        while (i < superTypes.length) {
            ITypeBinding typeDecl;
            ICompilationUnit targetCU;
            IMethodBinding method;
            ITypeBinding curr = superTypes[i];
            if (curr.isFromSource() && (method = Bindings.findOverriddenMethodInType(curr, binding)) == null && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, typeDecl = curr.getTypeDeclaration())) != null) {
                String label = Messages.format(CorrectionMessages.QuickAssistProcessor_createmethodinsuper_description, curr.getName());
                resultingCollections.add(new NewDefiningMethodProposal(label, targetCU, (ASTNode)astRoot, typeDecl, binding, paramNames, 6));
            }
            ++i;
        }
        return true;
    }

    private static boolean getConvertForLoopProposal(IInvocationContext context, ASTNode node, ArrayList resultingCollections) throws CoreException {
        ForStatement forStatement = QuickAssistProcessor.getEnclosingForStatementHeader(node);
        if (forStatement == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        IFix fix = ControlStatementsFix.createConvertForLoopToEnhancedFix(context.getASTRoot(), forStatement);
        if (fix == null) {
            return false;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ControlStatementsCleanUp cleanUp = new ControlStatementsCleanUp(2);
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 1, image, context);
        proposal.setCommandId(CONVERT_FOR_LOOP_ID);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertIterableLoopProposal(IInvocationContext context, ASTNode node, ArrayList resultingCollections) throws CoreException {
        ForStatement forStatement = QuickAssistProcessor.getEnclosingForStatementHeader(node);
        if (forStatement == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        IFix fix = ControlStatementsFix.createConvertIterableLoopToEnhancedFix(context.getASTRoot(), forStatement);
        if (fix == null) {
            return false;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ControlStatementsCleanUp cleanUp = new ControlStatementsCleanUp(2);
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 1, image, context);
        proposal.setCommandId(CONVERT_FOR_LOOP_ID);
        resultingCollections.add(proposal);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static ForStatement getEnclosingForStatementHeader(ASTNode node) {
        if (!(node instanceof ForStatement)) ** GOTO lbl10
        return (ForStatement)node;
lbl-1000:
        // 1 sources

        {
            parent = node.getParent();
            if (parent instanceof ForStatement) {
                locationInParent = node.getLocationInParent();
                if (locationInParent == ForStatement.EXPRESSION_PROPERTY || locationInParent == ForStatement.INITIALIZERS_PROPERTY || locationInParent == ForStatement.UPDATERS_PROPERTY) {
                    return (ForStatement)parent;
                }
                return null;
            }
            node = parent;
lbl10:
            // 2 sources

            ** while (node != null)
        }
lbl11:
        // 1 sources

        return null;
    }
}

