/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public abstract class AbstractJavaEditorTextHover
implements IJavaEditorTextHover,
ITextHoverExtension {
    private IEditorPart fEditor;
    private IBindingService fBindingService;
    static /* synthetic */ Class class$0;

    public AbstractJavaEditorTextHover() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz);
    }

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            if (input instanceof IClassFileEditorInput) {
                IClassFileEditorInput cfeInput = (IClassFileEditorInput)input;
                return cfeInput.getClassFile();
            }
            WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input, false);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord(textViewer.getDocument(), offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            try {
                IJavaElement[] result = null;
                ICodeAssist iCodeAssist = resolve;
                synchronized (iCodeAssist) {
                    result = resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
                }
                if (result == null) {
                    return null;
                }
                int nResults = result.length;
                if (nResults == 0) {
                    return null;
                }
                return this.getHoverInfo(result);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    protected String getHoverInfo(IJavaElement[] javaElements) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractJavaEditorTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    protected String getTooltipAffordanceString() {
        if (this.fBindingService == null || !JavaPlugin.getDefault().getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return null;
        }
        String keySequence = this.fBindingService.getBestActiveBindingFormattedFor("org.eclipse.jdt.ui.edit.text.java.show.javadoc");
        return Messages.format(JavaHoverMessages.JavaTextHover_makeStickyHint, keySequence == null ? "" : keySequence);
    }
}

