/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.template.contentassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.SurroundWith;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateContentAssistMessages;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;

public class SurroundWithTemplateProposal
extends TemplateProposal {
    private final IRegion fRegion;
    private final ICompilationUnit fCompilationUnit;
    private final CompilationUnitContext fContext;
    private final Template fTemplate;
    private final Statement[] fSelectedStatements;
    private TemplateProposal fProposal;
    private IRegion fSelectedRegion;

    public SurroundWithTemplateProposal(ICompilationUnit compilationUnit, Template template, CompilationUnitContext context, IRegion region, Image image, Statement[] selectedStatements) {
        super(template, (TemplateContext)context, region, image);
        this.fCompilationUnit = compilationUnit;
        this.fTemplate = template;
        this.fContext = context;
        this.fRegion = region;
        this.fSelectedStatements = selectedStatements;
    }

    public String getPreviewContent() {
        try {
            TemplateBuffer templateBuffer;
            Document document = new Document(this.fCompilationUnit.getBuffer().getContents());
            CompilationUnitContext context = this.createNewContext((IDocument)document);
            int offset = context.getCompletionOffset();
            int start = context.getStart();
            int end = context.getEnd();
            Region region = new Region(start, end - start);
            context.setReadOnly(false);
            try {
                templateBuffer = context.evaluate(this.fTemplate);
            }
            catch (TemplateException e1) {
                JavaPlugin.log(e1);
                return null;
            }
            start = region.getOffset();
            end = region.getOffset() + region.getLength();
            end = Math.max(end, offset);
            String templateString = templateBuffer.getString();
            document.replace(start, end - start, templateString);
            return document.get();
        }
        catch (MalformedTreeException e) {
            JavaPlugin.log(e);
        }
        catch (IllegalArgumentException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            IDocument document = viewer.getDocument();
            CompilationUnitContext context = this.createNewContext(document);
            int start = context.getStart();
            int end = context.getEnd();
            Region region = new Region(start, end - start);
            this.fProposal = new TemplateProposal(this.fTemplate, (TemplateContext)context, (IRegion)region, null);
            this.fProposal.apply(viewer, trigger, stateMask, context.getCompletionOffset());
        }
        catch (MalformedTreeException e) {
            this.handleException(viewer, (Exception)((Object)e), this.fRegion);
        }
        catch (IllegalArgumentException e) {
            this.handleException(viewer, e, this.fRegion);
        }
        catch (BadLocationException e) {
            this.handleException(viewer, (Exception)((Object)e), this.fRegion);
        }
        catch (CoreException e) {
            this.handleException(viewer, (Exception)((Object)e), this.fRegion);
        }
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion != null) {
            return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
        }
        if (this.fProposal != null) {
            return this.fProposal.getSelection(document);
        }
        return null;
    }

    private CompilationUnitContext createNewContext(IDocument document) throws CoreException, BadLocationException {
        AssistContext invocationContext = new AssistContext(this.fCompilationUnit, this.fContext.getStart(), this.fContext.getEnd() - this.fContext.getStart());
        SurroundWithTemplate surroundWith = new SurroundWithTemplate(invocationContext, this.fSelectedStatements, this.fTemplate);
        Map options = this.fCompilationUnit.getJavaProject().getOptions(true);
        MultiTextEdit allEdits = (MultiTextEdit)surroundWith.getRewrite().rewriteAST(document, options);
        this.removeBlockStartAndEnd(allEdits);
        MultiTextEdit blockFreeEdits = (MultiTextEdit)allEdits.copy();
        this.removeBlock(blockFreeEdits);
        String newSelection = this.calculateNewSelection(document, surroundWith.getNewBodyPosition(), allEdits);
        blockFreeEdits.apply(document);
        int replaceOffset = surroundWith.getNewBodyPosition().getStartPosition();
        int offset = document.getLineOffset(document.getLineOfOffset(replaceOffset));
        CompilationUnitContextType contextType = (CompilationUnitContextType)JavaPlugin.getDefault().getTemplateContextRegistry().getContextType("java");
        CompilationUnitContext context = contextType.createContext(document, offset, replaceOffset - offset, this.fCompilationUnit);
        context.setVariable("selection", newSelection);
        context.setForceEvaluation(true);
        return context;
    }

    private void removeBlockStartAndEnd(MultiTextEdit edits) {
        TextEdit[] children = edits.getChildren();
        int i = 0;
        while (!(children[i] instanceof RangeMarker)) {
            ++i;
        }
        edits.removeChild(++i);
        while (!(children[i] instanceof RangeMarker)) {
            ++i;
        }
        edits.removeChild(i - 2);
    }

    private void removeBlock(MultiTextEdit edits) {
        TextEdit[] children = edits.getChildren();
        int i = 0;
        while (!(children[i] instanceof RangeMarker)) {
            ++i;
        }
        int pos = ++i;
        while (!(children[i] instanceof RangeMarker)) {
            edits.removeChild(pos);
            ++i;
        }
    }

    private String calculateNewSelection(IDocument document, ITrackedNodePosition position, MultiTextEdit edits) throws BadLocationException {
        Document tmpDocument = new Document(String.copyValueOf(document.get().toCharArray()));
        edits.apply((IDocument)tmpDocument);
        return tmpDocument.get(position.getStartPosition(), position.getLength());
    }

    private void handleException(ITextViewer viewer, Exception e, IRegion region) {
        JavaPlugin.log(e);
        this.openErrorDialog(viewer.getTextWidget().getShell(), e);
        this.fSelectedRegion = region;
    }

    private void openErrorDialog(Shell shell, Exception e) {
        MessageDialog.openError((Shell)shell, (String)TemplateContentAssistMessages.TemplateEvaluator_error_title, (String)e.getMessage());
    }

    private static class SurroundWithTemplate
    extends SurroundWith {
        private static final String $_LINE_SELECTION = "${line_selection}";
        private final Template fTemplate;
        private final IJavaProject fCurrentProject;
        private ITrackedNodePosition fNewBodyPosition;
        private ITrackedNodePosition fInsertedTemplatePosition;
        private ASTNode fTemplateNode;
        static /* synthetic */ Class class$0;

        public SurroundWithTemplate(IInvocationContext context, Statement[] selectedNodes, Template template) {
            super(context.getASTRoot(), selectedNodes);
            this.fTemplate = template;
            this.fCurrentProject = context.getCompilationUnit().getJavaProject();
        }

        public ITrackedNodePosition getNewBodyPosition() {
            return this.fNewBodyPosition;
        }

        protected Statement generateCodeSkeleton(Block newBody, ASTRewrite rewrite) {
            this.fNewBodyPosition = rewrite.track((ASTNode)newBody);
            return newBody;
        }

        protected List getVariableDeclarationReadsInside(Statement[] selectedNodes, int maxVariableId) {
            if (this.isNewContext()) {
                return super.getVariableDeclarationReadsInside(selectedNodes, maxVariableId);
            }
            return new ArrayList();
        }

        private boolean isNewContext() {
            String template = this.fTemplate.getPattern();
            int currentPosition = template.indexOf($_LINE_SELECTION);
            int insertionPosition = -1;
            while (currentPosition != -1) {
                insertionPosition = currentPosition;
                template = template.replaceFirst("\\$\\{[^\\}]*\\}", "");
                currentPosition = template.indexOf($_LINE_SELECTION);
            }
            template = template.replaceAll("\\$\\{[^\\}]*\\}", "");
            AST ast = this.getAst();
            ASTParser parser = ASTParser.newParser((int)ast.apiLevel());
            parser.setSource(template.toCharArray());
            parser.setProject(this.fCurrentProject);
            parser.setKind(2);
            ASTNode root = parser.createAST(null);
            if (((Block)root).statements().isEmpty()) {
                parser = ASTParser.newParser((int)ast.apiLevel());
                parser.setSource(template.toCharArray());
                parser.setProject(this.fCurrentProject);
                parser.setKind(1);
                root = parser.createAST(null);
            }
            int lineSelectionPosition = insertionPosition;
            root.accept((ASTVisitor)new GenericVisitor(this, lineSelectionPosition){
                final /* synthetic */ SurroundWithTemplate this$1;
                private final /* synthetic */ int val$lineSelectionPosition;
                {
                    this.this$1 = surroundWithTemplate;
                    this.val$lineSelectionPosition = n;
                }

                public void endVisit(Block node) {
                    super.endVisit(node);
                    if (SurroundWithTemplate.access$0(this.this$1) == null && node.getStartPosition() <= this.val$lineSelectionPosition && node.getLength() + node.getStartPosition() >= this.val$lineSelectionPosition) {
                        SurroundWithTemplate.access$1(this.this$1, (ASTNode)node);
                    }
                }
            });
            if (this.fTemplateNode != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (ASTNodes.getParent(this.fTemplateNode, clazz) != null) {
                    return true;
                }
            }
            return false;
        }

        public ITrackedNodePosition getInsertedTemplatePosition() {
            return this.fInsertedTemplatePosition;
        }

        static /* synthetic */ ASTNode access$0(SurroundWithTemplate surroundWithTemplate) {
            return surroundWithTemplate.fTemplateNode;
        }

        static /* synthetic */ void access$1(SurroundWithTemplate surroundWithTemplate, ASTNode aSTNode) {
            surroundWithTemplate.fTemplateNode = aSTNode;
        }
    }
}

