/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.AddExternalArchivesOperation;
import org.eclipse.jdt.internal.corext.buildpath.AddLibraryOperation;
import org.eclipse.jdt.internal.corext.buildpath.AddSelectedLibraryOperation;
import org.eclipse.jdt.internal.corext.buildpath.AddSelectedSourceFolderOperation;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.EditFiltersOperation;
import org.eclipse.jdt.internal.corext.buildpath.EditOutputFolderOperation;
import org.eclipse.jdt.internal.corext.buildpath.ExcludeOperation;
import org.eclipse.jdt.internal.corext.buildpath.LinkedSourceFolderOperation;
import org.eclipse.jdt.internal.corext.buildpath.RemoveFromClasspathOperation;
import org.eclipse.jdt.internal.corext.buildpath.UnexcludeOperation;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.JarImportWizardAction;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AddSourceFolderWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.EditFilterWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildActionSelectionContext;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildPathAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ConfigureBuildPathAction;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.AbstractOpenWizardAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateBuildPathActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.jdt.ui.buildpath.menu";
    public static final String GROUP_BUILDPATH = "buildpathGroup";
    public static final String GROUP_FILTER = "filterGroup";
    public static final String GROUP_CUSTOMIZE = "customizeGroup";
    private Action fNoActionAvailable = new NoActionAvailable();
    private IWorkbenchSite fSite;
    private Action[] fActions;
    private String fGroupName = "group.reorganize";

    public GenerateBuildPathActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public GenerateBuildPathActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    private GenerateBuildPathActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        AddSourceFolderAction addSourceFolderAction = new AddSourceFolderAction();
        UpdateJarFileAction updateAction = new UpdateJarFileAction();
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.addSelectionChangedListener((ISelectionChangedListener)addSourceFolderAction);
        provider.addSelectionChangedListener((ISelectionChangedListener)updateAction);
        EditFilterAction editFilterAction = new EditFilterAction();
        provider.addSelectionChangedListener((ISelectionChangedListener)editFilterAction);
        AddLinkedSourceFolderAction addLinkedSourceFolderAction = new AddLinkedSourceFolderAction();
        provider.addSelectionChangedListener((ISelectionChangedListener)addLinkedSourceFolderAction);
        BuildActionSelectionContext context = new BuildActionSelectionContext();
        this.fActions = new Action[]{addLinkedSourceFolderAction, addSourceFolderAction, this.createBuildPathAction(this.fSite, 0, context), this.createBuildPathAction(this.fSite, 15, context), this.createBuildPathAction(this.fSite, 1, context), this.createBuildPathAction(this.fSite, 13, context), this.createBuildPathAction(this.fSite, 14, context), updateAction, this.createBuildPathAction(this.fSite, 2, context), this.createBuildPathAction(this.fSite, 3, context), editFilterAction, this.createBuildPathAction(this.fSite, 7, context), this.createConfigureAction(this.fSite)};
    }

    private Action createConfigureAction(IWorkbenchSite site) {
        ConfigureBuildPathAction action = new ConfigureBuildPathAction(site);
        action.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH);
        action.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH);
        action.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ConfigureBP_label);
        action.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ConfigureBP_tooltip);
        return action;
    }

    private BuildPathAction createBuildPathAction(IWorkbenchSite site, int type, BuildActionSelectionContext context) {
        ImageDescriptor imageDescriptor = null;
        ImageDescriptor disabledImageDescriptor = null;
        String text = null;
        String tooltip = null;
        ClasspathModifierOperation operation = null;
        BuildPathAction action = new BuildPathAction(site, context);
        switch (type) {
            case 5: {
                imageDescriptor = JavaPluginImages.DESC_ELCL_ADD_LINKED_SOURCE_TO_BUILDPATH;
                disabledImageDescriptor = JavaPluginImages.DESC_DLCL_ADD_LINKED_SOURCE_TO_BUILDPATH;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip;
                operation = new LinkedSourceFolderOperation(null, action);
                break;
            }
            case 0: {
                imageDescriptor = JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip;
                operation = new AddSelectedSourceFolderOperation(null, action);
                break;
            }
            case 15: {
                imageDescriptor = JavaPluginImages.DESC_OBJS_EXTJAR;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_tooltip;
                operation = new AddSelectedLibraryOperation(null, action);
                break;
            }
            case 1: {
                imageDescriptor = JavaPluginImages.DESC_ELCL_REMOVE_FROM_BP;
                disabledImageDescriptor = JavaPluginImages.DESC_DLCL_REMOVE_FROM_BP;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip;
                operation = new RemoveFromClasspathOperation(null, action);
                break;
            }
            case 2: {
                imageDescriptor = JavaPluginImages.DESC_ELCL_EXCLUDE_FROM_BUILDPATH;
                disabledImageDescriptor = JavaPluginImages.DESC_DLCL_EXCLUDE_FROM_BUILDPATH;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_tooltip;
                operation = new ExcludeOperation(null, action);
                break;
            }
            case 3: {
                imageDescriptor = JavaPluginImages.DESC_ELCL_INCLUDE_ON_BUILDPATH;
                disabledImageDescriptor = JavaPluginImages.DESC_DLCL_INCLUDE_ON_BUILDPATH;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Unexclude_tooltip;
                operation = new UnexcludeOperation(null, action);
                break;
            }
            case 4: {
                imageDescriptor = JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS;
                disabledImageDescriptor = JavaPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip;
                operation = new EditFiltersOperation(null, action);
                break;
            }
            case 7: {
                imageDescriptor = JavaPluginImages.DESC_ELCL_CONFIGURE_OUTPUT_FOLDER;
                disabledImageDescriptor = JavaPluginImages.DESC_DLCL_CONFIGURE_OUTPUT_FOLDER;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_tooltip;
                operation = new EditOutputFolderOperation(null, action);
                ((EditOutputFolderOperation)operation).showOutputFolders(true);
                break;
            }
            case 13: {
                imageDescriptor = JavaPluginImages.DESC_OBJS_EXTJAR;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddJarCP_tooltip;
                operation = new AddExternalArchivesOperation(null, action);
                break;
            }
            case 14: {
                imageDescriptor = JavaPluginImages.DESC_OBJS_LIBRARY;
                text = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_label;
                tooltip = NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_tooltip;
                operation = new AddLibraryOperation(null, action);
                break;
            }
        }
        action.initialize(operation, imageDescriptor, disabledImageDescriptor, text, tooltip);
        return action;
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.canOperateOnSelection()) {
            return;
        }
        String menuText = ActionMessages.BuildPath_label;
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GenerateBuildPathActionGroup.this.fillViewSubMenu(manager);
            }
        });
        subMenu.setRemoveAllWhenShown(true);
        subMenu.add((IAction)this.createConfigureAction(this.fSite));
        menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
    }

    private void fillViewSubMenu(IMenuManager source) {
        int added = 0;
        Action[] actions = this.fActions;
        int i = 0;
        while (i < actions.length) {
            if (actions[i] instanceof IUpdate) {
                ((IUpdate)actions[i]).update();
            }
            ++i;
        }
        i = 0;
        while (i < actions.length) {
            if (i == 2) {
                source.add((IContributionItem)new Separator(GROUP_BUILDPATH));
            } else if (i == 8) {
                source.add((IContributionItem)new Separator(GROUP_FILTER));
            } else if (i == 10) {
                source.add((IContributionItem)new Separator(GROUP_CUSTOMIZE));
            }
            added += this.addAction(source, (IAction)actions[i]);
            ++i;
        }
        if (added == 0) {
            source.add((IAction)this.fNoActionAvailable);
        }
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean canOperateOnSelection() {
        ISelection sel = this.fSite.getSelectionProvider().getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IWorkingSet)) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.fActions != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            int index = 0;
            while (index < this.fActions.length) {
                Action action = this.fActions[index];
                if (action instanceof ISelectionChangedListener) {
                    provider.removeSelectionChangedListener((ISelectionChangedListener)action);
                }
                ++index;
            }
        }
        this.fActions = null;
        super.dispose();
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(true);
            this.setText(NewWizardMessages.GenerateBuildPathActionGroup_no_action_available);
        }
    }

    private static abstract class OpenBuildPathWizardAction
    extends AbstractOpenWizardAction
    implements ISelectionChangedListener {
        OpenBuildPathWizardAction() {
        }

        protected IPath getOutputLocation(IJavaProject javaProject) {
            try {
                return javaProject.getOutputLocation();
            }
            catch (CoreException coreException) {
                IProject project = javaProject.getProject();
                IPath projPath = project.getFullPath();
                return projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.setEnabled(this.selectionChanged((IStructuredSelection)selection));
            } else {
                this.setEnabled(this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY));
            }
        }

        public abstract boolean selectionChanged(IStructuredSelection var1);
    }

    public static class AddSourceFolderAction
    extends OpenBuildPathWizardAction {
        private AddSourceFolderWizard fAddSourceFolderWizard;
        private IJavaProject fSelectedProject;

        public AddSourceFolderAction() {
            this.setText(ActionMessages.OpenNewSourceFolderWizardAction_text2);
            this.setDescription(ActionMessages.OpenNewSourceFolderWizardAction_description);
            this.setToolTipText(ActionMessages.OpenNewSourceFolderWizardAction_tooltip);
            this.setImageDescriptor(JavaPluginImages.DESC_TOOL_NEWPACKROOT);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_sourcefolder_wizard_action");
        }

        protected Wizard createWizard() throws CoreException {
            CPListElement newEntrie = new CPListElement(this.fSelectedProject, 3);
            this.fAddSourceFolderWizard = new AddSourceFolderWizard(CPListElement.createFromExisting(this.fSelectedProject), newEntrie, this.getOutputLocation(this.fSelectedProject), false);
            return this.fAddSourceFolderWizard;
        }

        public boolean selectionChanged(IStructuredSelection selection) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof IJavaProject) {
                this.fSelectedProject = (IJavaProject)selection.getFirstElement();
                return true;
            }
            return false;
        }

        public List getCPListElements() {
            return this.fAddSourceFolderWizard.getExistingEntries();
        }
    }

    public static class AddLinkedSourceFolderAction
    extends OpenBuildPathWizardAction {
        private AddSourceFolderWizard fAddSourceFolderWizard;
        private IJavaProject fSelectedProject;

        public AddLinkedSourceFolderAction() {
            this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_label);
            this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip);
            this.setImageDescriptor(JavaPluginImages.DESC_ELCL_ADD_LINKED_SOURCE_TO_BUILDPATH);
            this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_createLinkedFolder);
        }

        protected Wizard createWizard() throws CoreException {
            CPListElement newEntrie = new CPListElement(this.fSelectedProject, 3);
            this.fAddSourceFolderWizard = new AddSourceFolderWizard(CPListElement.createFromExisting(this.fSelectedProject), newEntrie, this.getOutputLocation(this.fSelectedProject), true);
            return this.fAddSourceFolderWizard;
        }

        public boolean selectionChanged(IStructuredSelection selection) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof IJavaProject) {
                this.fSelectedProject = (IJavaProject)selection.getFirstElement();
                return true;
            }
            return false;
        }

        public List getCPListElements() {
            return this.fAddSourceFolderWizard.getExistingEntries();
        }
    }

    public static class EditFilterAction
    extends OpenBuildPathWizardAction {
        private IJavaProject fSelectedProject;
        private IJavaElement fSelectedElement;
        private EditFilterWizard fEditFilterWizard;

        public EditFilterAction() {
            this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label);
            this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_Edit);
            this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip);
            this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS);
            this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS);
        }

        protected Wizard createWizard() throws CoreException {
            CPListElement[] existingEntries = CPListElement.createFromExisting(this.fSelectedProject);
            CPListElement elementToEdit = EditFilterAction.findElement(this.fSelectedElement, existingEntries);
            this.fEditFilterWizard = new EditFilterWizard(existingEntries, elementToEdit, this.getOutputLocation(this.fSelectedProject));
            return this.fEditFilterWizard;
        }

        public boolean selectionChanged(IStructuredSelection selection) {
            if (selection.size() != 1) {
                return false;
            }
            try {
                Object element = selection.getFirstElement();
                if (element instanceof IJavaProject) {
                    IJavaProject project = (IJavaProject)element;
                    if (ClasspathModifier.isSourceFolder(project)) {
                        this.fSelectedProject = project;
                        this.fSelectedElement = (IJavaElement)element;
                        return true;
                    }
                } else if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                    IJavaProject project = packageFragmentRoot.getJavaProject();
                    if (packageFragmentRoot.getKind() == 1 && project != null) {
                        this.fSelectedProject = project;
                        this.fSelectedElement = (IJavaElement)element;
                        return true;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            return false;
        }

        private static CPListElement findElement(IJavaElement element, CPListElement[] elements) {
            IPath path = element.getPath();
            int i = 0;
            while (i < elements.length) {
                CPListElement cur = elements[i];
                if (cur.getEntryKind() == 3 && cur.getPath().equals((Object)path)) {
                    return cur;
                }
                ++i;
            }
            return null;
        }

        public List getCPListElements() {
            return this.fEditFilterWizard.getExistingEntries();
        }
    }

    private class UpdateJarFileAction
    extends JarImportWizardAction
    implements IUpdate {
        public UpdateJarFileAction() {
            this.setText(ActionMessages.GenerateBuildPathActionGroup_update_jar_text);
            this.setDescription(ActionMessages.GenerateBuildPathActionGroup_update_jar_description);
            this.setToolTipText(ActionMessages.GenerateBuildPathActionGroup_update_jar_tooltip);
            this.setImageDescriptor(JavaPluginImages.DESC_OBJS_JAR);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.jar_import_wizard_page_context");
        }

        public void update() {
            IWorkbenchPart part = GenerateBuildPathActionGroup.this.fSite.getPage().getActivePart();
            if (part != null) {
                this.setActivePart((IAction)this, part);
            }
            this.selectionChanged((IAction)this, GenerateBuildPathActionGroup.this.fSite.getSelectionProvider().getSelection());
        }
    }
}

