/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetFilter
extends ViewerFilter {
    private IWorkingSet fWorkingSet = null;
    private IAdaptable[] fCachedWorkingSet = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.fWorkingSet = workingSet;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fWorkingSet == null || this.fWorkingSet.isAggregateWorkingSet() && this.fWorkingSet.getElements().length == 0) {
            return true;
        }
        if (element instanceof IJavaElement) {
            return this.isEnclosing((IJavaElement)element);
        }
        if (element instanceof IResource) {
            return this.isEnclosing(((IResource)element).getFullPath());
        }
        if (element instanceof ClassPathContainer) {
            return this.isEnclosing((ClassPathContainer)element);
        }
        if (element instanceof IAdaptable) {
            IResource resource;
            IJavaElement je;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((je = (IJavaElement)adaptable.getAdapter((Class)clazz)) != null) {
                return this.isEnclosing(je);
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)adaptable.getAdapter((Class)clazz2)) != null) {
                return this.isEnclosing(resource.getFullPath());
            }
        }
        return true;
    }

    private boolean isEnclosing(ClassPathContainer container) {
        Object[] roots = container.getPackageFragmentRoots();
        if (roots.length > 0) {
            return this.isEnclosing((IJavaElement)((IPackageFragmentRoot)roots[0]));
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        Object[] result = null;
        if (this.fWorkingSet != null) {
            this.fCachedWorkingSet = this.fWorkingSet.getElements();
        }
        try {
            result = super.filter(viewer, parent, elements);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fCachedWorkingSet = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.fCachedWorkingSet = null;
            return result;
        }
    }

    private boolean isEnclosing(IPath elementPath) {
        if (elementPath == null) {
            return false;
        }
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        int length = cachedWorkingSet.length;
        int i = 0;
        while (i < length) {
            if (this.isEnclosing(cachedWorkingSet[i], elementPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEnclosing(IJavaElement element) {
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.fWorkingSet.getElements();
        }
        boolean isElementPathComputed = false;
        IPath elementPath = null;
        int length = cachedWorkingSet.length;
        int i = 0;
        while (i < length) {
            IJavaElement scopeElement;
            IAdaptable iAdaptable = cachedWorkingSet[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((scopeElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                IJavaElement searchedElement = element;
                while (scopeElement != null && searchedElement != null) {
                    IPackageFragmentRoot pkgRoot;
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    if (scopeElement.getElementType() == 2 && searchedElement.getElementType() == 3 && (pkgRoot = (IPackageFragmentRoot)searchedElement).isExternal() && pkgRoot.isArchive() && ((IJavaProject)scopeElement).isOnClasspath(searchedElement)) {
                        return true;
                    }
                    if ((searchedElement = searchedElement.getParent()) == null || searchedElement.getElementType() != 5) continue;
                    ICompilationUnit cu = (ICompilationUnit)searchedElement;
                    cu = JavaModelUtil.toOriginal(cu);
                }
                while (scopeElement != null && element != null) {
                    if (element.equals(scopeElement)) {
                        return true;
                    }
                    scopeElement = scopeElement.getParent();
                }
            } else {
                if (!isElementPathComputed) {
                    IResource elementResource;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((elementResource = (IResource)element.getAdapter((Class)clazz2)) != null) {
                        elementPath = elementResource.getFullPath();
                    }
                }
                if (this.isEnclosing(cachedWorkingSet[i], elementPath)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isEnclosing(IAdaptable element, IPath path) {
        IResource elementResource;
        if (path == null) {
            return false;
        }
        IPath elementPath = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((elementResource = (IResource)element.getAdapter((Class)clazz)) != null) {
            elementPath = elementResource.getFullPath();
        }
        if (elementPath == null) {
            IJavaElement javaElement;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((javaElement = (IJavaElement)element.getAdapter((Class)clazz2)) != null) {
                elementPath = javaElement.getPath();
            }
        }
        if (elementPath == null && element instanceof IStorage) {
            elementPath = ((IStorage)element).getFullPath();
        }
        if (elementPath == null) {
            return false;
        }
        if (elementPath.isPrefixOf(path)) {
            return true;
        }
        return path.isPrefixOf(elementPath);
    }
}

