/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

class ImplicitJobs {
    private ThreadJob jobCache = null;
    protected JobManager manager;
    private final Set suspendedRules = new HashSet(20);
    private final Map threadJobs = new HashMap(20);

    ImplicitJobs(JobManager manager) {
        this.manager = manager;
    }

    /*
     * Exception decompiling
     */
    void begin(ISchedulingRule rule, IProgressMonitor monitor, boolean suspend) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 301->305)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized void end(ISchedulingRule rule, boolean resume) {
        ThreadJob threadJob;
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("End rule: " + rule);
        }
        if ((threadJob = (ThreadJob)this.threadJobs.get(Thread.currentThread())) == null) {
            Assert.isLegal((rule == null ? 1 : 0) != 0, (String)("endRule without matching beginRule: " + rule));
        } else if (threadJob.pop(rule)) {
            this.endThreadJob(threadJob, resume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endJob(InternalJob lastJob) {
        Status error;
        Thread currentThread = Thread.currentThread();
        ImplicitJobs implicitJobs = this;
        synchronized (implicitJobs) {
            ThreadJob threadJob = (ThreadJob)this.threadJobs.get(currentThread);
            if (threadJob == null) {
                return;
            }
            String msg = "Worker thread ended job: " + lastJob + ", but still holds rule: " + threadJob;
            error = new Status(4, "org.eclipse.core.jobs", 1, msg, null);
            this.endThreadJob(threadJob, false);
        }
        try {
            RuntimeLog.log((IStatus)error);
        }
        catch (RuntimeException runtimeException) {
            System.err.println(error.getMessage());
        }
    }

    private void endThreadJob(ThreadJob threadJob, boolean resume) {
        Thread currentThread = Thread.currentThread();
        this.threadJobs.remove(currentThread);
        ISchedulingRule rule = threadJob.getRule();
        if (resume && rule != null) {
            this.suspendedRules.remove(rule);
        }
        if (threadJob.acquireRule) {
            this.manager.getLockManager().removeLockThread(currentThread, rule);
        }
        if (threadJob.isRunning()) {
            this.manager.endJob(threadJob, Status.OK_STATUS, false);
        }
        this.recycle(threadJob);
    }

    private boolean isSuspended(ISchedulingRule rule) {
        if (this.suspendedRules.size() == 0) {
            return false;
        }
        Iterator it = this.suspendedRules.iterator();
        while (it.hasNext()) {
            if (!((ISchedulingRule)it.next()).contains(rule)) continue;
            return true;
        }
        return false;
    }

    private ThreadJob newThreadJob(ISchedulingRule rule) {
        if (this.jobCache != null) {
            ThreadJob job = this.jobCache;
            job.setRule(rule);
            job.isRunning = false;
            job.acquireRule = false;
            job.realJob = null;
            this.jobCache = null;
            return job;
        }
        return new ThreadJob(this.manager, rule);
    }

    private void recycle(ThreadJob job) {
        if (this.jobCache == null && job.recycle()) {
            this.jobCache = job;
        }
    }

    void resume(ISchedulingRule rule) {
        this.end(rule, true);
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Resume rule: " + rule);
        }
    }

    void suspend(ISchedulingRule rule, IProgressMonitor monitor) {
        if (JobManager.DEBUG_BEGIN_END) {
            JobManager.debug("Suspend rule: " + rule);
        }
        this.begin(rule, monitor, true);
    }

    synchronized void transfer(ISchedulingRule rule, Thread destinationThread) {
        if (rule == null) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        if (currentThread == destinationThread) {
            return;
        }
        ThreadJob job = (ThreadJob)this.threadJobs.get(destinationThread);
        Assert.isLegal((job == null ? 1 : 0) != 0);
        job = (ThreadJob)this.threadJobs.get(currentThread);
        Assert.isLegal((job != null ? 1 : 0) != 0);
        Assert.isLegal((job.getRule() == rule ? 1 : 0) != 0);
        job.setThread(destinationThread);
        this.threadJobs.remove(currentThread);
        this.threadJobs.put(destinationThread, job);
        if (job.acquireRule) {
            this.manager.getLockManager().removeLockThread(currentThread, rule);
            this.manager.getLockManager().addLockThread(destinationThread, rule);
        }
    }
}

