/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.NavigatorContentServiceContentProvider;
import org.eclipse.ui.internal.navigator.NavigatorContentServiceDescriptionProvider;
import org.eclipse.ui.internal.navigator.NavigatorContentServiceLabelProvider;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.ExtensionPriorityComparator;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptorManager;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.internal.navigator.extensions.NavigatorViewerDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorViewerDescriptorRegistry;
import org.eclipse.ui.internal.navigator.extensions.StructuredViewerManager;
import org.eclipse.ui.internal.navigator.sorters.NavigatorSorterService;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.eclipse.ui.navigator.IExtensionActivationListener;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorContentServiceListener;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.eclipse.ui.navigator.INavigatorSorterService;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;
import org.eclipse.ui.navigator.NavigatorActivationService;

public class NavigatorContentService
implements IExtensionActivationListener,
IMementoAware,
INavigatorContentService {
    private static final NavigatorContentDescriptorManager CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorManager.getInstance();
    private static final NavigatorViewerDescriptorRegistry VIEWER_DESCRIPTOR_REGISTRY = NavigatorViewerDescriptorRegistry.getInstance();
    private static final ITreeContentProvider[] NO_CONTENT_PROVIDERS = new ITreeContentProvider[0];
    private static final ILabelProvider[] NO_LABEL_PROVIDERS = new ILabelProvider[0];
    private static final INavigatorContentDescriptor[] NO_DESCRIPTORS = new INavigatorContentDescriptor[0];
    private static final String[] NO_EXTENSION_IDS = new String[0];
    private final NavigatorViewerDescriptor viewerDescriptor;
    private final List listeners = new ArrayList();
    private final Map contentExtensions = new HashMap();
    private StructuredViewerManager structuredViewerManager;
    private ITreeContentProvider[] rootContentProviders;
    private WeakHashMap contributionMemory;
    private ITreeContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private final VisibilityAssistant assistant;
    private NavigatorFilterService navigatorFilterService;
    private INavigatorSorterService navigatorSorterService;
    private IDescriptionProvider descriptionProvider;

    public NavigatorContentService(String aViewerId) {
        aViewerId = aViewerId != null ? aViewerId : "";
        this.viewerDescriptor = VIEWER_DESCRIPTOR_REGISTRY.getNavigatorViewerDescriptor(aViewerId);
        this.assistant = new VisibilityAssistant(this.viewerDescriptor);
        NavigatorActivationService.getInstance().addExtensionActivationListener(this.viewerDescriptor.getViewerId(), this);
    }

    public NavigatorContentService(String aViewerId, StructuredViewer aViewer) {
        this(aViewerId);
        this.structuredViewerManager = new StructuredViewerManager((Viewer)aViewer);
    }

    public String[] getVisibleExtensionIds() {
        ArrayList<String> visibleExtensionIds = new ArrayList<String>();
        NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (this.assistant.isVisible(descriptors[i].getId())) {
                visibleExtensionIds.add(descriptors[i].getId());
            }
            ++i;
        }
        if (visibleExtensionIds.isEmpty()) {
            return NO_EXTENSION_IDS;
        }
        return visibleExtensionIds.toArray(new String[visibleExtensionIds.size()]);
    }

    public INavigatorContentDescriptor[] getVisibleExtensions() {
        ArrayList<NavigatorContentDescriptor> visibleDescriptors = new ArrayList<NavigatorContentDescriptor>();
        NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (this.assistant.isVisible(descriptors[i].getId())) {
                visibleDescriptors.add(descriptors[i]);
            }
            ++i;
        }
        if (visibleDescriptors.isEmpty()) {
            return NO_DESCRIPTORS;
        }
        return visibleDescriptors.toArray(new INavigatorContentDescriptor[visibleDescriptors.size()]);
    }

    public INavigatorContentDescriptor[] bindExtensions(String[] extensionIds, boolean isRoot) {
        if (extensionIds == null || extensionIds.length == 0) {
            return NO_DESCRIPTORS;
        }
        int i = 0;
        while (i < extensionIds.length) {
            this.assistant.bindExtensions(extensionIds, isRoot);
            ++i;
        }
        HashSet<NavigatorContentDescriptor> boundDescriptors = new HashSet<NavigatorContentDescriptor>();
        int i2 = 0;
        while (i2 < extensionIds.length) {
            NavigatorContentDescriptor descriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(extensionIds[i2]);
            if (descriptor != null) {
                boundDescriptors.add(descriptor);
            }
            ++i2;
        }
        if (boundDescriptors.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return boundDescriptors.toArray(new INavigatorContentDescriptor[boundDescriptors.size()]);
    }

    public INavigatorContentDescriptor[] activateExtensions(String[] extensionIds, boolean toDeactivateAllOthers) {
        HashSet<NavigatorContentDescriptor> activatedDescriptors = new HashSet<NavigatorContentDescriptor>();
        String viewerId = this.viewerDescriptor.getViewerId();
        NavigatorActivationService.getInstance().activateNavigatorExtension(viewerId, extensionIds, true);
        int extId = 0;
        while (extId < extensionIds.length) {
            activatedDescriptors.add(CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(extensionIds[extId]));
            ++extId;
        }
        if (toDeactivateAllOthers) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            ArrayList<NavigatorContentDescriptor> descriptorList = new ArrayList<NavigatorContentDescriptor>(Arrays.asList(descriptors));
            int descriptorIndx = 0;
            while (descriptorIndx < descriptors.length) {
                int extId2 = 0;
                while (extId2 < extensionIds.length) {
                    if (descriptors[descriptorIndx].getId().equals(extensionIds[extId2])) {
                        descriptorList.remove(descriptors[descriptorIndx]);
                    }
                    ++extId2;
                }
                ++descriptorIndx;
            }
            String[] deactivatedExtensions = new String[descriptorList.size()];
            int i = 0;
            while (i < descriptorList.size()) {
                INavigatorContentDescriptor descriptor = (INavigatorContentDescriptor)descriptorList.get(i);
                deactivatedExtensions[i] = descriptor.getId();
                ++i;
            }
            NavigatorActivationService.getInstance().activateNavigatorExtension(viewerId, deactivatedExtensions, false);
        }
        if (activatedDescriptors.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return activatedDescriptors.toArray(new NavigatorContentDescriptor[activatedDescriptors.size()]);
    }

    public INavigatorContentDescriptor[] deactivateExtensions(String[] extensionIds, boolean toEnableAllOthers) {
        HashSet<NavigatorContentDescriptor> activatedDescriptors = new HashSet<NavigatorContentDescriptor>();
        String viewerId = this.viewerDescriptor.getViewerId();
        NavigatorActivationService.getInstance().activateNavigatorExtension(viewerId, extensionIds, false);
        if (toEnableAllOthers) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            ArrayList<NavigatorContentDescriptor> descriptorList = new ArrayList<NavigatorContentDescriptor>(Arrays.asList(descriptors));
            int descriptorIndx = 0;
            while (descriptorIndx < descriptors.length) {
                int extId = 0;
                while (extId < extensionIds.length) {
                    if (descriptors[descriptorIndx].getId().equals(extensionIds[extId])) {
                        descriptorList.remove(descriptors[descriptorIndx]);
                    }
                    ++extId;
                }
                ++descriptorIndx;
            }
            String[] activatedExtensions = new String[descriptorList.size()];
            int i = 0;
            while (i < descriptorList.size()) {
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)descriptorList.get(i);
                activatedExtensions[i] = descriptor.getId();
                activatedDescriptors.add(descriptor);
                ++i;
            }
            NavigatorActivationService.getInstance().activateNavigatorExtension(viewerId, activatedExtensions, true);
        }
        if (activatedDescriptors.size() == 0) {
            return NO_DESCRIPTORS;
        }
        return activatedDescriptors.toArray(new NavigatorContentDescriptor[activatedDescriptors.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITreeContentProvider createCommonContentProvider() {
        if (this.contentProvider != null) {
            return this.contentProvider;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.contentProvider == null) {
                this.contentProvider = new NavigatorContentServiceContentProvider(this);
            }
        }
        return this.contentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILabelProvider createCommonLabelProvider() {
        if (this.labelProvider != null) {
            return this.labelProvider;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.labelProvider == null) {
                this.labelProvider = new NavigatorContentServiceLabelProvider(this);
            }
        }
        return this.labelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDescriptionProvider createCommonDescriptionProvider() {
        if (this.descriptionProvider != null) {
            return this.descriptionProvider;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.descriptionProvider == null) {
                this.descriptionProvider = new NavigatorContentServiceDescriptionProvider(this);
            }
        }
        return this.descriptionProvider;
    }

    public void dispose() {
        Iterator contentItr = this.contentExtensions.values().iterator();
        while (contentItr.hasNext()) {
            ((NavigatorContentExtension)contentItr.next()).dispose();
        }
        NavigatorActivationService.getInstance().removeExtensionActivationListener(this.viewerDescriptor.getViewerId(), this);
        this.assistant.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateService(Viewer aViewer, Object anOldInput, Object aNewInput) {
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.structuredViewerManager == null) {
                this.structuredViewerManager = new StructuredViewerManager(aViewer);
                this.structuredViewerManager.inputChanged(anOldInput, aNewInput);
            } else {
                this.structuredViewerManager.inputChanged(aViewer, anOldInput, aNewInput);
            }
            Iterator contentItr = this.contentExtensions.values().iterator();
            while (contentItr.hasNext()) {
                this.structuredViewerManager.initialize((IStructuredContentProvider)((NavigatorContentExtension)contentItr.next()).getContentProvider());
            }
            this.rootContentProviders = this.extractContentProviders(this.findRootContentExtensions(aNewInput));
        }
    }

    public Set findEnabledContentDescriptors(Object anElement) {
        return this.findDescriptorsByTriggerPoint(anElement);
    }

    public IExtensionStateModel findStateModel(String anExtensionId) {
        return this.getExtension(CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor(anExtensionId)).getStateModel();
    }

    public ITreeContentProvider[] findParentContentProviders(Object anElement) {
        return this.extractContentProviders(this.findContentExtensionsByTriggerPoint(anElement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITreeContentProvider[] findRootContentProviders(Object anElement) {
        if (this.rootContentProviders != null) {
            return this.rootContentProviders;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.rootContentProviders == null) {
                this.rootContentProviders = this.extractContentProviders(this.findRootContentExtensions(anElement));
            }
        }
        return this.rootContentProviders;
    }

    public ITreeContentProvider[] findRelevantContentProviders(Object anElement) {
        return this.extractContentProviders(this.findContentExtensionsByTriggerPoint(anElement));
    }

    public ILabelProvider[] findRelevantLabelProviders(Object anElement) {
        return this.extractLabelProviders(this.findContentExtensionsWithPossibleChild(anElement, false));
    }

    public Set findContentExtensionsByTriggerPoint(Object anElement) {
        return this.findContentExtensionsByTriggerPoint(anElement, true);
    }

    public Set findContentExtensionsByTriggerPoint(Object anElement, boolean toLoadIfNecessary) {
        Set enabledDescriptors = this.findDescriptorsByTriggerPoint(anElement);
        return this.extractDescriptorInstances(enabledDescriptors, toLoadIfNecessary);
    }

    public Set findContentExtensionsWithPossibleChild(Object anElement) {
        return this.findContentExtensionsWithPossibleChild(anElement, true);
    }

    public Set findContentExtensionsWithPossibleChild(Object anElement, boolean toLoadIfNecessary) {
        Set enabledDescriptors = this.findDescriptorsWithPossibleChild(anElement);
        return this.extractDescriptorInstances(enabledDescriptors, toLoadIfNecessary);
    }

    public synchronized void rememberContribution(NavigatorContentDescriptor source, Object[] elements) {
        if (source != null && elements != null) {
            int i = 0;
            while (i < elements.length) {
                this.getContributionMemory().put(elements[i], source);
                ++i;
            }
        }
    }

    public synchronized void rememberContribution(NavigatorContentDescriptor source, Object element) {
        if (source != null && element != null) {
            this.getContributionMemory().put(element, source);
        }
    }

    public NavigatorContentDescriptor getSourceOfContribution(Object element) {
        return (NavigatorContentDescriptor)this.getContributionMemory().get(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getContributionMemory() {
        if (this.contributionMemory != null) {
            return this.contributionMemory;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            if (this.contributionMemory == null) {
                this.contributionMemory = new WeakHashMap();
            }
        }
        return this.contributionMemory;
    }

    public Set findDescriptorsByTriggerPoint(Object anElement) {
        NavigatorContentDescriptor descriptor = this.getSourceOfContribution(anElement);
        HashSet<NavigatorContentDescriptor> result = new HashSet<NavigatorContentDescriptor>();
        if (descriptor != null) {
            result.add(descriptor);
        }
        result.addAll(CONTENT_DESCRIPTOR_REGISTRY.findDescriptorsForTriggerPoint(anElement, this.assistant));
        return result;
    }

    public Set findDescriptorsWithPossibleChild(Object anElement) {
        NavigatorContentDescriptor descriptor = this.getSourceOfContribution(anElement);
        HashSet<NavigatorContentDescriptor> result = new HashSet<NavigatorContentDescriptor>();
        if (descriptor != null) {
            result.add(descriptor);
        }
        result.addAll(CONTENT_DESCRIPTOR_REGISTRY.findDescriptorsForPossibleChild(anElement, this.assistant));
        return result;
    }

    public void onExtensionActivation(String aViewerId, String[] aNavigatorExtensionId, boolean toEnable) {
        this.update();
    }

    public void update() {
        this.rootContentProviders = null;
        if (this.structuredViewerManager != null) {
            this.structuredViewerManager.safeRefresh();
        }
    }

    public final String getViewerId() {
        return this.viewerDescriptor.getViewerId();
    }

    public final NavigatorContentExtension getExtension(INavigatorContentDescriptor aDescriptorKey) {
        return this.getExtension(aDescriptorKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NavigatorContentExtension getExtension(INavigatorContentDescriptor aDescriptorKey, boolean toLoadIfNecessary) {
        NavigatorContentExtension extension = (NavigatorContentExtension)this.contentExtensions.get(aDescriptorKey);
        if (extension != null || !toLoadIfNecessary) {
            return extension;
        }
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            extension = (NavigatorContentExtension)this.contentExtensions.get(aDescriptorKey);
            if (extension == null) {
                extension = new NavigatorContentExtension((NavigatorContentDescriptor)aDescriptorKey, this, this.structuredViewerManager);
                this.contentExtensions.put(aDescriptorKey, extension);
                this.notifyListeners(extension);
            }
        }
        return extension;
    }

    public INavigatorViewerDescriptor getViewerDescriptor() {
        return this.viewerDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(final IMemento aMemento) {
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            Iterator extensionItr = this.getExtensions().iterator();
            while (extensionItr.hasNext()) {
                final NavigatorContentExtension element = (NavigatorContentExtension)extensionItr.next();
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void run() throws Exception {
                        element.restoreState(aMemento);
                    }

                    public void handleException(Throwable exception) {
                        NavigatorPlugin.logError(0, "Could not restore state for Common Navigator content extension" + element.getId(), exception);
                    }
                };
                Platform.run((ISafeRunnable)runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IMemento aMemento) {
        NavigatorContentService navigatorContentService = this;
        synchronized (navigatorContentService) {
            Iterator extensionItr = this.getExtensions().iterator();
            while (extensionItr.hasNext()) {
                NavigatorContentExtension element = (NavigatorContentExtension)extensionItr.next();
                element.saveState(aMemento);
            }
        }
    }

    protected final Set findRootContentExtensions(Object anElement) {
        return this.findRootContentExtensions(anElement, true);
    }

    protected final Set findRootContentExtensions(Object anElement, boolean toRespectViewerRoots) {
        TreeSet<NavigatorContentExtension> rootExtensions = new TreeSet<NavigatorContentExtension>(ExtensionPriorityComparator.INSTANCE);
        if (toRespectViewerRoots && this.viewerDescriptor.hasOverriddenRootExtensions()) {
            NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
            NavigatorContentExtension extension = null;
            int i = 0;
            while (i < descriptors.length) {
                if (this.isActive(descriptors[i].getId()) && this.isRootExtension(descriptors[i].getId()) && !(extension = this.getExtension(descriptors[i])).hasLoadingFailed()) {
                    rootExtensions.add(extension);
                }
                ++i;
            }
        }
        if (rootExtensions.isEmpty()) {
            return this.findContentExtensionsByTriggerPoint(anElement);
        }
        return rootExtensions;
    }

    public boolean isActive(String anExtensionId) {
        return this.assistant.isActive(anExtensionId);
    }

    public boolean isVisible(String anExtensionId) {
        return this.assistant.isVisible(anExtensionId);
    }

    protected final Collection getExtensions() {
        return this.contentExtensions.size() > 0 ? Collections.unmodifiableCollection(this.contentExtensions.values()) : Collections.EMPTY_LIST;
    }

    public void addListener(INavigatorContentServiceListener aListener) {
        this.listeners.add(aListener);
    }

    public INavigatorFilterService getFilterService() {
        if (this.navigatorFilterService == null) {
            this.navigatorFilterService = new NavigatorFilterService(this);
        }
        return this.navigatorFilterService;
    }

    public INavigatorSorterService getSorterService() {
        if (this.navigatorSorterService == null) {
            this.navigatorSorterService = new NavigatorSorterService(this);
        }
        return this.navigatorSorterService;
    }

    protected boolean isRootExtension(String anExtensionId) {
        return this.assistant.isRootExtension(anExtensionId);
    }

    public void removeListener(INavigatorContentServiceListener aListener) {
        this.listeners.remove(aListener);
    }

    private void notifyListeners(NavigatorContentExtension aDescriptorInstance) {
        if (this.listeners.size() == 0) {
            return;
        }
        INavigatorContentServiceListener listener = null;
        ArrayList<INavigatorContentServiceListener> failedListeners = null;
        Iterator listenersItr = this.listeners.iterator();
        while (listenersItr.hasNext()) {
            try {
                listener = (INavigatorContentServiceListener)listenersItr.next();
                listener.onLoad(aDescriptorInstance);
            }
            catch (RuntimeException runtimeException) {
                if (failedListeners == null) {
                    failedListeners = new ArrayList<INavigatorContentServiceListener>();
                }
                failedListeners.add(listener);
            }
        }
        if (failedListeners != null) {
            this.listeners.removeAll(failedListeners);
        }
    }

    private ITreeContentProvider[] extractContentProviders(Set theDescriptorInstances) {
        if (theDescriptorInstances.size() == 0) {
            return NO_CONTENT_PROVIDERS;
        }
        ArrayList<ITreeContentProvider> resultProvidersList = new ArrayList<ITreeContentProvider>();
        Iterator itr = theDescriptorInstances.iterator();
        while (itr.hasNext()) {
            resultProvidersList.add(((NavigatorContentExtension)itr.next()).getContentProvider());
        }
        return resultProvidersList.toArray(new ITreeContentProvider[resultProvidersList.size()]);
    }

    private Set extractDescriptorInstances(Set theDescriptors, boolean toLoadAllIfNecessary) {
        if (theDescriptors.size() == 0) {
            return Collections.EMPTY_SET;
        }
        TreeSet<NavigatorContentExtension> resultInstances = new TreeSet<NavigatorContentExtension>(ExtensionPriorityComparator.INSTANCE);
        Iterator descriptorIter = theDescriptors.iterator();
        while (descriptorIter.hasNext()) {
            NavigatorContentExtension extension = this.getExtension((NavigatorContentDescriptor)descriptorIter.next(), toLoadAllIfNecessary);
            if (extension == null) continue;
            resultInstances.add(extension);
        }
        return resultInstances;
    }

    private ILabelProvider[] extractLabelProviders(Set theDescriptorInstances) {
        if (theDescriptorInstances.size() == 0) {
            return NO_LABEL_PROVIDERS;
        }
        ArrayList<ICommonLabelProvider> resultProvidersList = new ArrayList<ICommonLabelProvider>();
        Iterator itr = theDescriptorInstances.iterator();
        while (itr.hasNext()) {
            resultProvidersList.add(((NavigatorContentExtension)itr.next()).getLabelProvider());
        }
        return resultProvidersList.toArray(new ILabelProvider[resultProvidersList.size()]);
    }
}

