/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.NavigatorContentService;

public class NavigatorContentServiceLabelProvider
extends EventManager
implements ILabelProvider {
    private final ILabelDecorator decorator;
    private final NavigatorContentService contentService;
    private final boolean isContentServiceSelfManaged;

    public NavigatorContentServiceLabelProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        this.decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.isContentServiceSelfManaged = false;
    }

    public Image getImage(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        Image image = null;
        int i = 0;
        while (i < labelProviders.length && image == null) {
            image = labelProviders[i].getImage(anElement);
            ++i;
        }
        return image == null ? null : this.decorator.decorateImage(image, anElement);
    }

    public String getText(Object anElement) {
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        String text = null;
        int i = 0;
        while (i < labelProviders.length && text == null) {
            text = labelProviders[i].getText(anElement);
            ++i;
        }
        return text == null ? "" : text;
    }

    public boolean isLabelProperty(Object anElement, String aProperty) {
        boolean result = false;
        ILabelProvider[] labelProviders = this.contentService.findRelevantLabelProviders(anElement);
        int i = 0;
        while (i < labelProviders.length && !result) {
            result = labelProviders[i].isLabelProperty(anElement, aProperty);
            ++i;
        }
        return result;
    }

    public void addListener(ILabelProviderListener aListener) {
        this.addListenerObject(aListener);
    }

    public void removeListener(ILabelProviderListener aListener) {
        this.removeListenerObject(aListener);
    }

    public void dispose() {
        if (this.isContentServiceSelfManaged) {
            this.contentService.dispose();
        }
    }

    protected void fireLabelProviderChanged(final LabelProviderChangedEvent event) {
        Object[] theListeners = this.getListeners();
        int i = 0;
        while (i < theListeners.length) {
            final ILabelProviderListener l = (ILabelProviderListener)theListeners[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.labelProviderChanged(event);
                }
            });
            ++i;
        }
    }
}

