/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.actions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.SkeletonActionProvider;
import org.eclipse.ui.navigator.CommonActionProvider;

public class CommonActionProviderDescriptor
implements INavigatorContentExtPtConstants {
    private static final String DEFAULT_ID = "org.eclipse.ui.navigator.actionProvider";
    private final IConfigurationElement configurationElement;
    private final boolean isNested;
    private Set dependentDescriptors;
    private IConfigurationElement enablementElement;
    private Expression enablement;
    private boolean hasLoadingFailed;
    private String id;
    private String dependsOnId;
    private String toString;

    public CommonActionProviderDescriptor(IConfigurationElement aConfigElement) {
        Assert.isTrue((boolean)"actionProvider".equals(aConfigElement.getName()));
        this.configurationElement = aConfigElement;
        this.isNested = false;
        this.init();
    }

    public CommonActionProviderDescriptor(IConfigurationElement aConfigElement, IConfigurationElement anEnablementExpression, String anOverrideId, boolean nestedUnderNavigatorContent) {
        Assert.isTrue((boolean)"actionProvider".equals(aConfigElement.getName()));
        Assert.isTrue(("triggerPoints".equals(anEnablementExpression.getName()) || "enablement".equals(anEnablementExpression.getName()) ? 1 : 0) != 0);
        this.configurationElement = aConfigElement;
        this.enablementElement = anEnablementExpression;
        this.id = anOverrideId;
        this.isNested = nestedUnderNavigatorContent;
        this.init();
    }

    private void init() {
        try {
            if (this.id == null) {
                this.id = this.configurationElement.getAttribute("id");
            }
            if (this.id == null) {
                this.id = DEFAULT_ID;
            }
            this.dependsOnId = this.configurationElement.getAttribute("dependsOn");
            IConfigurationElement[] children = this.configurationElement.getChildren("enablement");
            if (children.length == 0 && this.enablementElement != null) {
                this.enablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), this.enablementElement);
            } else if (children.length == 1) {
                this.enablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), children[0]);
            } else {
                System.err.println("Incorrect number of expressions: enablement in navigator extension: " + this.configurationElement.getDeclaringExtension().getUniqueIdentifier());
            }
        }
        catch (CoreException e) {
            NavigatorPlugin.log(4, 0, e.getMessage(), e);
        }
    }

    public CommonActionProvider createActionProvider() {
        if (this.hasLoadingFailed) {
            return SkeletonActionProvider.INSTANCE;
        }
        CommonActionProvider provider = null;
        try {
            provider = (CommonActionProvider)this.configurationElement.createExecutableExtension("class");
        }
        catch (CoreException exception) {
            NavigatorPlugin.log("Unable to create navigator extension: " + this.getClassName(), exception.getStatus());
            this.hasLoadingFailed = true;
            provider = SkeletonActionProvider.INSTANCE;
        }
        catch (Exception e) {
            NavigatorPlugin.log("Unable to create navigator extension: " + this.getClassName(), (IStatus)new Status(4, NavigatorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e));
            this.hasLoadingFailed = true;
            provider = SkeletonActionProvider.INSTANCE;
        }
        return provider;
    }

    private String getClassName() {
        return this.configurationElement.getAttribute("class");
    }

    public boolean isEnabledFor(IStructuredSelection aStructuredSelection) {
        if (this.enablement == null) {
            return false;
        }
        EvaluationContext context = null;
        Iterator elements = aStructuredSelection.iterator();
        while (elements.hasNext()) {
            context = new EvaluationContext(null, elements.next());
            try {
                if (this.enablement.evaluate((IEvaluationContext)context) != EvaluationResult.FALSE && this.enablement.evaluate((IEvaluationContext)context) != EvaluationResult.NOT_LOADED) continue;
                return false;
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
                return false;
            }
        }
        return true;
    }

    public boolean isEnabledFor(Object anElement) {
        if (this.enablement == null || anElement == null) {
            return false;
        }
        try {
            return this.enablement.evaluate((IEvaluationContext)new EvaluationContext(null, anElement)) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            NavigatorPlugin.log(4, 0, e.getMessage(), e);
            return false;
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public String getDependsOnId() {
        return this.dependsOnId;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CommonActionProviderDescriptor) {
            CommonActionProviderDescriptor other = (CommonActionProviderDescriptor)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    protected void addDependentDescriptor(CommonActionProviderDescriptor dependentDescriptor) {
        Assert.isTrue((this != dependentDescriptor ? 1 : 0) != 0);
        if (this.dependentDescriptors == null) {
            this.dependentDescriptors = new HashSet();
        }
        this.dependentDescriptors.add(dependentDescriptor);
    }

    protected boolean hasDependentDescriptors() {
        return this.dependentDescriptors != null && !this.dependentDescriptors.isEmpty();
    }

    protected Iterator dependentDescriptors() {
        return this.dependentDescriptors.iterator();
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "CommonActionProviderDescriptor[" + this.getId() + ", dependsOn=" + this.getDependsOnId() + "]";
        }
        return this.toString;
    }
}

