/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.extensions.LinkHelperRegistry;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.progress.UIJob;

public class LinkEditorAction
extends Action
implements ISelectionChangedListener,
IAction,
IPropertyListener {
    private IPartListener partListener;
    private final CommonViewer commonViewer;
    private final CommonNavigator commonNavigator;
    private LinkHelperRegistry linkHelperRegistry;

    public LinkEditorAction(CommonNavigator aNavigator, CommonViewer aViewer) {
        super(CommonNavigatorMessages.LinkEditorActionDelegate_0);
        this.setToolTipText(CommonNavigatorMessages.LinkEditorActionDelegate_1);
        this.commonNavigator = aNavigator;
        this.commonViewer = aViewer;
        this.init();
    }

    protected void activateEditor() {
        ISelection selection = this.commonViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.activateEditor((IStructuredSelection)selection);
        }
    }

    protected void activateEditor(final IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.size() != 1) {
            return;
        }
        final Runnable activateEditor = new Runnable(){

            public void run() {
                ILinkHelper[] helpers = LinkEditorAction.this.linkHelperRegistry.getLinkHelpersFor(aSelection);
                if (helpers.length > 0) {
                    helpers[0].activateEditor(LinkEditorAction.this.commonNavigator.getSite().getPage(), aSelection);
                }
            }
        };
        if (Display.getCurrent() != null) {
            activateEditor.run();
        } else {
            new UIJob(CommonNavigatorMessages.Link_With_Editor_Job_){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    activateEditor.run();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    protected void init() {
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    LinkEditorAction.this.linkToEditor((IEditorPart)part);
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    LinkEditorAction.this.linkToEditor((IEditorPart)part);
                }
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        this.updateLinkingEnabled(this.commonNavigator.isLinkingEnabled());
        this.commonNavigator.addPropertyListener(this);
        this.linkHelperRegistry = new LinkHelperRegistry(this.commonViewer.getNavigatorContentService());
    }

    private void linkToEditor(IEditorPart anEditor) {
        if (anEditor != null) {
            IEditorInput input = anEditor.getEditorInput();
            ILinkHelper[] helpers = this.linkHelperRegistry.getLinkHelpersFor(input);
            StructuredSelection selection = StructuredSelection.EMPTY;
            StructuredSelection newSelection = StructuredSelection.EMPTY;
            int i = 0;
            while (i < helpers.length) {
                selection = helpers[i].findSelection(input);
                if (selection != null && !selection.isEmpty()) {
                    newSelection = this.mergeSelection((IStructuredSelection)newSelection, (IStructuredSelection)selection);
                }
                ++i;
            }
            this.commonNavigator.selectReveal((ISelection)newSelection);
        }
    }

    private IStructuredSelection mergeSelection(IStructuredSelection aBase, IStructuredSelection aSelectionToAppend) {
        if (aBase == null || aBase.isEmpty()) {
            return aSelectionToAppend != null ? aSelectionToAppend : StructuredSelection.EMPTY;
        }
        if (aSelectionToAppend == null || aSelectionToAppend.isEmpty()) {
            return aBase;
        }
        ArrayList newItems = new ArrayList(aBase.toList());
        newItems.addAll(aSelectionToAppend.toList());
        return new StructuredSelection(newItems);
    }

    public void run() {
        this.commonNavigator.setLinkingEnabled(!this.commonNavigator.isLinkingEnabled());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.commonNavigator.isLinkingEnabled()) {
            this.activateEditor((IStructuredSelection)event.getSelection());
        }
    }

    public void propertyChanged(Object aSource, int aPropertyId) {
        switch (aPropertyId) {
            case 1: {
                this.updateLinkingEnabled(((CommonNavigator)((Object)aSource)).isLinkingEnabled());
            }
        }
    }

    private void updateLinkingEnabled(boolean toEnableLinking) {
        this.setChecked(toEnableLinking);
        if (toEnableLinking) {
            IEditorPart editor = this.commonNavigator.getSite().getPage().getActiveEditor();
            this.linkToEditor(editor);
            this.commonViewer.addSelectionChangedListener(this);
            this.commonNavigator.getSite().getPage().addPartListener(this.partListener);
        } else {
            this.commonViewer.removeSelectionChangedListener(this);
            this.commonNavigator.getSite().getPage().removePartListener(this.partListener);
        }
    }
}

