/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.dnd.ISerializer;
import org.eclipse.ui.internal.navigator.dnd.LocalSelectionTransfer;
import org.eclipse.ui.internal.navigator.dnd.NavigatorSelectionSerializer;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

public class CommonNavigatorDragAdapter
extends DragSourceAdapter {
    private ISerializer serializer;
    private final CommonViewer commonViewer;

    public CommonNavigatorDragAdapter(CommonViewer aViewer) {
        this.commonViewer = aViewer;
    }

    public void dragStart(DragSourceEvent event) {
        try {
            ISelection selection = this.commonViewer.getSelection();
            event.doit = !selection.isEmpty();
            LocalSelectionTransfer.getInstance().setSelection(selection);
        }
        catch (RuntimeException e) {
            NavigatorPlugin.log("CommonNavigatorDragAdapter.dragStart():" + e.toString());
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (LocalSelectionTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = LocalSelectionTransfer.getInstance().getSelection();
        } else if (PluginTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getInstance().getSelection();
            byte[] data = this.getSerializer().toByteArray(selection);
            event.data = new PluginTransferData("org.eclipse.navigator.ui.dnd.PluginDropAction", data);
        }
    }

    private ISerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new NavigatorSelectionSerializer(this.commonViewer.getNavigatorContentService().getViewerId());
        }
        return this.serializer;
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer.getInstance().setSelection(null);
    }
}

