/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.dnd.CommonDropHandlerService;
import org.eclipse.ui.internal.navigator.dnd.ISerializer;
import org.eclipse.ui.internal.navigator.dnd.SerializerDescriptor;

public class NavigatorSelectionSerializer
implements ISerializer {
    private String viewerId;

    public NavigatorSelectionSerializer() {
    }

    public NavigatorSelectionSerializer(String aViewerId) {
        this.viewerId = aViewerId;
    }

    public byte[] toByteArray(Object object) {
        if (this.viewerId == null) {
            return null;
        }
        if (!(object instanceof IStructuredSelection)) {
            return new byte[0];
        }
        IStructuredSelection selection = (IStructuredSelection)object;
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(this.viewerId);
            byte[] data = null;
            Object element = null;
            SerializerDescriptor[] serializerDescriptors = null;
            dataOutputStream.writeInt(selection.size());
            Iterator selectionIterator = selection.iterator();
            while (selectionIterator.hasNext()) {
                element = selectionIterator.next();
                serializerDescriptors = CommonDropHandlerService.getInstance(this.viewerId).getSerializersEnabledFor(element);
                ByteArrayOutputStream localRepresentationOutputStream = null;
                int differentRepresentations = 0;
                localRepresentationOutputStream = new ByteArrayOutputStream();
                DataOutputStream serializedDataOutputStream = new DataOutputStream(localRepresentationOutputStream);
                int i = 0;
                while (i < serializerDescriptors.length) {
                    ISerializer serializer = serializerDescriptors[i].getSerializer();
                    data = serializer.toByteArray(element);
                    if (data != null) {
                        serializedDataOutputStream.writeUTF(serializerDescriptors[i].id);
                        serializedDataOutputStream.writeInt(data.length);
                        serializedDataOutputStream.write(data);
                        ++differentRepresentations;
                    }
                    ++i;
                }
                dataOutputStream.writeInt(differentRepresentations);
                dataOutputStream.write(localRepresentationOutputStream.toByteArray());
            }
            result = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            NavigatorPlugin.log(String.valueOf(CommonNavigatorMessages.NavigatorSelectionSerializer_1) + e.toString());
            result = null;
        }
        return result;
    }

    public Object fromByteArray(byte[] data) {
        HashMap results = new HashMap();
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(data));
        try {
            int localDataLen = 0;
            byte[] localData = null;
            String serializerId = null;
            Object dataObject = null;
            String localViewerId = dataInputStream.readUTF();
            int numberOfObjects = dataInputStream.readInt();
            int i = 0;
            while (i < numberOfObjects) {
                int numberOfRepresentations = dataInputStream.readInt();
                int j = 0;
                while (j < numberOfRepresentations) {
                    serializerId = dataInputStream.readUTF();
                    SerializerDescriptor serializerDescriptor = CommonDropHandlerService.getInstance(localViewerId).getSerializerById(serializerId);
                    ISerializer serializer = serializerDescriptor.getSerializer();
                    localDataLen = dataInputStream.readInt();
                    localData = new byte[localDataLen];
                    dataInputStream.read(localData, 0, localData.length);
                    dataObject = serializer.fromByteArray(localData);
                    this.getDataList(results, serializerId).add(dataObject);
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new NavigatorSerializedSelection(this.viewerId, results);
    }

    public List getDataList(Map serializerMap, String id) {
        ArrayList result = (ArrayList)serializerMap.get(id);
        if (result == null) {
            result = new ArrayList();
            serializerMap.put(id, result);
        }
        return result;
    }

    public class NavigatorSerializedSelection {
        public final String viewerId;
        public final Map selectionMap;

        public NavigatorSerializedSelection(String viewerId, Map selectionMap) {
            this.viewerId = viewerId;
            this.selectionMap = selectionMap;
        }
    }
}

