/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.Iterator;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.navigator.ILinkHelper;

public class LinkHelperDescriptor {
    private final IConfigurationElement configElement;
    private String id;
    private String navigatorContentExtensionId;
    private ILinkHelper linkHelper;
    public static final String LINK_HELPER = "linkHelper";
    public static final String ATT_ID = "id";
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAVIGATOR_CONTENT_EXTENSION_ID = "navigatorContentExtensionId";
    private Expression editorInputEnablement;
    private Expression selectionEnablement;
    private static final String EDITOR_INPUT_ENABLEMENT = "editorInputEnablement";
    private static final String SELECTION_ENABLEMENT = "selectionEnablement";

    public LinkHelperDescriptor(IConfigurationElement element) {
        Assert.isNotNull((Object)element, (String)"LinkHelperRegistry.Descriptor objects cannot be null.");
        Assert.isLegal((boolean)LINK_HELPER.equals(element.getName()), (String)"LinkHelperRegistry.Descriptor objects must have the name \"linkHelper\".");
        this.configElement = element;
        this.init();
    }

    void init() {
        this.id = this.configElement.getAttribute(ATT_ID);
        IConfigurationElement[] expressions = this.configElement.getChildren(EDITOR_INPUT_ENABLEMENT);
        Assert.isLegal((expressions.length == 1 ? 1 : 0) != 0, (String)"The linkHelper extension point requires exactly one editorInputEnablement child.");
        try {
            this.editorInputEnablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), expressions[0]);
        }
        catch (CoreException e) {
            NavigatorPlugin.log(4, 0, e.getMessage(), e);
        }
        expressions = this.configElement.getChildren(SELECTION_ENABLEMENT);
        if (expressions.length > 0) {
            this.navigatorContentExtensionId = expressions[0].getAttribute(ATT_NAVIGATOR_CONTENT_EXTENSION_ID);
            if (expressions[0].getChildren() != null && expressions[0].getChildren().length > 0) {
                try {
                    this.selectionEnablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), expressions[0]);
                }
                catch (CoreException e) {
                    NavigatorPlugin.log(4, 0, e.getMessage(), e);
                }
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public ILinkHelper getLinkHelper() {
        if (this.linkHelper == null) {
            try {
                this.linkHelper = (ILinkHelper)this.configElement.createExecutableExtension(ATT_CLASS);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this.linkHelper;
    }

    public boolean isEnabledFor(IEditorInput anInput) {
        if (this.editorInputEnablement == null || anInput == null) {
            return false;
        }
        try {
            return this.editorInputEnablement.evaluate((IEvaluationContext)new EvaluationContext(null, (Object)anInput)) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            NavigatorPlugin.log(4, 0, e.getMessage(), e);
            return false;
        }
    }

    public boolean isEnabledFor(String aNavigatorContentExtensionId) {
        return this.navigatorContentExtensionId != null ? this.navigatorContentExtensionId.equals(aNavigatorContentExtensionId) : false;
    }

    public boolean isEnabledFor(IStructuredSelection aSelection) {
        if (this.selectionEnablement == null) {
            return false;
        }
        EvaluationContext context = null;
        Iterator elements = aSelection.iterator();
        while (elements.hasNext()) {
            context = new EvaluationContext(null, elements.next());
            try {
                if (this.selectionEnablement.evaluate((IEvaluationContext)context) != EvaluationResult.FALSE) continue;
                return false;
            }
            catch (CoreException e) {
                NavigatorPlugin.log(4, 0, e.getMessage(), e);
                return false;
            }
        }
        return true;
    }
}

