/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.DelegateCommonLabelProvider;
import org.eclipse.ui.internal.navigator.extensions.ExtensionStateModel;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentProvider;
import org.eclipse.ui.internal.navigator.extensions.SkeletonLabelProvider;
import org.eclipse.ui.internal.navigator.extensions.SkeletonTreeContentProvider;
import org.eclipse.ui.internal.navigator.extensions.StructuredViewerManager;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentExtension;

public class NavigatorContentExtension
implements IMementoAware,
INavigatorContentExtension {
    private static final NavigatorContentExtension[] NO_EXTENSIONS = new NavigatorContentExtension[0];
    private NavigatorContentService contentService;
    private NavigatorContentDescriptor descriptor;
    private final String viewerId;
    private ICommonContentProvider contentProvider;
    private ICommonLabelProvider labelProvider;
    private IExtensionStateModel stateModel;
    private boolean labelProviderInitializationFailed = false;
    private boolean contentProviderInitializationFailed = false;
    private boolean isDisposed = false;
    private IMemento appliedMemento;
    private StructuredViewerManager viewerManager;

    public NavigatorContentExtension(NavigatorContentDescriptor aDescriptor, NavigatorContentService aContentService, StructuredViewerManager aViewerManager) {
        Assert.isNotNull((Object)aDescriptor);
        this.descriptor = aDescriptor;
        this.contentService = aContentService;
        this.viewerId = this.contentService.getViewerId();
        this.viewerManager = aViewerManager;
    }

    public String getId() {
        return this.descriptor.getId();
    }

    public INavigatorContentDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITreeContentProvider getContentProvider() {
        if (this.contentProvider != null || this.contentProviderInitializationFailed) {
            return this.contentProvider;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            try {
                if (this.contentProvider == null) {
                    ITreeContentProvider treeContentProvider = this.descriptor.createContentProvider();
                    if (treeContentProvider != null) {
                        this.contentProvider = new NavigatorContentProvider(treeContentProvider, this.descriptor, this.contentService);
                        this.contentProvider.init(this.getStateModel(), this.appliedMemento);
                        this.viewerManager.initialize((IStructuredContentProvider)this.contentProvider);
                    } else {
                        this.contentProvider = SkeletonTreeContentProvider.INSTANCE;
                    }
                }
            }
            catch (CoreException e) {
                this.contentProviderInitializationFailed = true;
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                this.contentProviderInitializationFailed = true;
                e.printStackTrace();
            }
            if (this.contentProviderInitializationFailed) {
                this.contentProvider = SkeletonTreeContentProvider.INSTANCE;
            }
        }
        return this.contentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonLabelProvider getLabelProvider() {
        if (this.labelProvider != null || this.labelProviderInitializationFailed) {
            return this.labelProvider;
        }
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            try {
                if (this.labelProvider == null) {
                    ILabelProvider tempLabelProvider = this.descriptor.createLabelProvider();
                    if (tempLabelProvider instanceof ICommonLabelProvider) {
                        this.labelProvider = (ICommonLabelProvider)tempLabelProvider;
                        if (this.getContentProvider() instanceof NavigatorContentProvider) {
                            this.labelProvider.init(this.getStateModel(), ((NavigatorContentProvider)this.getContentProvider()).getDelegateContentProvider());
                        } else {
                            this.labelProvider.init(this.getStateModel(), SkeletonTreeContentProvider.INSTANCE);
                        }
                    } else {
                        this.labelProvider = new DelegateCommonLabelProvider(tempLabelProvider);
                    }
                }
            }
            catch (CoreException e) {
                this.labelProviderInitializationFailed = true;
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                this.labelProviderInitializationFailed = true;
                e.printStackTrace();
            }
            if (this.labelProviderInitializationFailed) {
                this.labelProvider = SkeletonLabelProvider.INSTANCE;
            }
        }
        return this.labelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        try {
            NavigatorContentExtension navigatorContentExtension = this;
            synchronized (navigatorContentExtension) {
                if (this.contentProvider != null) {
                    this.contentProvider.dispose();
                }
                if (this.labelProvider != null) {
                    this.labelProvider.dispose();
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.isDisposed = true;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.isDisposed = true;
            return;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean hasContentProviderInitializationFailed() {
        return this.contentProviderInitializationFailed;
    }

    public boolean hasLabelProviderInitializationFailed() {
        return this.labelProviderInitializationFailed;
    }

    public boolean hasLoadingFailed() {
        return this.contentProviderInitializationFailed;
    }

    public boolean isLoaded() {
        return this.contentProvider != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreState(IMemento aMemento) {
        NavigatorContentExtension navigatorContentExtension = this;
        synchronized (navigatorContentExtension) {
            this.appliedMemento = aMemento;
            this.applyMemento(this.contentProvider);
            this.applyMemento(this.labelProvider);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void saveState(IMemento aMemento) {
        NavigatorContentExtension navigatorContentExtension = this;
        // MONITORENTER : navigatorContentExtension
        // MONITOREXIT : navigatorContentExtension
    }

    private void applyMemento(IMementoAware target) {
        if (target != null) {
            target.restoreState(this.appliedMemento);
        }
    }

    protected final void complainDisposedIfNecessary() {
        if (this.isDisposed) {
            throw new IllegalStateException("INavigatorContentExtension " + this.descriptor.getId() + " is disposed!");
        }
    }

    public IExtensionStateModel getStateModel() {
        if (this.stateModel == null) {
            this.stateModel = new ExtensionStateModel(this.descriptor.getId(), this.viewerId);
        }
        return this.stateModel;
    }

    public NavigatorContentExtension[] getOverridingExtensionsForTriggerPoint(Object anElement) {
        if (!this.descriptor.hasOverridingExtensions()) {
            return NO_EXTENSIONS;
        }
        HashSet<NavigatorContentExtension> overridingExtensions = new HashSet<NavigatorContentExtension>();
        Iterator contentDescriptorsItr = this.descriptor.getOverriddingExtensions().iterator();
        while (contentDescriptorsItr.hasNext()) {
            NavigatorContentDescriptor overriddingDescriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            if (!this.contentService.isActive(overriddingDescriptor.getId()) || !this.contentService.isVisible(overriddingDescriptor.getId()) || !overriddingDescriptor.isTriggerPoint(anElement)) continue;
            overridingExtensions.add(this.contentService.getExtension(overriddingDescriptor));
        }
        if (overridingExtensions.size() == 0) {
            return NO_EXTENSIONS;
        }
        return overridingExtensions.toArray(new NavigatorContentExtension[overridingExtensions.size()]);
    }

    public NavigatorContentExtension[] getOverridingExtensionsForPossibleChild(Object anElement) {
        if (!this.descriptor.hasOverridingExtensions()) {
            return NO_EXTENSIONS;
        }
        HashSet<NavigatorContentExtension> overridingExtensions = new HashSet<NavigatorContentExtension>();
        Iterator contentDescriptorsItr = this.descriptor.getOverriddingExtensions().iterator();
        while (contentDescriptorsItr.hasNext()) {
            this.descriptor = (NavigatorContentDescriptor)contentDescriptorsItr.next();
            if (!this.contentService.isActive(this.descriptor.getId()) || !this.contentService.isVisible(this.descriptor.getId()) || !this.descriptor.isPossibleChild(anElement)) continue;
            overridingExtensions.add(this.contentService.getExtension(this.descriptor));
        }
        if (overridingExtensions.size() == 0) {
            return NO_EXTENSIONS;
        }
        return overridingExtensions.toArray(new NavigatorContentExtension[overridingExtensions.size()]);
    }

    public String toString() {
        return String.valueOf(this.descriptor.toString()) + " Instance";
    }
}

