/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class NavigatorContentProvider
implements IPipelinedTreeContentProvider {
    private final ITreeContentProvider contentProvider;
    private NavigatorContentService contentService;
    private NavigatorContentDescriptor descriptor;

    public NavigatorContentProvider(ITreeContentProvider aContentProvider, NavigatorContentDescriptor aDescriptor, NavigatorContentService theContentService) {
        this.contentProvider = aContentProvider;
        this.contentService = theContentService;
        this.descriptor = aDescriptor;
    }

    public void dispose() {
        this.contentProvider.dispose();
    }

    public boolean equals(Object anObject) {
        return this.contentProvider.equals(anObject);
    }

    public Object[] getChildren(Object aParentElement) {
        Object[] children = this.contentProvider.getChildren(aParentElement);
        this.contentService.rememberContribution(this.descriptor, children);
        return children;
    }

    public Object[] getElements(Object anInputElement) {
        Object[] elements = this.contentProvider.getElements(anInputElement);
        this.contentService.rememberContribution(this.descriptor, elements);
        return elements;
    }

    public Object getParent(Object anElement) {
        return this.contentProvider.getParent(anElement);
    }

    public boolean hasChildren(Object anElement) {
        return this.contentProvider.hasChildren(anElement);
    }

    public int hashCode() {
        return this.contentProvider.hashCode();
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.contentProvider.inputChanged(aViewer, anOldInput, aNewInput);
    }

    public String toString() {
        return this.contentProvider.toString();
    }

    public ITreeContentProvider getDelegateContentProvider() {
        return this.contentProvider;
    }

    public void restoreState(IMemento aMemento) {
        if (this.contentProvider != null && this.contentProvider instanceof IMementoAware) {
            ((IMementoAware)this.contentProvider).restoreState(aMemento);
        }
    }

    public void saveState(IMemento aMemento) {
        if (this.contentProvider != null && this.contentProvider instanceof IMementoAware) {
            ((IMementoAware)this.contentProvider).saveState(aMemento);
        }
    }

    public void init(IExtensionStateModel aStateModel, IMemento aMemento) {
        if (this.contentProvider instanceof ICommonContentProvider) {
            ((ICommonContentProvider)this.contentProvider).init(aStateModel, aMemento);
        }
    }

    public Set getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            return ((IPipelinedTreeContentProvider)this.contentProvider).getPipelinedChildren(aParent, theCurrentChildren);
        }
        return theCurrentChildren;
    }

    public Set getPipelinedElements(Object anInput, Set theCurrentElements) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            return ((IPipelinedTreeContentProvider)this.contentProvider).getPipelinedElements(anInput, theCurrentElements);
        }
        return theCurrentElements;
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        if (this.contentProvider instanceof IPipelinedTreeContentProvider) {
            return ((IPipelinedTreeContentProvider)this.contentProvider).getPipelinedParent(anObject, aSuggestedParent);
        }
        return anObject;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        return null;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return null;
    }

    public PipelinedViewerUpdate interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        return null;
    }

    public PipelinedViewerUpdate interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return null;
    }
}

