/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.InsertionPoint;
import org.eclipse.ui.internal.navigator.extensions.NavigatorViewerDescriptor;
import org.eclipse.ui.internal.navigator.extensions.RegistryReader;

public class NavigatorViewerDescriptorRegistry
extends RegistryReader {
    private static final NavigatorViewerDescriptorRegistry INSTANCE = new NavigatorViewerDescriptorRegistry();
    private static final String TAG_VIEWER = "viewer";
    private static final String TAG_VIEWER_CONTENT_BINDING = "viewerContentBinding";
    private static final String TAG_VIEWER_ACTION_BINDING = "viewerActionBinding";
    private static final String TAG_POPUP_MENU = "popupMenu";
    private static final String TAG_OPTIONS = "options";
    private static final String TAG_PROPERTY = "property";
    private static final String ATT_ID = "id";
    private static final String ATT_ALLOWS_PLATFORM_CONTRIBUTIONS = "allowsPlatformContributions";
    private static final String TAG_INSERTION_POINT = "insertionPoint";
    private static final String ATT_NAME = "name";
    private static final String ATT_SEPARATOR = "separator";
    private static final String ATT_VIEWER_ID = "viewerId";
    private static final String ATT_POPUP_MENU_ID = "popupMenuId";
    private static final String ATT_VALUE = "value";
    private static boolean isInitialized = false;
    private final Map viewerDescriptors = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigatorViewerDescriptorRegistry getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        NavigatorViewerDescriptorRegistry navigatorViewerDescriptorRegistry = INSTANCE;
        synchronized (navigatorViewerDescriptorRegistry) {
            if (!isInitialized) {
                INSTANCE.readRegistry();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    protected NavigatorViewerDescriptorRegistry() {
        super(NavigatorPlugin.PLUGIN_ID, TAG_VIEWER);
    }

    public NavigatorViewerDescriptor getNavigatorViewerDescriptor(String viewerId) {
        return this.getViewerDescriptor(viewerId);
    }

    protected boolean readElement(IConfigurationElement element) {
        if (TAG_VIEWER.equals(element.getName())) {
            String viewerId = element.getAttribute(ATT_VIEWER_ID);
            NavigatorViewerDescriptor descriptor = this.getViewerDescriptor(viewerId);
            String attPopupMenuId = element.getAttribute(ATT_POPUP_MENU_ID);
            IConfigurationElement[] tagPopupMenu = element.getChildren(TAG_POPUP_MENU);
            if (tagPopupMenu.length == 0 && attPopupMenuId != null) {
                descriptor.setPopupMenuId(attPopupMenuId);
            } else if (attPopupMenuId != null) {
                NavigatorPlugin.logError(0, "A popupMenuId attribute and popupMenu element may NOT be concurrently specified. (see " + element.getNamespace() + ")", null);
            } else if (tagPopupMenu.length > 1) {
                NavigatorPlugin.logError(0, "Only one \"popupMenu\" child of \"viewer\" may be specified. (see " + element.getNamespace() + ")", null);
            } else {
                String popupMenuId = tagPopupMenu[0].getAttribute(ATT_ID);
                String allowsPlatformContributions = tagPopupMenu[0].getAttribute(ATT_ALLOWS_PLATFORM_CONTRIBUTIONS);
                if (popupMenuId != null) {
                    descriptor.setPopupMenuId(popupMenuId);
                }
                if (allowsPlatformContributions != null) {
                    descriptor.setAllowsPlatformContributions(Boolean.valueOf(allowsPlatformContributions));
                }
                IConfigurationElement[] insertionPointElements = tagPopupMenu[0].getChildren(TAG_INSERTION_POINT);
                InsertionPoint[] insertionPoints = new InsertionPoint[insertionPointElements.length];
                int indx = 0;
                while (indx < insertionPointElements.length) {
                    String name = insertionPointElements[indx].getAttribute(ATT_NAME);
                    String stringAttSeparator = insertionPointElements[indx].getAttribute(ATT_SEPARATOR);
                    boolean isSeparator = stringAttSeparator != null ? Boolean.valueOf(stringAttSeparator) : false;
                    insertionPoints[indx] = new InsertionPoint(name, isSeparator);
                    ++indx;
                }
                descriptor.setCustomInsertionPoints(insertionPoints);
            }
            IConfigurationElement[] options = element.getChildren(TAG_OPTIONS);
            if (options.length == 1) {
                IConfigurationElement[] properties = options[0].getChildren(TAG_PROPERTY);
                int i = 0;
                while (i < properties.length) {
                    String name = properties[i].getAttribute(ATT_NAME);
                    if (name != null) {
                        String value = properties[i].getAttribute(ATT_VALUE);
                        descriptor.setProperty(name, value);
                    }
                    ++i;
                }
            } else if (options.length > 1) {
                NavigatorPlugin.logError(0, "Only one \"options\" child of \"viewer\" may be specified. (see " + element.getNamespace() + ")", null);
            }
            return true;
        }
        if (TAG_VIEWER_CONTENT_BINDING.equals(element.getName())) {
            try {
                String viewerId = element.getAttribute(ATT_VIEWER_ID);
                NavigatorViewerDescriptor descriptor = this.getViewerDescriptor(viewerId);
                descriptor.consumeContentBinding(element);
                return true;
            }
            catch (WorkbenchException e) {
                NavigatorPlugin.log("Unable to create navigator view descriptor.", e.getStatus());
            }
        }
        if (TAG_VIEWER_ACTION_BINDING.equals(element.getName())) {
            try {
                String viewerId = element.getAttribute(ATT_VIEWER_ID);
                NavigatorViewerDescriptor descriptor = this.getViewerDescriptor(viewerId);
                descriptor.consumeActionBinding(element);
                return true;
            }
            catch (WorkbenchException e) {
                NavigatorPlugin.log("Unable to create navigator view descriptor.", e.getStatus());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigatorViewerDescriptor getViewerDescriptor(String aViewerId) {
        NavigatorViewerDescriptor viewerDescriptor = null;
        Map map = this.viewerDescriptors;
        synchronized (map) {
            viewerDescriptor = (NavigatorViewerDescriptor)this.viewerDescriptors.get(aViewerId);
            if (viewerDescriptor != null) {
                return viewerDescriptor;
            }
            viewerDescriptor = new NavigatorViewerDescriptor(aViewerId);
            this.viewerDescriptors.put(viewerDescriptor.getViewerId(), viewerDescriptor);
        }
        return viewerDescriptor;
    }
}

