/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.internal.navigator.filters.CoreExpressionFilter;
import org.eclipse.ui.internal.navigator.filters.SkeletonViewerFilter;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;

public class CommonFilterDescriptor
implements ICommonFilterDescriptor,
INavigatorContentExtPtConstants {
    private IConfigurationElement element;
    private Expression filterExpression;
    private String id;

    protected CommonFilterDescriptor(IConfigurationElement anElement) {
        this.element = anElement;
        this.init();
    }

    private void init() {
        IConfigurationElement[] children;
        this.id = this.element.getAttribute("id");
        if (this.id == null) {
            this.id = "";
        }
        if ((children = this.element.getChildren("filterExpression")).length == 1) {
            this.filterExpression = new CustomAndExpression(children[0]);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public boolean isActiveByDefault() {
        return Boolean.valueOf(this.element.getAttribute("activeByDefault"));
    }

    public ViewerFilter createFilter() {
        try {
            if (this.filterExpression != null) {
                if (this.element.getAttribute("class") != null) {
                    NavigatorPlugin.log(2, 0, "A \"commonFilter\" was specified in " + this.element.getDeclaringExtension().getNamespace() + " which specifies a \"class\" attribute and an Core Expression.\n" + "Only the Core Expression will be respected.", null);
                }
                return new CoreExpressionFilter(this.filterExpression);
            }
            return (ViewerFilter)this.element.createExecutableExtension("class");
        }
        catch (RuntimeException re) {
            NavigatorPlugin.logError(0, re.getMessage(), re);
        }
        catch (CoreException e) {
            NavigatorPlugin.logError(0, e.getMessage(), e);
        }
        return SkeletonViewerFilter.INSTANCE;
    }

    public String toString() {
        return "CommonFilterDescriptor[" + this.getName() + " (" + this.getId() + ")]";
    }
}

