/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.sorters;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.internal.navigator.CustomAndExpression;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.internal.navigator.sorters.SkeletonViewerSorter;

public class CommonSorterDescriptor
implements INavigatorContentExtPtConstants {
    private IConfigurationElement element;
    private Expression parentExpression;
    private String id;

    protected CommonSorterDescriptor(IConfigurationElement anElement) {
        this.element = anElement;
        this.init();
    }

    private void init() {
        IConfigurationElement[] children;
        this.id = this.element.getAttribute("id");
        if (this.id == null) {
            this.id = "";
        }
        if ((children = this.element.getChildren("parentExpression")).length == 1) {
            this.parentExpression = new CustomAndExpression(children[0]);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public boolean isEnabledForParent(Object aParent) {
        if (aParent == null) {
            return false;
        }
        if (this.parentExpression != null) {
            EvaluationContext context = new EvaluationContext(null, aParent);
            try {
                return this.parentExpression.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                NavigatorPlugin.logError(0, e.getMessage(), e);
            }
        }
        return true;
    }

    public ViewerSorter createSorter() {
        try {
            return (ViewerSorter)this.element.createExecutableExtension("class");
        }
        catch (RuntimeException re) {
            NavigatorPlugin.logError(0, re.getMessage(), re);
        }
        catch (CoreException e) {
            NavigatorPlugin.logError(0, e.getMessage(), e);
        }
        return SkeletonViewerSorter.INSTANCE;
    }

    public String toString() {
        return "CommonSorterDescriptor[" + this.getName() + " (" + this.getId() + ")]";
    }
}

