/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.CommonNavigatorActionGroup;
import org.eclipse.ui.internal.navigator.CommonNavigatorManager;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class CommonNavigator
extends ViewPart
implements ISetSelectionTarget {
    public static final int IS_LINKING_ENABLED_PROPERTY = 1;
    private CommonViewer commonViewer;
    private CommonNavigatorManager commonManager;
    private ActionGroup commonActionGroup;
    private IMemento memento;
    private boolean isLinkingEnabled = false;
    private String LINKING_ENABLED = "CommonNavigator.LINKING_ENABLED";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void createPartControl(Composite aParent) {
        this.commonViewer = this.createCommonViewer(aParent);
        INavigatorFilterService filterService = this.commonViewer.getNavigatorContentService().getFilterService();
        ViewerFilter[] visibleFilters = filterService.getVisibleFilters(true);
        int i = 0;
        while (i < visibleFilters.length) {
            this.commonViewer.addFilter(visibleFilters[i]);
            ++i;
        }
        this.commonViewer.setSorter(new CommonViewerSorter());
        this.commonViewer.setInput(this.getInitialInput());
        this.commonViewer.getControl().addDisposeListener(this.createDisposeListener());
        this.getSite().setSelectionProvider((ISelectionProvider)this.commonViewer);
        this.updateTitle();
        this.commonManager = this.createCommonManager();
        if (this.memento != null) {
            this.commonManager.restoreState(this.memento);
            this.commonViewer.getNavigatorContentService().restoreState(this.memento);
        }
        this.commonActionGroup = this.createCommonActionGroup();
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
    }

    public void dispose() {
        if (this.commonManager != null) {
            this.commonManager.dispose();
        }
        super.dispose();
    }

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        super.init(aSite, aMemento);
        this.memento = aMemento;
        if (this.memento != null) {
            Integer linkingEnabledInteger = this.memento.getInteger(this.LINKING_ENABLED);
            this.setLinkingEnabled(linkingEnabledInteger != null ? linkingEnabledInteger == 1 : false);
        }
    }

    public void saveState(IMemento aMemento) {
        aMemento.putInteger(this.LINKING_ENABLED, this.isLinkingEnabled ? 1 : 0);
        super.saveState(aMemento);
        this.commonManager.saveState(aMemento);
        this.commonViewer.getNavigatorContentService().saveState(aMemento);
    }

    public void setFocus() {
        if (this.commonViewer != null) {
            this.commonViewer.getTree().setFocus();
        }
    }

    public void selectReveal(ISelection selection) {
        if (this.commonViewer != null) {
            this.commonViewer.setSelection(selection, true);
        }
    }

    public final void setLinkingEnabled(boolean toEnableLinking) {
        this.isLinkingEnabled = toEnableLinking;
        this.firePropertyChange(1);
    }

    public final boolean isLinkingEnabled() {
        return this.isLinkingEnabled;
    }

    public CommonViewer getCommonViewer() {
        return this.commonViewer;
    }

    public INavigatorContentService getNavigatorContentService() {
        return this.getCommonViewer().getNavigatorContentService();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.navigator.CommonViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getCommonViewer();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.internal.navigator.NavigatorContentService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getCommonViewer().getNavigatorContentService();
        }
        return super.getAdapter(adapter);
    }

    public NavigatorActionService getNavigatorActionService() {
        return this.commonManager.getNavigatorActionService();
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer aViewer = new CommonViewer(this.getViewSite().getId(), aParent, 770);
        this.initListeners(aViewer);
        aViewer.getNavigatorContentService().restoreState(this.memento);
        return aViewer;
    }

    protected void initListeners(TreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    CommonNavigator.this.handleDoubleClick(event);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
            }
        });
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        IStructuredSelection selection = (IStructuredSelection)anEvent.getSelection();
        Object element = selection.getFirstElement();
        CommonViewer viewer = this.getCommonViewer();
        if (viewer.isExpandable(element)) {
            viewer.setExpandedState(element, !viewer.getExpandedState(element));
        }
    }

    protected CommonNavigatorManager createCommonManager() {
        return new CommonNavigatorManager(this);
    }

    protected ActionGroup createCommonActionGroup() {
        return new CommonNavigatorActionGroup(this, this.commonViewer);
    }

    protected DisposeListener createDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommonNavigator.this.dispose();
            }
        };
    }

    protected IAdaptable getInitialInput() {
        return this.getSite().getPage().getInput();
    }

    protected void updateTitle() {
        if (this.commonViewer == null) {
            return;
        }
        Object input = this.commonViewer.getInput();
        String viewName = this.getConfigurationElement().getAttribute("name");
        if (input == null) {
            this.setPartName(viewName);
            this.setTitleToolTip("");
        } else {
            String inputToolTip = this.getFrameToolTipText(input);
            this.setPartName(viewName);
            this.setTitleToolTip(inputToolTip);
        }
    }

    protected String getFrameToolTipText(Object anElement) {
        if (this.commonViewer != null) {
            return ((ILabelProvider)this.commonViewer.getLabelProvider()).getText(anElement);
        }
        return "";
    }
}

