/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationElementHandle;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionDelta;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.ExtensionsParser;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.internal.registry.IObjectManager;
import org.eclipse.core.internal.registry.ReadWriteMonitor;
import org.eclipse.core.internal.registry.RegistryChangeEvent;
import org.eclipse.core.internal.registry.RegistryDelta;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.RegistryObjectFactory;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.registry.TableReader;
import org.eclipse.core.internal.registry.TableWriter;
import org.eclipse.core.internal.registry.spi.ConfigurationElementAttribute;
import org.eclipse.core.internal.registry.spi.ConfigurationElementDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.osgi.storagemanager.StorageManager;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExtensionRegistry
implements IExtensionRegistry {
    private ReadWriteMonitor access = new ReadWriteMonitor();
    private transient Map deltas = new HashMap(11);
    protected StorageManager cacheStorageManager;
    private transient ListenerList listeners = new ListenerList();
    private RegistryObjectManager registryObjects = null;
    protected boolean isRegistryFilledFromCache = false;
    protected TableReader theTableReader = new TableReader(this);
    private Object masterToken;
    private Object userToken;
    protected RegistryStrategy strategy;
    protected RegistryObjectFactory theRegistryObjectFactory = null;
    private RegistryEventThread eventThread = null;
    private final List queue = new LinkedList();

    public RegistryObjectManager getObjectManager() {
        return this.registryObjects;
    }

    protected void setFileManager(File cacheBase, boolean isCacheReadOnly) {
        if (this.cacheStorageManager != null) {
            this.cacheStorageManager.close();
        }
        if (cacheBase != null) {
            this.cacheStorageManager = new StorageManager(cacheBase, isCacheReadOnly ? "none" : null, isCacheReadOnly);
            try {
                this.cacheStorageManager.open(!isCacheReadOnly);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void add(Contribution element) {
        this.access.enterWrite();
        try {
            this.basicAdd(element, true);
            this.fireRegistryChangeEvent();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.access.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.access.exitWrite();
            return;
        }
    }

    static Object concatArrays(Object a, Object b) {
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), Array.getLength(a) + Array.getLength(b));
        System.arraycopy(a, 0, result, 0, Array.getLength(a));
        System.arraycopy(b, 0, result, Array.getLength(a), Array.getLength(b));
        return result;
    }

    private String addExtension(int extension) {
        Extension addedExtension = (Extension)this.registryObjects.getObject(extension, (byte)2);
        String extensionPointToAddTo = addedExtension.getExtensionPointIdentifier();
        ExtensionPoint extPoint = this.registryObjects.getExtensionPointObject(extensionPointToAddTo);
        if (extPoint == null) {
            this.registryObjects.addOrphan(extensionPointToAddTo, extension);
            return null;
        }
        int[] existingExtensions = extPoint.getRawChildren();
        int[] newExtensions = new int[existingExtensions.length + 1];
        System.arraycopy(existingExtensions, 0, newExtensions, 0, existingExtensions.length);
        newExtensions[newExtensions.length - 1] = extension;
        this.link(extPoint, newExtensions);
        return this.recordChange(extPoint, extension, 1);
    }

    private String addExtensionPoint(int extPoint) {
        ExtensionPoint extensionPoint = (ExtensionPoint)this.registryObjects.getObject(extPoint, (byte)3);
        int[] orphans = this.registryObjects.removeOrphans(extensionPoint.getUniqueIdentifier());
        if (orphans == null) {
            return null;
        }
        this.link(extensionPoint, orphans);
        return this.recordChange(extensionPoint, orphans, 1);
    }

    private Set addExtensionsAndExtensionPoints(Contribution element) {
        HashSet<String> affectedNamespaces = new HashSet<String>();
        int[] extPoints = element.getExtensionPoints();
        int i = 0;
        while (i < extPoints.length) {
            String namespace = this.addExtensionPoint(extPoints[i]);
            if (namespace != null) {
                affectedNamespaces.add(namespace);
            }
            ++i;
        }
        int[] extensions = element.getExtensions();
        int i2 = 0;
        while (i2 < extensions.length) {
            String namespace = this.addExtension(extensions[i2]);
            if (namespace != null) {
                affectedNamespaces.add(namespace);
            }
            ++i2;
        }
        return affectedNamespaces;
    }

    public void addRegistryChangeListener(IRegistryChangeListener listener) {
        this.addRegistryChangeListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistryChangeListener(IRegistryChangeListener listener, String filter) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.add((Object)new ListenerInfo(listener, filter));
        }
    }

    private void basicAdd(Contribution element, boolean link) {
        if (element.getNamespace() == null) {
            return;
        }
        this.registryObjects.addContribution(element);
        if (!link) {
            return;
        }
        Set affectedNamespaces = this.addExtensionsAndExtensionPoints(element);
        this.setObjectManagers(affectedNamespaces, this.registryObjects.createDelegatingObjectManager(this.registryObjects.getAssociatedObjects(element.getContributorId())));
    }

    private void setObjectManagers(Set affectedNamespaces, IObjectManager manager) {
        Iterator iter = affectedNamespaces.iterator();
        while (iter.hasNext()) {
            this.getDelta((String)iter.next()).setObjectManager(manager);
        }
    }

    private void basicRemove(String contributorId) {
        Set affectedNamespaces = this.removeExtensionsAndExtensionPoints(contributorId);
        Map associatedObjects = this.registryObjects.getAssociatedObjects(contributorId);
        this.registryObjects.removeObjects(associatedObjects);
        this.registryObjects.addNavigableObjects(associatedObjects);
        this.setObjectManagers(affectedNamespaces, this.registryObjects.createDelegatingObjectManager(associatedObjects));
        this.registryObjects.removeContribution(contributorId);
    }

    void enterRead() {
        this.access.enterRead();
    }

    void exitRead() {
        this.access.exitRead();
    }

    private void fireRegistryChangeEvent() {
        if (this.deltas.isEmpty() || this.listeners.isEmpty()) {
            return;
        }
        Object[] tmpListeners = this.listeners.getListeners();
        HashMap tmpDeltas = new HashMap(this.deltas);
        this.deltas.clear();
        this.strategy.scheduleChangeEvent(tmpListeners, tmpDeltas, this);
    }

    public IConfigurationElement[] getConfigurationElementsFor(String extensionPointId) {
        int lastdot = extensionPointId.lastIndexOf(46);
        if (lastdot == -1) {
            return new IConfigurationElement[0];
        }
        return this.getConfigurationElementsFor(extensionPointId.substring(0, lastdot), extensionPointId.substring(lastdot + 1));
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String extensionPointSimpleId) {
        IExtensionPoint extPoint = this.getExtensionPoint(pluginId, extensionPointSimpleId);
        if (extPoint == null) {
            return new IConfigurationElement[0];
        }
        return extPoint.getConfigurationElements();
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String extensionPointName, String extensionId) {
        IExtension extension = this.getExtension(pluginId, extensionPointName, extensionId);
        if (extension == null) {
            return new IConfigurationElement[0];
        }
        return extension.getConfigurationElements();
    }

    private RegistryDelta getDelta(String namespace) {
        RegistryDelta existingDelta = (RegistryDelta)this.deltas.get(namespace);
        if (existingDelta != null) {
            return existingDelta;
        }
        RegistryDelta delta = new RegistryDelta();
        this.deltas.put(namespace, delta);
        return delta;
    }

    public IExtension getExtension(String extensionId) {
        if (extensionId == null) {
            return null;
        }
        int lastdot = extensionId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        String namespace = extensionId.substring(0, lastdot);
        String[] contributorIds = this.getContributorIds(namespace);
        int i = 0;
        while (i < contributorIds.length) {
            int[] extensions = this.registryObjects.getExtensionsFrom(contributorIds[i]);
            int j = 0;
            while (j < extensions.length) {
                Extension ext = (Extension)this.registryObjects.getObject(extensions[j], (byte)2);
                if (extensionId.equals(ext.getUniqueIdentifier()) && this.registryObjects.getExtensionPointObject(ext.getExtensionPointIdentifier()) != null) {
                    return (IExtension)((Object)this.registryObjects.getHandle(extensions[j], (byte)2));
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public IExtension getExtension(String extensionPointId, String extensionId) {
        int lastdot = extensionPointId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        return this.getExtension(extensionPointId.substring(0, lastdot), extensionPointId.substring(lastdot + 1), extensionId);
    }

    public IExtension getExtension(String pluginId, String extensionPointName, String extensionId) {
        IExtensionPoint extPoint = this.getExtensionPoint(pluginId, extensionPointName);
        if (extPoint != null) {
            return extPoint.getExtension(extensionId);
        }
        return null;
    }

    public IExtensionPoint getExtensionPoint(String xptUniqueId) {
        return this.registryObjects.getExtensionPointHandle(xptUniqueId);
    }

    public IExtensionPoint getExtensionPoint(String elementName, String xpt) {
        this.access.enterRead();
        try {
            ExtensionPointHandle extensionPointHandle = this.registryObjects.getExtensionPointHandle(String.valueOf(elementName) + '.' + xpt);
            Object var3_4 = null;
            this.access.exitRead();
            return extensionPointHandle;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public IExtensionPoint[] getExtensionPoints() {
        this.access.enterRead();
        try {
            IExtensionPoint[] iExtensionPointArray = this.registryObjects.getExtensionPointsHandles();
            Object var1_2 = null;
            this.access.exitRead();
            return iExtensionPointArray;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public IExtensionPoint[] getExtensionPoints(String namespace) {
        this.access.enterRead();
        try {
            String[] contributorIds = this.getContributorIds(namespace);
            IExtensionPoint[] result = ExtensionPointHandle.EMPTY_ARRAY;
            int i = 0;
            while (i < contributorIds.length) {
                result = (IExtensionPoint[])ExtensionRegistry.concatArrays(result, this.registryObjects.getHandles(this.registryObjects.getExtensionPointsFrom(contributorIds[i]), (byte)3));
                ++i;
            }
            IExtensionPoint[] iExtensionPointArray = result;
            Object var5_6 = null;
            this.access.exitRead();
            return iExtensionPointArray;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public IExtension[] getExtensions(String namespace) {
        ArrayList<Handle> tmp;
        block6: {
            this.access.enterRead();
            try {
                String[] contributorIds = this.getContributorIds(namespace);
                tmp = new ArrayList<Handle>();
                int i = 0;
                while (i < contributorIds.length) {
                    Extension[] exts = (Extension[])this.registryObjects.getObjects(this.registryObjects.getExtensionsFrom(contributorIds[i]), (byte)2);
                    int j = 0;
                    while (j < exts.length) {
                        if (this.registryObjects.getExtensionPointObject(exts[j].getExtensionPointIdentifier()) != null) {
                            tmp.add(this.registryObjects.getHandle(exts[j].getObjectId(), (byte)2));
                        }
                        ++j;
                    }
                    ++i;
                }
                if (tmp.size() != 0) break block6;
                IExtension[] iExtensionArray = ExtensionHandle.EMPTY_ARRAY;
                Object var7_10 = null;
                this.access.exitRead();
                return iExtensionArray;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                this.access.exitRead();
                throw throwable;
            }
        }
        IExtension[] result = new IExtension[tmp.size()];
        IExtension[] iExtensionArray = tmp.toArray(result);
        Object var7_11 = null;
        this.access.exitRead();
        return iExtensionArray;
    }

    public String[] getNamespaces() {
        this.access.enterRead();
        try {
            Set namespaces = this.registryObjects.getNamespaces();
            String[] result = new String[namespaces.size()];
            String[] stringArray = namespaces.toArray(result);
            Object var3_4 = null;
            this.access.exitRead();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    public boolean hasNamespace(String name) {
        this.access.enterRead();
        try {
            boolean bl = this.registryObjects.hasContribution(name);
            Object var2_3 = null;
            this.access.exitRead();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.access.exitRead();
            throw throwable;
        }
    }

    private void link(ExtensionPoint extPoint, int[] extensions) {
        extPoint.setRawChildren(extensions);
        this.registryObjects.add(extPoint, true);
    }

    private String recordChange(ExtensionPoint extPoint, int extension, int kind) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        ExtensionDelta extensionDelta = new ExtensionDelta();
        extensionDelta.setExtension(extension);
        extensionDelta.setExtensionPoint(extPoint.getObjectId());
        extensionDelta.setKind(kind);
        this.getDelta(extPoint.getNamespace()).addExtensionDelta(extensionDelta);
        return extPoint.getNamespace();
    }

    private String recordChange(ExtensionPoint extPoint, int[] extensions, int kind) {
        if (this.listeners.isEmpty()) {
            return null;
        }
        if (extensions == null || extensions.length == 0) {
            return null;
        }
        RegistryDelta pluginDelta = this.getDelta(extPoint.getNamespace());
        int i = 0;
        while (i < extensions.length) {
            ExtensionDelta extensionDelta = new ExtensionDelta();
            extensionDelta.setExtension(extensions[i]);
            extensionDelta.setExtensionPoint(extPoint.getObjectId());
            extensionDelta.setKind(kind);
            pluginDelta.addExtensionDelta(extensionDelta);
            ++i;
        }
        return extPoint.getNamespace();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String removedContributorId) {
        this.access.enterWrite();
        try {
            this.basicRemove(removedContributorId);
            this.fireRegistryChangeEvent();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.access.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.access.exitWrite();
            return;
        }
    }

    private String removeExtension(int extensionId) {
        Extension extension = (Extension)this.registryObjects.getObject(extensionId, (byte)2);
        String xptName = extension.getExtensionPointIdentifier();
        ExtensionPoint extPoint = this.registryObjects.getExtensionPointObject(xptName);
        if (extPoint == null) {
            this.registryObjects.removeOrphan(xptName, extensionId);
            return null;
        }
        int[] existingExtensions = extPoint.getRawChildren();
        int[] newExtensions = RegistryObjectManager.EMPTY_INT_ARRAY;
        if (existingExtensions.length > 1) {
            if (existingExtensions.length == 1) {
                newExtensions = RegistryObjectManager.EMPTY_INT_ARRAY;
            }
            newExtensions = new int[existingExtensions.length - 1];
            int i = 0;
            int j = 0;
            while (i < existingExtensions.length) {
                if (existingExtensions[i] != extension.getObjectId()) {
                    newExtensions[j++] = existingExtensions[i];
                }
                ++i;
            }
        }
        this.link(extPoint, newExtensions);
        return this.recordChange(extPoint, extension.getObjectId(), 2);
    }

    private String removeExtensionPoint(int extPoint) {
        ExtensionPoint extensionPoint = (ExtensionPoint)this.registryObjects.getObject(extPoint, (byte)3);
        int[] existingExtensions = extensionPoint.getRawChildren();
        if (existingExtensions == null || existingExtensions.length == 0) {
            return null;
        }
        this.registryObjects.addOrphans(extensionPoint.getUniqueIdentifier(), existingExtensions);
        this.link(extensionPoint, RegistryObjectManager.EMPTY_INT_ARRAY);
        return this.recordChange(extensionPoint, existingExtensions, 2);
    }

    private Set removeExtensionsAndExtensionPoints(String contributorId) {
        HashSet<String> affectedNamespaces = new HashSet<String>();
        int[] extensions = this.registryObjects.getExtensionsFrom(contributorId);
        int i = 0;
        while (i < extensions.length) {
            String namespace = this.removeExtension(extensions[i]);
            if (namespace != null) {
                affectedNamespaces.add(namespace);
            }
            ++i;
        }
        int[] extPoints = this.registryObjects.getExtensionPointsFrom(contributorId);
        int i2 = 0;
        while (i2 < extPoints.length) {
            String namespace = this.removeExtensionPoint(extPoints[i2]);
            if (namespace != null) {
                affectedNamespaces.add(namespace);
            }
            ++i2;
        }
        return affectedNamespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRegistryChangeListener(IRegistryChangeListener listener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.remove((Object)new ListenerInfo(listener, null));
        }
    }

    public ExtensionRegistry(RegistryStrategy registryStrategy, Object masterToken, Object userToken) {
        this.strategy = registryStrategy != null ? registryStrategy : new RegistryStrategy(null, true);
        this.setFileManager(this.strategy.getStorage(), this.strategy.isCacheReadOnly());
        this.masterToken = masterToken;
        this.userToken = userToken;
        this.registryObjects = new RegistryObjectManager(this);
        if (this.strategy.cacheUse()) {
            long start = 0L;
            if (this.debug()) {
                start = System.currentTimeMillis();
            }
            if (this.checkCache()) {
                try {
                    this.theTableReader.setTableFile(this.cacheStorageManager.lookup(".table", false));
                    this.theTableReader.setExtraDataFile(this.cacheStorageManager.lookup(".extraData", false));
                    this.theTableReader.setMainDataFile(this.cacheStorageManager.lookup(".mainData", false));
                    this.theTableReader.setContributionsFile(this.cacheStorageManager.lookup(".contributions", false));
                    this.theTableReader.setOrphansFile(this.cacheStorageManager.lookup(".orphans", false));
                    this.isRegistryFilledFromCache = this.registryObjects.init(this.computeTimeStamp());
                }
                catch (IOException e) {
                    this.isRegistryFilledFromCache = false;
                    this.clearRegistryCache();
                    this.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, RegistryMessages.registry_bad_cache, (Throwable)e));
                }
            }
            if (this.debug() && this.isRegistryFilledFromCache) {
                System.out.println("Reading registry cache: " + (System.currentTimeMillis() - start));
            }
            if (this.debug()) {
                if (!this.isRegistryFilledFromCache) {
                    System.out.println("Reloading registry from manifest files...");
                } else {
                    System.out.println("Using registry cache...");
                }
            }
        }
        if (this.debugEvents()) {
            this.addRegistryChangeListener(new IRegistryChangeListener(){

                public void registryChanged(IRegistryChangeEvent event) {
                    System.out.println(event);
                }
            });
        }
        this.strategy.onStart(this);
    }

    public void stop(Object key) {
        if (this.masterToken != null && this.masterToken != key) {
            throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.stop() method. Check if proper access token is supplied.");
        }
        this.strategy.onStop(this);
        this.stopChangeEventScheduler();
        if (this.cacheStorageManager == null) {
            return;
        }
        if (!this.registryObjects.isDirty() || this.cacheStorageManager.isReadOnly()) {
            this.cacheStorageManager.close();
            return;
        }
        File tableFile = null;
        File mainFile = null;
        File extraFile = null;
        File contributionsFile = null;
        File orphansFile = null;
        TableWriter theTableWriter = new TableWriter(this);
        try {
            this.cacheStorageManager.lookup(".table", true);
            this.cacheStorageManager.lookup(".mainData", true);
            this.cacheStorageManager.lookup(".extraData", true);
            this.cacheStorageManager.lookup(".contributions", true);
            this.cacheStorageManager.lookup(".orphans", true);
            tableFile = File.createTempFile(".table", ".new", this.cacheStorageManager.getBase());
            mainFile = File.createTempFile(".mainData", ".new", this.cacheStorageManager.getBase());
            extraFile = File.createTempFile(".extraData", ".new", this.cacheStorageManager.getBase());
            contributionsFile = File.createTempFile(".contributions", ".new", this.cacheStorageManager.getBase());
            orphansFile = File.createTempFile(".orphans", ".new", this.cacheStorageManager.getBase());
            theTableWriter.setTableFile(tableFile);
            theTableWriter.setExtraDataFile(extraFile);
            theTableWriter.setMainDataFile(mainFile);
            theTableWriter.setContributionsFile(contributionsFile);
            theTableWriter.setOrphansFile(orphansFile);
        }
        catch (IOException iOException) {
            this.cacheStorageManager.close();
            return;
        }
        try {
            if (theTableWriter.saveCache(this.registryObjects, this.computeTimeStamp())) {
                this.cacheStorageManager.update(new String[]{".table", ".mainData", ".extraData", ".contributions", ".orphans"}, new String[]{tableFile.getName(), mainFile.getName(), extraFile.getName(), contributionsFile.getName(), orphansFile.getName()});
            }
        }
        catch (IOException iOException) {}
        this.theTableReader.close();
        this.cacheStorageManager.close();
    }

    public void clearRegistryCache() {
        String[] keys = new String[]{".table", ".mainData", ".extraData", ".contributions", ".orphans"};
        int i = 0;
        while (i < keys.length) {
            try {
                this.cacheStorageManager.remove(keys[i]);
            }
            catch (IOException e) {
                this.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 4, RegistryMessages.meta_registryCacheReadProblems, (Throwable)e));
            }
            ++i;
        }
    }

    protected void setElementFactory() {
        this.theRegistryObjectFactory = new RegistryObjectFactory(this);
    }

    public RegistryObjectFactory getElementFactory() {
        if (this.theRegistryObjectFactory == null) {
            this.setElementFactory();
        }
        return this.theRegistryObjectFactory;
    }

    TableReader getTableReader() {
        return this.theTableReader;
    }

    public void log(IStatus status) {
        this.strategy.log(status);
    }

    public String translate(String key, ResourceBundle resources) {
        return this.strategy.translate(key, resources);
    }

    public boolean debug() {
        return this.strategy.debug();
    }

    public boolean debugEvents() {
        return this.strategy.debugRegistryEvents();
    }

    public boolean useLazyCacheLoading() {
        return this.strategy.cacheLazyLoading();
    }

    public long computeState() {
        return this.strategy.cacheComputeState();
    }

    public long computeTimeStamp() {
        return this.strategy.cacheComputeTimeStamp();
    }

    protected boolean checkCache() {
        File cacheFile = null;
        if (this.cacheStorageManager != null) {
            try {
                cacheFile = this.cacheStorageManager.lookup(TableReader.getTestFileName(), false);
            }
            catch (IOException iOException) {}
        }
        if (cacheFile != null && cacheFile.isFile()) {
            return true;
        }
        File alternativeBase = this.strategy.cacheAlternativeLocation();
        if (alternativeBase != null) {
            this.setFileManager(alternativeBase, true);
            if (this.cacheStorageManager != null) {
                cacheFile = null;
                try {
                    cacheFile = this.cacheStorageManager.lookup(TableReader.getTestFileName(), false);
                }
                catch (IOException iOException) {}
                return cacheFile != null && cacheFile.isFile();
            }
        }
        return false;
    }

    public boolean filledFromCache() {
        return this.isRegistryFilledFromCache;
    }

    public Object processExecutableExtension(String contributorName, String namespaceOwnerId, String namespaceName, String className, Object initData, String propertyName, ConfigurationElement confElement) throws CoreException {
        ConfigurationElementHandle confElementHandle = new ConfigurationElementHandle(this.getObjectManager(), confElement.getObjectId());
        return this.strategy.createExecutableExtension(contributorName, namespaceOwnerId, namespaceName, className, initData, propertyName, confElementHandle);
    }

    public String getNamespaceOwnerId(String contributorId) {
        return this.strategy.getNamespaceOwnerId(contributorId);
    }

    public String getNamespace(String contributorId) {
        return this.strategy.getNamespace(contributorId);
    }

    public String[] getContributorIds(String namespace) {
        return this.strategy.getNamespaceContributors(namespace);
    }

    public IStatus processChangeEvent(Object[] listenerInfos, Map deltas) {
        MultiStatus result = new MultiStatus("org.eclipse.equinox.registry", 0, RegistryMessages.plugin_eventListenerError, null);
        int i = 0;
        while (i < listenerInfos.length) {
            ListenerInfo listenerInfo = (ListenerInfo)listenerInfos[i];
            if ((listenerInfo.filter == null || deltas.containsKey(listenerInfo.filter)) && listenerInfo.listener instanceof IRegistryChangeListener) {
                listenerInfo.listener.registryChanged(new RegistryChangeEvent(deltas, listenerInfo.filter));
            }
            ++i;
        }
        Iterator iter = deltas.values().iterator();
        while (iter.hasNext()) {
            ((RegistryDelta)iter.next()).getObjectManager().close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleChangeEvent(Object[] listenerInfos, Map deltas) {
        QueueElement newElement = new QueueElement(listenerInfos, deltas);
        if (this.eventThread == null) {
            this.eventThread = new RegistryEventThread(this);
            this.eventThread.start();
        }
        List list = this.queue;
        synchronized (list) {
            this.queue.add(newElement);
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopChangeEventScheduler() {
        if (this.eventThread != null) {
            List list = this.queue;
            synchronized (list) {
                this.eventThread.interrupt();
                this.eventThread = null;
            }
        }
    }

    private boolean checkReadWriteAccess(Object key, boolean persist) {
        if (this.strategy.isModifiable()) {
            return true;
        }
        if (this.masterToken == key) {
            return true;
        }
        return this.userToken == key && !persist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addContribution(InputStream is, String contributorId, boolean persist, String contributionName, ResourceBundle b, Object key) {
        Contribution contribution;
        block16: {
            if (!this.checkReadWriteAccess(key, persist)) {
                throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.addXMLContribution() method. Check if proper access token is supplied.");
            }
            if (contributionName == null) {
                contributionName = "";
            }
            String ownerName = this.getNamespace(contributorId);
            String message = NLS.bind((String)RegistryMessages.parse_problems, (Object)ownerName);
            MultiStatus problems = new MultiStatus("org.eclipse.equinox.registry", 1, message, null);
            ExtensionsParser parser = new ExtensionsParser(problems, this);
            contribution = this.getElementFactory().createContribution(contributorId, persist);
            try {
                try {
                    parser.parseManifest(this.strategy.getXMLParser(), new InputSource(is), contributionName, this.getObjectManager(), contribution, b);
                    if (problems.getSeverity() == 0) break block16;
                    this.log((IStatus)problems);
                    Object var13_12 = null;
                }
                catch (ParserConfigurationException e) {
                    this.logError(ownerName, contributionName, e);
                    Object var13_13 = null;
                    try {
                        is.close();
                        return false;
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                catch (SAXException e) {
                    this.logError(ownerName, contributionName, e);
                    Object var13_14 = null;
                    try {}
                    catch (IOException iOException) {}
                    is.close();
                    return false;
                }
                catch (IOException e) {
                    this.logError(ownerName, contributionName, e);
                    Object var13_15 = null;
                    try {}
                    catch (IOException iOException) {}
                    is.close();
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {}
                catch (IOException iOException) {}
                is.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            is.close();
            return false;
        }
        Object var13_17 = null;
        try {}
        catch (IOException iOException) {}
        is.close();
        this.add(contribution);
        return true;
    }

    private void logError(String owner, String contributionName, Exception e) {
        String message = NLS.bind((String)RegistryMessages.parse_failedParsingManifest, (Object)(String.valueOf(owner) + "/" + contributionName));
        this.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, message, (Throwable)e));
    }

    public void addExtensionPoint(String identifier, String contributorId, boolean persist, String label, String schemaReference, Object token) throws IllegalArgumentException {
        if (!this.checkReadWriteAccess(token, persist)) {
            throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.addExtensionPoint() method. Check if proper access token is supplied.");
        }
        if (identifier == null) {
            String message = NLS.bind((String)RegistryMessages.create_failedExtensionPoint, (Object)label);
            this.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, message, null));
        }
        if (schemaReference == null) {
            schemaReference = "";
        }
        String namespaceName = this.getNamespace(contributorId);
        String namespaceOwnerId = this.getNamespaceOwnerId(contributorId);
        Contribution contribution = this.getElementFactory().createContribution(contributorId, persist);
        ExtensionPoint currentExtPoint = this.getElementFactory().createExtensionPoint(persist);
        String uniqueId = String.valueOf(namespaceName) + '.' + identifier;
        currentExtPoint.setUniqueIdentifier(uniqueId);
        String labelNLS = this.translate(label, null);
        currentExtPoint.setLabel(labelNLS);
        currentExtPoint.setSchema(schemaReference);
        this.getObjectManager().addExtensionPoint(currentExtPoint, true);
        currentExtPoint.setNamespace(namespaceName);
        currentExtPoint.setNamespaceOwnerId(namespaceOwnerId);
        int[] contributionChildren = new int[]{1, 0, currentExtPoint.getObjectId()};
        contribution.setRawChildren(contributionChildren);
        this.add(contribution);
    }

    public void addExtension(String identifier, String contributorId, boolean persist, String label, String extensionPointId, ConfigurationElementDescription configurationElements, Object token) throws IllegalArgumentException {
        if (!this.checkReadWriteAccess(token, persist)) {
            throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.addExtensionPoint() method. Check if proper access token is supplied.");
        }
        String namespaceName = this.getNamespace(contributorId);
        String namespaceOwnerId = this.getNamespaceOwnerId(contributorId);
        Contribution contribution = this.getElementFactory().createContribution(contributorId, persist);
        Extension currentExtension = this.getElementFactory().createExtension(persist);
        currentExtension.setSimpleIdentifier(identifier);
        String extensionLabelNLS = this.translate(label, null);
        currentExtension.setLabel(extensionLabelNLS);
        String targetExtensionPointId = extensionPointId.indexOf(46) == -1 ? String.valueOf(namespaceName) + '.' + extensionPointId : extensionPointId;
        currentExtension.setExtensionPointIdentifier(targetExtensionPointId);
        this.getObjectManager().add(currentExtension, true);
        this.createExtensionData(namespaceOwnerId, configurationElements, currentExtension, persist);
        currentExtension.setNamespaceName(namespaceName);
        int[] contributionChildren = new int[]{0, 1, currentExtension.getObjectId()};
        contribution.setRawChildren(contributionChildren);
        this.add(contribution);
    }

    private void createExtensionData(String namespaceOwnerId, ConfigurationElementDescription description, RegistryObject parent, boolean persist) {
        int i;
        ConfigurationElement currentConfigurationElement = this.getElementFactory().createConfigurationElement(persist);
        currentConfigurationElement.setNamespaceOwnerId(namespaceOwnerId);
        currentConfigurationElement.setName(description.getName());
        ConfigurationElementAttribute[] descriptionProperties = description.getAttributes();
        if (descriptionProperties != null && descriptionProperties.length != 0) {
            int len = descriptionProperties.length;
            String[] properties = new String[len * 2];
            i = 0;
            while (i < len) {
                properties[i * 2] = descriptionProperties[i].getName();
                properties[i * 2 + 1] = this.translate(descriptionProperties[i].getValue(), null);
                ++i;
            }
            currentConfigurationElement.setProperties(properties);
        } else {
            currentConfigurationElement.setProperties(RegistryObjectManager.EMPTY_STRING_ARRAY);
        }
        String value = description.getValue();
        if (value != null) {
            currentConfigurationElement.setValue(value);
        }
        this.getObjectManager().add(currentConfigurationElement, true);
        ConfigurationElementDescription[] children = description.getChildren();
        if (children != null) {
            i = 0;
            while (i < children.length) {
                this.createExtensionData(namespaceOwnerId, children[i], currentConfigurationElement, persist);
                ++i;
            }
        }
        int[] oldValues = parent.getRawChildren();
        int size = oldValues.length;
        int[] newValues = new int[size + 1];
        int i2 = 0;
        while (i2 < size) {
            newValues[i2] = oldValues[i2];
            ++i2;
        }
        newValues[size] = currentConfigurationElement.getObjectId();
        parent.setRawChildren(newValues);
        currentConfigurationElement.setParentId(parent.getObjectId());
        currentConfigurationElement.setParentType(parent instanceof ConfigurationElement ? (byte)1 : 2);
    }

    public boolean removeExtension(IExtension extension, Object token) throws IllegalArgumentException {
        if (!(extension instanceof ExtensionHandle)) {
            return false;
        }
        return this.removeObject(((ExtensionHandle)extension).getObject(), false, token);
    }

    public boolean removeExtensionPoint(IExtensionPoint extensionPoint, Object token) throws IllegalArgumentException {
        if (!(extensionPoint instanceof ExtensionPointHandle)) {
            return false;
        }
        return this.removeObject(((ExtensionPointHandle)extensionPoint).getObject(), true, token);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean removeObject(RegistryObject registryObject, boolean isExtensionPoint, Object token) {
        if (!this.checkReadWriteAccess(token, registryObject.shouldPersist())) {
            throw new IllegalArgumentException("Unauthorized access to the ExtensionRegistry.removeExtension() method. Check if proper access token is supplied.");
        }
        int id = registryObject.getObjectId();
        this.access.enterWrite();
        try {
            String namespace = isExtensionPoint ? this.removeExtensionPoint(id) : this.removeExtension(id);
            HashMap<Integer, RegistryObject> removed = new HashMap<Integer, RegistryObject>(1);
            removed.put(new Integer(id), registryObject);
            this.registryObjects.removeObjects(removed);
            this.registryObjects.addNavigableObjects(removed);
            this.getDelta(namespace).setObjectManager(this.registryObjects.createDelegatingObjectManager(removed));
            String[] possibleContributors = this.strategy.getNamespaceContributors(namespace);
            int i = 0;
            while (i < possibleContributors.length) {
                Contribution contribution = this.registryObjects.getContribution(possibleContributors[i]);
                if (contribution.hasChild(id)) {
                    contribution.unlinkChild(id);
                    if (!contribution.isEmpty()) break;
                    this.registryObjects.removeContribution(possibleContributors[i]);
                    break;
                }
                ++i;
            }
            this.fireRegistryChangeEvent();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.access.exitWrite();
            throw throwable;
        }
        {
            Object var10_12 = null;
            this.access.exitWrite();
            return true;
        }
    }

    public Object getTemporaryUserToken() {
        return this.userToken;
    }

    protected class ListenerInfo {
        public String filter;
        public IRegistryChangeListener listener;

        public ListenerInfo(IRegistryChangeListener listener, String filter) {
            this.listener = listener;
            this.filter = filter;
        }

        public boolean equals(Object another) {
            return another instanceof ListenerInfo && ((ListenerInfo)another).listener == this.listener;
        }
    }

    private class QueueElement {
        Object[] listenerInfos;
        Map deltas;

        QueueElement(Object[] infos, Map deltas) {
            this.deltas = deltas;
            this.listenerInfos = infos;
        }
    }

    private class RegistryEventThread
    extends Thread {
        private ExtensionRegistry registry;

        public RegistryEventThread(ExtensionRegistry registry) {
            super("Extension Registry Event Dispatcher");
            this.setDaemon(true);
            this.registry = registry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                QueueElement element;
                List list = ExtensionRegistry.this.queue;
                synchronized (list) {
                    try {
                        while (ExtensionRegistry.this.queue.isEmpty()) {
                            ExtensionRegistry.this.queue.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    element = (QueueElement)ExtensionRegistry.this.queue.remove(0);
                }
                this.registry.processChangeEvent(element.listenerInfos, element.deltas);
            }
        }
    }
}

