/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.PlatformAdmin;

public class EquinoxRegistryStrategy
extends RegistryStrategyOSGI {
    public static final String PLUGIN_NAME = "org.eclipse.equinox.registry";
    public static final String OPTION_DEBUG = "org.eclipse.equinox.registry/debug";
    public static final String OPTION_DEBUG_EVENTS = "org.eclipse.equinox.registry/debug/events";
    private static boolean DEBUG_ECLIPSE_REGISTRY = OSGIUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.registry/debug", false);
    private static boolean DEBUG_ECLIPSE_EVENTS = OSGIUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.registry/debug/events", false);

    public EquinoxRegistryStrategy(File theStorageDir, boolean cacheReadOnly, Object key) {
        super(theStorageDir, cacheReadOnly, key);
    }

    public boolean debug() {
        return DEBUG_ECLIPSE_REGISTRY;
    }

    public boolean debugRegistryEvents() {
        return DEBUG_ECLIPSE_EVENTS;
    }

    public final void log(IStatus status) {
        RuntimeLog.log((IStatus)status);
    }

    public long cacheComputeState() {
        PlatformAdmin admin = OSGIUtils.getDefault().getPlatformAdmin();
        return admin == null ? -1L : admin.getState(false).getTimeStamp();
    }

    public File cacheAlternativeLocation() {
        Location currentLocation = OSGIUtils.getDefault().getConfigurationLocation();
        if (currentLocation == null) {
            return null;
        }
        Location parentLocation = currentLocation.getParentLocation();
        if (parentLocation == null) {
            return null;
        }
        String theRegistryLocation = String.valueOf(parentLocation.getURL().getFile()) + '/' + "org.eclipse.core.runtime";
        return new File(theRegistryLocation);
    }
}

