/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.ReferenceMap;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.Activator;
import org.eclipse.core.internal.registry.osgi.EclipseBundleListener;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class RegistryStrategyOSGI
extends RegistryStrategy {
    private Object token;
    protected boolean DEBUG;
    protected boolean DEBUG_REGISTRY_EVENTS;
    private ServiceTracker xmlTracker = null;
    private static float DEFAULT_BUNDLECACHE_LOADFACTOR = 0.75f;
    private static int DEFAULT_BUNDLECACHE_SIZE = 200;
    private ReferenceMap bundleMap = new ReferenceMap(1, DEFAULT_BUNDLECACHE_SIZE, DEFAULT_BUNDLECACHE_LOADFACTOR);
    private EclipseBundleListener pluginBundleListener = null;
    static /* synthetic */ Class class$0;

    public RegistryStrategyOSGI(File theStorageDir, boolean cacheReadOnly, Object key) {
        super(theStorageDir, cacheReadOnly);
        this.token = key;
    }

    public boolean isModifiable() {
        return false;
    }

    public final String translate(String key, ResourceBundle resources) {
        return ResourceTranslator.getResourceString(null, (String)key, (ResourceBundle)resources);
    }

    public final void scheduleChangeEvent(Object[] listeners, Map deltas, Object registry) {
        new ExtensionEventDispatcherJob(listeners, deltas, registry).schedule();
    }

    public Bundle getBundle(String id) {
        long OSGiId;
        if (id == null) {
            return null;
        }
        try {
            OSGiId = Long.parseLong(id);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        Bundle bundle = (Bundle)this.bundleMap.get((int)OSGiId);
        if (bundle != null) {
            return bundle;
        }
        bundle = Activator.getContext().getBundle(OSGiId);
        this.bundleMap.put((int)OSGiId, bundle);
        return bundle;
    }

    public static String getId(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        return Long.toString(bundle.getBundleId());
    }

    private Bundle getNamespaceBundle(String contributingBundleId) {
        Bundle[] hosts;
        Bundle contributingBundle = this.getBundle(contributingBundleId);
        if (contributingBundle == null) {
            throw new IllegalStateException("Internal error in extension registry. The bundle corresponding to this contribution has been uninstalled.");
        }
        if (OSGIUtils.getDefault().isFragment(contributingBundle) && (hosts = OSGIUtils.getDefault().getHosts(contributingBundle)) != null) {
            return hosts[0];
        }
        return contributingBundle;
    }

    public String getNamespaceOwnerId(String contributorId) {
        if (contributorId == null) {
            return null;
        }
        Bundle namespaceBundle = this.getNamespaceBundle(contributorId);
        return RegistryStrategyOSGI.getId(namespaceBundle);
    }

    public String getNamespace(String contributorId) {
        if (contributorId == null) {
            return null;
        }
        Bundle namespaceBundle = this.getNamespaceBundle(contributorId);
        if (namespaceBundle == null) {
            return null;
        }
        return namespaceBundle.getSymbolicName();
    }

    public String[] getNamespaceContributors(String namespace) {
        Bundle correspondingHost = OSGIUtils.getDefault().getBundle(namespace);
        if (correspondingHost == null) {
            return new String[0];
        }
        Bundle[] fragments = OSGIUtils.getDefault().getFragments(correspondingHost);
        if (fragments == null) {
            return new String[]{RegistryStrategyOSGI.getId(correspondingHost)};
        }
        String[] result = new String[fragments.length + 1];
        int i = 0;
        while (i < fragments.length) {
            result[i] = RegistryStrategyOSGI.getId(fragments[i]);
            ++i;
        }
        result[fragments.length] = RegistryStrategyOSGI.getId(correspondingHost);
        return result;
    }

    public Object createExecutableExtension(String pluginName, String namespaceOwnerId, String namespaceName, String className, Object initData, String propertyName, IConfigurationElement confElement) throws CoreException {
        if (pluginName != null && !pluginName.equals("") && !pluginName.equals(namespaceName)) {
            Bundle otherBundle = null;
            otherBundle = OSGIUtils.getDefault().getBundle(pluginName);
            return this.createExecutableExtension(otherBundle, className, initData, propertyName, confElement);
        }
        Bundle contributingBundle = this.getBundle(namespaceOwnerId);
        return this.createExecutableExtension(contributingBundle, className, initData, propertyName, confElement);
    }

    private Object createExecutableExtension(Bundle bundle, String className, Object initData, String propertyName, IConfigurationElement confElement) throws CoreException {
        Class classInstance = null;
        try {
            classInstance = bundle.loadClass(className);
        }
        catch (Exception e1) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)bundle.getSymbolicName(), (Object)className), e1);
        }
        catch (LinkageError e) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)bundle.getSymbolicName(), (Object)className), e);
        }
        Object result = null;
        try {
            result = classInstance.newInstance();
        }
        catch (Exception e) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_instantiateClassError, (Object)bundle.getSymbolicName(), (Object)className), e);
        }
        return result;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.registry", 1, message, exception));
    }

    public void onStart(Object registry) {
        super.onStart(registry);
        if (!(registry instanceof ExtensionRegistry)) {
            return;
        }
        ExtensionRegistry theRegistry = (ExtensionRegistry)registry;
        this.pluginBundleListener = new EclipseBundleListener(theRegistry, this.token);
        Activator.getContext().addBundleListener((BundleListener)this.pluginBundleListener);
        if (!theRegistry.filledFromCache()) {
            this.pluginBundleListener.processBundles(Activator.getContext().getBundles());
        }
    }

    public void onStop(Object registry) {
        if (this.pluginBundleListener != null) {
            Activator.getContext().removeBundleListener((BundleListener)this.pluginBundleListener);
        }
        if (this.xmlTracker != null) {
            this.xmlTracker.close();
            this.xmlTracker = null;
        }
        super.onStop(registry);
    }

    public boolean cacheUse() {
        return !"true".equals(System.getProperty("eclipse.noRegistryCache"));
    }

    public boolean cacheLazyLoading() {
        return !"true".equalsIgnoreCase(System.getProperty("eclipse.noLazyRegistryCacheLoading"));
    }

    public long cacheComputeTimeStamp() {
        if (!"true".equalsIgnoreCase(System.getProperty("osgi.checkConfiguration"))) {
            return 0L;
        }
        BundleContext context = Activator.getContext();
        if (context == null) {
            return 0L;
        }
        Bundle[] allBundles = context.getBundles();
        long result = 0L;
        int i = 0;
        while (i < allBundles.length) {
            URL pluginManifest = allBundles[i].getEntry("plugin.xml");
            if (pluginManifest == null) {
                pluginManifest = allBundles[i].getEntry("fragment.xml");
            }
            if (pluginManifest != null) {
                try {
                    URLConnection connection = pluginManifest.openConnection();
                    result ^= connection.getLastModified() + allBundles[i].getBundleId();
                }
                catch (IOException iOException) {
                    return 0L;
                }
            }
            ++i;
        }
        return result;
    }

    public SAXParserFactory getXMLParser() {
        if (this.xmlTracker == null) {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.xml.parsers.SAXParserFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.xmlTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            this.xmlTracker.open();
        }
        return (SAXParserFactory)this.xmlTracker.getService();
    }

    private static final class ExtensionEventDispatcherJob
    extends Job {
        private static final ISchedulingRule EXTENSION_EVENT_RULE = new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this;
            }
        };
        private Map deltas;
        private Object[] listenerInfos;
        private Object registry;

        public ExtensionEventDispatcherJob(Object[] listenerInfos, Map deltas, Object registry) {
            super("Registry event dispatcher");
            this.setSystem(true);
            this.listenerInfos = listenerInfos;
            this.deltas = deltas;
            this.registry = registry;
            this.setRule(EXTENSION_EVENT_RULE);
        }

        public IStatus run(IProgressMonitor monitor) {
            return RegistryStrategy.processChangeEvent(this.listenerInfos, this.deltas, this.registry);
        }
    }
}

