/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.spi;

import java.io.File;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistrySupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RegistryStrategy {
    private final File theStorageDir;
    private final boolean cacheReadOnly;
    private SAXParserFactory theXMLParserFactory = null;

    public RegistryStrategy(File theStorageDir, boolean cacheReadOnly) {
        this.theStorageDir = theStorageDir;
        this.cacheReadOnly = cacheReadOnly;
    }

    public final File getStorage() {
        return this.theStorageDir;
    }

    public final boolean isCacheReadOnly() {
        return this.cacheReadOnly;
    }

    public boolean isModifiable() {
        return true;
    }

    public void log(IStatus status) {
        RegistrySupport.log(status, null);
    }

    public String translate(String key, ResourceBundle resources) {
        return RegistrySupport.translate(key, resources);
    }

    public void onStart(Object registry) {
    }

    public void onStop(Object registry) {
    }

    public String getNamespaceOwnerId(String contributorId) {
        return contributorId;
    }

    public String getNamespace(String contributorId) {
        return contributorId;
    }

    public String[] getNamespaceContributors(String namespace) {
        return new String[]{namespace};
    }

    public Object createExecutableExtension(String contributorName, String namespaceOwnerId, String namespaceName, String className, Object initData, String propertyName, IConfigurationElement theConfElement) throws CoreException {
        Object result = null;
        Class<?> classInstance = null;
        try {
            classInstance = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            String message = NLS.bind((String)RegistryMessages.exExt_findClassError, (Object)this.getNamespace(namespaceOwnerId), (Object)className);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.registry", 1, message, (Throwable)e1));
        }
        try {
            result = classInstance.newInstance();
        }
        catch (Exception e) {
            String message = NLS.bind((String)RegistryMessages.exExt_instantiateClassError, (Object)this.getNamespace(namespaceOwnerId), (Object)className);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.registry", 1, message, (Throwable)e));
        }
        return result;
    }

    public void scheduleChangeEvent(Object[] listeners, Map deltas, Object registry) {
        if (registry instanceof ExtensionRegistry) {
            ((ExtensionRegistry)registry).scheduleChangeEvent(listeners, deltas);
        }
    }

    public static final IStatus processChangeEvent(Object[] listeners, Map deltas, Object registry) {
        if (registry instanceof ExtensionRegistry) {
            return ((ExtensionRegistry)registry).processChangeEvent(listeners, deltas);
        }
        return null;
    }

    public boolean debug() {
        return false;
    }

    public boolean debugRegistryEvents() {
        return false;
    }

    public boolean cacheUse() {
        return true;
    }

    public boolean cacheLazyLoading() {
        return true;
    }

    public long cacheComputeState() {
        return 0L;
    }

    public long cacheComputeTimeStamp() {
        return 0L;
    }

    public File cacheAlternativeLocation() {
        return null;
    }

    public SAXParserFactory getXMLParser() {
        if (this.theXMLParserFactory == null) {
            this.theXMLParserFactory = SAXParserFactory.newInstance();
        }
        return this.theXMLParserFactory;
    }
}

