/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.datatransfer.BuildFileCreator;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.ant.internal.ui.datatransfer.EclipseClasspath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ExportUtil {
    private static Comparator javaProjectComparator;
    private static Comparator classnameComparator;
    private static Comparator fileComparator;
    private static Comparator typeComparator;
    public static final String NEWLINE;
    private static IFileModificationValidator defaultValidator;
    static /* synthetic */ Class class$0;

    static {
        NEWLINE = System.getProperty("line.separator");
    }

    private ExportUtil() {
    }

    public static IResource getResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            if (iter.hasNext()) {
                IAdaptable adaptable = (IAdaptable)iter.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (IResource)adaptable.getAdapter((Class)clazz);
            }
        }
        return null;
    }

    public static IJavaProject getJavaProjectByName(String name) {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject javaProject = javaProjects[i];
            if (name.equals(javaProject.getProject().getName())) {
                return javaProject;
            }
            ++i;
        }
        return null;
    }

    public static String getProjectRoot(IJavaProject project) {
        return project.getResource().getLocation().toString();
    }

    public static String resolve(IPath file) {
        if (file == null) {
            return null;
        }
        try {
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(file);
            IPath p = f.getLocation();
            return p != null ? p.toString() : f.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String projectName = ExportUtil.removePrefix(file.toString(), "/");
            IJavaProject project = ExportUtil.getJavaProjectByName(projectName);
            return ExportUtil.getProjectRoot(project);
        }
    }

    public static IJavaProject getJavaProject(String root) {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject javaProject = javaProjects[i];
            if (root.equals(javaProject.getPath().toString())) {
                return javaProject;
            }
            ++i;
        }
        return null;
    }

    public static String removeProjectRoot(String file, IProject project) {
        String res = ExportUtil.removePrefix(file, String.valueOf('/') + project.getName() + '/');
        if (res.equals(String.valueOf('/') + project.getName())) {
            return ".";
        }
        return res;
    }

    public static String replaceProjectRoot(String file, IProject project, String newProjectRoot) {
        String res = ExportUtil.removeProjectRoot(file, project);
        if (res.equals(".")) {
            return newProjectRoot;
        }
        if (newProjectRoot == null) {
            return res;
        }
        if (!res.equals(file)) {
            return String.valueOf(newProjectRoot) + '/' + res;
        }
        return res;
    }

    public static List getClasspathProjects(IJavaProject project) throws JavaModelException {
        ArrayList projects = new ArrayList();
        IClasspathEntry[] entries = project.getRawClasspath();
        ExportUtil.addClasspathProjects(projects, entries);
        return projects;
    }

    private static void addClasspathProjects(List projects, IClasspathEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            String subProjectRoot;
            IJavaProject subProject;
            IClasspathEntry classpathEntry = entries[i];
            if (classpathEntry.getContentKind() == 1 && classpathEntry.getEntryKind() == 2 && (subProject = ExportUtil.getJavaProject(subProjectRoot = classpathEntry.getPath().toString())) != null) {
                projects.add(subProject);
            }
            ++i;
        }
    }

    public static List getClasspathProjectsRecursive(IJavaProject project) throws JavaModelException {
        LinkedList result = new LinkedList();
        ExportUtil.getClasspathProjectsRecursive(project, result);
        return result;
    }

    private static void getClasspathProjectsRecursive(IJavaProject project, LinkedList result) throws JavaModelException {
        List projects = ExportUtil.getClasspathProjects(project);
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            IJavaProject javaProject = (IJavaProject)iter.next();
            if (result.contains(javaProject)) continue;
            result.addFirst(javaProject);
            ExportUtil.getClasspathProjectsRecursive(javaProject, result);
        }
    }

    public static boolean hasCyclicDependency(IJavaProject javaProject) throws CoreException {
        IMarker[] markers = javaProject.getProject().findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 1);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            String cycleAttr = (String)marker.getAttribute("cycleDetected");
            if (cycleAttr != null && cycleAttr.equals("true")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IType[] findTestsInContainer(String containerHandle) {
        IJavaElement container = JavaCore.create((String)containerHandle);
        if (container == null) {
            return new IType[0];
        }
        Object[] elements = new Object[]{container};
        HashSet result = new HashSet();
        if (elements.length > 0) {
            ExportUtil.doFindTests(elements, result);
        }
        return result.toArray(new IType[result.size()]);
    }

    private static List searchMethod(IJavaSearchScope scope) throws CoreException {
        ArrayList typesFound = new ArrayList(200);
        ExportUtil.searchMethod(typesFound, scope);
        return typesFound;
    }

    private static List searchMethod(List v, IJavaSearchScope scope) throws CoreException {
        JUnitSearchResultCollector requestor = new JUnitSearchResultCollector(v);
        int matchRule = 24;
        SearchPattern suitePattern = SearchPattern.createPattern((String)"suite() Test", (int)1, (int)0, (int)matchRule);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        new SearchEngine().search(suitePattern, participants, scope, (SearchRequestor)requestor, null);
        return v;
    }

    private static void doFindTests(Object[] elements, Set result) {
        int nElements = elements.length;
        int i = 0;
        while (i < nElements) {
            try {
                ExportUtil.collectTypes(elements[i], result);
            }
            catch (CoreException e) {
                AntUIPlugin.log(e.getStatus());
            }
            ++i;
        }
    }

    private static void collectTypes(Object element, Set result) throws CoreException {
        element = ExportUtil.computeScope(element);
        while (element instanceof ISourceReference && !(element instanceof ICompilationUnit)) {
            if (element instanceof IType && (ExportUtil.hasSuiteMethod((IType)element) || ExportUtil.isTestType((IType)element))) {
                result.add(element);
                return;
            }
            element = ((IJavaElement)element).getParent();
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            IType[] types = cu.getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (ExportUtil.hasSuiteMethod(types[i]) || ExportUtil.isTestType(types[i])) {
                    result.add(types[i]);
                }
                ++i;
            }
        } else if (element instanceof IJavaElement) {
            List testCases = ExportUtil.findTestCases((IJavaElement)element);
            List suiteMethods = ExportUtil.searchSuiteMethods((IJavaElement)element);
            while (!suiteMethods.isEmpty()) {
                if (!testCases.contains(suiteMethods.get(0))) {
                    testCases.add(suiteMethods.get(0));
                }
                suiteMethods.remove(0);
            }
            result.addAll(testCases);
        }
    }

    private static List findTestCases(IJavaElement element) throws JavaModelException {
        ArrayList<IType> found = new ArrayList<IType>();
        IJavaProject javaProject = element.getJavaProject();
        if (javaProject == null) {
            return found;
        }
        IType testCaseType = ExportUtil.testCaseType(javaProject);
        if (testCaseType == null) {
            return found;
        }
        IType[] subtypes = javaProject.newTypeHierarchy(testCaseType, ExportUtil.getRegion(javaProject), null).getAllSubtypes(testCaseType);
        if (subtypes == null) {
            throw new JavaModelException(new CoreException((IStatus)new Status(4, "org.eclipse.ant.ui", 101, null, null)));
        }
        int i = 0;
        while (i < subtypes.length) {
            try {
                if (element.equals(subtypes[i].getAncestor(element.getElementType())) && ExportUtil.hasValidModifiers(subtypes[i])) {
                    found.add(subtypes[i]);
                }
            }
            catch (JavaModelException e) {
                AntUIPlugin.log(e.getStatus());
            }
            ++i;
        }
        return found;
    }

    private static IType testCaseType(IJavaProject javaProject) {
        try {
            return javaProject.findType("junit.framework.TestCase");
        }
        catch (JavaModelException e) {
            AntUIPlugin.log(e.getStatus());
            return null;
        }
    }

    private static IRegion getRegion(IJavaProject javaProject) throws JavaModelException {
        IRegion region = JavaCore.newRegion();
        IJavaElement[] elements = javaProject.getChildren();
        int i = 0;
        while (i < elements.length) {
            if (!((IPackageFragmentRoot)elements[i]).isArchive()) {
                region.add(elements[i]);
            }
            ++i;
        }
        return region;
    }

    private static Object computeScope(Object element) throws JavaModelException {
        if (element instanceof IFileEditorInput) {
            element = ((IFileEditorInput)element).getFile();
        }
        if (element instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)element));
        }
        if (element instanceof IClassFile) {
            IClassFile cf = (IClassFile)element;
            element = cf.getType();
        }
        return element;
    }

    private static List searchSuiteMethods(IJavaElement element) throws CoreException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element}, (int)1);
        return ExportUtil.searchMethod(scope);
    }

    private static boolean hasSuiteMethod(IType type) throws JavaModelException {
        IMethod method = type.getMethod("suite", new String[0]);
        if (method == null || !method.exists()) {
            return false;
        }
        if (!(Flags.isStatic((int)method.getFlags()) && Flags.isPublic((int)method.getFlags()) && Flags.isPublic((int)method.getDeclaringType().getFlags()))) {
            return false;
        }
        return Signature.getSimpleName((String)Signature.toString((String)method.getReturnType())).equals("Test");
    }

    private static boolean isTestType(IType type) throws JavaModelException {
        if (!ExportUtil.hasValidModifiers(type)) {
            return false;
        }
        IType[] interfaces = type.newSupertypeHierarchy(null).getAllSuperInterfaces(type);
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getFullyQualifiedName('.').equals("junit.framework.Test")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasValidModifiers(IType type) throws JavaModelException {
        if (Flags.isAbstract((int)type.getFlags())) {
            return false;
        }
        return Flags.isPublic((int)type.getFlags());
    }

    public static synchronized Comparator getJavaProjectComparator() {
        if (javaProjectComparator == null) {
            javaProjectComparator = new JavaProjectComparator();
        }
        return javaProjectComparator;
    }

    public static synchronized Comparator getClassnameComparator() {
        if (classnameComparator == null) {
            classnameComparator = new ClassnameComparator();
        }
        return classnameComparator;
    }

    public static synchronized Comparator getIFileComparator() {
        if (fileComparator == null) {
            fileComparator = new IFileComparator();
        }
        return fileComparator;
    }

    public static synchronized Comparator getITypeComparator() {
        if (typeComparator == null) {
            typeComparator = new TypeComparator();
        }
        return typeComparator;
    }

    public static String removePrefix(String s, String prefix) {
        if (s == null) {
            return null;
        }
        if (s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    public static String removeSuffix(String s, String suffix) {
        if (s == null) {
            return null;
        }
        if (s.endsWith(suffix)) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public static String removePrefixAndSuffix(String s, String prefix, String suffix) {
        return ExportUtil.removePrefix(ExportUtil.removeSuffix(s, suffix), prefix);
    }

    public static String toString(Document doc) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        boolean indentFallback = false;
        try {
            factory.setAttribute("indent-number", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            indentFallback = true;
        }
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        if (indentFallback) {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        transformer.transform(source, result);
        return writer.toString();
    }

    public static Document parseXmlFile(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        Document doc = factory.newDocumentBuilder().parse(file);
        return doc;
    }

    public static Document parseXmlString(String s) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(s.getBytes()));
        return doc;
    }

    public static String toString(Collection c, String separator) {
        StringBuffer b = new StringBuffer();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            b.append((String)iter.next());
            b.append(separator);
        }
        if (c.size() > 0) {
            b.delete(b.length() - separator.length(), b.length());
        }
        return b.toString();
    }

    public static List removeDuplicates(List l) {
        ArrayList res = new ArrayList();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (res.contains(element)) continue;
            res.add(element);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existsUserFile(String filename) {
        BufferedReader in;
        block12: {
            File buildFile = new File(filename);
            if (!buildFile.exists()) return false;
            in = null;
            try {
                try {
                    String line;
                    in = new BufferedReader(new FileReader(buildFile));
                    int i = BuildFileCreator.WARNING.indexOf(NEWLINE);
                    String warning = BuildFileCreator.WARNING.substring(0, i);
                    do {
                        if ((line = in.readLine()) != null) continue;
                        break block12;
                    } while (line.indexOf(warning) == -1);
                    Object var6_6 = null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Object var6_8 = null;
                    try {
                        if (in == null) return false;
                        in.close();
                        return false;
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                catch (IOException iOException) {
                    Object var6_9 = null;
                    try {}
                    catch (IOException iOException2) {}
                    if (in == null) return false;
                    in.close();
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {}
                catch (IOException iOException) {}
                if (in == null) throw throwable;
                in.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (in == null) return false;
            in.close();
            return false;
        }
        Object var6_7 = null;
        try {}
        catch (IOException iOException) {}
        if (in == null) return true;
        in.close();
        return true;
    }

    public static boolean confirm(String message, Shell shell) {
        return MessageDialog.openConfirm((Shell)shell, (String)DataTransferMessages.AntBuildfileExportPage_4, (String)message);
    }

    public static IFileModificationValidator getFileModificationValidator(IFile file) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.add(file);
        Map validator2files = ExportUtil.getFileModificationValidator(files);
        return (IFileModificationValidator)validator2files.keySet().iterator().next();
    }

    public static Map getFileModificationValidator(List files) {
        TreeMap<IFileModificationValidator, ArrayList<IFile>> validator2files = new TreeMap<IFileModificationValidator, ArrayList<IFile>>(ExportUtil.getClassnameComparator());
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            ArrayList<IFile> list;
            IFileModificationValidator validator;
            IFile file = (IFile)iter.next();
            RepositoryProvider rp = RepositoryProvider.getProvider((IProject)file.getProject());
            IFileModificationValidator iFileModificationValidator = validator = rp != null ? rp.getFileModificationValidator() : ExportUtil.getDefaultValidator();
            if (validator == null) {
                validator = ExportUtil.getDefaultValidator();
            }
            if ((list = (ArrayList<IFile>)validator2files.get(validator)) == null) {
                list = new ArrayList<IFile>();
            }
            list.add(file);
            validator2files.put(validator, list);
        }
        return validator2files;
    }

    public static boolean validateEdit(Shell shell, IFile file) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.add(file);
        Map validator2files = ExportUtil.getFileModificationValidator(files);
        return ExportUtil.validateEdit(shell, validator2files).size() > 0;
    }

    public static Set validateEdit(Shell shell, Map validator2files) throws CoreException {
        TreeSet<IFile> confirmedFiles = new TreeSet<IFile>(ExportUtil.getIFileComparator());
        Iterator iter = validator2files.keySet().iterator();
        while (iter.hasNext()) {
            List files;
            IFile[] filesArray;
            IFileModificationValidator validator = (IFileModificationValidator)iter.next();
            IStatus status = validator.validateEdit(filesArray = (files = (List)validator2files.get(validator)).toArray(new IFile[files.size()]), (Object)shell);
            if (status.isMultiStatus() && status.getChildren().length > 0) {
                int i = 0;
                while (i < status.getChildren().length) {
                    IStatus statusChild = status.getChildren()[i];
                    if (statusChild.isOK()) {
                        confirmedFiles.add(filesArray[i]);
                    }
                    ++i;
                }
            } else if (status.isOK()) {
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    IFile file = (IFile)iterator.next();
                    confirmedFiles.add(file);
                }
            }
            if (validator == ExportUtil.getDefaultValidator() || status.getSeverity() != 4) continue;
            StringBuffer message = new StringBuffer(String.valueOf(status.getPlugin()) + ": " + status.getMessage() + NEWLINE);
            if (status.isMultiStatus()) {
                int i = 0;
                while (i < status.getChildren().length) {
                    IStatus statusChild = status.getChildren()[i];
                    message.append(String.valueOf(statusChild.getMessage()) + NEWLINE);
                    ++i;
                }
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ant.ui", 0, message.toString(), null));
        }
        return confirmedFiles;
    }

    public static synchronized IFileModificationValidator getDefaultValidator() {
        if (defaultValidator == null) {
            defaultValidator = ExportUtil.loadUIValidator();
        }
        return defaultValidator;
    }

    private static IFileModificationValidator loadUIValidator() {
        IConfigurationElement[] configElements;
        IExtension[] extensions;
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.core", "defaultFileModificationValidator");
        if (extension != null && (extensions = extension.getExtensions()).length > 0 && (configElements = extensions[0].getConfigurationElements()).length > 0) {
            try {
                Object o = configElements[0].createExecutableExtension("class");
                if (o instanceof IFileModificationValidator) {
                    return (IFileModificationValidator)o;
                }
            }
            catch (CoreException e) {
                AntUIPlugin.log(e);
            }
        }
        return new IFileModificationValidator(){

            public IStatus validateEdit(IFile[] files, Object context) {
                return Status.OK_STATUS;
            }

            public IStatus validateSave(IFile file) {
                return Status.OK_STATUS;
            }
        };
    }

    public static boolean isDefaultClasspath(IJavaProject project, EclipseClasspath classpath) {
        List list = ExportUtil.removeDuplicates(classpath.rawClassPathEntries);
        if (list.size() != 1) {
            return false;
        }
        String entry = (String)list.iterator().next();
        if (EclipseClasspath.isProjectReference(entry)) {
            IJavaProject referencedProject = EclipseClasspath.resolveProjectReference(entry);
            if (referencedProject == null) {
                return false;
            }
            if (referencedProject.getProject().getName().equals(project.getProject().getName())) {
                return true;
            }
        }
        return false;
    }

    public static void addVariable(Map variable2valueMap, String s, String projectRoot) {
        if (s == null || s.equals("")) {
            return;
        }
        Pattern pattern = Pattern.compile("\\$\\{.*?\\}");
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            File file;
            String value;
            String variable = matcher.group();
            try {
                value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(variable);
            }
            catch (CoreException coreException) {
                value = variable;
            }
            variable = ExportUtil.removePrefixAndSuffix(variable, "${", "}");
            if (variable.startsWith("env_var:")) {
                value = "env." + variable.substring("env_var:".length());
            }
            if ((file = new File(value)).exists()) {
                value = ExportUtil.getRelativePath(file.getAbsolutePath(), projectRoot);
            }
            variable2valueMap.put(variable, value);
        }
    }

    public static String getRelativePath(String otherLocation, String basePath) {
        Path location = new Path(otherLocation);
        Path base = new Path(basePath);
        if (location.getDevice() != null && !location.getDevice().equalsIgnoreCase(base.getDevice()) || !location.isAbsolute()) {
            return otherLocation;
        }
        int baseCount = base.segmentCount();
        int count = base.matchingFirstSegments((IPath)location);
        String temp = "";
        int j = 0;
        while (j < baseCount - count) {
            temp = String.valueOf(temp) + "../";
            ++j;
        }
        String relative = new Path(temp).append(location.removeFirstSegments(count)).toString();
        if (relative.length() == 0) {
            relative = ".";
        }
        return relative;
    }

    private static class JUnitSearchResultCollector
    extends SearchRequestor {
        List fList;
        Set fFailed = new HashSet();
        Set fMatches = new HashSet();

        public JUnitSearchResultCollector(List list) {
            this.fList = list;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object enclosingElement = match.getElement();
            if (!(enclosingElement instanceof IMethod)) {
                return;
            }
            IMethod method = (IMethod)enclosingElement;
            IType declaringType = method.getDeclaringType();
            if (this.fMatches.contains(declaringType) || this.fFailed.contains(declaringType)) {
                return;
            }
            if (!ExportUtil.hasSuiteMethod(declaringType) && !ExportUtil.isTestType(declaringType)) {
                this.fFailed.add(declaringType);
                return;
            }
            this.fMatches.add(declaringType);
        }

        public void endReporting() {
            this.fList.addAll(this.fMatches);
        }
    }

    private static class JavaProjectComparator
    implements Comparator {
        JavaProjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            IJavaProject j1 = (IJavaProject)o1;
            IJavaProject j2 = (IJavaProject)o2;
            return j1.getProject().getName().compareTo(j2.getProject().getName());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.compare(this, obj) == 0;
        }
    }

    private static class ClassnameComparator
    implements Comparator {
        ClassnameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.compare(this, obj) == 0;
        }
    }

    private static class IFileComparator
    implements Comparator {
        IFileComparator() {
        }

        public int compare(Object o1, Object o2) {
            IFile f1 = (IFile)o1;
            IFile f2 = (IFile)o2;
            return f1.toString().compareTo(f2.toString());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.compare(this, obj) == 0;
        }
    }

    private static class TypeComparator
    implements Comparator {
        TypeComparator() {
        }

        public int compare(Object o1, Object o2) {
            IType t1 = (IType)o1;
            IType t2 = (IType)o2;
            return t1.getFullyQualifiedName().compareTo(t2.getFullyQualifiedName());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.compare(this, obj) == 0;
        }
    }
}

