/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.CopyFailureListAction;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.OpenTestAction;
import org.eclipse.jdt.internal.junit.ui.RerunAction;
import org.eclipse.jdt.internal.junit.ui.TestRunInfo;
import org.eclipse.jdt.internal.junit.ui.TestRunTab;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class FailureTab
extends TestRunTab
implements IMenuListener,
ISelectionProvider {
    private Table fTable;
    private TestRunnerViewPart fRunnerViewPart;
    private Clipboard fClipboard;
    private boolean fMoveSelection = false;
    private ListenerList fSelectionListeners = new ListenerList(1);
    private final Image fErrorIcon = TestRunnerViewPart.createImage("obj16/testerr.gif");
    private final Image fFailureIcon = TestRunnerViewPart.createImage("obj16/testfail.gif");
    private final Image fFailureTabIcon = TestRunnerViewPart.createImage("obj16/failures.gif");

    public void createTabControl(CTabFolder tabFolder, Clipboard clipboard, TestRunnerViewPart runner) {
        this.fRunnerViewPart = runner;
        this.fClipboard = clipboard;
        CTabItem failureTab = new CTabItem(tabFolder, 0);
        failureTab.setText(this.getName());
        failureTab.setImage(this.fFailureTabIcon);
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.fTable = new Table(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fTable.setLayout((Layout)gridLayout);
        OpenStrategy handler = new OpenStrategy((Control)this.fTable);
        handler.addPostSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FailureTab.this.fireSelectionChanged();
            }
        });
        gridData = new GridData(1808);
        this.fTable.setLayoutData((Object)gridData);
        failureTab.setControl((Control)composite);
        failureTab.setToolTipText(JUnitMessages.FailureRunView_tab_tooltip);
        this.initMenu();
        this.addListeners();
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
        this.fFailureTabIcon.dispose();
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fRunnerViewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    public String getName() {
        return JUnitMessages.FailureRunView_tab_title;
    }

    public String getSelectedTestId() {
        TestRunInfo testInfo = this.getSelectedTestInfo();
        if (testInfo == null) {
            return null;
        }
        return testInfo.getTestId();
    }

    private TestRunInfo getSelectedTestInfo() {
        return this.getTestInfo(this.fTable.getSelectionIndex());
    }

    private TestRunInfo getTestInfo(int index) {
        if (index == -1) {
            return null;
        }
        return this.getTestInfo(this.fTable.getItem(index));
    }

    public String getAllFailedTestNames() {
        StringBuffer trace = new StringBuffer();
        String lineDelim = System.getProperty("line.separator", "\n");
        int i = 0;
        while (i < this.fTable.getItemCount()) {
            TestRunInfo testInfo = this.getTestInfo(i);
            trace.append(testInfo.getTestName()).append(lineDelim);
            String failureTrace = testInfo.getTrace();
            if (failureTrace != null) {
                StringReader stringReader = new StringReader(failureTrace);
                BufferedReader bufferedReader = new BufferedReader(stringReader);
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        trace.append(String.valueOf(line) + lineDelim);
                    }
                }
                catch (IOException iOException) {
                    trace.append(lineDelim);
                }
            }
            ++i;
        }
        return trace.toString();
    }

    private String getClassName() {
        TableItem item = this.getSelectedItem();
        TestRunInfo info = this.getTestInfo(item);
        return info.getClassName();
    }

    private String getMethodName() {
        TableItem item = this.getSelectedItem();
        TestRunInfo info = this.getTestInfo(item);
        return info.getTestMethodName();
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fTable.getSelectionCount() > 0) {
            String className = this.getClassName();
            String methodName = this.getMethodName();
            if (className != null) {
                manager.add((IAction)new OpenTestAction(this.fRunnerViewPart, className, methodName));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new RerunAction(this.fRunnerViewPart, this.getSelectedTestId(), className, methodName, "run"));
                if (!this.fRunnerViewPart.lastLaunchIsKeptAlive()) {
                    manager.add((IAction)new RerunAction(this.fRunnerViewPart, this.getSelectedTestId(), className, methodName, "debug"));
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new CopyFailureListAction(this.fRunnerViewPart, this, this.fClipboard));
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private TableItem getSelectedItem() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return this.fTable.getItem(index);
    }

    public void setSelectedTest(String testId) {
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem tableItem = items[i];
            TestRunInfo info = this.getTestInfo(tableItem);
            if (info.getTestId().equals(testId)) {
                if (this.fRunnerViewPart.isAutoScroll()) {
                    this.fTable.setSelection(new TableItem[]{tableItem});
                    this.fTable.showItem(tableItem);
                }
                return;
            }
            ++i;
        }
    }

    private TestRunInfo getTestInfo(TableItem item) {
        return (TestRunInfo)item.getData();
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    public void endTest(String testId) {
        TestRunInfo testInfo = this.fRunnerViewPart.getTestInfo(testId);
        if (testInfo == null || testInfo.getStatus() == 0) {
            return;
        }
        TableItem tableItem = new TableItem(this.fTable, 0);
        this.updateTableItem(testInfo, tableItem);
        if (this.fRunnerViewPart.isAutoScroll()) {
            this.fTable.showItem(tableItem);
        }
    }

    private void updateTableItem(TestRunInfo testInfo, TableItem tableItem) {
        String label = Messages.format(JUnitMessages.FailureRunView_labelfmt, new String[]{testInfo.getTestMethodName(), testInfo.getClassName()});
        tableItem.setText(label);
        if (testInfo.getStatus() == 2) {
            tableItem.setImage(this.fFailureIcon);
        } else {
            tableItem.setImage(this.fErrorIcon);
        }
        tableItem.setData((Object)testInfo);
    }

    private TableItem findItem(String testId) {
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            TestRunInfo info = this.getTestInfo(items[i]);
            if (info.getTestId().equals(testId)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public void activate() {
        this.fMoveSelection = false;
        this.testSelected();
    }

    public void aboutToStart() {
        this.fMoveSelection = false;
        this.fTable.removeAll();
    }

    private void testSelected() {
        this.fRunnerViewPart.handleTestSelected(this.getSelectedTestInfo());
    }

    private void addListeners() {
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FailureTab.this.activate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FailureTab.this.handleDefaultSelected(null);
            }
        });
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FailureTab.this.disposeIcons();
            }
        });
        this.fTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                FailureTab.this.activate();
            }

            public void mouseUp(MouseEvent e) {
                FailureTab.this.activate();
            }
        });
    }

    void handleDefaultSelected(MouseEvent e) {
        if (this.fTable.getSelectionCount() > 0) {
            new OpenTestAction(this.fRunnerViewPart, this.getClassName(), this.getMethodName()).run();
        }
    }

    public void testStatusChanged(TestRunInfo info) {
        TableItem item = this.findItem(info.getTestId());
        if (item != null) {
            if (info.getStatus() == 0) {
                item.dispose();
                return;
            }
            this.updateTableItem(info, item);
        }
        if (item == null && info.getStatus() != 0) {
            item = new TableItem(this.fTable, 0);
            this.updateTableItem(info, item);
        }
        if (item != null) {
            this.fTable.showItem(item);
        }
    }

    public void selectNext() {
        if (this.fTable.getItemCount() == 0) {
            return;
        }
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            index = 0;
        }
        if (this.fMoveSelection) {
            index = Math.min(this.fTable.getItemCount() - 1, index + 1);
        } else {
            this.fMoveSelection = true;
        }
        this.selectTest(index);
    }

    public void selectPrevious() {
        if (this.fTable.getItemCount() == 0) {
            return;
        }
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            index = this.fTable.getItemCount() - 1;
        }
        if (this.fMoveSelection) {
            index = Math.max(0, index - 1);
        } else {
            this.fMoveSelection = true;
        }
        this.selectTest(index);
    }

    private void selectTest(int index) {
        TableItem item = this.fTable.getItem(index);
        TestRunInfo info = this.getTestInfo(item);
        this.fRunnerViewPart.showTest(info);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.getTestInfo(index));
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }
}

