/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IPersistableAnnotationModel;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.filebuffers.DocumentReader;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.JavaFileBuffer;
import org.eclipse.core.internal.filebuffers.NLSUtility;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;

public class JavaTextFileBuffer
extends JavaFileBuffer
implements ITextFileBuffer {
    private static final int READER_CHUNK_SIZE = 2048;
    private static final int BUFFER_SIZE = 16384;
    private static final IStatus STATUS_OK = new Status(0, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.FileBuffer_status_ok, null);
    private static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.core.filebuffers", 1, FileBuffersMessages.FileBuffer_status_error, null);
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final QualifiedName[] NO_PROPERTIES = new QualifiedName[0];
    protected IDocument fDocument;
    protected String fEncoding;
    protected IDocumentListener fDocumentListener = new DocumentListener();
    private String fExplicitEncoding;
    private boolean fHasBOM;
    private IAnnotationModel fAnnotationModel;
    private final Object fAnnotationModelCreationLock = new Object();

    public JavaTextFileBuffer(TextFileBufferManager manager) {
        super(manager);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAnnotationModel getAnnotationModel() {
        Object object = this.fAnnotationModelCreationLock;
        synchronized (object) {
            if (this.fAnnotationModel == null && !this.isDisconnected()) {
                this.fAnnotationModel = this.fManager.createAnnotationModel(this.getLocation());
                if (this.fAnnotationModel != null) {
                    this.fAnnotationModel.connect(this.fDocument);
                }
            }
        }
        return this.fAnnotationModel;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.fExplicitEncoding = encoding;
        if (encoding == null || encoding.equals(this.fEncoding)) {
            this.cacheEncodingState(null);
        } else {
            this.fEncoding = encoding;
            this.fHasBOM = false;
        }
    }

    public IStatus getStatus() {
        if (!this.isDisconnected()) {
            if (this.fStatus != null) {
                return this.fStatus;
            }
            return this.fDocument == null ? STATUS_ERROR : STATUS_OK;
        }
        return STATUS_ERROR;
    }

    private InputStream getFileContents(IFileStore file, IProgressMonitor monitor) {
        try {
            if (file != null) {
                return file.openInputStream(0, null);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void setFileContents(InputStream stream, boolean overwrite, IProgressMonitor monitor) {
        try {
            OutputStream out = this.fFileStore.openOutputStream(0, null);
            try {
                byte[] buffer = new byte[8192];
                while (true) {
                    int bytesRead = -1;
                    try {
                        bytesRead = stream.read(buffer);
                    }
                    catch (IOException iOException) {}
                    if (bytesRead == -1) break;
                    try {
                        out.write(buffer, 0, bytesRead);
                    }
                    catch (IOException iOException) {}
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    try {
                        out.close();
                        throw throwable2;
                    }
                    catch (IOException iOException) {}
                    throw throwable2;
                }
                try {}
                catch (IOException iOException) {}
                out.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (Throwable throwable) {
                Object var9_14 = null;
                try {}
                catch (IOException iOException) {}
                out.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            stream.close();
            Object var9_15 = null;
            try {}
            catch (IOException iOException) {
                return;
            }
            out.close();
            return;
        }
        catch (CoreException coreException) {}
    }

    public void revert(IProgressMonitor monitor) throws CoreException {
        boolean replaceContents;
        if (this.isDisconnected()) {
            return;
        }
        IDocument original = null;
        this.fStatus = null;
        try {
            original = this.fManager.createEmptyDocument(this.getLocation());
            this.cacheEncodingState(monitor);
            this.setDocumentContent(original, this.fFileStore, this.fEncoding, monitor);
        }
        catch (CoreException x) {
            this.fStatus = x.getStatus();
        }
        if (original == null) {
            return;
        }
        String originalContents = original.get();
        boolean bl = replaceContents = !originalContents.equals(this.fDocument.get());
        if (!replaceContents && !this.fCanBeSaved) {
            return;
        }
        this.fManager.fireStateChanging(this);
        try {
            if (replaceContents) {
                this.fManager.fireBufferContentAboutToBeReplaced(this);
                this.fDocument.set(original.get());
            }
            boolean fireDirtyStateChanged = this.fCanBeSaved;
            if (this.fCanBeSaved) {
                this.fCanBeSaved = false;
                this.addFileBufferContentListeners();
            }
            if (replaceContents) {
                this.fManager.fireBufferContentReplaced(this);
            }
            if (this.fFileStore != null) {
                this.fSynchronizationStamp = this.fFileStore.fetchInfo().getLastModified();
            }
            if (this.fAnnotationModel instanceof IPersistableAnnotationModel) {
                IPersistableAnnotationModel persistableModel = (IPersistableAnnotationModel)this.fAnnotationModel;
                try {
                    persistableModel.revert(this.fDocument);
                }
                catch (CoreException x) {
                    this.fStatus = x.getStatus();
                }
            }
            if (fireDirtyStateChanged) {
                this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
            }
        }
        catch (RuntimeException x) {
            this.fManager.fireStateChangeFailed(this);
            throw x;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IContentType getContentType() throws CoreException {
        if (this.fFileStore == null) {
            return null;
        }
        InputStream stream = null;
        try {
            try {
                if (this.isDirty()) {
                    DocumentReader reader;
                    block22: {
                        IContentType iContentType;
                        reader = new DocumentReader(this.getDocument());
                        try {
                            IContentDescription desc = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, this.fFileStore.getName(), NO_PROPERTIES);
                            if (desc == null || desc.getContentType() == null) break block22;
                            iContentType = desc.getContentType();
                            Object var4_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            try {}
                            catch (IOException iOException) {}
                            if (reader == null) throw throwable;
                            ((Reader)reader).close();
                            throw throwable;
                            throw throwable;
                        }
                        try {
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        Object var7_9 = null;
                        try {
                            if (stream == null) return iContentType;
                            stream.close();
                            return iContentType;
                        }
                        catch (IOException iOException) {}
                        return iContentType;
                    }
                    Object var4_8 = null;
                    try {}
                    catch (IOException iOException) {}
                    if (reader != null) {
                        ((Reader)reader).close();
                    }
                }
                stream = this.fFileStore.openInputStream(0, null);
                IContentDescription desc = Platform.getContentTypeManager().getDescriptionFor(stream, this.fFileStore.getName(), NO_PROPERTIES);
                if (desc != null && desc.getContentType() != null) {
                    IContentType iContentType = desc.getContentType();
                    Object var7_10 = null;
                    try {}
                    catch (IOException iOException) {}
                    if (stream == null) return iContentType;
                    stream.close();
                    return iContentType;
                }
                IContentType iContentType = null;
                Object var7_11 = null;
                try {}
                catch (IOException iOException) {}
                if (stream == null) return iContentType;
                stream.close();
                return iContentType;
            }
            catch (IOException x) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, NLSUtility.format(FileBuffersMessages.FileBuffer_error_queryContentDescription, this.fFileStore.toString()), (Throwable)x));
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
    }

    protected void addFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener(this.fDocumentListener);
        }
    }

    protected void removeFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
    }

    protected void initializeFileBufferContent(IProgressMonitor monitor) throws CoreException {
        try {
            this.fDocument = this.fManager.createEmptyDocument(this.getLocation());
            this.cacheEncodingState(monitor);
            this.setDocumentContent(this.fDocument, this.fFileStore, this.fEncoding, monitor);
        }
        catch (CoreException x) {
            this.fDocument = this.fManager.createEmptyDocument(this.getLocation());
            this.fStatus = x.getStatus();
        }
    }

    protected void connected() {
        super.connected();
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.connect(this.fDocument);
        }
    }

    protected void disconnected() {
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.disconnect(this.fDocument);
        }
        super.disconnected();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cacheEncodingState(IProgressMonitor monitor) {
        this.fEncoding = this.fExplicitEncoding;
        this.fHasBOM = false;
        InputStream stream = this.getFileContents(this.fFileStore, monitor);
        if (stream == null) return;
        try {
            try {
                QualifiedName[] options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                IContentDescription description = Platform.getContentTypeManager().getDescriptionFor(stream, this.fFileStore.getName(), options);
                if (description != null) {
                    boolean bl = this.fHasBOM = description.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
                    if (this.fEncoding == null) {
                        this.fEncoding = description.getCharset();
                    }
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ex) {
                FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.JavaTextFileBuffer_error_closeStream, (Throwable)ex));
            }
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException ex) {
            FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.JavaTextFileBuffer_error_closeStream, (Throwable)ex));
            return;
        }
        stream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitFileBufferContent(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        String encoding = this.computeEncoding();
        try {
            IFileInfo fileInfo;
            byte[] bytes = this.fDocument.get().getBytes(encoding);
            if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                int bomLength = IContentDescription.BOM_UTF_8.length;
                byte[] bytesWithBOM = new byte[bytes.length + bomLength];
                System.arraycopy(IContentDescription.BOM_UTF_8, 0, bytesWithBOM, 0, bomLength);
                System.arraycopy(bytes, 0, bytesWithBOM, bomLength, bytes.length);
                bytes = bytesWithBOM;
            }
            IFileInfo iFileInfo = fileInfo = this.fFileStore == null ? null : this.fFileStore.fetchInfo();
            if (fileInfo != null && fileInfo.exists()) {
                if (!overwrite) {
                    this.checkSynchronizationState();
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                this.setFileContents(stream, overwrite, monitor);
                this.fSynchronizationStamp = this.fFileStore.fetchInfo().getLastModified();
                if (!(this.fAnnotationModel instanceof IPersistableAnnotationModel)) return;
                IPersistableAnnotationModel persistableModel = (IPersistableAnnotationModel)this.fAnnotationModel;
                persistableModel.commit(this.fDocument);
                return;
            }
            this.fFileStore = FileBuffers.getFileStoreAtLocation(this.getLocation());
            this.fFileStore.getParent().mkdir(0, null);
            OutputStream out = this.fFileStore.openOutputStream(0, null);
            try {
                try {
                    out.write(bytes);
                    out.flush();
                }
                catch (IOException x) {
                    Status s = new Status(4, "org.eclipse.core.filebuffers", 0, x.getLocalizedMessage(), (Throwable)x);
                    throw new CoreException((IStatus)s);
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var9_16 = null;
            }
            try {}
            catch (IOException iOException) {}
            out.close();
            this.fSynchronizationStamp = this.fFileStore.fetchInfo().getLastModified();
            return;
        }
        catch (UnsupportedEncodingException x) {
            String message = NLSUtility.format(FileBuffersMessages.ResourceTextFileBuffer_error_unsupported_encoding_message_arg, encoding);
            Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)x);
            throw new CoreException((IStatus)s);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String computeEncoding() {
        if (this.fExplicitEncoding != null) {
            return this.fExplicitEncoding;
        }
        if (this.fFileStore != null) {
            DocumentReader reader;
            block12: {
                String string;
                reader = new DocumentReader(this.fDocument);
                try {
                    try {
                        String encoding;
                        QualifiedName[] options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                        IContentDescription description = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, this.fFileStore.getName(), options);
                        if (description == null || (encoding = description.getCharset()) == null) break block12;
                        string = encoding;
                        Object var5_6 = null;
                    }
                    catch (IOException iOException) {
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (reader == null) throw throwable;
                        ((Reader)reader).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                if (reader == null) return string;
                ((Reader)reader).close();
                return string;
            }
            Object var5_8 = null;
            try {}
            catch (IOException iOException) {}
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
        if (!this.fHasBOM) return this.fManager.getDefaultEncoding();
        return this.fEncoding;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setDocumentContent(IDocument document, IFileStore file, String encoding, IProgressMonitor monitor) throws CoreException {
        InputStream contentStream = this.getFileContents(file, monitor);
        if (contentStream == null) {
            return;
        }
        Reader in = null;
        try {
            try {
                if (encoding == null) {
                    encoding = this.fManager.getDefaultEncoding();
                }
                if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                    int bytes;
                    int n = 0;
                    do {
                        if ((bytes = contentStream.read(new byte[IContentDescription.BOM_UTF_8.length])) != -1) continue;
                        throw new IOException();
                    } while ((n += bytes) < IContentDescription.BOM_UTF_8.length);
                }
                in = new BufferedReader(new InputStreamReader(contentStream, encoding), 16384);
                StringBuffer buffer = new StringBuffer(16384);
                char[] readBuffer = new char[2048];
                int n = in.read(readBuffer);
                while (true) {
                    block15: {
                        if (n > 0) break block15;
                        document.set(buffer.toString());
                        break;
                    }
                    buffer.append(readBuffer, 0, n);
                    n = in.read(readBuffer);
                }
            }
            catch (IOException x) {
                String msg = x.getMessage() == null ? "" : x.getMessage();
                Status s = new Status(4, "org.eclipse.core.filebuffers", 0, msg, (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            try {
                if (in != null) {
                    in.close();
                    throw throwable;
                }
                contentStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_17 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (in != null) {
            in.close();
            return;
        }
        contentStream.close();
    }

    private void checkSynchronizationState() throws CoreException {
        if (!this.isSynchronized()) {
            Status status = new Status(4, "org.eclipse.core.filebuffers", 274, FileBuffersMessages.FileBuffer_error_outOfSync, null);
            throw new CoreException((IStatus)status);
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            JavaTextFileBuffer.this.fCanBeSaved = true;
            JavaTextFileBuffer.this.removeFileBufferContentListeners();
            JavaTextFileBuffer.this.fManager.fireDirtyStateChanged(JavaTextFileBuffer.this, JavaTextFileBuffer.this.fCanBeSaved);
        }
    }
}

