/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class ExternalFeatureModelManager
implements Preferences.IPropertyChangeListener {
    private Vector fListeners = new Vector();
    private IFeatureModel[] fModels;
    private String fPlatformHome;
    private Preferences fPref = PDECore.getDefault().getPluginPreferences();

    /*
     * Exception decompiling
     */
    private static IFeatureModel createModel(File manifest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 69->72)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IFeatureModel[] createModels(String platformHome) {
        URL[] featurePaths = PluginPathFinder.getFeaturePaths(platformHome);
        HashMap<String, IFeatureModel> uniqueFeatures = new HashMap<String, IFeatureModel>();
        int i = 0;
        while (i < featurePaths.length) {
            File manifest = new File(featurePaths[i].getFile(), "feature.xml");
            IFeatureModel model = ExternalFeatureModelManager.createModel(manifest);
            if (model != null && model.isLoaded()) {
                IFeature feature = model.getFeature();
                uniqueFeatures.put(String.valueOf(feature.getId()) + "_" + feature.getVersion(), model);
            }
            ++i;
        }
        Collection models = uniqueFeatures.values();
        return models.toArray(new IFeatureModel[models.size()]);
    }

    public void addModelProviderListener(IModelProviderListener listener) {
        this.fListeners.add(listener);
    }

    private boolean equalPaths(String path1, String path2) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return false;
        }
        return new File(path1).equals(new File(path2));
    }

    private void fireModelProviderEvent(IModelProviderEvent e) {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            IModelProviderListener listener = (IModelProviderListener)iter.next();
            listener.modelsChanged(e);
        }
    }

    private String getPathString(Object propertyValue) {
        String path;
        if (propertyValue != null && propertyValue instanceof String && (path = (String)propertyValue).length() > 0) {
            return path;
        }
        return null;
    }

    public void loadModels(String platformHome) {
        IFeatureModel[] newModels = platformHome != null && platformHome.length() > 0 ? ExternalFeatureModelManager.createModels(platformHome) : new IFeatureModel[]{};
        this.fPlatformHome = platformHome;
        IFeatureModel[] oldModels = this.fModels != null ? this.fModels : new IFeatureModel[]{};
        this.fModels = newModels;
        this.notifyListeners(oldModels, newModels);
    }

    private void notifyListeners(IFeatureModel[] oldModels, IFeatureModel[] newFeatureModels) {
        if (oldModels.length > 0 || newFeatureModels.length > 0) {
            int type = 0;
            if (oldModels.length > 0) {
                type |= 2;
            }
            if (newFeatureModels.length > 0) {
                type |= 1;
            }
            ModelProviderEvent replacedFeatures = new ModelProviderEvent(this, type, newFeatureModels, oldModels, null);
            this.fireModelProviderEvent(replacedFeatures);
        }
    }

    private synchronized void platformPathChanged(String newHome) {
        if (!this.equalPaths(newHome, this.fPlatformHome)) {
            this.loadModels(newHome);
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (!"platform_path".equals(event.getProperty())) {
            return;
        }
        String newHome = this.getPathString(event.getNewValue());
        this.platformPathChanged(newHome);
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.fListeners.remove(listener);
    }

    public synchronized void shutdown() {
        this.fPref.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.loadModels(null);
    }

    public synchronized void startup() {
        this.fPref.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.loadModels(this.fPref.getString("platform_path"));
    }

    public synchronized void reload() {
        this.loadModels(this.fPref.getString("platform_path"));
    }

    public IFeatureModel[] getModels() {
        return this.fModels;
    }
}

