/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDEClasspathContainer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;

public class RequiredPluginsClasspathContainer
extends PDEClasspathContainer
implements IClasspathContainer {
    private IPluginModelBase fModel;
    private static boolean DEBUG = false;
    private IClasspathEntry[] fEntries = null;

    static {
        DEBUG = PDECore.getDefault().isDebugging() && "true".equals(Platform.getDebugOption((String)"org.eclipse.pde.core/classpath"));
    }

    public RequiredPluginsClasspathContainer(IPluginModelBase model) {
        this.fModel = model;
    }

    public void reset() {
        this.fEntries = null;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return new Path("org.eclipse.pde.core.requiredPlugins");
    }

    public String getDescription() {
        return PDECoreMessages.RequiredPluginsClasspathContainer_description;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.fModel == null) {
            if (DEBUG) {
                System.out.println("********Returned an empty container");
                System.out.println();
            }
            return new IClasspathEntry[0];
        }
        if (this.fEntries == null) {
            this.fEntries = this.computePluginEntries();
        }
        if (DEBUG) {
            System.out.println("Dependencies for plugin '" + this.fModel.getPluginBase().getId() + "':");
            int i = 0;
            while (i < this.fEntries.length) {
                System.out.println(this.fEntries[i]);
                ++i;
            }
            System.out.println();
        }
        return this.fEntries;
    }

    private IClasspathEntry[] computePluginEntries() {
        ArrayList entries = new ArrayList();
        try {
            BundleDescription desc = this.fModel.getBundleDescription();
            if (desc == null) {
                return new IClasspathEntry[0];
            }
            Map map = this.retrieveVisiblePackagesFromState(desc);
            HashSet<String> added = new HashSet<String>();
            added.add(desc.getSymbolicName());
            HostSpecification host = desc.getHost();
            if (desc.isResolved() && host != null) {
                this.addHostPlugin(host, added, map, entries);
            }
            BundleSpecification[] required = desc.getRequiredBundles();
            int i = 0;
            while (i < required.length) {
                this.addDependency(this.getSupplier(required[i]), added, map, entries);
                ++i;
            }
            IBuild build = ClasspathUtilCore.getBuild(this.fModel);
            if (build != null) {
                this.addSecondaryDependencies(added, map, entries, build);
            }
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String symbolicName = iter.next().toString();
                IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(symbolicName);
                if (model == null || !model.isEnabled()) continue;
                this.addDependencyViaImportPackage(model.getBundleDescription(), added, map, entries);
            }
            if (build != null) {
                this.addExtraClasspathEntries(added, entries, build);
            }
        }
        catch (CoreException coreException) {}
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    private BundleDescription getSupplier(BundleSpecification spec) {
        if (spec.isResolved()) {
            return (BundleDescription)spec.getSupplier();
        }
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(spec.getName());
        return model != null && model.isEnabled() ? model.getBundleDescription() : null;
    }

    private Map retrieveVisiblePackagesFromState(BundleDescription bundle) {
        TreeMap visiblePackages = new TreeMap();
        if (bundle.isResolved()) {
            BundleDescription desc = bundle;
            StateHelper helper = Platform.getPlatformAdmin().getStateHelper();
            this.addVisiblePackagesFromState(helper, desc, visiblePackages);
            if (desc.getHost() != null) {
                this.addVisiblePackagesFromState(helper, (BundleDescription)desc.getHost().getSupplier(), visiblePackages);
            }
        }
        return visiblePackages;
    }

    private void addVisiblePackagesFromState(StateHelper helper, BundleDescription desc, Map visiblePackages) {
        ExportPackageDescription[] exports = helper.getVisiblePackages(desc);
        int i = 0;
        while (i < exports.length) {
            BundleDescription exporter = exports[i].getExporter();
            if (exporter != null) {
                PDEClasspathContainer.Rule rule;
                ArrayList<PDEClasspathContainer.Rule> list = (ArrayList<PDEClasspathContainer.Rule>)visiblePackages.get(exporter.getSymbolicName());
                if (list == null) {
                    list = new ArrayList<PDEClasspathContainer.Rule>();
                }
                if (!list.contains(rule = this.getRule(helper, desc, exports[i]))) {
                    list.add(rule);
                }
                visiblePackages.put(exporter.getSymbolicName(), list);
            }
            ++i;
        }
    }

    private PDEClasspathContainer.Rule getRule(StateHelper helper, BundleDescription desc, ExportPackageDescription export) {
        PDEClasspathContainer.Rule rule = new PDEClasspathContainer.Rule();
        rule.discouraged = helper.getAccessCode(desc, export) == 2;
        rule.path = new Path(String.valueOf(export.getName().replaceAll("\\.", "/")) + "/*");
        return rule;
    }

    protected void addDependencyViaImportPackage(BundleDescription desc, HashSet added, Map map, ArrayList entries) throws CoreException {
        if (desc == null || !added.add(desc.getSymbolicName())) {
            return;
        }
        this.addPlugin(desc, true, map, entries);
        if (this.hasExtensibleAPI(desc) && desc.getContainingState() != null) {
            BundleDescription[] fragments = desc.getFragments();
            int i = 0;
            while (i < fragments.length) {
                if (fragments[i].isResolved()) {
                    this.addDependencyViaImportPackage(fragments[i], added, map, entries);
                }
                ++i;
            }
        }
    }

    private void addDependency(BundleDescription desc, HashSet added, Map map, ArrayList entries) throws CoreException {
        this.addDependency(desc, added, map, entries, true);
    }

    private void addDependency(BundleDescription desc, HashSet added, Map map, ArrayList entries, boolean useInclusion) throws CoreException {
        if (desc == null || !added.add(desc.getSymbolicName())) {
            return;
        }
        BundleDescription[] fragments = this.hasExtensibleAPI(desc) ? desc.getFragments() : new BundleDescription[]{};
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved() && ClasspathUtilCore.isPatchFragment(fragments[i])) {
                this.addDependency(fragments[i], added, map, entries, useInclusion);
            }
            ++i;
        }
        this.addPlugin(desc, useInclusion, map, entries);
        i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved() && !ClasspathUtilCore.isPatchFragment(fragments[i])) {
                this.addDependency(fragments[i], added, map, entries, useInclusion);
            }
            ++i;
        }
        BundleSpecification[] required = desc.getRequiredBundles();
        int i2 = 0;
        while (i2 < required.length) {
            if (required[i2].isExported()) {
                this.addDependency(this.getSupplier(required[i2]), added, map, entries, useInclusion);
            }
            ++i2;
        }
    }

    private boolean addPlugin(BundleDescription desc, boolean useInclusions, Map map, ArrayList entries) throws CoreException {
        PDEClasspathContainer.Rule[] rules;
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(desc);
        if (model == null || !model.isEnabled()) {
            return false;
        }
        IResource resource = model.getUnderlyingResource();
        PDEClasspathContainer.Rule[] ruleArray = rules = useInclusions ? this.getInclusions(map, model) : null;
        if (resource != null) {
            this.addProjectEntry(resource.getProject(), rules, entries);
        } else {
            RequiredPluginsClasspathContainer.addExternalPlugin(model, rules, entries);
        }
        return true;
    }

    private PDEClasspathContainer.Rule[] getInclusions(Map map, IPluginModelBase model) {
        if ("false".equals(System.getProperty("pde.restriction")) || !this.fModel.getBundleDescription().isResolved() || !(this.fModel instanceof IBundlePluginModelBase)) {
            return null;
        }
        if (TargetPlatform.getTargetVersion() < 3.1) {
            return null;
        }
        BundleDescription desc = model.getBundleDescription();
        if (desc == null || !desc.isResolved()) {
            return null;
        }
        PDEClasspathContainer.Rule[] rules = desc.getHost() != null ? this.getInclusions(map, (BundleDescription)desc.getHost().getSupplier()) : this.getInclusions(map, desc);
        return rules.length == 0 && !ClasspathUtilCore.hasBundleStructure(model) ? null : rules;
    }

    private PDEClasspathContainer.Rule[] getInclusions(Map map, BundleDescription desc) {
        ArrayList list = (ArrayList)map.get(desc.getSymbolicName());
        return list != null ? list.toArray(new PDEClasspathContainer.Rule[list.size()]) : new PDEClasspathContainer.Rule[]{};
    }

    private void addHostPlugin(HostSpecification hostSpec, HashSet added, Map map, ArrayList entries) throws CoreException {
        BundleDescription host;
        BaseDescription desc = hostSpec.getSupplier();
        if (desc instanceof BundleDescription && added.add(desc.getName()) && this.addPlugin(host = (BundleDescription)desc, false, map, entries)) {
            BundleSpecification[] required = host.getRequiredBundles();
            int i = 0;
            while (i < required.length) {
                desc = this.getSupplier(required[i]);
                if (desc != null && desc instanceof BundleDescription) {
                    this.addDependency((BundleDescription)desc, added, map, entries);
                }
                ++i;
            }
            ImportPackageSpecification[] imports = host.getImportPackages();
            int i2 = 0;
            while (i2 < imports.length) {
                BaseDescription supplier = imports[i2].getSupplier();
                if (supplier instanceof ExportPackageDescription) {
                    this.addDependencyViaImportPackage(((ExportPackageDescription)supplier).getExporter(), added, map, entries);
                }
                ++i2;
            }
        }
    }

    private boolean hasExtensibleAPI(BundleDescription desc) {
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(desc);
        return model != null ? ClasspathUtilCore.hasExtensibleAPI(model) : false;
    }

    protected void addExtraClasspathEntries(HashSet added, ArrayList entries, IBuild build) throws CoreException {
        IBuildEntry entry = build.getEntry("jars.extra.classpath");
        if (entry == null) {
            return;
        }
        String[] tokens = entry.getTokens();
        int i = 0;
        while (i < tokens.length) {
            block15: {
                File file;
                IPath path;
                block13: {
                    block14: {
                        IFile resource;
                        path = Path.fromPortableString((String)tokens[i]);
                        if (path.isAbsolute()) break block13;
                        file = new File(this.fModel.getInstallLocation(), path.toString());
                        if (!file.exists() || (resource = PDECore.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()))) == null || !resource.getProject().equals((Object)this.fModel.getUnderlyingResource().getProject())) break block14;
                        this.addExtraLibrary(resource.getFullPath(), null, entries);
                        break block15;
                    }
                    if (path.segmentCount() < 3 || !"..".equals(path.segment(0))) break block15;
                    path = path.removeFirstSegments(1);
                    path = Path.fromPortableString((String)"platform:/plugin/").append(path);
                }
                if (!path.toPortableString().startsWith("platform:")) {
                    file = new File(path.toOSString());
                    if (file.exists()) {
                        this.addExtraLibrary(path, null, entries);
                    }
                } else {
                    IPluginModelBase model;
                    String pluginID;
                    int count;
                    int n = count = path.getDevice() == null ? 4 : 3;
                    if (path.segmentCount() >= count && !added.contains(pluginID = path.segment(count - 2)) && (model = PDECore.getDefault().getModelManager().findModel(pluginID)) != null && model.isEnabled()) {
                        path = path.setDevice(null);
                        path = path.removeFirstSegments(count - 1);
                        if (model.getUnderlyingResource() == null) {
                            File file2 = new File(model.getInstallLocation(), path.toOSString());
                            if (file2.exists()) {
                                this.addExtraLibrary((IPath)new Path(file2.getAbsolutePath()), model, entries);
                            }
                        } else {
                            IProject project = model.getUnderlyingResource().getProject();
                            IFile file3 = project.getFile(path);
                            if (file3.exists()) {
                                this.addExtraLibrary(file3.getFullPath(), model, entries);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void addSecondaryDependencies(HashSet added, Map map, ArrayList entries, IBuild build) {
        try {
            IBuildEntry entry = build.getEntry("secondary.libs");
            if (entry != null) {
                String[] tokens = entry.getTokens();
                int i = 0;
                while (i < tokens.length) {
                    IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(tokens[i]);
                    if (model != null) {
                        this.addDependency(model.getBundleDescription(), added, map, entries, false);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private void addExtraLibrary(IPath path, IPluginModelBase model, ArrayList entries) throws CoreException {
        IPath srcPath = null;
        if (model != null) {
            IPath shortPath = path.removeFirstSegments(path.matchingFirstSegments((IPath)new Path(model.getInstallLocation())));
            srcPath = ClasspathUtilCore.getSourceAnnotation(model, shortPath.toString());
        } else {
            String filename = ClasspathUtilCore.getSourceZipName(path.lastSegment());
            IPath candidate = path.removeLastSegments(1).append(filename);
            if (PDECore.getWorkspace().getRoot().getFile(candidate).exists()) {
                srcPath = candidate;
            }
        }
        IClasspathEntry clsEntry = JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null);
        if (!entries.contains(clsEntry)) {
            entries.add(clsEntry);
        }
    }
}

