/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;

public class TargetPlatform
implements IEnvironmentVariables {
    public static Properties getConfigIniProperties() {
        File iniFile = new File(ExternalModelManager.getEclipseHome().toOSString(), "configuration/config.ini");
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            FileInputStream fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            return pini;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getBundleList() {
        String osgiBundles;
        Properties properties = TargetPlatform.getConfigIniProperties();
        String string = osgiBundles = properties == null ? null : properties.getProperty("osgi.bundles");
        if (osgiBundles == null) {
            StringBuffer buffer = new StringBuffer();
            if (TargetPlatform.getTargetVersion() > 3.1) {
                buffer.append("org.eclipse.equinox.common@2:start,");
                buffer.append("org.eclipse.core.jobs@2:start,");
                buffer.append("org.eclipse.core.runtime.compatibility.registry,");
                buffer.append("org.eclipse.equinox.registry@2:start,");
                buffer.append("org.eclipse.equinox.preferences,");
                buffer.append("org.eclipse.core.contenttype,");
            }
            buffer.append("org.eclipse.core.runtime@2:start,");
            buffer.append("org.eclipse.update.configurator@3:start");
            osgiBundles = buffer.toString();
        } else {
            osgiBundles = osgiBundles.replaceAll("\\s", "");
        }
        return osgiBundles;
    }

    public static void createPlatformConfigurationArea(Map pluginMap, File configDir, String brandingPluginID) throws CoreException {
        try {
            if (pluginMap.containsKey("org.eclipse.update.configurator")) {
                TargetPlatform.savePlatformConfiguration(ConfiguratorUtils.getPlatformConfiguration(null), configDir, pluginMap, brandingPluginID);
            }
            TargetPlatform.checkPluginPropertiesConsistency(pluginMap, configDir);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = PDECoreMessages.TargetPlatform_exceptionThrown;
            }
            throw new CoreException((IStatus)new Status(4, PDECore.getPluginId(), 4, message, (Throwable)e));
        }
    }

    private static void checkPluginPropertiesConsistency(Map map, File configDir) {
        File runtimeDir = new File(configDir, "org.eclipse.core.runtime");
        if (runtimeDir.exists() && runtimeDir.isDirectory()) {
            long timestamp = runtimeDir.lastModified();
            Iterator iter = map.values().iterator();
            while (iter.hasNext()) {
                if (!TargetPlatform.hasChanged((IPluginModelBase)iter.next(), timestamp)) continue;
                CoreUtility.deleteContent(runtimeDir);
                break;
            }
        }
    }

    private static boolean hasChanged(IPluginModelBase model, long timestamp) {
        if (model.getUnderlyingResource() != null) {
            File[] files = new File(model.getInstallLocation()).listFiles();
            int i = 0;
            while (i < files.length) {
                String name;
                if (!files[i].isDirectory() && (name = files[i].getName()).startsWith("plugin") && name.endsWith(".properties") && files[i].lastModified() > timestamp) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static void savePlatformConfiguration(IPlatformConfiguration platformConfiguration, File configFile, Map pluginMap, String primaryFeatureId) throws IOException, CoreException, MalformedURLException {
        ArrayList sites = new ArrayList();
        Iterator iter = pluginMap.values().iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            IPath sitePath = TargetPlatform.getTransientSitePath(model);
            TargetPlatform.addToSite(sitePath, model, sites);
        }
        TargetPlatform.createConfigurationEntries(platformConfiguration, sites);
        if (primaryFeatureId != null) {
            TargetPlatform.createFeatureEntries(platformConfiguration, pluginMap, primaryFeatureId);
        }
        platformConfiguration.refresh();
        platformConfiguration.save(new URL("file:" + configFile.getPath()));
    }

    private static IPath getTransientSitePath(IPluginModelBase model) {
        return new Path(model.getInstallLocation()).removeLastSegments(2);
    }

    private static void addToSite(IPath path, IPluginModelBase model, ArrayList sites) {
        if (path.getDevice() != null) {
            path = path.setDevice(path.getDevice().toUpperCase(Locale.ENGLISH));
        }
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            if (localSite.getPath().equals((Object)path)) {
                localSite.add(model);
                return;
            }
            ++i;
        }
        LocalSite localSite = new LocalSite(path);
        localSite.add(model);
        sites.add(localSite);
    }

    private static void createConfigurationEntries(IPlatformConfiguration config, ArrayList sites) throws CoreException, MalformedURLException {
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            String[] plugins = localSite.getRelativePluginList();
            int policy = 0;
            IPlatformConfiguration.ISitePolicy sitePolicy = config.createSitePolicy(policy, plugins);
            IPlatformConfiguration.ISiteEntry siteEntry = config.createSiteEntry(localSite.getURL(), sitePolicy);
            config.configureSite(siteEntry);
            ++i;
        }
        config.isTransient(true);
    }

    private static void createFeatureEntries(IPlatformConfiguration config, Map pluginMap, String brandingPluginID) throws MalformedURLException {
        IFeatureModel featureModel = PDECore.getDefault().getFeatureModelManager().findFeatureModel(brandingPluginID);
        if (featureModel == null) {
            return;
        }
        IFeature feature = featureModel.getFeature();
        String featureVersion = feature.getVersion();
        IPluginModelBase primaryPlugin = (IPluginModelBase)pluginMap.get(brandingPluginID);
        if (primaryPlugin == null) {
            return;
        }
        URL pluginURL = new URL("file:" + primaryPlugin.getInstallLocation());
        URL[] root = new URL[]{pluginURL};
        IPlatformConfiguration.IFeatureEntry featureEntry = config.createFeatureEntry(brandingPluginID, featureVersion, brandingPluginID, primaryPlugin.getPluginBase().getVersion(), true, null, root);
        config.configureFeatureEntry(featureEntry);
    }

    public static String getOS() {
        String value = TargetPlatform.getProperty("org.eclipse.pde.ui.os");
        return value.equals("") ? Platform.getOS() : value;
    }

    public static String getWS() {
        String value = TargetPlatform.getProperty("org.eclipse.pde.ui.ws");
        return value.equals("") ? Platform.getWS() : value;
    }

    public static String getNL() {
        String value = TargetPlatform.getProperty("org.eclipse.pde.ui.nl");
        return value.equals("") ? Platform.getNL() : value;
    }

    public static String getOSArch() {
        String value = TargetPlatform.getProperty("org.eclipse.pde.ui.arch");
        return value.equals("") ? Platform.getOSArch() : value;
    }

    private static String getProperty(String key) {
        return PDECore.getDefault().getPluginPreferences().getString(key);
    }

    public static String[] getApplicationNames() {
        TreeSet<String> result = new TreeSet<String>();
        IPluginModelBase[] plugins = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < plugins.length) {
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                String id;
                String point = extensions[j].getPoint();
                if (point != null && point.equals("org.eclipse.core.runtime.applications") && (id = extensions[j].getPluginBase().getId()) != null && id.trim().length() != 0 && !id.startsWith("org.eclipse.pde.junit.runtime") && extensions[j].getId() != null) {
                    result.add(String.valueOf(id) + "." + extensions[j].getId());
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public static TreeSet getProductNameSet() {
        TreeSet<String> result = new TreeSet<String>();
        IPluginModelBase[] plugins = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < plugins.length) {
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                String id;
                IPluginObject[] children;
                String point = extensions[j].getPoint();
                if (point != null && point.equals("org.eclipse.core.runtime.products") && (children = extensions[j].getChildren()).length == 1 && "product".equals(children[0].getName()) && (id = extensions[j].getPluginBase().getId()) != null && id.trim().length() != 0 && extensions[j].getId() != null) {
                    result.add(String.valueOf(id) + "." + extensions[j].getId());
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static String[] getProductNames() {
        TreeSet result = TargetPlatform.getProductNameSet();
        return result.toArray(new String[result.size()]);
    }

    public static Dictionary getTargetEnvironment() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        ((Dictionary)result).put("osgi.os", TargetPlatform.getOS());
        ((Dictionary)result).put("osgi.ws", TargetPlatform.getWS());
        ((Dictionary)result).put("osgi.nl", TargetPlatform.getNL());
        ((Dictionary)result).put("osgi.arch", TargetPlatform.getOSArch());
        ((Dictionary)result).put("osgi.resolveOptional", "true");
        return result;
    }

    public static String getTargetVersionString() {
        return PDECore.getDefault().getModelManager().getTargetVersion();
    }

    public static double getTargetVersion() {
        return Double.parseDouble(TargetPlatform.getTargetVersionString());
    }

    public static PDEState getPDEState() {
        return PDECore.getDefault().getModelManager().getState();
    }

    public static State getState() {
        return TargetPlatform.getPDEState().getState();
    }

    public static Map getPatchMap(PDEState state) {
        HashMap<Long, String> properties = new HashMap<Long, String>();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        IPluginModelBase[] models = manager.getAllPlugins();
        int i = 0;
        while (i < models.length) {
            BundleDescription desc = models[i].getBundleDescription();
            if (desc != null) {
                Long id = new Long(desc.getBundleId());
                if (ClasspathUtilCore.hasExtensibleAPI(models[i])) {
                    properties.put(id, "Eclipse-ExtensibleAPI: true");
                } else if (ClasspathUtilCore.isPatchFragment(models[i])) {
                    properties.put(id, "Eclipse-PatchFragment: true");
                }
            }
            ++i;
        }
        return properties;
    }

    public static HashMap getBundleClasspaths(PDEState state) {
        HashMap<Long, String[]> properties = new HashMap<Long, String[]>();
        BundleDescription[] bundles = state.getState().getBundles();
        int i = 0;
        while (i < bundles.length) {
            properties.put(new Long(bundles[i].getBundleId()), TargetPlatform.getValue(bundles[i], state));
            ++i;
        }
        return properties;
    }

    private static String[] getValue(BundleDescription bundle, PDEState state) {
        IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(bundle);
        String[] result = null;
        if (model != null) {
            IPluginLibrary[] libs = model.getPluginBase().getLibraries();
            result = new String[libs.length];
            int i = 0;
            while (i < libs.length) {
                result[i] = libs[i].getName();
                ++i;
            }
        } else {
            String[] libs = state.getLibraryNames(bundle.getBundleId());
            result = new String[libs.length];
            int i = 0;
            while (i < libs.length) {
                result[i] = libs[i];
                ++i;
            }
        }
        if (result.length == 0) {
            return new String[]{"."};
        }
        return result;
    }

    public static String[] getFeaturePaths() {
        IFeatureModel[] models = PDECore.getDefault().getFeatureModelManager().getModels();
        String[] paths = new String[models.length];
        int i = 0;
        while (i < models.length) {
            paths[i] = String.valueOf(models[i].getInstallLocation()) + '/' + "feature.xml";
            ++i;
        }
        return paths;
    }

    public static String getDefaultProduct() {
        String product;
        Properties config = TargetPlatform.getConfigIniProperties();
        if (config != null && (product = (String)config.get("eclipse.product")) != null && TargetPlatform.getProductNameSet().contains(product)) {
            return product;
        }
        TreeSet set = TargetPlatform.getProductNameSet();
        if (set.contains("org.eclipse.sdk.ide")) {
            return "org.eclipse.sdk.ide";
        }
        return set.contains("org.eclipse.platform.ide") ? "org.eclipse.platform.ide" : null;
    }

    public static boolean isRuntimeRefactored1() {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        return manager.findEntry("org.eclipse.equinox.common") != null;
    }

    public static boolean isRuntimeRefactored2() {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        return manager.findEntry("org.eclipse.core.runtime.compatibility.registry") != null;
    }

    static class LocalSite {
        private ArrayList plugins;
        private IPath path;

        public LocalSite(IPath path) {
            this.path = path.getDevice() != null ? path.setDevice(path.getDevice().toUpperCase(Locale.ENGLISH)) : path;
            this.plugins = new ArrayList();
        }

        public IPath getPath() {
            return this.path;
        }

        public URL getURL() throws MalformedURLException {
            return new URL("file:" + this.path.addTrailingSeparator().toString());
        }

        public void add(IPluginModelBase model) {
            this.plugins.add(model);
        }

        public String[] getRelativePluginList() {
            String[] list = new String[this.plugins.size()];
            int i = 0;
            while (i < this.plugins.size()) {
                IPluginModelBase model = (IPluginModelBase)this.plugins.get(i);
                Path location = new Path(model.getInstallLocation());
                if (location.segmentCount() > 2) {
                    location = location.removeFirstSegments(location.segmentCount() - 2);
                }
                list[i] = location.setDevice(null).makeRelative().toString();
                ++i;
            }
            return list;
        }
    }
}

