/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.pde.internal.core.itarget.IAdditionalLocation;
import org.eclipse.pde.internal.core.itarget.IArgumentsInfo;
import org.eclipse.pde.internal.core.itarget.IEnvironmentInfo;
import org.eclipse.pde.internal.core.itarget.IImplicitDependenciesInfo;
import org.eclipse.pde.internal.core.itarget.ILocationInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetFeature;
import org.eclipse.pde.internal.core.itarget.ITargetJRE;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.itarget.ITargetModelFactory;
import org.eclipse.pde.internal.core.itarget.ITargetPlugin;
import org.eclipse.pde.internal.core.target.TargetObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Target
extends TargetObject
implements ITarget {
    private static final long serialVersionUID = 1L;
    private String fName;
    private TreeMap fPlugins = new TreeMap();
    private TreeMap fFeatures = new TreeMap();
    private IArgumentsInfo fArgsInfo;
    private IEnvironmentInfo fEnvInfo;
    private ITargetJRE fRuntimeInfo;
    private ILocationInfo fLocationInfo;
    private IImplicitDependenciesInfo fImplicitInfo;
    private boolean fUseAllTargetPlatform = false;
    private Set fAdditionalDirectories = new HashSet();

    public Target(ITargetModel model) {
        super(model);
    }

    public void reset() {
        this.fArgsInfo = null;
        this.fEnvInfo = null;
        this.fRuntimeInfo = null;
        this.fLocationInfo = null;
        this.fImplicitInfo = null;
        this.fPlugins.clear();
        this.fFeatures.clear();
        this.fUseAllTargetPlatform = false;
        this.fAdditionalDirectories.clear();
    }

    public void parse(Node node) {
        if (node.getNodeType() == 1 && node.getNodeName().equals("target")) {
            Element element = (Element)node;
            this.fName = element.getAttribute("name");
            NodeList children = node.getChildNodes();
            ITargetModelFactory factory = this.getModel().getFactory();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    String name = child.getNodeName();
                    if (name.equals("launcherArgs")) {
                        this.fArgsInfo = factory.createArguments();
                        this.fArgsInfo.parse(child);
                    } else if (name.equals("content")) {
                        this.parseContent((Element)child);
                    } else if (name.equals("environment")) {
                        this.fEnvInfo = factory.createEnvironment();
                        this.fEnvInfo.parse(child);
                    } else if (name.equals("targetJRE")) {
                        this.fRuntimeInfo = factory.createJREInfo();
                        this.fRuntimeInfo.parse(child);
                    } else if (name.equals("location")) {
                        this.fLocationInfo = factory.createLocation();
                        this.fLocationInfo.parse(child);
                    } else if (name.equals("implicitDependencies")) {
                        this.fImplicitInfo = factory.createImplicitPluginInfo();
                        this.fImplicitInfo.parse(child);
                    }
                }
                ++i;
            }
        }
    }

    private void parseContent(Element content) {
        this.fUseAllTargetPlatform = "true".equals(content.getAttribute("useAllPlugins"));
        NodeList children = content.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if ("plugins".equals(node.getNodeName())) {
                this.parsePlugins(node.getChildNodes());
            } else if ("features".equals(node.getNodeName())) {
                this.parseFeatures(node.getChildNodes());
            } else if ("extraLocations".equals(node.getNodeName())) {
                this.parseLocations(node.getChildNodes());
            }
            ++i;
        }
    }

    private void parsePlugins(NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("plugin")) {
                ITargetPlugin plugin = this.getModel().getFactory().createPlugin();
                plugin.parse(child);
                this.fPlugins.put(plugin.getId(), plugin);
            }
            ++i;
        }
    }

    private void parseFeatures(NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("feature")) {
                ITargetFeature feature = this.getModel().getFactory().createFeature();
                feature.parse(child);
                this.fFeatures.put(feature.getId(), feature);
            }
            ++i;
        }
    }

    private void parseLocations(NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("location")) {
                IAdditionalLocation loc = this.getModel().getFactory().createAdditionalLocation();
                loc.parse(child);
                this.fAdditionalDirectories.add(loc);
            }
            ++i;
        }
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<target");
        if (this.fName != null && this.fName.length() > 0) {
            writer.print(" name=\"" + this.getWritableString(this.fName) + "\"");
        }
        writer.println(">");
        if (this.fArgsInfo != null) {
            this.fArgsInfo.write(String.valueOf(indent) + "   ", writer);
        }
        if (this.fEnvInfo != null) {
            this.fEnvInfo.write(String.valueOf(indent) + "   ", writer);
        }
        if (this.fRuntimeInfo != null) {
            this.fRuntimeInfo.write(String.valueOf(indent) + "   ", writer);
        }
        if (this.fLocationInfo != null) {
            this.fLocationInfo.write(String.valueOf(indent) + "   ", writer);
        }
        writer.println();
        if (this.fUseAllTargetPlatform) {
            writer.println(String.valueOf(indent) + "   <content useAllPlugins=\"true\">");
        } else {
            writer.println(String.valueOf(indent) + "   <content>");
        }
        writer.println(String.valueOf(indent) + "      <plugins>");
        Iterator<Object> iter = this.fPlugins.values().iterator();
        while (iter.hasNext()) {
            ITargetPlugin plugin = (ITargetPlugin)iter.next();
            plugin.write(String.valueOf(indent) + "         ", writer);
        }
        writer.println(String.valueOf(indent) + "      </plugins>");
        writer.println(String.valueOf(indent) + "      <features>");
        iter = this.fFeatures.values().iterator();
        while (iter.hasNext()) {
            ITargetFeature feature = (ITargetFeature)iter.next();
            feature.write(String.valueOf(indent) + "         ", writer);
        }
        writer.println(String.valueOf(indent) + "      </features>");
        if (!this.fAdditionalDirectories.isEmpty()) {
            writer.println(String.valueOf(indent) + "      <extraLocations>");
            iter = this.fAdditionalDirectories.iterator();
            while (iter.hasNext()) {
                IAdditionalLocation location = (IAdditionalLocation)iter.next();
                location.write(String.valueOf(indent) + "         ", writer);
            }
            writer.println(String.valueOf(indent) + "      </extraLocations>");
        }
        writer.println(String.valueOf(indent) + "   </content>");
        if (this.fImplicitInfo != null) {
            this.fImplicitInfo.write(String.valueOf(indent) + "   ", writer);
        }
        writer.println();
        writer.println(String.valueOf(indent) + "</target>");
    }

    public IArgumentsInfo getArguments() {
        return this.fArgsInfo;
    }

    public void setArguments(IArgumentsInfo info) {
        this.fArgsInfo = info;
    }

    public IEnvironmentInfo getEnvironment() {
        return this.fEnvInfo;
    }

    public void setEnvironment(IEnvironmentInfo info) {
        this.fEnvInfo = info;
    }

    public ITargetJRE getTargetJREInfo() {
        return this.fRuntimeInfo;
    }

    public void setTargetJREInfo(ITargetJRE info) {
        this.fRuntimeInfo = info;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        String oldValue = this.fName;
        this.fName = name;
        this.firePropertyChanged("name", oldValue, this.fName);
    }

    public ILocationInfo getLocationInfo() {
        return this.fLocationInfo;
    }

    public void setLocationInfo(ILocationInfo info) {
        this.fLocationInfo = info;
    }

    public void addPlugin(ITargetPlugin plugin) {
        this.addPlugins(new ITargetPlugin[]{plugin});
    }

    public void addPlugins(ITargetPlugin[] plugins) {
        boolean modify = false;
        int i = 0;
        while (i < plugins.length) {
            String id = plugins[i].getId();
            if (!this.fPlugins.containsKey(id)) {
                modify = true;
                plugins[i].setModel(this.getModel());
                this.fPlugins.put(id, plugins[i]);
            }
            ++i;
        }
        if (this.isEditable() && modify) {
            this.fireStructureChanged(plugins, 1);
        }
    }

    public void addFeature(ITargetFeature feature) {
        this.addFeatures(new ITargetFeature[]{feature});
    }

    public void addFeatures(ITargetFeature[] features) {
        boolean modify = false;
        int i = 0;
        while (i < features.length) {
            String id = features[i].getId();
            if (!this.fFeatures.containsKey(id)) {
                modify = true;
                features[i].setModel(this.getModel());
                this.fFeatures.put(id, features[i]);
            }
            ++i;
        }
        if (this.isEditable() && modify) {
            this.fireStructureChanged(features, 1);
        }
    }

    public void removePlugin(ITargetPlugin plugin) {
        this.removePlugins(new ITargetPlugin[]{plugin});
    }

    public void removePlugins(ITargetPlugin[] plugins) {
        boolean modify = false;
        int i = 0;
        while (i < plugins.length) {
            modify = this.fPlugins.remove(plugins[i].getId()) != null || modify;
            ++i;
        }
        if (this.isEditable() && modify) {
            this.fireStructureChanged(plugins, 2);
        }
    }

    public void removeFeature(ITargetFeature feature) {
        this.removeFeatures(new ITargetFeature[]{feature});
    }

    public void removeFeatures(ITargetFeature[] features) {
        boolean modify = false;
        int i = 0;
        while (i < features.length) {
            modify = this.fFeatures.remove(features[i].getId()) != null || modify;
            ++i;
        }
        if (this.isEditable() && modify) {
            this.fireStructureChanged(features, 2);
        }
    }

    public ITargetPlugin[] getPlugins() {
        return this.fPlugins.values().toArray(new ITargetPlugin[this.fPlugins.size()]);
    }

    public ITargetFeature[] getFeatures() {
        return this.fFeatures.values().toArray(new ITargetFeature[this.fFeatures.size()]);
    }

    public boolean containsPlugin(String id) {
        return this.fPlugins.containsKey(id);
    }

    public boolean containsFeature(String id) {
        return this.fFeatures.containsKey(id);
    }

    public boolean useAllPlugins() {
        return this.fUseAllTargetPlatform;
    }

    public void setUseAllPlugins(boolean value) {
        boolean oldValue = this.fUseAllTargetPlatform;
        this.fUseAllTargetPlatform = value;
        if (this.isEditable()) {
            this.firePropertyChanged("useAllPlugins", new Boolean(oldValue), new Boolean(this.fUseAllTargetPlatform));
        }
    }

    public void setImplicitPluginsInfo(IImplicitDependenciesInfo info) {
        this.fImplicitInfo = info;
    }

    public IImplicitDependenciesInfo getImplicitPluginsInfo() {
        return this.fImplicitInfo;
    }

    public IAdditionalLocation[] getAdditionalDirectories() {
        return this.fAdditionalDirectories.toArray(new IAdditionalLocation[this.fAdditionalDirectories.size()]);
    }

    public void addAdditionalDirectories(IAdditionalLocation[] dirs) {
        int i = 0;
        while (i < dirs.length) {
            this.fAdditionalDirectories.add(dirs[i]);
            ++i;
        }
        this.fireStructureChanged(dirs, 1);
    }

    public void removeAdditionalDirectories(IAdditionalLocation[] dirs) {
        int i = 0;
        while (i < dirs.length) {
            this.fAdditionalDirectories.remove(dirs[i]);
            ++i;
        }
        this.fireStructureChanged(dirs, 2);
    }
}

