/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

class SelectResourcesBlock
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    private Object root;
    private Object currentTreeSelection;
    private Collection expandedTreeNodes = new HashSet();
    private Map checkedStateStore = new HashMap(9);
    private Collection whiteCheckedTreeItems = new HashSet();
    private ListenerList listeners = new ListenerList(1);
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private CheckboxTreeViewer treeViewer;
    private CheckboxTableViewer listViewer;
    private static int PREFERRED_HEIGHT = 150;

    public SelectResourcesBlock(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, IStructuredContentProvider listContentProvider, ILabelProvider listLabelProvider, int style, boolean useHeightHint) {
        this.root = rootObject;
        this.treeContentProvider = treeContentProvider;
        this.listContentProvider = listContentProvider;
        this.treeLabelProvider = treeLabelProvider;
        this.listLabelProvider = listLabelProvider;
        this.createContents(parent, style, useHeightHint);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.listeners.add((Object)listener);
    }

    private void checkNewTreeElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            Object currentElement = elements[i];
            boolean checked = this.checkedStateStore.containsKey(currentElement);
            this.treeViewer.setChecked(currentElement, checked);
            this.treeViewer.setGrayed(currentElement, checked && !this.whiteCheckedTreeItems.contains(currentElement));
            ++i;
        }
    }

    public void checkStateChanged(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (event.getCheckable().equals(SelectResourcesBlock.this.treeViewer)) {
                    SelectResourcesBlock.this.treeItemChecked(event.getElement(), event.getChecked());
                } else {
                    SelectResourcesBlock.this.listItemChecked(event.getElement(), event.getChecked(), true);
                }
                SelectResourcesBlock.this.notifyCheckStateChangeListeners(event);
            }
        });
    }

    private void createContents(Composite parent, int style, boolean useHeightHint) {
        Composite composite = new Composite(parent, style);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite, useHeightHint);
        this.createListViewer(composite, useHeightHint);
        this.initialize();
    }

    private void createListViewer(Composite parent, boolean useHeightHint) {
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(parent.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.addCheckStateListener((ICheckStateListener)this);
    }

    private void createTreeViewer(Composite parent, boolean useHeightHint) {
        Tree tree = new Tree(parent, 2080);
        GridData data = new GridData(1808);
        if (useHeightHint) {
            data.heightHint = PREFERRED_HEIGHT;
        }
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.treeViewer.addCheckStateListener((ICheckStateListener)this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        List checked = (List)this.checkedStateStore.get(treeElement);
        if (checked != null && !checked.isEmpty()) {
            return true;
        }
        if (this.expandedTreeNodes.contains(treeElement)) {
            Object[] children = this.treeContentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                if (this.checkedStateStore.containsKey(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void expandTreeElement(final Object element) {
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (SelectResourcesBlock.this.expandedTreeNodes.contains(element)) {
                    SelectResourcesBlock.this.checkNewTreeElements(SelectResourcesBlock.this.treeContentProvider.getChildren(element));
                } else {
                    SelectResourcesBlock.this.expandedTreeNodes.add(element);
                    if (SelectResourcesBlock.this.whiteCheckedTreeItems.contains(element)) {
                        Object[] children = SelectResourcesBlock.this.treeContentProvider.getChildren(element);
                        int i = 0;
                        while (i < children.length) {
                            if (!SelectResourcesBlock.this.whiteCheckedTreeItems.contains(children[i])) {
                                Object child = children[i];
                                SelectResourcesBlock.this.setWhiteChecked(child, true);
                                SelectResourcesBlock.this.treeViewer.setChecked(child, true);
                                SelectResourcesBlock.this.checkedStateStore.put(child, new ArrayList());
                            }
                            ++i;
                        }
                        SelectResourcesBlock.this.setListForWhiteSelection(element);
                    }
                }
            }
        });
    }

    private void findAllSelectedListElements(Object treeElement, String parentLabel, boolean addAll, IElementFilter filter) throws InterruptedException {
        String fullLabel = null;
        if (addAll) {
            filter.filterElements(this.listContentProvider.getElements(treeElement));
        } else if (this.checkedStateStore.containsKey(treeElement)) {
            filter.filterElements((Collection)this.checkedStateStore.get(treeElement));
        }
        Object[] treeChildren = this.treeContentProvider.getChildren(treeElement);
        int i = 0;
        while (i < treeChildren.length) {
            Object child = treeChildren[i];
            if (addAll) {
                this.findAllSelectedListElements(child, fullLabel, true, filter);
            } else if (this.checkedStateStore.containsKey(child)) {
                this.findAllSelectedListElements(child, fullLabel, this.whiteCheckedTreeItems.contains(child), filter);
            }
            ++i;
        }
    }

    private void findAllWhiteCheckedItems(Object treeElement, Collection result) {
        if (this.whiteCheckedTreeItems.contains(treeElement)) {
            result.add(treeElement);
        } else {
            Collection listChildren = (Collection)this.checkedStateStore.get(treeElement);
            if (listChildren == null) {
                return;
            }
            result.addAll(listChildren);
            Object[] children = this.treeContentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                this.findAllWhiteCheckedItems(children[i], result);
                ++i;
            }
        }
    }

    private void getAllCheckedListItems(IElementFilter filter) throws InterruptedException {
        Object[] children = this.treeContentProvider.getChildren(this.root);
        int i = 0;
        while (i < children.length) {
            this.findAllSelectedListElements(children[i], null, this.whiteCheckedTreeItems.contains(children[i]), filter);
            ++i;
        }
    }

    public List getAllCheckedListItems() {
        final ArrayList returnValue = new ArrayList();
        IElementFilter passThroughFilter = new IElementFilter(){

            public void filterElements(Collection elements) throws InterruptedException {
                returnValue.addAll(elements);
            }

            public void filterElements(Object[] elements) throws InterruptedException {
                int i = 0;
                while (i < elements.length) {
                    returnValue.add(elements[i]);
                    ++i;
                }
            }
        };
        try {
            this.getAllCheckedListItems(passThroughFilter);
        }
        catch (InterruptedException interruptedException) {
            return new ArrayList();
        }
        return returnValue;
    }

    public List getAllWhiteCheckedItems() {
        ArrayList result = new ArrayList();
        Object[] children = this.treeContentProvider.getChildren(this.root);
        int i = 0;
        while (i < children.length) {
            this.findAllWhiteCheckedItems(children[i], result);
            ++i;
        }
        return result;
    }

    private void grayCheckHierarchy(Object treeElement) {
        this.expandTreeElement(treeElement);
        if (this.checkedStateStore.containsKey(treeElement)) {
            return;
        }
        this.checkedStateStore.put(treeElement, new ArrayList());
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    private void grayUpdateHierarchy(Object treeElement) {
        Object parent;
        boolean shouldBeAtLeastGray = this.determineShouldBeAtLeastGrayChecked(treeElement);
        this.treeViewer.setGrayChecked(treeElement, shouldBeAtLeastGray);
        if (this.whiteCheckedTreeItems.contains(treeElement)) {
            this.whiteCheckedTreeItems.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.grayUpdateHierarchy(parent);
        }
    }

    public void selectAndReveal(Object treeElement) {
        this.treeViewer.reveal(treeElement);
        StructuredSelection selection = new StructuredSelection(treeElement);
        this.treeViewer.setSelection((ISelection)selection);
    }

    private void initialize() {
        this.treeViewer.setInput(this.root);
        this.expandedTreeNodes = new ArrayList();
        this.expandedTreeNodes.add(this.root);
    }

    private void listItemChecked(Object listElement, boolean state, boolean updatingFromSelection) {
        List checkedListItems = (List)this.checkedStateStore.get(this.currentTreeSelection);
        if (!this.expandedTreeNodes.contains(this.currentTreeSelection)) {
            this.expandTreeElement(this.currentTreeSelection);
        }
        if (state) {
            if (checkedListItems == null) {
                this.grayCheckHierarchy(this.currentTreeSelection);
                checkedListItems = (List)this.checkedStateStore.get(this.currentTreeSelection);
            }
            checkedListItems.add(listElement);
        } else {
            checkedListItems.remove(listElement);
            if (checkedListItems.isEmpty()) {
                this.ungrayCheckHierarchy(this.currentTreeSelection);
            }
        }
        if (checkedListItems.size() > 0) {
            this.checkedStateStore.put(this.currentTreeSelection, checkedListItems);
        }
        if (updatingFromSelection) {
            this.grayUpdateHierarchy(this.currentTreeSelection);
        }
    }

    private void notifyCheckStateChangeListeners(final CheckStateChangedEvent event) {
        Object[] array = this.listeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
            ++i;
        }
    }

    private void populateListViewer(final Object treeElement) {
        this.listViewer.setInput(treeElement);
        if (!this.expandedTreeNodes.contains(treeElement) && this.whiteCheckedTreeItems.contains(treeElement)) {
            BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    SelectResourcesBlock.this.setListForWhiteSelection(treeElement);
                    SelectResourcesBlock.this.listViewer.setAllChecked(true);
                }
            });
        } else {
            List listItemsToCheck = (List)this.checkedStateStore.get(treeElement);
            if (listItemsToCheck != null) {
                Iterator listItemsEnum = listItemsToCheck.iterator();
                while (listItemsEnum.hasNext()) {
                    this.listViewer.setChecked(listItemsEnum.next(), true);
                }
            }
        }
    }

    private void primeHierarchyForSelection(Object item, Set selectedNodes) {
        if (selectedNodes.contains(item)) {
            return;
        }
        this.checkedStateStore.put(item, new ArrayList());
        this.expandedTreeNodes.add(item);
        selectedNodes.add(item);
        Object parent = this.treeContentProvider.getParent(item);
        if (parent != null) {
            this.primeHierarchyForSelection(parent, selectedNodes);
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(this.currentTreeSelection);
            return;
        }
        if (selectedElement != this.currentTreeSelection) {
            this.populateListViewer(selectedElement);
        }
        this.currentTreeSelection = selectedElement;
    }

    public void setAllSelections(final boolean selection) {
        if (this.root == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SelectResourcesBlock.this.setTreeChecked(SelectResourcesBlock.this.root, selection);
                SelectResourcesBlock.this.listViewer.setAllChecked(selection);
            }
        });
    }

    private void setListForWhiteSelection(Object treeElement) {
        Object[] listItems = this.listContentProvider.getElements(treeElement);
        ArrayList<Object> listItemsChecked = new ArrayList<Object>();
        int i = 0;
        while (i < listItems.length) {
            listItemsChecked.add(listItems[i]);
            ++i;
        }
        this.checkedStateStore.put(treeElement, listItemsChecked);
    }

    public void setListSorter(ViewerSorter sorter) {
        this.listViewer.setSorter(sorter);
    }

    private void setTreeChecked(Object treeElement, boolean state) {
        if (treeElement.equals(this.currentTreeSelection)) {
            this.listViewer.setAllChecked(state);
        }
        if (state) {
            this.setListForWhiteSelection(treeElement);
        } else {
            this.checkedStateStore.remove(treeElement);
        }
        this.setWhiteChecked(treeElement, state);
        this.treeViewer.setChecked(treeElement, state);
        this.treeViewer.setGrayed(treeElement, false);
        if (this.expandedTreeNodes.contains(treeElement)) {
            Object[] children = this.treeContentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                this.setTreeChecked(children[i], state);
                ++i;
            }
        }
    }

    public void setTreeSorter(ViewerSorter sorter) {
        this.treeViewer.setSorter(sorter);
    }

    private void setWhiteChecked(Object treeElement, boolean isWhiteChecked) {
        if (isWhiteChecked) {
            if (!this.whiteCheckedTreeItems.contains(treeElement)) {
                this.whiteCheckedTreeItems.add(treeElement);
            }
        } else {
            this.whiteCheckedTreeItems.remove(treeElement);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.expandTreeElement(event.getElement());
    }

    private void treeItemChecked(Object treeElement, boolean state) {
        this.setTreeChecked(treeElement, state);
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent == null) {
            return;
        }
        if (state) {
            this.grayCheckHierarchy(parent);
        } else {
            this.ungrayCheckHierarchy(parent);
        }
        this.grayUpdateHierarchy(parent);
    }

    private void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.checkedStateStore.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    public void updateSelections(Map items) {
        Object displayItems;
        this.listViewer.setAllChecked(false);
        this.treeViewer.setCheckedElements(new Object[0]);
        this.whiteCheckedTreeItems = new HashSet();
        HashSet selectedNodes = new HashSet();
        this.checkedStateStore = new HashMap();
        Iterator keyIterator = items.keySet().iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            this.primeHierarchyForSelection(key, selectedNodes);
            this.checkedStateStore.put(key, items.get(key));
        }
        this.treeViewer.setCheckedElements(this.checkedStateStore.keySet().toArray());
        this.treeViewer.setGrayedElements(this.checkedStateStore.keySet().toArray());
        if (this.currentTreeSelection != null && (displayItems = items.get(this.currentTreeSelection)) != null) {
            this.listViewer.setCheckedElements(((List)displayItems).toArray());
        }
    }

    static interface IElementFilter {
        public void filterElements(Collection var1) throws InterruptedException;

        public void filterElements(Object[] var1) throws InterruptedException;
    }
}

