/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractIntroIdElement
extends AbstractIntroElement {
    public static final String ATT_ID = "id";
    public static final String ATT_FILTER = "filter";
    public static final String ATT_NAME = "name";
    public static final String ATT_VALUE = "value";
    public static final String ELEMENT_FILTER = "filter";
    protected String id;
    private Map filters;

    AbstractIntroIdElement(IConfigurationElement element) {
        super(element);
        this.id = element.getAttribute(ATT_ID);
    }

    AbstractIntroIdElement(Element element, Bundle bundle) {
        super(element, bundle);
        this.id = this.getAttribute(element, ATT_ID);
        this.filters = AbstractIntroIdElement.findFilters(element);
    }

    AbstractIntroIdElement(Element element, Bundle bundle, String base) {
        super(element, bundle, base);
        this.id = this.getAttribute(element, ATT_ID);
        this.filters = AbstractIntroIdElement.findFilters(element);
    }

    private static Map findFilters(Element element) {
        HashMap<String, String> map = null;
        String filterAttribute = element.getAttribute("filter");
        if (filterAttribute.length() > 0) {
            map = new HashMap<String, String>();
            int equalsIndex = filterAttribute.indexOf(61);
            String name = filterAttribute.substring(0, equalsIndex);
            String value = filterAttribute.substring(equalsIndex + 1);
            map.put(name, value);
        }
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1 && "filter".equals(node.getNodeName())) {
                Element elementNode = (Element)node;
                if (map == null) {
                    map = new HashMap();
                }
                map.put(elementNode.getAttribute(ATT_NAME), elementNode.getAttribute(ATT_VALUE));
            }
            ++i;
        }
        return map;
    }

    public String getId() {
        return this.id;
    }

    public Map getFilters() {
        return this.filters;
    }
}

