/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.presentations;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ITrimManager;
import org.eclipse.ui.IWindowTrim;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.RectangleAnimation;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.Messages;
import org.eclipse.ui.internal.intro.impl.model.IntroLaunchBarElement;
import org.eclipse.ui.internal.intro.impl.model.IntroLaunchBarShortcut;
import org.eclipse.ui.internal.intro.impl.swt.SharedStyleManager;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.CustomizableIntroPart;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;

public class IntroLaunchBar
implements IWindowTrim {
    private Composite container;
    protected ToolBarManager toolBarManager;
    protected int orientation;
    protected int location;
    protected String lastPageId;
    protected Action closeAction = null;
    private IntroLaunchBarElement element;
    protected boolean simple;
    private String presentationId;
    static final int[] TOP_LEFT_CORNER;
    static final int[] TOP_RIGHT_CORNER;
    static final int[] BOTTOM_LEFT_CORNER;
    static final int[] BOTTOM_RIGHT_CORNER;
    static final int[] SIMPLE_TOP_LEFT_CORNER;
    static final int[] SIMPLE_TOP_RIGHT_CORNER;
    static final int[] SIMPLE_BOTTOM_LEFT_CORNER;
    static final int[] SIMPLE_BOTTOM_RIGHT_CORNER;
    static final String S_STORED_LOCATION = "introLaunchBar.location";
    private static final String LAUNCH_COMMAND_BASE = "http://org.eclipse.ui.intro/showPage?id=";
    private Color fg;
    private Color bg;

    static {
        int[] nArray = new int[12];
        nArray[1] = 6;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 1;
        nArray[5] = 4;
        nArray[6] = 4;
        nArray[7] = 1;
        nArray[8] = 5;
        nArray[9] = 1;
        nArray[10] = 6;
        TOP_LEFT_CORNER = nArray;
        int[] nArray2 = new int[12];
        nArray2[0] = -6;
        nArray2[2] = -5;
        nArray2[3] = 1;
        nArray2[4] = -4;
        nArray2[5] = 1;
        nArray2[6] = -1;
        nArray2[7] = 4;
        nArray2[8] = -1;
        nArray2[9] = 5;
        nArray2[11] = 6;
        TOP_RIGHT_CORNER = nArray2;
        int[] nArray3 = new int[12];
        nArray3[1] = -6;
        nArray3[2] = 1;
        nArray3[3] = -5;
        nArray3[4] = 1;
        nArray3[5] = -4;
        nArray3[6] = 4;
        nArray3[7] = -1;
        nArray3[8] = 5;
        nArray3[9] = -1;
        nArray3[10] = 6;
        BOTTOM_LEFT_CORNER = nArray3;
        int[] nArray4 = new int[12];
        nArray4[0] = -6;
        nArray4[2] = -5;
        nArray4[3] = -1;
        nArray4[4] = -4;
        nArray4[5] = -1;
        nArray4[6] = -1;
        nArray4[7] = -4;
        nArray4[8] = -1;
        nArray4[9] = -5;
        nArray4[11] = -6;
        BOTTOM_RIGHT_CORNER = nArray4;
        int[] nArray5 = new int[6];
        nArray5[1] = 2;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 2;
        SIMPLE_TOP_LEFT_CORNER = nArray5;
        int[] nArray6 = new int[6];
        nArray6[0] = -2;
        nArray6[2] = -1;
        nArray6[3] = 1;
        nArray6[5] = 2;
        SIMPLE_TOP_RIGHT_CORNER = nArray6;
        int[] nArray7 = new int[6];
        nArray7[1] = -2;
        nArray7[2] = 1;
        nArray7[3] = -1;
        nArray7[4] = 2;
        SIMPLE_BOTTOM_LEFT_CORNER = nArray7;
        int[] nArray8 = new int[6];
        nArray8[0] = -2;
        nArray8[2] = -1;
        nArray8[3] = -1;
        nArray8[5] = -2;
        SIMPLE_BOTTOM_RIGHT_CORNER = nArray8;
    }

    public IntroLaunchBar(int orientation, String lastPageId, IntroLaunchBarElement element) {
        this.orientation = orientation;
        this.location = element.getLocation();
        this.lastPageId = lastPageId;
        this.element = element;
        this.simple = true;
        this.presentationId = PlatformUI.getPreferenceStore().getString("presentationFactoryId");
        this.loadStoredLocation();
    }

    private void loadStoredLocation() {
        IDialogSettings settings = IntroPlugin.getDefault().getDialogSettings();
        try {
            int storedLocation = settings.getInt(S_STORED_LOCATION);
            if (storedLocation > 0) {
                this.setLocation(storedLocation);
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void storeLocation() {
        IDialogSettings settings = IntroPlugin.getDefault().getDialogSettings();
        settings.put(S_STORED_LOCATION, this.location);
    }

    public void createInActiveWindow() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.dock(this.location);
        ITrimManager trimManager = window.getTrimManager();
        trimManager.addTrim(this.location, (IWindowTrim)this);
        window.getShell().layout();
    }

    protected boolean isPlain() {
        return !"org.eclipse.ui.presentations.default".equals(this.presentationId);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.computeColors(parent.getDisplay());
        this.container.setLayout((Layout)new BarLayout());
        this.toolBarManager = new ToolBarManager(0x800000 | this.orientation);
        this.fillToolBar();
        this.toolBarManager.createControl(this.container);
        ToolBar toolBar = this.toolBarManager.getControl();
        if (this.bg != null) {
            toolBar.setBackground(this.bg);
        }
        this.container.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                IntroLaunchBar.this.onPaint(e);
            }
        });
        MenuManager manager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IntroLaunchBar.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        Menu contextMenu = manager.createContextMenu((Control)this.toolBarManager.getControl());
        this.toolBarManager.getControl().setMenu(contextMenu);
        IntroPlugin.getDefault().setLaunchBar(this);
    }

    protected void startDragging(Point position, boolean usingKeyboard) {
        Rectangle dragRect = DragUtil.getDisplayBounds((Control)this.getControl());
        this.startDrag(this, dragRect, position, usingKeyboard);
    }

    private void startDrag(Object toDrag, Rectangle dragRect, Point position, boolean usingKeyboard) {
        DragUtil.performDrag((Object)toDrag, (Rectangle)dragRect, (Point)position, (!usingKeyboard ? 1 : 0) != 0);
    }

    protected void onPaint(PaintEvent e) {
        GC gc = e.gc;
        Color color = this.fg;
        if (color == null) {
            color = e.display.getSystemColor(18);
        }
        gc.setForeground(color);
        if (this.bg != null) {
            gc.setBackground(this.bg);
        }
        if (this.isPlain()) {
            Point size = this.container.getSize();
            gc.fillRectangle(0, 0, size.x, size.y);
            gc.drawRectangle(0, 0, size.x - 1, size.y - 1);
        } else {
            switch (this.location) {
                case 16384: {
                    this.paintLeft(gc);
                    break;
                }
                case 131072: {
                    this.paintRight(gc);
                    break;
                }
                case 1024: {
                    this.paintBottom(gc);
                }
            }
        }
    }

    private void paintLeft(GC gc) {
        int[] top = this.simple ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
        int[] bot = this.simple ? SIMPLE_BOTTOM_RIGHT_CORNER : BOTTOM_RIGHT_CORNER;
        int[] shape = new int[top.length + bot.length + 4];
        int index = 0;
        Point size = this.container.getSize();
        int x = size.x - 1;
        int y = 0;
        index = this.fillShape(shape, top, index, x, y, false);
        y = size.y - 1;
        index = this.fillShape(shape, bot, index, x, y, true);
        shape[index++] = -1;
        shape[index++] = size.y - 1;
        shape[index++] = -1;
        shape[index++] = 0;
        gc.fillPolygon(shape);
        gc.drawPolygon(shape);
    }

    private void paintBottom(GC gc) {
        int[] left = this.simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
        int[] right = this.simple ? SIMPLE_TOP_RIGHT_CORNER : TOP_RIGHT_CORNER;
        int[] shape = new int[left.length + right.length + 4];
        int index = 0;
        Point size = this.container.getSize();
        int x = 0;
        int y = 0;
        index = this.fillShape(shape, left, index, x, y, false);
        x = size.x - 1;
        index = this.fillShape(shape, right, index, x, y, false);
        shape[index++] = size.x - 1;
        shape[index++] = size.y;
        shape[index++] = 0;
        shape[index++] = size.y;
        gc.fillPolygon(shape);
        gc.drawPolygon(shape);
    }

    private void paintRight(GC gc) {
        int[] top = this.simple ? SIMPLE_TOP_LEFT_CORNER : TOP_LEFT_CORNER;
        int[] bot = this.simple ? SIMPLE_BOTTOM_LEFT_CORNER : BOTTOM_LEFT_CORNER;
        int[] shape = new int[top.length + bot.length + 4];
        int index = 0;
        Point size = this.container.getSize();
        int x = 0;
        int y = 0;
        index = this.fillShape(shape, top, index, x, y, false);
        shape[index++] = size.x;
        shape[index++] = 0;
        shape[index++] = size.x;
        shape[index++] = size.y - 1;
        x = 0;
        y = size.y - 1;
        this.fillShape(shape, bot, index, x, y, true);
        gc.fillPolygon(shape);
        gc.drawPolygon(shape);
    }

    private int fillShape(int[] shape, int[] points, int index, int x, int y, boolean reverse) {
        int fill = points.length;
        int i = 0;
        while (i < points.length / 2) {
            if (!reverse) {
                shape[index++] = x + points[2 * i];
                shape[index++] = y + points[2 * i + 1];
            } else {
                shape[index + fill - 2 - 2 * i] = x + points[2 * i];
                shape[index + fill - 1 - 2 * i] = y + points[2 * i + 1];
            }
            ++i;
        }
        if (reverse) {
            index += fill;
        }
        return index;
    }

    private void computeColors(Display display) {
        RGB r;
        if (this.element.getBackground() != null && (r = SharedStyleManager.parseRGB(this.element.getBackground())) != null) {
            this.bg = new Color((Device)display, r);
        }
        if (this.element.getForeground() != null && (r = SharedStyleManager.parseRGB(this.element.getForeground())) != null) {
            this.fg = new Color((Device)display, r);
        }
    }

    public Control getControl() {
        return this.container;
    }

    public void dispose() {
        if (this.container != null) {
            this.container.dispose();
        }
        if (this.toolBarManager != null) {
            this.toolBarManager.dispose();
            this.toolBarManager.removeAll();
        }
        this.toolBarManager = null;
        this.container = null;
        if (this.bg != null) {
            this.bg.dispose();
        }
        if (this.fg != null) {
            this.fg.dispose();
        }
    }

    private void fillToolBar() {
        this.closeAction = new Action("close"){

            public void run() {
                IntroLaunchBar.this.closeLaunchBar(false);
            }
        };
        this.closeAction.setText(Messages.IntroLaunchBar_close_label);
        this.closeAction.setToolTipText(Messages.IntroLaunchBar_close_tooltip);
        Action action = new Action("restore"){

            public void run() {
                IntroLaunchBar.this.openPage(IntroLaunchBar.this.lastPageId);
            }
        };
        action.setToolTipText(Messages.IntroLaunchBar_restore_tooltip);
        action.setImageDescriptor(ImageUtil.createImageDescriptor("full/etool16/restore_welcome.gif"));
        this.toolBarManager.add((IAction)action);
        this.toolBarManager.add((IContributionItem)new Separator());
        if (this.element == null) {
            return;
        }
        IntroLaunchBarShortcut[] shortcuts = this.element.getShortcuts();
        int i = 0;
        while (i < shortcuts.length) {
            IntroLaunchBarShortcut shortcut = shortcuts[i];
            this.addShortcut(shortcut, (IToolBarManager)this.toolBarManager);
            ++i;
        }
    }

    private void addShortcut(final IntroLaunchBarShortcut shortcut, IToolBarManager toolBarManager) {
        Action action = new Action(shortcut.getToolTip()){

            public void run() {
                IntroLaunchBar.this.executeShortcut(shortcut.getURL());
            }
        };
        action.setImageDescriptor(shortcut.getImageDescriptor());
        action.setToolTipText(shortcut.getToolTip());
        toolBarManager.add((IAction)action);
    }

    public void close() {
        this.closeLaunchBar(false);
    }

    protected IIntroPart closeLaunchBar(boolean restore) {
        IntroPlugin.getDefault().setLaunchBar(null);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        window.getTrimManager().removeTrim((IWindowTrim)this);
        IIntroPart intro = null;
        if (restore) {
            intro = PlatformUI.getWorkbench().getIntroManager().showIntro(window, false);
            CustomizableIntroPart cpart = (CustomizableIntroPart)intro;
            Rectangle startBounds = Geometry.toDisplay((Control)this.getControl().getParent(), (Rectangle)this.getControl().getBounds());
            Rectangle endBounds = Geometry.toDisplay((Control)cpart.getControl().getParent(), (Rectangle)cpart.getControl().getBounds());
            RectangleAnimation animation = new RectangleAnimation(window.getShell(), startBounds, endBounds);
            animation.schedule();
        }
        this.dispose();
        window.getShell().layout();
        return intro;
    }

    protected void executeShortcut(String url) {
        IIntroURL introURL = IntroURLFactory.createIntroURL(url);
        if (introURL != null) {
            IIntroPart intro = this.closeLaunchBar(true);
            if (intro == null) {
                return;
            }
            introURL.execute();
        }
    }

    protected void openPage(String id) {
        IIntroPart intro = this.closeLaunchBar(true);
        if (intro == null) {
            return;
        }
        StringBuffer url = new StringBuffer();
        url.append(LAUNCH_COMMAND_BASE);
        url.append(id);
        IIntroURL introURL = IntroURLFactory.createIntroURL(url.toString());
        if (introURL != null) {
            introURL.execute();
        }
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        manager.add((IAction)this.closeAction);
    }

    public void dock(int side) {
        this.dispose();
        this.setLocation(side);
        this.storeLocation();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.createControl((Composite)window.getShell());
    }

    private void setLocation(int location) {
        this.orientation = location == 16384 || location == 131072 ? 512 : 256;
        this.location = location;
    }

    public int getValidSides() {
        return 148480;
    }

    public String getId() {
        return "org.eclipse.ui.internal.intro.impl.presentations.IntroLaunchBar";
    }

    public String getDisplayName() {
        return WorkbenchMessages.TrimCommon_IntroBar_TrimName;
    }

    public boolean isCloseable() {
        return this.element.getClose();
    }

    public void handleClose() {
        this.closeLaunchBar(false);
    }

    public int getWidthHint() {
        return -1;
    }

    public int getHeightHint() {
        return -1;
    }

    public boolean isResizeable() {
        return false;
    }

    class BarLayout
    extends Layout {
        BarLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean changed) {
            boolean vertical;
            boolean bl = vertical = (IntroLaunchBar.this.orientation & 0x200) != 0;
            int marginWidth = vertical | IntroLaunchBar.this.isPlain() ? 1 : (IntroLaunchBar.this.simple ? 3 : 7);
            int marginHeight = !vertical | IntroLaunchBar.this.isPlain() ? 1 : (IntroLaunchBar.this.simple ? 3 : 7);
            int width = 0;
            int height = 0;
            Point tsize = IntroLaunchBar.this.toolBarManager.getControl().computeSize(-1, -1, changed);
            if (vertical) {
                width = tsize.x;
                height = tsize.y;
            } else {
                height = tsize.y;
                width = tsize.x;
            }
            if (vertical) {
                width += marginWidth;
                height += marginHeight + marginHeight;
            } else {
                width += marginWidth + marginWidth;
                height += marginHeight;
            }
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean changed) {
            boolean vertical;
            boolean bl = vertical = (IntroLaunchBar.this.orientation & 0x200) != 0;
            int marginWidth = vertical | IntroLaunchBar.this.isPlain() ? 1 : (IntroLaunchBar.this.simple ? 4 : 7);
            int marginHeight = !vertical | IntroLaunchBar.this.isPlain() ? 1 : (IntroLaunchBar.this.simple ? 4 : 7);
            Point tsize = IntroLaunchBar.this.toolBarManager.getControl().computeSize(-1, -1, changed);
            Rectangle carea = composite.getClientArea();
            int x = carea.x + (IntroLaunchBar.this.location == 16384 ? 0 : marginWidth);
            int y = carea.y + marginHeight;
            if (vertical) {
                IntroLaunchBar.this.toolBarManager.getControl().setBounds(x, y, carea.width - marginWidth, tsize.y);
            } else {
                IntroLaunchBar.this.toolBarManager.getControl().setBounds(x, y, tsize.x, carea.height - marginHeight);
            }
        }
    }
}

